/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.exception.RssException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionLengthStatistic {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionLengthStatistic.class);
    private final AtomicLong[] partitionLens;

    public PartitionLengthStatistic(int numPartitions) {
        this.partitionLens = new AtomicLong[numPartitions];
        for (int i = 0; i < numPartitions; ++i) {
            this.partitionLens[i] = new AtomicLong(0L);
        }
    }

    public void inc(ShuffleBlockInfo block) {
        int partitionId = block.getPartitionId();
        if (partitionId >= this.partitionLens.length) {
            throw new RssException("Partition ID " + partitionId + " is out of bounds (should be less than " + this.partitionLens.length + ")");
        }
        this.partitionLens[block.getPartitionId()].addAndGet(block.getLength());
    }

    public long[] toArray() {
        return Arrays.stream(this.partitionLens).mapToLong(x -> x.get()).toArray();
    }
}

