/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer.lab;

import java.util.function.Supplier;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.buffer.ShuffleBufferWithLinkedList;
import org.apache.uniffle.server.buffer.lab.LAB;
import org.apache.uniffle.server.buffer.lab.SupportsLAB;

public class LABShuffleBufferWithLinkedList
extends ShuffleBufferWithLinkedList
implements SupportsLAB {
    private LAB lab = new LAB();

    @Override
    protected boolean addBlock(ShufflePartitionedBlock block) {
        ShufflePartitionedBlock newBlock = this.lab.tryCopyBlockToChunk(block);
        boolean addSuccess = super.addBlock(newBlock);
        if (addSuccess && newBlock.isOnLAB()) {
            super.releaseBlock(block);
        }
        return addSuccess;
    }

    @Override
    protected void releaseBlock(ShufflePartitionedBlock block) {
        if (!block.isOnLAB()) {
            super.releaseBlock(block);
        }
    }

    @Override
    public synchronized ShuffleDataFlushEvent toFlushEvent(String appId, int shuffleId, int startPartition, int endPartition, Supplier<Boolean> isValid, ShuffleDataDistributionType dataDistributionType) {
        ShuffleDataFlushEvent event = super.toFlushEvent(appId, shuffleId, startPartition, endPartition, isValid, dataDistributionType);
        this.lab = new LAB();
        return event;
    }

    @Override
    protected Runnable createCallbackForFlush(ShuffleDataFlushEvent event) {
        Runnable runnable = super.createCallbackForFlush(event);
        LAB labRef = this.lab;
        return () -> {
            runnable.run();
            labRef.close();
        };
    }

    @Override
    public synchronized long release() {
        long size = super.release();
        this.lab.close();
        return size;
    }
}

