/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.concurrent.BlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.shaded.com.google.common.collect.Queues;
import org.apache.uniffle.storage.factory.ShuffleHandlerFactory;
import org.apache.uniffle.storage.handler.AsynDeletionEvent;
import org.apache.uniffle.storage.handler.api.ShuffleDeleteHandler;
import org.apache.uniffle.storage.request.CreateShuffleDeleteHandlerRequest;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynDeletionEventManager {
    private static final Logger LOG = LoggerFactory.getLogger(AsynDeletionEventManager.class);
    private static AsynDeletionEventManager INSTANCE;
    protected final BlockingQueue<AsynDeletionEvent> renameAndAsynDeleteEventQueue = Queues.newLinkedBlockingQueue();
    protected Thread renameAndAsynDeleteThread;

    public static synchronized AsynDeletionEventManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AsynDeletionEventManager();
        }
        return INSTANCE;
    }

    public AsynDeletionEventManager() {
        Runnable renameAndDeletionTask = () -> {
            while (true) {
                AsynDeletionEvent asynDeletionEvent = null;
                try {
                    ShuffleDeleteHandler deleteHandler;
                    asynDeletionEvent = this.renameAndAsynDeleteEventQueue.take();
                    if (asynDeletionEvent.getStorageType().equalsIgnoreCase(StorageType.LOCALFILE.name())) {
                        deleteHandler = ShuffleHandlerFactory.getInstance().createShuffleDeleteHandler(new CreateShuffleDeleteHandlerRequest(StorageType.LOCALFILE.name(), new Configuration()));
                        deleteHandler.delete(asynDeletionEvent.getNeedDeleteRenamePaths(), asynDeletionEvent.getAppId(), asynDeletionEvent.getUser());
                        continue;
                    }
                    if (!asynDeletionEvent.getStorageType().equalsIgnoreCase(StorageType.HDFS.name())) continue;
                    deleteHandler = ShuffleHandlerFactory.getInstance().createShuffleDeleteHandler(new CreateShuffleDeleteHandlerRequest(StorageType.HDFS.name(), asynDeletionEvent.getConf(), asynDeletionEvent.getShuffleServerId()));
                    deleteHandler.delete(asynDeletionEvent.getNeedDeleteRenamePaths(), asynDeletionEvent.getAppId(), asynDeletionEvent.getUser());
                    continue;
                }
                catch (Exception e) {
                    if (asynDeletionEvent != null) {
                        LOG.error("Delete Paths of {} failed.", (Object)asynDeletionEvent.getNeedDeleteRenamePaths(), (Object)e);
                        continue;
                    }
                    LOG.error("Failed to delete a directory in renameAndAsynDeleteThread.", (Throwable)e);
                    continue;
                }
                break;
            }
        };
        this.renameAndAsynDeleteThread = new Thread(renameAndDeletionTask);
        this.renameAndAsynDeleteThread.setName("renameAndAsynDeleteThread");
        this.renameAndAsynDeleteThread.setDaemon(true);
        this.renameAndAsynDeleteThread.start();
    }

    public synchronized boolean handlerAsynDelete(AsynDeletionEvent asynDeletionEvent) {
        return this.renameAndAsynDeleteEventQueue.offer(asynDeletionEvent);
    }
}

