/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.proxy;

import jakarta.batch.api.Batchlet;
import jakarta.batch.api.Decider;
import jakarta.batch.api.chunk.CheckpointAlgorithm;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.batch.api.partition.PartitionAnalyzer;
import jakarta.batch.api.partition.PartitionCollector;
import jakarta.batch.api.partition.PartitionMapper;
import jakarta.batch.api.partition.PartitionReducer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.BatchProxyInvocationHandler;
import org.apache.batchee.container.proxy.CheckpointAlgorithmProxy;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.spi.BatchArtifactFactory;

public class ProxyFactory {
    private static final ThreadLocal<InjectionReferences> INJECTION_CONTEXT = new ThreadLocal();

    private ProxyFactory() {
    }

    protected static Object loadArtifact(BatchArtifactFactory factory, String id, InjectionReferences injectionReferences, RuntimeJobExecution execution) {
        INJECTION_CONTEXT.set(injectionReferences);
        try {
            BatchArtifactFactory.Instance instance = factory.load(id);
            if (instance == null) {
                Object var5_6 = null;
                return var5_6;
            }
            if (instance.getReleasable() != null && execution != null) {
                execution.addReleasable(instance.getReleasable());
            }
            Object object = instance.getValue();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            INJECTION_CONTEXT.remove();
        }
    }

    public static InjectionReferences getInjectionReferences() {
        return INJECTION_CONTEXT.get();
    }

    public static InjectionReferences setInjectionReferences(InjectionReferences injectionReferences) {
        InjectionReferences oldRef = INJECTION_CONTEXT.get();
        INJECTION_CONTEXT.set(injectionReferences);
        if (injectionReferences == null) {
            INJECTION_CONTEXT.remove();
        }
        return oldRef;
    }

    public static <T> T createProxy(T delegate, InjectionReferences injectionRefs, String ... nonExceptionHandlingMethods) {
        if (delegate == null) {
            return null;
        }
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), ProxyFactory.getInterfaces(delegate.getClass()), (InvocationHandler)new BatchProxyInvocationHandler(delegate, injectionRefs, nonExceptionHandlingMethods));
    }

    public static Decider createDeciderProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        return ProxyFactory.createProxy((Decider)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution), injectionRefs, new String[0]);
    }

    public static Batchlet createBatchletProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        Batchlet loadedArtifact = (Batchlet)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, new String[0]);
    }

    public static CheckpointAlgorithmProxy createCheckpointAlgorithmProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        CheckpointAlgorithm loadedArtifact = (CheckpointAlgorithm)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        CheckpointAlgorithmProxy proxy = new CheckpointAlgorithmProxy(loadedArtifact);
        proxy.setStepContext(injectionRefs.getStepContext());
        return proxy;
    }

    public static ItemReader createItemReaderProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        ItemReader loadedArtifact = (ItemReader)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, "readItem");
    }

    public static ItemProcessor createItemProcessorProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        ItemProcessor loadedArtifact = (ItemProcessor)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, "processItem");
    }

    public static ItemWriter createItemWriterProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        ItemWriter loadedArtifact = (ItemWriter)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, "writeItems");
    }

    public static PartitionReducer createPartitionReducerProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        PartitionReducer loadedArtifact = (PartitionReducer)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, new String[0]);
    }

    public static PartitionMapper createPartitionMapperProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        PartitionMapper loadedArtifact = (PartitionMapper)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, new String[0]);
    }

    public static PartitionAnalyzer createPartitionAnalyzerProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        PartitionAnalyzer loadedArtifact = (PartitionAnalyzer)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, new String[0]);
    }

    public static PartitionCollector createPartitionCollectorProxy(BatchArtifactFactory factory, String id, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        PartitionCollector loadedArtifact = (PartitionCollector)ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        return ProxyFactory.createProxy(loadedArtifact, injectionRefs, new String[0]);
    }

    private static Class<?>[] getInterfaces(Class<?> clazz) {
        if (clazz.getSuperclass() == Object.class) {
            return clazz.getInterfaces();
        }
        HashSet clazzes = new HashSet();
        while (clazz != Object.class) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                clazzes.add(interfaceClass);
            }
            clazz = clazz.getSuperclass();
        }
        return clazzes.toArray(new Class[clazzes.size()]);
    }
}

