/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class DateTimeConverter
implements Converter,
PartialStateHolder {
    public static final String CONVERTER_ID = "jakarta.faces.DateTime";
    public static final String DATE_ID = "jakarta.faces.converter.DateTimeConverter.DATE";
    public static final String DATETIME_ID = "jakarta.faces.converter.DateTimeConverter.DATETIME";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    public static final String TIME_ID = "jakarta.faces.converter.DateTimeConverter.TIME";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_BOTH = "both";
    private static final String TYPE_LOCAL_DATE = "localDate";
    private static final String TYPE_LOCAL_TIME = "localTime";
    private static final String TYPE_LOCAL_DATE_TIME = "localDateTime";
    private static final String TYPE_OFFSET_TIME = "offsetTime";
    private static final String TYPE_OFFSET_DATE_TIME = "offsetDateTime";
    private static final String TYPE_ZONED_DATE_TIME = "zonedDateTime";
    private static final String STYLE_DEFAULT = "default";
    private static final String STYLE_MEDIUM = "medium";
    private static final String STYLE_SHORT = "short";
    private static final String STYLE_LONG = "long";
    private static final String STYLE_FULL = "full";
    private static final TimeZone TIMEZONE_DEFAULT = TimeZone.getTimeZone("GMT");
    private String _dateStyle;
    private Locale _locale;
    private String _pattern;
    private String _timeStyle;
    private TimeZone _timeZone;
    private String _type;
    private boolean _transient;
    private boolean _initialStateMarked = false;

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value != null && (value = value.trim()).length() > 0) {
            if (this.isJava8DateTimeFormatter()) {
                DateTimeFormatter format = this.getDateTimeFormatter();
                try {
                    TemporalQuery tq = this.getTemporalQuery();
                    if (tq != null) {
                        return format.parse((CharSequence)value, tq);
                    }
                    return format.parse(value);
                }
                catch (Exception e) {
                    String type = this.getType();
                    Comparable<ChronoLocalDateTime<?>> currentDate = TYPE_LOCAL_DATE.equals(type) || TYPE_LOCAL_DATE_TIME.equals(type) || TYPE_LOCAL_TIME.equals(type) ? LocalDateTime.now() : (TYPE_OFFSET_TIME.equals(type) || TYPE_OFFSET_DATE_TIME.equals(type) ? OffsetDateTime.now() : ZonedDateTime.now());
                    Object[] args = new Object[]{value, format.format((TemporalAccessor)((Object)currentDate)), MessageUtils.getLabel(facesContext, uiComponent)};
                    if (type.equals(TYPE_LOCAL_DATE)) {
                        throw new ConverterException(MessageUtils.getErrorMessage(facesContext, DATE_ID, args));
                    }
                    if (type.equals(TYPE_LOCAL_TIME) || type.equals(TYPE_OFFSET_TIME)) {
                        throw new ConverterException(MessageUtils.getErrorMessage(facesContext, TIME_ID, args));
                    }
                    if (type.equals(TYPE_LOCAL_DATE_TIME) || type.equals(TYPE_OFFSET_DATE_TIME) || type.equals(TYPE_ZONED_DATE_TIME)) {
                        throw new ConverterException(MessageUtils.getErrorMessage(facesContext, DATETIME_ID, args));
                    }
                    throw new ConverterException("invalid type '" + this._type + "'");
                }
            }
            DateFormat format = this.getDateFormat();
            TimeZone tz = this.getTimeZone();
            if (tz != null) {
                format.setTimeZone(tz);
            }
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                String type = this.getType();
                Object[] args = new Object[]{value, format.format(new Date()), MessageUtils.getLabel(facesContext, uiComponent)};
                if (type.equals(TYPE_DATE)) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, DATE_ID, args));
                }
                if (type.equals(TYPE_TIME)) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, TIME_ID, args));
                }
                if (type.equals(TYPE_BOTH)) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, DATETIME_ID, args));
                }
                throw new ConverterException("invalid type '" + this._type + "'");
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (this.isJava8DateTimeFormatter()) {
            DateTimeFormatter format = this.getDateTimeFormatter();
            if (value instanceof TemporalAccessor) {
                try {
                    return format.format((TemporalAccessor)value);
                }
                catch (Exception e) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
                }
            }
            return null;
        }
        DateFormat format = this.getDateFormat();
        TimeZone tz = this.getTimeZone();
        if (tz != null) {
            format.setTimeZone(tz);
        }
        try {
            return format.format(value);
        }
        catch (Exception e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }

    private DateFormat getDateFormat() {
        DateFormat format;
        String type = this.getType();
        if (this._pattern != null) {
            try {
                format = new SimpleDateFormat(this._pattern, this.getLocale());
            }
            catch (IllegalArgumentException iae) {
                throw new ConverterException("Invalid pattern", (Throwable)iae);
            }
        } else if (type.equals(TYPE_DATE)) {
            format = DateFormat.getDateInstance(this.calcStyle(this.getDateStyle()), this.getLocale());
        } else if (type.equals(TYPE_TIME)) {
            format = DateFormat.getTimeInstance(this.calcStyle(this.getTimeStyle()), this.getLocale());
        } else if (type.equals(TYPE_BOTH)) {
            format = DateFormat.getDateTimeInstance(this.calcStyle(this.getDateStyle()), this.calcStyle(this.getTimeStyle()), this.getLocale());
        } else {
            throw new ConverterException("invalid type '" + this._type + "'");
        }
        format.setLenient(false);
        return format;
    }

    private DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter formatter = null;
        String type = this.getType();
        String pattern = this.getPattern();
        if (pattern != null && pattern.length() > 0) {
            Locale locale = this.getLocale();
            formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
        } else {
            if (TYPE_LOCAL_DATE.equals(type)) {
                formatter = DateTimeFormatter.ofLocalizedDate(this.calcFormatStyle(this.getDateStyle()));
            } else if (TYPE_LOCAL_DATE_TIME.equals(type)) {
                String timeStyle = this.getTimeStyle();
                formatter = timeStyle != null && timeStyle.length() > 0 ? DateTimeFormatter.ofLocalizedDateTime(this.calcFormatStyle(this.getDateStyle()), this.calcFormatStyle(timeStyle)) : DateTimeFormatter.ofLocalizedDateTime(this.calcFormatStyle(this.getDateStyle()));
            } else if (TYPE_LOCAL_TIME.equals(type)) {
                formatter = DateTimeFormatter.ofLocalizedTime(this.calcFormatStyle(this.getTimeStyle()));
            } else if (TYPE_OFFSET_TIME.equals(type)) {
                formatter = DateTimeFormatter.ISO_OFFSET_TIME;
            } else if (TYPE_OFFSET_DATE_TIME.equals(type)) {
                formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            } else if (TYPE_ZONED_DATE_TIME.equals(type)) {
                formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
            }
            Locale locale = this.getLocale();
            if (locale != null) {
                formatter = formatter.withLocale(locale);
            }
        }
        return formatter;
    }

    private TemporalQuery getTemporalQuery() {
        String type = this.getType();
        if (TYPE_LOCAL_DATE.equals(type)) {
            return LocalDate::from;
        }
        if (TYPE_LOCAL_DATE_TIME.equals(type)) {
            return LocalDateTime::from;
        }
        if (TYPE_LOCAL_TIME.equals(type)) {
            return LocalTime::from;
        }
        if (TYPE_OFFSET_TIME.equals(type)) {
            return OffsetTime::from;
        }
        if (TYPE_OFFSET_DATE_TIME.equals(type)) {
            return OffsetDateTime::from;
        }
        if (TYPE_ZONED_DATE_TIME.equals(type)) {
            return ZonedDateTime::from;
        }
        return null;
    }

    private FormatStyle calcFormatStyle(String name) {
        if (name.equals(STYLE_DEFAULT)) {
            return FormatStyle.MEDIUM;
        }
        if (name.equals(STYLE_MEDIUM)) {
            return FormatStyle.MEDIUM;
        }
        if (name.equals(STYLE_SHORT)) {
            return FormatStyle.SHORT;
        }
        if (name.equals(STYLE_LONG)) {
            return FormatStyle.LONG;
        }
        if (name.equals(STYLE_FULL)) {
            return FormatStyle.FULL;
        }
        throw new ConverterException("invalid style '" + name + "'");
    }

    private int calcStyle(String name) {
        if (name.equals(STYLE_DEFAULT)) {
            return 2;
        }
        if (name.equals(STYLE_MEDIUM)) {
            return 2;
        }
        if (name.equals(STYLE_SHORT)) {
            return 3;
        }
        if (name.equals(STYLE_LONG)) {
            return 1;
        }
        if (name.equals(STYLE_FULL)) {
            return 0;
        }
        throw new ConverterException("invalid style '" + name + "'");
    }

    private boolean isJava8DateTimeFormatter() {
        String type = this.getType();
        if (type != null) {
            return TYPE_LOCAL_DATE.equals(type) || TYPE_LOCAL_TIME.equals(type) || TYPE_LOCAL_DATE_TIME.equals(type) || TYPE_OFFSET_TIME.equals(type) || TYPE_OFFSET_DATE_TIME.equals(type) || TYPE_ZONED_DATE_TIME.equals(type);
        }
        return false;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this._dateStyle = (String)values[0];
            this._locale = (Locale)values[1];
            this._pattern = (String)values[2];
            this._timeStyle = (String)values[3];
            this._timeZone = (TimeZone)values[4];
            this._type = (String)values[5];
        }
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this._dateStyle, this._locale, this._pattern, this._timeStyle, this._timeZone, this._type};
            return values;
        }
        return null;
    }

    public String getDateStyle() {
        return this._dateStyle != null ? this._dateStyle : STYLE_DEFAULT;
    }

    public void setDateStyle(String dateStyle) {
        this._dateStyle = dateStyle;
        this.clearInitialState();
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        this.clearInitialState();
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
        this.clearInitialState();
    }

    public String getTimeStyle() {
        return this._timeStyle != null ? this._timeStyle : STYLE_DEFAULT;
    }

    public void setTimeStyle(String timeStyle) {
        this._timeStyle = timeStyle;
        this.clearInitialState();
    }

    public TimeZone getTimeZone() {
        return this._timeZone != null ? this._timeZone : TIMEZONE_DEFAULT;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        this.clearInitialState();
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean aTransient) {
        this._transient = aTransient;
    }

    public String getType() {
        return this._type != null ? this._type : TYPE_DATE;
    }

    public void setType(String type) {
        this._type = type;
        this.clearInitialState();
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

