/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.reference;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public abstract class SimpleReference
extends Reference {
    private static final Enumeration<RefAddr> EMPTY_ENUMERATION = new Enumeration<RefAddr>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public RefAddr nextElement() {
            throw new NoSuchElementException();
        }
    };

    public SimpleReference() {
        super(null);
    }

    public abstract Object getContent() throws NamingException;

    @Override
    public String getClassName() {
        return "java.lang.Object";
    }

    @Override
    public final String getFactoryClassName() {
        return SimpleObjectFactory.class.getName();
    }

    @Override
    public final String getFactoryClassLocation() {
        return null;
    }

    @Override
    public final RefAddr get(String addrType) {
        return null;
    }

    @Override
    public final RefAddr get(int posn) {
        throw new ArrayIndexOutOfBoundsException(posn);
    }

    @Override
    public final Enumeration<RefAddr> getAll() {
        return EMPTY_ENUMERATION;
    }

    @Override
    public final int size() {
        return 0;
    }

    @Override
    public final void add(RefAddr addr) {
        throw new UnsupportedOperationException("SimpleReference has no addresses so none can be added");
    }

    @Override
    public final void add(int posn, RefAddr addr) {
        throw new UnsupportedOperationException("SimpleReference has no addresses so none can be added");
    }

    @Override
    public final Object remove(int posn) {
        throw new ArrayIndexOutOfBoundsException(posn);
    }

    @Override
    public final void clear() {
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("SimpleReference can not be cloned");
    }

    public static final class SimpleObjectFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            if (obj instanceof SimpleReference) {
                SimpleReference reference = (SimpleReference)obj;
                return reference.getContent();
            }
            return null;
        }
    }
}

