/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.Instant;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class InstantSerializer
extends SimpleTypeSerializer<Instant> {
    public InstantSerializer() {
        super(DataType.INSTANT);
    }

    @Override
    protected Instant readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return Instant.ofEpochSecond(buffer.readLong(), buffer.readInt());
    }

    @Override
    protected void writeValue(Instant value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeLong(value.getEpochSecond()).writeInt(value.getNano());
    }
}

