/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.contexts;

import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityContextInitializeException;
import org.apache.flink.runtime.security.contexts.HadoopSecurityContext;
import org.apache.flink.runtime.security.contexts.SecurityContext;
import org.apache.flink.runtime.security.contexts.SecurityContextFactory;
import org.apache.flink.runtime.security.modules.HadoopModuleFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopSecurityContextFactory
implements SecurityContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopSecurityContextFactory.class);

    @Override
    public boolean isCompatibleWith(SecurityConfiguration securityConfig) {
        if (!securityConfig.getSecurityModuleFactories().contains(HadoopModuleFactory.class.getCanonicalName())) {
            return false;
        }
        try {
            Class.forName("org.apache.hadoop.security.UserGroupInformation", false, HadoopSecurityContextFactory.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.info("Cannot install HadoopSecurityContext because Hadoop cannot be found in the Classpath.");
            return false;
        }
    }

    @Override
    public SecurityContext createContext(SecurityConfiguration securityConfig) throws SecurityContextInitializeException {
        try {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            return new HadoopSecurityContext(loginUser);
        }
        catch (Exception e) {
            LOG.error("Cannot instantiate HadoopSecurityContext.", (Throwable)e);
            throw new SecurityContextInitializeException("Cannot instantiate HadoopSecurityContext.", e);
        }
    }
}

