/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.storm.shade.io.netty.channel.uring.IoUring;
import org.apache.storm.shade.io.netty.channel.uring.IoUringBufferRingConfig;
import org.apache.storm.shade.io.netty.util.internal.ObjectUtil;

public final class IoUringIoHandlerConfig {
    private int ringSize = IoUring.DEFAULT_RING_SIZE;
    private int cqSize = IoUring.DEFAULT_CQ_SIZE;
    private int maxBoundedWorker;
    private int maxUnboundedWorker;
    private Set<IoUringBufferRingConfig> bufferRingConfigs;
    private boolean singleIssuer = true;

    public IoUringIoHandlerConfig() {
    }

    private IoUringIoHandlerConfig(IoUringIoHandlerConfig config) {
        this.ringSize = config.ringSize;
        this.cqSize = config.cqSize;
        this.maxBoundedWorker = config.maxBoundedWorker;
        this.maxUnboundedWorker = config.maxUnboundedWorker;
        this.bufferRingConfigs = config.bufferRingConfigs == null ? null : new HashSet<IoUringBufferRingConfig>(config.bufferRingConfigs);
        this.singleIssuer = config.singleIssuer;
    }

    public int getRingSize() {
        return this.ringSize;
    }

    public int getCqSize() {
        return this.cqSize;
    }

    public int getMaxBoundedWorker() {
        return this.maxBoundedWorker;
    }

    public int getMaxUnboundedWorker() {
        return this.maxUnboundedWorker;
    }

    public IoUringIoHandlerConfig setRingSize(int ringSize) {
        this.ringSize = ObjectUtil.checkPositive(ringSize, "ringSize");
        return this;
    }

    public IoUringIoHandlerConfig setCqSize(int cqSize) {
        ObjectUtil.checkPositive(cqSize, "cqSize");
        this.cqSize = this.checkCqSize(cqSize);
        return this;
    }

    private int checkCqSize(int cqSize) {
        boolean isPowerOfTwo;
        if (cqSize < this.ringSize) {
            throw new IllegalArgumentException("cqSize must be greater than or equal to ringSize");
        }
        boolean bl = isPowerOfTwo = Integer.bitCount(cqSize) == 1;
        if (!isPowerOfTwo) {
            throw new IllegalArgumentException("cqSize: " + cqSize + " (expected: power of 2)");
        }
        return cqSize;
    }

    public IoUringIoHandlerConfig setMaxBoundedWorker(int maxBoundedWorker) {
        this.maxBoundedWorker = ObjectUtil.checkPositiveOrZero(maxBoundedWorker, "maxBoundedWorker");
        return this;
    }

    public IoUringIoHandlerConfig setMaxUnboundedWorker(int maxUnboundedWorker) {
        this.maxUnboundedWorker = ObjectUtil.checkPositiveOrZero(maxUnboundedWorker, "maxUnboundedWorker");
        return this;
    }

    public IoUringIoHandlerConfig setBufferRingConfig(IoUringBufferRingConfig ... ringConfig) {
        HashSet<IoUringBufferRingConfig> configSet = new HashSet<IoUringBufferRingConfig>(ringConfig.length);
        for (IoUringBufferRingConfig bufferRingConfig : ringConfig) {
            if (configSet.add(bufferRingConfig)) continue;
            throw new IllegalArgumentException("Duplicated buffer group id: " + bufferRingConfig.bufferGroupId());
        }
        this.bufferRingConfigs = configSet;
        return this;
    }

    public IoUringIoHandlerConfig setSingleIssuer(boolean singleIssuer) {
        this.singleIssuer = singleIssuer;
        return this;
    }

    public List<IoUringBufferRingConfig> getBufferRingConfigs() {
        return new ArrayList<IoUringBufferRingConfig>(this.bufferRingConfigs);
    }

    boolean needRegisterIowqMaxWorker() {
        return this.maxBoundedWorker > 0 || this.maxUnboundedWorker > 0;
    }

    boolean needSetupCqeSize() {
        return this.cqSize != -1;
    }

    Set<IoUringBufferRingConfig> getInternBufferRingConfigs() {
        return this.bufferRingConfigs;
    }

    boolean singleIssuer() {
        return this.singleIssuer;
    }

    IoUringIoHandlerConfig verifyAndClone() {
        Set<IoUringBufferRingConfig> bufferRingConfigs;
        IoUring.ensureAvailability();
        if (this.needSetupCqeSize()) {
            if (!IoUring.isSetupCqeSizeSupported()) {
                throw new UnsupportedOperationException("IORING_SETUP_CQSIZE is not supported");
            }
            this.checkCqSize(this.getCqSize());
        }
        if ((bufferRingConfigs = this.getInternBufferRingConfigs()) != null && !bufferRingConfigs.isEmpty() && !IoUring.isRegisterBufferRingSupported()) {
            throw new UnsupportedOperationException("IORING_REGISTER_PBUF_RING is not supported");
        }
        return new IoUringIoHandlerConfig(this);
    }
}

