/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.zookeeper;

import java.io.File;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.nimbus.TopoCache;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.recipes.leader.Participant;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.storm.shade.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.storm.zookeeper.LeaderElectorImp;
import org.apache.storm.zookeeper.LeaderListenerCallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zookeeper {
    private static final Zookeeper INSTANCE = new Zookeeper();
    private static Logger LOG = LoggerFactory.getLogger(Zookeeper.class);
    private static Zookeeper instance = INSTANCE;

    public static void setInstance(Zookeeper u) {
        instance = u;
    }

    public static void resetInstance() {
        instance = INSTANCE;
    }

    public static NIOServerCnxnFactory mkInprocessZookeeper(String localdir, Integer port) throws Exception {
        NIOServerCnxnFactory factory = null;
        int report = 2000;
        int limitPort = 65535;
        if (port != null) {
            report = port;
            limitPort = port;
        }
        while (true) {
            try {
                factory = new NIOServerCnxnFactory();
                factory.configure(new InetSocketAddress(report), 0);
            }
            catch (BindException e) {
                if (++report <= limitPort) continue;
                throw new RuntimeException("No port is available to launch an inprocess zookeeper");
            }
            break;
        }
        LOG.info("Starting inprocess zookeeper at port {} and dir {}", (Object)report, (Object)localdir);
        File localfile = new File(localdir);
        ZooKeeperServer zk = new ZooKeeperServer(localfile, localfile, 2000);
        factory.startup(zk);
        return factory;
    }

    public static void shutdownInprocessZookeeper(NIOServerCnxnFactory handle) {
        handle.shutdown();
    }

    public static NimbusInfo toNimbusInfo(Participant participant) {
        String id = participant.getId();
        if (StringUtils.isBlank((String)id)) {
            throw new RuntimeException("No nimbus leader participant host found, have you started your nimbus hosts?");
        }
        NimbusInfo nimbusInfo = NimbusInfo.parse((String)id);
        nimbusInfo.setLeader(participant.isLeader());
        return nimbusInfo;
    }

    public static ILeaderElector zkLeaderElector(Map<String, Object> conf, CuratorFramework zkClient, BlobStore blobStore, TopoCache tc, IStormClusterState clusterState, List<ACL> acls, StormMetricsRegistry metricsRegistry, Object submitLock) {
        return instance.zkLeaderElectorImpl(conf, zkClient, blobStore, tc, clusterState, acls, metricsRegistry, submitLock);
    }

    protected ILeaderElector zkLeaderElectorImpl(Map<String, Object> conf, CuratorFramework zk, BlobStore blobStore, TopoCache tc, IStormClusterState clusterState, List<ACL> acls, StormMetricsRegistry metricsRegistry, Object submitLock) {
        String id = NimbusInfo.fromConf(conf).toHostPortString();
        return new LeaderElectorImp(zk, id, new LeaderListenerCallbackFactory(conf, zk, blobStore, tc, clusterState, acls, metricsRegistry, submitLock));
    }
}

