/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.NonJVMResource;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.ui.SparkUI$;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005m4Qa\u0007\u000f\u0001E!B\u0001b\r\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019Q\u0005\u0001)A\u0005\u007f!91\n\u0001b\u0001\n\u0013q\u0004B\u0002'\u0001A\u0003%q\bC\u0004N\u0001\t\u0007I\u0011\u0002(\t\rI\u0003\u0001\u0015!\u0003P\u0011\u001d\u0019\u0006A1A\u0005\nyBa\u0001\u0016\u0001!\u0002\u0013y\u0004bB+\u0001\u0005\u0004%IA\u0016\u0005\u00075\u0002\u0001\u000b\u0011B,\t\u000fm\u0003!\u0019!C\u00059\"1\u0001\r\u0001Q\u0001\nuCq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004g\u0001\u0001\u0006Ia\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003]\u0011\u0019A\u0007\u0001)A\u0005;\"9\u0011\u000e\u0001b\u0001\n\u0013\u0011\u0007B\u00026\u0001A\u0003%1\rC\u0004l\u0001\t\u0007I\u0011\u0002/\t\r1\u0004\u0001\u0015!\u0003^\u0011\u001di\u0007A1A\u0005\nqCaA\u001c\u0001!\u0002\u0013i\u0006\"B8\u0001\t\u0003\u0002\b\"\u0002<\u0001\t\u0003:(A\u0006\"bg&\u001cGI]5wKJ4U-\u0019;ve\u0016\u001cF/\u001a9\u000b\u0005uq\u0012\u0001\u00034fCR,(/Z:\u000b\u0005}\u0001\u0013aA69g*\u0011\u0011EI\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c2\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001'M\u0007\u00029%\u0011!\u0007\b\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0002\t\r|gNZ\u0002\u0001!\t1t'D\u0001\u001f\u0013\tAdD\u0001\u000bLk\n,'O\\3uKN$%/\u001b<fe\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mb\u0004C\u0001\u0019\u0001\u0011\u0015\u0019$\u00011\u00016\u00035!'/\u001b<feB{GMT1nKV\tq\b\u0005\u0002A\u000f:\u0011\u0011)\u0012\t\u0003\u0005.j\u0011a\u0011\u0006\u0003\tR\na\u0001\u0010:p_Rt\u0014B\u0001$,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019[\u0013A\u00043sSZ,'\u000fU8e\u001d\u0006lW\rI\u0001\u0015IJLg/\u001a:D_:$\u0018-\u001b8fe&k\u0017mZ3\u0002+\u0011\u0014\u0018N^3s\u0007>tG/Y5oKJLU.Y4fA\u0005qAM]5wKJ\u001c\u0005/^\"pe\u0016\u001cX#A(\u0011\u0005)\u0002\u0016BA),\u0005\rIe\u000e^\u0001\u0010IJLg/\u001a:DaV\u001cuN]3tA\u0005\u0011BM]5wKJ\u001cuN]3t%\u0016\fX/Z:u\u0003M!'/\u001b<fe\u000e{'/Z:SKF,Xm\u001d;!\u0003A!'/\u001b<fe2KW.\u001b;D_J,7/F\u0001X!\rQ\u0003lP\u0005\u00033.\u0012aa\u00149uS>t\u0017!\u00053sSZ,'\u000fT5nSR\u001cuN]3tA\u0005yAM]5wKJlU-\\8ss6K')F\u0001^!\tQc,\u0003\u0002`W\t!Aj\u001c8h\u0003A!'/\u001b<fe6+Wn\u001c:z\u001b&\u0014\u0005%A\u000beK\u001a\fW\u000f\u001c;Pm\u0016\u0014\b.Z1e\r\u0006\u001cGo\u001c:\u0016\u0003\r\u0004\"A\u000b3\n\u0005\u0015\\#A\u0002#pk\ndW-\u0001\feK\u001a\fW\u000f\u001c;Pm\u0016\u0014\b.Z1e\r\u0006\u001cGo\u001c:!\u0003m!'/\u001b<fe6Kg.[7v[6+Wn\u001c:z\u001fZ,'\u000f[3bI\u0006aBM]5wKJl\u0015N\\5nk6lU-\\8ss>3XM\u001d5fC\u0012\u0004\u0013\u0001F7f[>\u0014\u0018p\u0014<fe\",\u0017\r\u001a$bGR|'/A\u000bnK6|'/_(wKJDW-\u00193GC\u000e$xN\u001d\u0011\u0002#5,Wn\u001c:z\u001fZ,'\u000f[3bI6K')\u0001\nnK6|'/_(wKJDW-\u00193NS\n\u0003\u0013a\u00073sSZ,'/T3n_JLx+\u001b;i\u001fZ,'\u000f[3bI6K')\u0001\u000fee&4XM]'f[>\u0014\u0018pV5uQ>3XM\u001d5fC\u0012l\u0015N\u0011\u0011\u0002\u0019\r|gNZ5hkJ,\u0007k\u001c3\u0015\u0005E$\bC\u0001\u001cs\u0013\t\u0019hD\u0001\u0005Ta\u0006\u00148\u000eU8e\u0011\u0015)\u0018\u00041\u0001r\u0003\r\u0001x\u000eZ\u0001!O\u0016$\u0018\t\u001a3ji&|g.\u00197Q_\u0012\u001c\u0016p\u001d;f[B\u0013x\u000e]3si&,7\u000fF\u0001y!\u0011\u0001\u0015pP \n\u0005iL%aA'ba\u0002")
public class BasicDriverFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesDriverConf conf;
    private final String driverPodName;
    private final String driverContainerImage;
    private final int driverCpuCores;
    private final String driverCoresRequest;
    private final Option<String> driverLimitCores;
    private final long driverMemoryMiB;
    private final double defaultOverheadFactor;
    private final long driverMinimumMemoryOverhead;
    private final double memoryOverheadFactor;
    private final long memoryOverheadMiB;
    private final long driverMemoryWithOverheadMiB;

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private String driverContainerImage() {
        return this.driverContainerImage;
    }

    private int driverCpuCores() {
        return this.driverCpuCores;
    }

    private String driverCoresRequest() {
        return this.driverCoresRequest;
    }

    private Option<String> driverLimitCores() {
        return this.driverLimitCores;
    }

    private long driverMemoryMiB() {
        return this.driverMemoryMiB;
    }

    private double defaultOverheadFactor() {
        return this.defaultOverheadFactor;
    }

    private long driverMinimumMemoryOverhead() {
        return this.driverMinimumMemoryOverhead;
    }

    private double memoryOverheadFactor() {
        return this.memoryOverheadFactor;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long driverMemoryWithOverheadMiB() {
        return this.driverMemoryWithOverheadMiB;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Seq<EnvVar> driverCustomEnvs = KubernetesUtils$.MODULE$.buildEnvVars((Seq<Tuple2<String, String>>)((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)this.conf.appId()), (List)Nil$.MODULE$).$plus$plus(this.conf.environment())));
        Quantity driverCpuQuantity = new Quantity(this.driverCoresRequest());
        Quantity driverMemoryQuantity = new Quantity(this.driverMemoryWithOverheadMiB() + "Mi");
        Option maybeCpuLimitQuantity = this.driverLimitCores().map((Function1 & Serializable)limitCores -> new Tuple2((Object)"cpu", (Object)new Quantity(limitCores)));
        scala.collection.immutable.Map<String, Quantity> driverResourceQuantities = KubernetesUtils$.MODULE$.buildResourcesQuantities(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), this.conf.sparkConf());
        int driverPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        int driverBlockManagerPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT()));
        int driverUIPort = SparkUI$.MODULE$.getUIPort(this.conf.sparkConf());
        int driverSparkConnectServerPort = this.conf.sparkConf().getInt(Constants$.MODULE$.CONNECT_GRPC_BINDING_PORT(), Constants$.MODULE$.DEFAULT_SPARK_CONNECT_SERVER_PORT());
        Container driverContainer = ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent)((ContainerFluent.EnvNested)((ContainerFluent)((ContainerFluent.EnvNested)((ContainerFluent)((ContainerFluent.PortsNested)((ContainerFluent)((ContainerFluent.PortsNested)((ContainerFluent)((ContainerFluent.PortsNested)((ContainerFluent)((ContainerFluent.PortsNested)new ContainerBuilder(pod.container()).withName((String)Option$.MODULE$.apply((Object)pod.container().getName()).getOrElse((Function0 & Serializable)() -> Constants$.MODULE$.DEFAULT_DRIVER_CONTAINER_NAME())).withImage(this.driverContainerImage()).withImagePullPolicy(this.conf.imagePullPolicy()).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverBlockManagerPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.UI_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverUIPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.SPARK_CONNECT_SERVER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverSparkConnectServerPort)).withProtocol("TCP")).endPort()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_USER()).withValue(Utils$.MODULE$.getCurrentUserName())).endEnv()).addAllToEnv((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(driverCustomEnvs).asJava()).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv()).editOrNewResources().addToRequests("cpu", driverCpuQuantity).addToLimits(CollectionConverters$.MODULE$.MapHasAsJava((Map)Option$.MODULE$.option2Iterable(maybeCpuLimitQuantity).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()).addToRequests("memory", driverMemoryQuantity).addToLimits("memory", driverMemoryQuantity).addToLimits(CollectionConverters$.MODULE$.MapHasAsJava(driverResourceQuantities).asJava())).endResources()).build();
        Pod driverPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluent)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editOrNewMetadata().withName(this.driverPodName()).addToLabels(CollectionConverters$.MODULE$.MapHasAsJava(this.conf.labels()).asJava()).addToAnnotations(CollectionConverters$.MODULE$.MapHasAsJava(this.conf.annotations()).asJava())).endMetadata()).editOrNewSpec().withRestartPolicy("Never").addToNodeSelector(CollectionConverters$.MODULE$.MapHasAsJava(this.conf.nodeSelector()).asJava()).addToNodeSelector(CollectionConverters$.MODULE$.MapHasAsJava(this.conf.driverNodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.conf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        PodSpec podSpec = driverPod.getSpec();
        this.conf.schedulerName().foreach((Function1 & Serializable)x$1 -> {
            podSpec.setSchedulerName(x$1);
            return BoxedUnit.UNIT;
        });
        return new SparkPod(driverPod, driverContainer);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        scala.collection.mutable.Map additionalProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME().key()), (Object)this.driverPodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.id"), (Object)this.conf.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()), (Object)Double.toString(this.defaultOverheadFactor()))}));
        new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JARS(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.FILES(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.ARCHIVES(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.SUBMIT_PYTHON_FILES(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)key -> {
            Tuple2 tuple2 = ((IterableOps)$this.conf.get(key)).partition((Function1 & Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.MODULE$.isLocalAndResolvable(uri)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq localUris = (Seq)tuple2._1();
            Seq remoteUris = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)localUris, (Object)remoteUris);
            Seq localUris2 = (Seq)tuple22._1();
            Seq remoteUris2 = (Seq)tuple22._2();
            ConfigEntry configEntry = key;
            ConfigEntry configEntry2 = org.apache.spark.internal.config.package$.MODULE$.ARCHIVES();
            Seq value = !(configEntry != null ? !configEntry.equals(configEntry2) : configEntry2 != null) ? (Seq)((IterableOps)localUris2.map((Function1 & Serializable)x$2 -> Utils$.MODULE$.getUriBuilder(x$2).fragment(null).build(new Object[0]))).map((Function1 & Serializable)x$3 -> x$3.toString()) : localUris2;
            Iterable resolved = KubernetesUtils$.MODULE$.uploadAndTransformFileUris((Iterable<String>)value, (Option<SparkConf>)new Some((Object)$this.conf.sparkConf()));
            if (resolved.nonEmpty()) {
                ConfigEntry configEntry3 = key;
                ConfigEntry configEntry4 = org.apache.spark.internal.config.package$.MODULE$.ARCHIVES();
                Iterable resolvedValue = !(configEntry3 != null ? !configEntry3.equals(configEntry4) : configEntry4 != null) ? (Iterable)((IterableOps)localUris2.zip(resolved)).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String uri = (String)tuple2._1();
                        String r = (String)tuple2._2();
                        return Utils$.MODULE$.getUriBuilder(r).fragment(new URI(uri).getFragment()).build(new Object[0]).toString();
                    }
                    throw new MatchError((Object)tuple2);
                }) : resolved;
                return additionalProps.put((Object)key.key(), (Object)((IterableOnceOps)resolvedValue.$plus$plus((IterableOnce)remoteUris2)).mkString(","));
            }
            return BoxedUnit.UNIT;
        });
        return additionalProps.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public BasicDriverFeatureStep(KubernetesDriverConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.driverPodName = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).getOrElse((Function0 & Serializable)() -> $this.conf.resourceNamePrefix() + "-driver");
        this.driverContainerImage = conf.image();
        this.driverCpuCores = BoxesRunTime.unboxToInt(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES()));
        this.driverCoresRequest = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REQUEST_CORES())).getOrElse((Function0 & Serializable)() -> Integer.toString(this.driverCpuCores()));
        this.driverLimitCores = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES());
        this.driverMemoryMiB = BoxesRunTime.unboxToLong(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY()));
        this.defaultOverheadFactor = conf.mainAppResource() instanceof NonJVMResource ? (conf.contains(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()) ? BoxesRunTime.unboxToDouble((Object)conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) : Constants$.MODULE$.NON_JVM_MEMORY_OVERHEAD_FACTOR()) : BoxesRunTime.unboxToDouble((Object)conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()));
        this.driverMinimumMemoryOverhead = BoxesRunTime.unboxToLong(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MIN_MEMORY_OVERHEAD()));
        this.memoryOverheadFactor = conf.contains(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR()) ? BoxesRunTime.unboxToDouble(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR())) : this.defaultOverheadFactor();
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> package$.MODULE$.max((long)((int)(this.memoryOverheadFactor() * (double)this.driverMemoryMiB())), this.driverMinimumMemoryOverhead())));
        this.driverMemoryWithOverheadMiB = this.driverMemoryMiB() + this.memoryOverheadMiB();
    }
}

