/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class LevelOrderWalker
extends DefaultGraphWalker {
    private HashSet<Class<? extends Node>> nodeTypes = new HashSet();
    private final int numLevels;

    public LevelOrderWalker(Dispatcher disp) {
        super(disp);
        this.numLevels = Integer.MAX_VALUE;
    }

    public LevelOrderWalker(Dispatcher disp, int numLevels) {
        super(disp);
        this.numLevels = numLevels;
    }

    public void setNodeTypes(Class<? extends Node> ... nodeTypes) {
        this.nodeTypes.addAll(Arrays.asList(nodeTypes));
    }

    @Override
    public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
        this.toWalk.addAll(startNodes);
        HashSet<Node> addedNodes = new HashSet<Node>();
        for (Node node : startNodes) {
            addedNodes.add(node);
        }
        for (int index = 0; index < this.toWalk.size(); ++index) {
            if (((Node)this.toWalk.get(index)).getChildren() == null) continue;
            for (Node node : ((Node)this.toWalk.get(index)).getChildren()) {
                Operator childOP = (Operator)node;
                if (addedNodes.contains(node) || childOP.getParentOperators() != null && !addedNodes.containsAll(childOP.getParentOperators())) continue;
                this.toWalk.add(node);
                addedNodes.add(node);
            }
        }
        for (Node node : this.toWalk) {
            if (!this.nodeTypes.isEmpty() && !this.nodeTypes.contains(node.getClass())) continue;
            this.opStack.clear();
            this.opStack.push(node);
            this.walk(node, 0, this.opStack);
            if (nodeOutput == null || !this.getDispatchedList().contains(node)) continue;
            nodeOutput.put(node, this.retMap.get(node));
        }
    }

    private void walk(Node nd, int level, Stack<Node> stack) throws SemanticException {
        List<Operator<OperatorDesc>> parents = ((Operator)nd).getParentOperators();
        if (level >= this.numLevels || parents == null || parents.isEmpty()) {
            this.dispatch(stack.peek(), stack);
            return;
        }
        for (Node node : parents) {
            stack.add(0, node);
            this.walk(node, level + 1, stack);
            stack.remove(0);
        }
    }
}

