/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Extract;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rmg\u0001B\"E\t>CQa\u001c\u0001\u0005\u0002ADQA\u001d\u0001\u0005BMD\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u000fA\u0011\"a\n\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005%\u0002\u0001)A\u0005\u0003\u000fA\u0011\"a\u000b\u0001\u0005\u0004%I!!\u0002\t\u0011\u00055\u0002\u0001)A\u0005\u0003\u000fAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u00028\u0001!\t%!\u000f\u0007\r\u0005%\u0003\u0001AA&\u0011\u0019y7\u0002\"\u0001\u0002V!9\u0011\u0011L\u0006\u0005B\u0005m\u0003bBA9\u0017\u0011\u0005\u00131\u000f\u0005\b\u0003\u0003[A\u0011IAB\u0011\u001d\tij\u0003C!\u0003?Cq!!+\f\t\u0003\nY\u000bC\u0004\u00022.!\t%a-\t\u000f\u0005e6\u0002\"\u0011\u0002<\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAm\u0001\u0011\u0005\u00131\u001c\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0011\u001d\u0011y\u0001\u0001C!\u0005#AqAa\u000e\u0001\t\u0003\u0012I\u0004C\u0004\u0003B\u0001!\tEa\u0011\t\u000f\t\u001d\u0003\u0001\"\u0011\u0003J!9!q\n\u0001\u0005B\tE\u0003b\u0002B0\u0001\u0011\u0005#\u0011\r\u0005\b\u0005_\u0002A\u0011\tB9\u0011\u001d\u0011Y\b\u0001C!\u0005{BqAa\"\u0001\t\u0003\u0012I\tC\u0004\u0003\u0018\u0002!\tE!'\t\u000f\t}\u0005\u0001\"\u0011\u0003\"\"9!Q\u0015\u0001\u0005B\t\u001d\u0006b\u0002Bp\u0001\u0011\u0005#\u0011\u001d\u0005\b\u0005W\u0004A\u0011\tBw\u0011\u001d\u0011\u0019\u0010\u0001C!\u0005kDqaa\u0003\u0001\t\u0003\u001ai\u0001C\u0004\u0004:\u0001!\tea\u000f\u0007\r\r\r\u0003\u0001AB#\u0011%\u0019i\u0005\u000bB\u0001B\u0003%\u0001\u000b\u0003\u0006\u0003 !\u0012\t\u0011)A\u0005\u0005CAaa\u001c\u0015\u0005\u0002\r=\u0003bBB,Q\u0011\u00053\u0011\f\u0005\b\u00077\u0002A\u0011IB/\u0011\u001d\u0019\t\u0007\u0001C!\u0007GBqa!\u001a\u0001\t\u0003\u001a\u0019\u0007C\u0004\u0004h\u0001!\tea\u0019\t\u000f\r%\u0004\u0001\"\u0011\u0004d!A11\u000e\u0001\u0002\u0002\u0013\u0005\u0001\u000fC\u0005\u0004n\u0001\t\t\u0011\"\u0011\u0004p!I1\u0011\u000f\u0001\u0002\u0002\u0013\u000511\u000f\u0005\n\u0007k\u0002\u0011\u0011!C\u0001\u0007oB\u0011ba!\u0001\u0003\u0003%\te!\"\t\u0013\r=\u0005!!A\u0005\u0002\rE\u0005\"CBK\u0001\u0005\u0005I\u0011IBL\u0011%\u0019Y\nAA\u0001\n\u0003\u001ai\nC\u0005\u0004 \u0002\t\t\u0011\"\u0011\u0004\"\"I11\u0015\u0001\u0002\u0002\u0013\u00053QU\u0004\n\u0007S#\u0015\u0011!E\u0005\u0007W3\u0001b\u0011#\u0002\u0002#%1Q\u0016\u0005\u0007_v\"\ta!2\t\u0013\r}U(!A\u0005F\r\u0005\u0006\u0002CBd{\u0005\u0005I\u0011\u00119\t\u0013\r%W(!A\u0005\u0002\u000e-\u0007\"CBi{\u0005\u0005I\u0011BBj\u00051i\u0015pU)M\t&\fG.Z2u\u0015\t)e)\u0001\u0003kI\n\u001c'BA$I\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013*\u000bQa\u001d9be.T!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sO\u000e\u00011C\u0002\u0001Q)jk6\r\u0005\u0002R%6\tA)\u0003\u0002T\t\nY!\n\u001a2d\t&\fG.Z2u!\t)\u0006,D\u0001W\u0015\t9f)\u0001\u0005dCR\fG._:u\u0013\tIfKA\u0007T#2\u001buN\u001c4IK2\u0004XM\u001d\t\u0003#nK!\u0001\u0018#\u0003#9{G*Z4bGfTEIQ\"FeJ|'\u000f\u0005\u0002_C6\tqLC\u0001a\u0003\u0015\u00198-\u00197b\u0013\t\u0011wLA\u0004Qe>$Wo\u0019;\u0011\u0005\u0011dgBA3k\u001d\t1\u0017.D\u0001h\u0015\tAg*\u0001\u0004=e>|GOP\u0005\u0002A&\u00111nX\u0001\ba\u0006\u001c7.Y4f\u0013\tigN\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002l?\u00061A(\u001b8jiz\"\u0012!\u001d\t\u0003#\u0002\t\u0011bY1o\u0011\u0006tG\r\\3\u0015\u0005Q<\bC\u00010v\u0013\t1xLA\u0004C_>dW-\u00198\t\u000ba\u0014\u0001\u0019A=\u0002\u0007U\u0014H\u000e\u0005\u0002{}:\u00111\u0010 \t\u0003M~K!!`0\u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u|\u0016!\n3jgRLgn\u0019;V]N,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8t+\t\t9\u0001\u0005\u0004\u0002\n\u0005M\u0011qC\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003#y\u0016AC2pY2,7\r^5p]&!\u0011QCA\u0006\u0005\r\u0019V\r\u001e\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006L1a`A\u000e\u0003\u0019\"\u0017n\u001d;j]\u000e$XK\\:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u001cgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u00029M,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005\u00112/\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8t\u0003M\u0019X\u000f\u001d9peR,GMR;oGRLwN\\:!\u0003MI7oU;qa>\u0014H/\u001a3Gk:\u001cG/[8o)\r!\u00181\u0007\u0005\u0007\u0003kI\u0001\u0019A=\u0002\u0011\u0019,hn\u0019(b[\u0016\f\u0011$[:PE*,7\r\u001e(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]R\u0019A/a\u000f\t\u000f\u0005u\"\u00021\u0001\u0002@\u0005\tQ\r\u0005\u0003\u0002B\u0005\u0015SBAA\"\u0015\r9\u0015qD\u0005\u0005\u0003\u000f\n\u0019E\u0001\u0007T#2+\u0005pY3qi&|gNA\bNsN\u000bFjU)M\u0005VLG\u000eZ3s'\rY\u0011Q\n\t\u0005\u0003\u001f\n\t&D\u0001\u0001\u0013\r\t\u0019F\u0015\u0002\u000f\u0015\u0012\u00135iU)M\u0005VLG\u000eZ3s)\t\t9\u0006E\u0002\u0002P-\tAB^5tSR,\u0005\u0010\u001e:bGR$2!_A/\u0011\u001d\ty&\u0004a\u0001\u0003C\nq!\u001a=ue\u0006\u001cG\u000f\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u0003W2\u0015!C2p]:,7\r^8s\u0013\u0011\ty'!\u001a\u0003\u000f\u0015CHO]1di\u0006\u0001b/[:jiN\u000bFJR;oGRLwN\u001c\u000b\u0006s\u0006U\u0014q\u000f\u0005\u0007\u0003kq\u0001\u0019A=\t\u000f\u0005ed\u00021\u0001\u0002|\u00051\u0011N\u001c9viN\u0004BAXA?s&\u0019\u0011qP0\u0003\u000b\u0005\u0013(/Y=\u0002\u001dYL7/\u001b;T_J$xJ\u001d3feR9\u00110!\"\u0002\n\u0006M\u0005BBAD\u001f\u0001\u0007\u00110A\u0004t_J$8*Z=\t\u000f\u0005-u\u00021\u0001\u0002\u000e\u0006i1o\u001c:u\t&\u0014Xm\u0019;j_:\u0004B!a\u0019\u0002\u0010&!\u0011\u0011SA3\u00055\u0019vN\u001d;ESJ,7\r^5p]\"9\u0011QS\bA\u0002\u0005]\u0015\u0001\u00048vY2|%\u000fZ3sS:<\u0007\u0003BA2\u00033KA!a'\u0002f\taa*\u001e7m\u001fJ$WM]5oO\u0006ya/[:jiN#\u0018M\u001d;t/&$\b\u000eF\u0003z\u0003C\u000b)\u000b\u0003\u0004\u0002$B\u0001\r!_\u0001\u0002Y\"1\u0011q\u0015\tA\u0002e\f\u0011A]\u0001\u000em&\u001c\u0018\u000e^#oIN<\u0016\u000e\u001e5\u0015\u000be\fi+a,\t\r\u0005\r\u0016\u00031\u0001z\u0011\u0019\t9+\u0005a\u0001s\u0006ia/[:ji\u000e{g\u000e^1j]N$R!_A[\u0003oCa!a)\u0013\u0001\u0004I\bBBAT%\u0001\u0007\u00110\u0001\fwSNLG/Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o)\u001dI\u0018QXA`\u0003\u0007Da!!\u000e\u0014\u0001\u0004I\bBBAa'\u0001\u0007A/\u0001\u0006jg\u0012K7\u000f^5oGRDq!!\u001f\u0014\u0001\u0004\tY(A\td_6\u0004\u0018\u000e\\3FqB\u0014Xm]:j_:$B!!3\u0002PB!a,a3z\u0013\r\tim\u0018\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005EG\u00031\u0001\u0002T\u0006!Q\r\u001f9s!\u0011\t\u0019'!6\n\t\u0005]\u0017Q\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0015\u0005u\u00171^A{\u0003s\fi\u0010E\u0003_\u0003\u0017\fy\u000e\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)OR\u0001\u0006if\u0004Xm]\u0005\u0005\u0003S\f\u0019O\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\ti/\u0006a\u0001\u0003_\fqa]9m)f\u0004X\rE\u0002_\u0003cL1!a=`\u0005\rIe\u000e\u001e\u0005\u0007\u0003o,\u0002\u0019A=\u0002\u0011QL\b/\u001a(b[\u0016Dq!a?\u0016\u0001\u0004\ty/\u0001\u0003tSj,\u0007bBA\u0000+\u0001\u0007!\u0011A\u0001\u0003[\u0012\u0004B!!9\u0003\u0004%!!QAAr\u0005=iU\r^1eCR\f')^5mI\u0016\u0014\u0018aD9v_R,\u0017\nZ3oi&4\u0017.\u001a:\u0015\u0007e\u0014Y\u0001\u0003\u0004\u0003\u000eY\u0001\r!_\u0001\bG>dg*Y7f\u00035\u00198\r[3nCN,\u00050[:ugR9AOa\u0005\u0003\u001e\tM\u0002b\u0002B\u000b/\u0001\u0007!qC\u0001\u0005G>tg\u000e\u0005\u0003\u0002B\te\u0011\u0002\u0002B\u000e\u0003\u0007\u0012!bQ8o]\u0016\u001cG/[8o\u0011\u001d\u0011yb\u0006a\u0001\u0005C\tqa\u001c9uS>t7\u000f\u0005\u0003\u0003$\t=RB\u0001B\u0013\u0015\r)%q\u0005\u0006\u0005\u0005S\u0011Y#A\u0006eCR\f7o\\;sG\u0016\u001c(b\u0001B\u0017\r\u0006IQ\r_3dkRLwN\\\u0005\u0005\u0005c\u0011)CA\u0006K\t\n\u001bu\n\u001d;j_:\u001c\bB\u0002B\u001b/\u0001\u0007\u00110\u0001\u0004tG\",W.Y\u0001\fY&\u001cHoU2iK6\f7\u000f\u0006\u0004\u0003<\tu\"q\b\t\u0006=\u0006u\u00141\u0010\u0005\b\u0005+A\u0002\u0019\u0001B\f\u0011\u001d\u0011y\u0002\u0007a\u0001\u0005C\t\u0001$[:DCN\u001c\u0017\rZ5oOR\u0013XO\\2bi\u0016$\u0016M\u00197f)\t\u0011)\u0005\u0005\u0003_\u0003\u0017$\u0018aF5t'ftG/\u0019=FeJ|'OQ3ti\u00163gm\u001c:u)\r!(1\n\u0005\b\u0005\u001bR\u0002\u0019AA \u0003%)\u0007pY3qi&|g.\u0001\rhKR,\u0006\u000fZ1uK\u000e{G.^7o)f\u0004X-U;fef$r!\u001fB*\u0005/\u0012Y\u0006\u0003\u0004\u0003Vm\u0001\r!_\u0001\ni\u0006\u0014G.\u001a(b[\u0016DaA!\u0017\u001c\u0001\u0004I\u0018AC2pYVlgNT1nK\"1!QL\u000eA\u0002e\f1B\\3x\t\u0006$\u0018\rV=qK\u0006!r-\u001a;SK:\fW.Z\"pYVlg.U;fef$\u0012\"\u001fB2\u0005K\u00129Ga\u001b\t\r\tUC\u00041\u0001z\u0011\u0019\u0011I\u0006\ba\u0001s\"1!\u0011\u000e\u000fA\u0002e\fqA\\3x\u001d\u0006lW\rC\u0004\u0003nq\u0001\r!a<\u0002\u001d\u0011\u0014W*\u00196peZ+'o]5p]\u0006yr-\u001a;Va\u0012\fG/Z\"pYVlgNT;mY\u0006\u0014\u0017\u000e\\5usF+XM]=\u0015\u000fe\u0014\u0019H!\u001e\u0003x!1!QK\u000fA\u0002eDaA!\u0017\u001e\u0001\u0004I\bB\u0002B=;\u0001\u0007A/\u0001\u0006jg:+H\u000e\\1cY\u0016\fAcZ3u)\u0006\u0014G.Z\"p[6,g\u000e^)vKJLH#B=\u0003\u0000\t\r\u0005B\u0002BA=\u0001\u0007\u00110A\u0003uC\ndW\r\u0003\u0004\u0003\u0006z\u0001\r!_\u0001\bG>lW.\u001a8u\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\t\t-%1\u0013\t\u0006=\u0006-'Q\u0012\t\u0004#\n=\u0015b\u0001BI\t\nA!\n\u001a2d)f\u0004X\rC\u0004\u0003\u0016~\u0001\r!a8\u0002\u0005\u0011$\u0018!F4fiN\u001b\u0007.Z7b\u0007>lW.\u001a8u#V,'/\u001f\u000b\u0006s\nm%Q\u0014\u0005\u0007\u0005k\u0001\u0003\u0019A=\t\r\t\u0015\u0005\u00051\u0001z\u0003a\u0011X-\\8wKN\u001b\u0007.Z7b\u0007>lW.\u001a8u#V,'/\u001f\u000b\u0004s\n\r\u0006B\u0002B\u001bC\u0001\u0007\u00110A\u0006de\u0016\fG/Z%oI\u0016DHcC=\u0003*\n5&Q\u0018Be\u00057DaAa+#\u0001\u0004I\u0018!C5oI\u0016Dh*Y7f\u0011\u001d\u0011yK\ta\u0001\u0005c\u000b!\u0002^1cY\u0016LE-\u001a8u!\u0011\u0011\u0019L!/\u000e\u0005\tU&\u0002\u0002B\\\u0003S\nqaY1uC2|w-\u0003\u0003\u0003<\nU&AC%eK:$\u0018NZ5fe\"9!q\u0018\u0012A\u0002\t\u0005\u0017aB2pYVlgn\u001d\t\u0006=\u0006u$1\u0019\t\u0005\u0003G\u0012)-\u0003\u0003\u0003H\u0006\u0015$A\u0004(b[\u0016$'+\u001a4fe\u0016t7-\u001a\u0005\b\u0005\u0017\u0014\u0003\u0019\u0001Bg\u0003E\u0019w\u000e\\;n]N\u0004&o\u001c9feRLWm\u001d\t\t\u0005\u001f\u0014)Na1\u0003Z6\u0011!\u0011\u001b\u0006\u0005\u0005'\fy\"\u0001\u0003vi&d\u0017\u0002\u0002Bl\u0005#\u00141!T1q!\u0019\u0011yM!6zs\"9!Q\u001c\u0012A\u0002\te\u0017A\u00039s_B,'\u000f^5fg\u0006Y\u0011N\u001c3fq\u0016C\u0018n\u001d;t)%!(1\u001dBs\u0005O\u0014I\u000fC\u0004\u0003\u0016\r\u0002\rAa\u0006\t\r\t-6\u00051\u0001z\u0011\u001d\u0011yk\ta\u0001\u0005cCqAa\b$\u0001\u0004\u0011\t#A\u0005ee>\u0004\u0018J\u001c3fqR)\u0011Pa<\u0003r\"1!1\u0016\u0013A\u0002eDqAa,%\u0001\u0004\u0011\t,A\u0006mSN$\u0018J\u001c3fq\u0016\u001cH\u0003\u0003B|\u0007\u000b\u00199a!\u0003\u0011\u000by\u000biH!?\u0011\t\tm8\u0011A\u0007\u0003\u0005{TAAa@\u00036\u0006)\u0011N\u001c3fq&!11\u0001B\u007f\u0005)!\u0016M\u00197f\u0013:$W\r\u001f\u0005\b\u0005+)\u0003\u0019\u0001B\f\u0011\u001d\u0011y+\na\u0001\u0005cCqAa\b&\u0001\u0004\u0011\t#A\tdY\u0006\u001c8/\u001b4z\u000bb\u001cW\r\u001d;j_:$Bba\u0004\u0004$\r\u00152\u0011FB\u0019\u0007k\u0011ba!\u0005\u0004\u0016\rmaABB\n\u0001\u0001\u0019yA\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002e\u0007/I1a!\u0007o\u0005%!\u0006N]8xC\ndW\r\u0005\u0003\u0004\u001e\r}Q\"\u0001%\n\u0007\r\u0005\u0002J\u0001\bTa\u0006\u00148\u000e\u00165s_^\f'\r\\3\t\u000f\u0005ub\u00051\u0001\u0004\u0016!11q\u0005\u0014A\u0002e\f\u0011bY8oI&$\u0018n\u001c8\t\u000f\r-b\u00051\u0001\u0004.\u0005\tR.Z:tC\u001e,\u0007+\u0019:b[\u0016$XM]:\u0011\u000bi\u001cy#_=\n\t\t]\u0017\u0011\u0001\u0005\u0007\u0007g1\u0003\u0019A=\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\u0007\u0007o1\u0003\u0019\u0001;\u0002\u0013%\u001c(+\u001e8uS6,\u0017A\u00033s_B\u001c6\r[3nCR)\u0011p!\u0010\u0004@!1!QG\u0014A\u0002eDaa!\u0011(\u0001\u0004!\u0018aB2bg\u000e\fG-\u001a\u0002\u0015\u001bf\u001c\u0016\u000bT*R\u0019F+XM]=Ck&dG-\u001a:\u0014\u0007!\u001a9\u0005E\u0002R\u0007\u0013J1aa\u0013E\u0005MQEMY2T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s\u0003\u001d!\u0017.\u00197fGR$ba!\u0015\u0004T\rU\u0003cAA(Q!11QJ\u0016A\u0002ACqAa\b,\u0001\u0004\u0011\t#A\u0003ck&dG\rF\u0001z\u0003Y9W\r\u001e&eE\u000e\u001c\u0016\u000bT)vKJL()^5mI\u0016\u0014H\u0003BB$\u0007?BqAa\b.\u0001\u0004\u0011\t#A\u0007tkB\u0004xN\u001d;t\u0019&l\u0017\u000e^\u000b\u0002i\u0006q1/\u001e9q_J$8o\u00144gg\u0016$\u0018\u0001D:vaB|'\u000f^:IS:$\u0018\u0001D:vaB|'\u000f^:K_&t\u0017\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\re4q\u0010\t\u0004=\u000em\u0014bAB??\n\u0019\u0011I\\=\t\u0013\r\u0005U'!AA\u0002\u0005=\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004\bB11\u0011RBF\u0007sj!!a\u0004\n\t\r5\u0015q\u0002\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002u\u0007'C\u0011b!!8\u0003\u0003\u0005\ra!\u001f\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003/\u0019I\nC\u0005\u0004\u0002b\n\t\u00111\u0001\u0002p\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002p\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0018\u00051Q-];bYN$2\u0001^BT\u0011%\u0019\tiOA\u0001\u0002\u0004\u0019I(\u0001\u0007NsN\u000bF\nR5bY\u0016\u001cG\u000f\u0005\u0002R{M)Qha,\u0004<B)1\u0011WB\\c6\u001111\u0017\u0006\u0004\u0007k{\u0016a\u0002:v]RLW.Z\u0005\u0005\u0007s\u001b\u0019LA\tBEN$(/Y2u\rVt7\r^5p]B\u0002Ba!0\u0004D6\u00111q\u0018\u0006\u0005\u0007\u0003\fy\"\u0001\u0002j_&\u0019Qna0\u0015\u0005\r-\u0016!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u0004i\u000e5\u0007\u0002CBh\u0003\u0006\u0005\t\u0019A9\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004VB!\u0011\u0011DBl\u0013\u0011\u0019I.a\u0007\u0003\r=\u0013'.Z2u\u0001")
public class MySQLDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(MySQLDialect x$0) {
        return MySQLDialect$.MODULE$.unapply(x$0);
    }

    public static MySQLDialect apply() {
        return MySQLDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    public Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return e.getErrorCode() == 1146;
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MySQLSQLBuilder mysqlSQLBuilder = new MySQLSQLBuilder(this);
        try {
            some = new Some((Object)mysqlSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (-3 == n2 && "BIT".equalsIgnoreCase(typeName) && size != 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (-7 == n2 && size > 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (12 == n2 && "TINYTEXT".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ((12 == n2 ? true : 1 == n2) && "JSON".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (-6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ByteType$.MODULE$);
            }
            return new Some((Object)ShortType$.MODULE$);
        }
        if (5 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ShortType$.MODULE$);
            }
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (4 == n2 && "MEDIUMINT UNSIGNED".equalsIgnoreCase(typeName)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (7 == n2 ? true : 6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)FloatType$.MODULE$);
            }
            return new Some((Object)DoubleType$.MODULE$);
        }
        if (93 == n2) {
            bl = true;
            n = n2;
            if ("DATETIME".equalsIgnoreCase(typeName)) {
                return new Some((Object)this.getTimestampType(md.build()));
            }
        }
        if (bl && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        String escapedColName = colName.replace("`", "``");
        return "`" + escapedColName + "`";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return "42000".equals(exception.getSQLState());
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion >= 8) {
            return "ALTER TABLE " + tableName + " RENAME COLUMN " + this.quoteIdentifier(columnName) + " TO " + this.quoteIdentifier(newName);
        }
        throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return "ALTER TABLE " + table + " COMMENT = '" + comment + "'";
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("LONGTEXT", -1));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TINYINT", -6));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType) && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return Option$.MODULE$.apply((Object)new JdbcType("DATETIME", 93));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCommentNamespaceError(schema);
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError(schema);
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.quoteIdentifier(tableIdent.name()) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(" ");
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + this.quoteIdentifier(tableIdent.name()) + " WHERE key_name = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName) + " ON " + tableIdent.name();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + tableIdent.name();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1050: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
                case 1061: {
                    String string = condition;
                    String string3 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 1091: {
                    String string = condition;
                    String string4 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string4) : string4 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema);
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceError(schema);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MySQLSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    @Override
    public boolean supportsJoin() {
        return true;
    }

    public MySQLDialect copy() {
        return new MySQLDialect();
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MySQLDialect && ((MySQLDialect)x$1).canEqual(this);
    }

    private final Option getCatalystTypeForBitArray$1(MetadataBuilder md$1) {
        md$1.putLong("binarylong", 1L);
        if (this.conf().legacyMySqlBitArrayMappingEnabled()) {
            return new Some((Object)LongType$.MODULE$);
        }
        return new Some((Object)BinaryType$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$1));
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(indexComment)) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public MySQLDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_ADD", "DATE_DIFF"})));
    }

    public class MySQLSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(Extract extract2) {
            String field;
            block12: {
                field = extract2.field();
                String string = field;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1852950412: {
                        if ("SECOND".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case -1351979174: {
                        if ("YEAR_OF_WEEK".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 2660340: {
                        if ("WEEK".equals(string)) {
                            return "WEEKOFYEAR(" + this.build(extract2.source()) + ")";
                        }
                        break block12;
                    }
                    case 2074232729: {
                        if ("DAY_OF_WEEK".equals(string)) {
                            return "(WEEKDAY(" + this.build(extract2.source()) + ") + 1)";
                        }
                        break block12;
                    }
                    case 2074292194: {
                        if ("DAY_OF_YEAR".equals(string)) {
                            return "DAYOFYEAR(" + this.build(extract2.source()) + ")";
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                return this.visitUnexpectedExpr((Expression)extract2);
            }
            return super.visitExtract(field, this.build(extract2.source()));
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -1728155146: {
                    if (!"DATE_DIFF".equals(string)) break;
                    return "DATEDIFF(" + inputs[0] + ", " + inputs[1] + ")";
                }
                case -1718317968: {
                    if (!"DATE_ADD".equals(string)) break;
                    return "DATE_ADD(" + inputs[0] + ", INTERVAL " + inputs[1] + " DAY)";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
            Tuple2 tuple2 = new Tuple2((Object)sortDirection, (Object)nullOrdering);
            if (tuple2 != null) {
                SortDirection sortDirection2 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering2 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection2) && NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
                    return sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection3 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering3 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection3) && NullOrdering.NULLS_LAST.equals(nullOrdering3)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 1 ELSE 0 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection4 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering4 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection4) && NullOrdering.NULLS_FIRST.equals(nullOrdering4)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 0 ELSE 1 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection5 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering5 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection5) && NullOrdering.NULLS_LAST.equals(nullOrdering5)) {
                    return sortKey + " " + sortDirection;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        public String visitStartsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        public String visitEndsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "' ESCAPE '\\\\'";
        }

        public String visitContains(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer().org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer() {
            return (MySQLDialect)this.$outer;
        }

        public MySQLSQLBuilder(MySQLDialect $outer) {
        }
    }

    public class MySQLSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ MySQLDialect $outer;

        @Override
        public String build() {
            String limitOrOffsetStmt = this.limit() > 0 ? (this.offset() > 0 ? "LIMIT " + this.offset() + ", " + this.limit() : this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()))) : (this.offset() > 0 ? "LIMIT " + this.offset() + ", 18446744073709551615" : "");
            return this.options.prepareQuery() + "SELECT " + this.hintClause() + this.columnList() + " FROM " + this.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + limitOrOffsetStmt;
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public MySQLSQLQueryBuilder(MySQLDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

