/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.spark.sql.catalyst.xml.XmlOptions$;
import org.apache.spark.sql.execution.datasources.xml.XmlInputFormat$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tEb!\u0002\u001c8\u0001]*\u0005\"B,\u0001\t\u0003I\u0006\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0011%Y\u0007\u00011AA\u0002\u0013%A\u000eC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005=\"IA\u000f\u0001a\u0001\u0002\u0004%I!\u0018\u0005\nk\u0002\u0001\r\u00111A\u0005\nYD\u0011\u0002\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u00020\t\u0013e\u0004\u0001\u0019!a\u0001\n\u0013i\u0006\"\u0003>\u0001\u0001\u0004\u0005\r\u0011\"\u0003|\u0011%i\b\u00011A\u0001B\u0003&a\fC\u0005\u007f\u0001\u0001\u0007\t\u0019!C\u0005\u007f\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0002\u0011)\t9\u0001\u0001a\u0001\u0002\u0003\u0006KA\u0014\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0001C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\n\u0005=\u0001BCA\n\u0001\u0001\u0007\t\u0011)Q\u0005)\"Y\u0011Q\u0003\u0001A\u0002\u0003\u0007I\u0011BA\f\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0017\u0005\u0015\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0004\u0005\f\u0003O\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0002C\u0006\u0002*\u0001\u0001\r\u00111A\u0005\n\u0005-\u0002bCA\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u00033A1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0011-\tI\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000e\t\u0017\u0005-\u0003\u00011AA\u0002\u0013%\u0011Q\n\u0005\f\u00037\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0006C\u0006\u0002b\u0001\u0001\r\u0011!Q!\n\u0005=\u0003bCA2\u0001\u0001\u0007\t\u0019!C\u0005\u0003KB1\"!\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002|!Y\u0011q\u0010\u0001A\u0002\u0003\u0005\u000b\u0015BA4\u0011-\t\t\t\u0001a\u0001\u0002\u0004%I!a!\t\u0017\u0005E\u0005\u00011AA\u0002\u0013%\u00111\u0013\u0005\f\u0003/\u0003\u0001\u0019!A!B\u0013\t)\tC\u0006\u0002\u001a\u0002\u0001\r\u00111A\u0005\n\u0005m\u0005bCAU\u0001\u0001\u0007\t\u0019!C\u0005\u0003WC1\"a,\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e\"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0007I\u0011BAZ\u0011-\t\t\r\u0001a\u0001\u0002\u0004%I!a1\t\u0017\u0005\u001d\u0007\u00011A\u0001B\u0003&\u0011Q\u0017\u0005\n\u0003\u0013\u0004\u0001\u0019!C\u0005\u0003\u0017D\u0011\"!8\u0001\u0001\u0004%I!a8\t\u0011\u0005\r\b\u0001)Q\u0005\u0003\u001bDq!!:\u0001\t\u0003\n9\u000fC\u0004\u0002~\u0002!I!a@\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\t\u0001\u0011%!1\u0001\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011Y\u0002\u0001C!\u0005;AqA!\n\u0001\t\u0003\u00129\u0003C\u0004\u0003*\u0001!\tEa\u000b\t\u000f\t5\u0002\u0001\"\u0001\u00030\ty\u0001,\u001c7SK\u000e|'\u000f\u001a*fC\u0012,'O\u0003\u00029s\u0005\u0019\u00010\u001c7\u000b\u0005iZ\u0014a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001P\u001f\u0002\u0013\u0015DXmY;uS>t'B\u0001 @\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0001\u0006\u000bQa\u001d9be.T!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sON\u0011\u0001A\u0012\t\u0005\u000f2sE+D\u0001I\u0015\tI%*A\u0005nCB\u0014X\rZ;dK*\u00111*Q\u0001\u0007Q\u0006$wn\u001c9\n\u00055C%\u0001\u0004*fG>\u0014HMU3bI\u0016\u0014\bCA(S\u001b\u0005\u0001&BA)K\u0003\tIw.\u0003\u0002T!\naAj\u001c8h/JLG/\u00192mKB\u0011q*V\u0005\u0003-B\u0013A\u0001V3yi\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001[!\tY\u0006!D\u00018\u0003!\u0019H/\u0019:u)\u0006<W#\u00010\u0011\u0005}CgB\u00011g!\t\tG-D\u0001c\u0015\t\u0019\u0007,\u0001\u0004=e>|GO\u0010\u0006\u0002K\u0006)1oY1mC&\u0011q\rZ\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002hI\u0006a1\u000f^1siR\u000bwm\u0018\u0013fcR\u0011Q.\u001d\t\u0003]>l\u0011\u0001Z\u0005\u0003a\u0012\u0014A!\u00168ji\"9!oAA\u0001\u0002\u0004q\u0016a\u0001=%c\u0005I1\u000f^1siR\u000bw\rI\u0001\u0010GV\u0014(/\u001a8u'R\f'\u000f\u001e+bO\u0006\u00192-\u001e:sK:$8\u000b^1siR\u000bwm\u0018\u0013fcR\u0011Qn\u001e\u0005\be\u001a\t\t\u00111\u0001_\u0003A\u0019WO\u001d:f]R\u001cF/\u0019:u)\u0006<\u0007%\u0001\u0004f]\u0012$\u0016mZ\u0001\u000bK:$G+Y4`I\u0015\fHCA7}\u0011\u001d\u0011\u0018\"!AA\u0002y\u000bq!\u001a8e)\u0006<\u0007%\u0001\u0006dkJ\u0014XM\u001c;LKf,\u0012AT\u0001\u000fGV\u0014(/\u001a8u\u0017\u0016Lx\fJ3r)\ri\u0017Q\u0001\u0005\be2\t\t\u00111\u0001O\u0003-\u0019WO\u001d:f]R\\U-\u001f\u0011\u0002\u0019\r,(O]3oiZ\u000bG.^3\u0016\u0003Q\u000b\u0001cY;se\u0016tGOV1mk\u0016|F%Z9\u0015\u00075\f\t\u0002C\u0004s\u001f\u0005\u0005\t\u0019\u0001+\u0002\u001b\r,(O]3oiZ\u000bG.^3!\u0003\u0015\u0019H/\u0019:u+\t\tI\u0002E\u0002o\u00037I1!!\be\u0005\u0011auN\\4\u0002\u0013M$\u0018M\u001d;`I\u0015\fHcA7\u0002$!A!OEA\u0001\u0002\u0004\tI\"\u0001\u0004ti\u0006\u0014H\u000fI\u0001\u0004K:$\u0017aB3oI~#S-\u001d\u000b\u0004[\u00065\u0002\u0002\u0003:\u0016\u0003\u0003\u0005\r!!\u0007\u0002\t\u0015tG\rI\u0001\u0007e\u0016\fG-\u001a:\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u007fi!!!\u000f\u000b\u0007E\u000bYD\u0003\u0002\u0002>\u0005!!.\u0019<b\u0013\u0011\t\t%!\u000f\u0003\rI+\u0017\rZ3s\u0003)\u0011X-\u00193fe~#S-\u001d\u000b\u0004[\u0006\u001d\u0003\u0002\u0003:\u0019\u0003\u0003\u0005\r!!\u000e\u0002\u000fI,\u0017\rZ3sA\u0005aa-\u001b7f!>\u001c\u0018\u000e^5p]V\u0011\u0011q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011Q\u000b&\u0002\u0005\u0019\u001c\u0018\u0002BA-\u0003'\u0012\u0001bU3fW\u0006\u0014G.Z\u0001\u0011M&dW\rU8tSRLwN\\0%KF$2!\\A0\u0011!\u00118$!AA\u0002\u0005=\u0013!\u00044jY\u0016\u0004vn]5uS>t\u0007%\u0001\u0006d_VtG/\u001b8h\u0013:,\"!a\u001a\u0011\t\u0005%\u0014QO\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005)\u0011N\u001c9vi*\u0019\u0011+!\u001d\u000b\u0007\u0005M\u0014)A\u0004d_6lwN\\:\n\t\u0005]\u00141\u000e\u0002\u0013\u0005>,h\u000eZ3e\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\bd_VtG/\u001b8h\u0013:|F%Z9\u0015\u00075\fi\b\u0003\u0005s=\u0005\u0005\t\u0019AA4\u0003-\u0019w.\u001e8uS:<\u0017J\u001c\u0011\u0002)I,\u0017\rZ3s\u0019\u00164Go\u001c<fe\u000eC\u0017M\u001d$o+\t\t)\tE\u0003o\u0003\u000f\u000bY)C\u0002\u0002\n\u0012\u0014\u0011BR;oGRLwN\u001c\u0019\u0011\u00079\fi)C\u0002\u0002\u0010\u0012\u0014qAQ8pY\u0016\fg.\u0001\rsK\u0006$WM\u001d'fMR|g/\u001a:DQ\u0006\u0014hI\\0%KF$2!\\AK\u0011!\u0011\u0018%!AA\u0002\u0005\u0015\u0015!\u0006:fC\u0012,'\u000fT3gi>4XM]\"iCJ4e\u000eI\u0001\u0011e\u0016\fG-\u001a:CsR,')\u001e4gKJ,\"!!(\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CSA!a)\u0002<\u0005\u0019a.[8\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018\u0001\u0006:fC\u0012,'OQ=uK\n+hMZ3s?\u0012*\u0017\u000fF\u0002n\u0003[C\u0001B\u001d\u0013\u0002\u0002\u0003\u0007\u0011QT\u0001\u0012e\u0016\fG-\u001a:CsR,')\u001e4gKJ\u0004\u0013\u0001\u00043fG>l\u0007O]3tg>\u0014XCAA[!\u0011\t9,!0\u000e\u0005\u0005e&bAA^!\u0006A1m\\7qe\u0016\u001c8/\u0003\u0003\u0002@\u0006e&\u0001\u0004#fG>l\u0007O]3tg>\u0014\u0018\u0001\u00053fG>l\u0007O]3tg>\u0014x\fJ3r)\ri\u0017Q\u0019\u0005\te\u001e\n\t\u00111\u0001\u00026\u0006iA-Z2p[B\u0014Xm]:pe\u0002\naAY;gM\u0016\u0014XCAAg!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\fq!\\;uC\ndWMC\u0002\u0002X\u0012\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY.!5\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0003)\u0011WO\u001a4fe~#S-\u001d\u000b\u0004[\u0006\u0005\b\u0002\u0003:+\u0003\u0003\u0005\r!!4\u0002\u000f\t,hMZ3sA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u000b5\fI/a=\t\u000f\u0005-H\u00061\u0001\u0002n\u0006)1\u000f\u001d7jiB\u0019q)a<\n\u0007\u0005E\bJ\u0001\u0006J]B,Ho\u00159mSRDq!!>-\u0001\u0004\t90A\u0004d_:$X\r\u001f;\u0011\u0007\u001d\u000bI0C\u0002\u0002|\"\u0013!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u0006yq-\u001a;GS2,\u0007k\\:ji&|g\u000e\u0006\u0002\u0002\u001a\u0005aa.\u001a=u\u0017\u0016Lh+\u00197vKR\u0011\u00111R\u0001\u0005]\u0016DH\u000f\u0006\u0004\u0002\f\n%!Q\u0002\u0005\u0007\u0005\u0017y\u0003\u0019\u0001(\u0002\u0007-,\u0017\u0010\u0003\u0004\u0003\u0010=\u0002\r\u0001V\u0001\u0006m\u0006dW/Z\u0001\u0016e\u0016\fG-\u00168uS2\u001cF/\u0019:u\u000b2,W.\u001a8u\u0003M\u0011X-\u00193V]RLG.\u00128e\u000b2,W.\u001a8u)\u0011\tYIa\u0006\t\u000f\te\u0011\u00071\u0001\u0002\f\u0006q1\u000f^1siR\u000bwm\u00117pg\u0016$\u0017aC4fiB\u0013xn\u001a:fgN$\"Aa\b\u0011\u00079\u0014\t#C\u0002\u0003$\u0011\u0014QA\u00127pCR\fQbZ3u\u0007V\u0014(/\u001a8u\u0017\u0016LH#\u0001(\u0002\u001f\u001d,GoQ;se\u0016tGOV1mk\u0016$\u0012\u0001V\u0001\u0006G2|7/\u001a\u000b\u0002[\u0002")
public class XmlRecordReader
extends RecordReader<LongWritable, Text> {
    private String startTag;
    private String currentStartTag;
    private String endTag;
    private LongWritable currentKey;
    private Text currentValue;
    private long start;
    private long end;
    private Reader reader;
    private Seekable filePosition;
    private BoundedInputStream countingIn;
    private Function0<Object> readerLeftoverCharFn;
    private ByteBuffer readerByteBuffer;
    private Decompressor decompressor;
    private StringBuilder buffer = new StringBuilder();

    private String startTag() {
        return this.startTag;
    }

    private void startTag_$eq(String x$1) {
        this.startTag = x$1;
    }

    private String currentStartTag() {
        return this.currentStartTag;
    }

    private void currentStartTag_$eq(String x$1) {
        this.currentStartTag = x$1;
    }

    private String endTag() {
        return this.endTag;
    }

    private void endTag_$eq(String x$1) {
        this.endTag = x$1;
    }

    private LongWritable currentKey() {
        return this.currentKey;
    }

    private void currentKey_$eq(LongWritable x$1) {
        this.currentKey = x$1;
    }

    private Text currentValue() {
        return this.currentValue;
    }

    private void currentValue_$eq(Text x$1) {
        this.currentValue = x$1;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long end() {
        return this.end;
    }

    private void end_$eq(long x$1) {
        this.end = x$1;
    }

    private Reader reader() {
        return this.reader;
    }

    private void reader_$eq(Reader x$1) {
        this.reader = x$1;
    }

    private Seekable filePosition() {
        return this.filePosition;
    }

    private void filePosition_$eq(Seekable x$1) {
        this.filePosition = x$1;
    }

    private BoundedInputStream countingIn() {
        return this.countingIn;
    }

    private void countingIn_$eq(BoundedInputStream x$1) {
        this.countingIn = x$1;
    }

    private Function0<Object> readerLeftoverCharFn() {
        return this.readerLeftoverCharFn;
    }

    private void readerLeftoverCharFn_$eq(Function0<Object> x$1) {
        this.readerLeftoverCharFn = x$1;
    }

    private ByteBuffer readerByteBuffer() {
        return this.readerByteBuffer;
    }

    private void readerByteBuffer_$eq(ByteBuffer x$1) {
        this.readerByteBuffer = x$1;
    }

    private Decompressor decompressor() {
        return this.decompressor;
    }

    private void decompressor_$eq(Decompressor x$1) {
        this.decompressor = x$1;
    }

    private StringBuilder buffer() {
        return this.buffer;
    }

    private void buffer_$eq(StringBuilder x$1) {
        this.buffer = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(InputSplit split, TaskAttemptContext context) {
        FileSplit fileSplit = (FileSplit)split;
        Configuration conf = context.getConfiguration();
        Charset charset = Charset.forName(conf.get(XmlInputFormat$.MODULE$.ENCODING_KEY(), XmlOptions$.MODULE$.DEFAULT_CHARSET()));
        this.startTag_$eq(conf.get(XmlInputFormat$.MODULE$.START_TAG_KEY()));
        this.endTag_$eq(conf.get(XmlInputFormat$.MODULE$.END_TAG_KEY()));
        this.start_$eq(fileSplit.getStart());
        this.end_$eq(this.start() + fileSplit.getLength());
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem(conf);
        FSDataInputStream fsin = fs.open(fileSplit.getPath());
        BoundedInputStream in = null;
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(path);
        if (codec != null) {
            this.decompressor_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            CompressionCodec compressionCodec = codec;
            if (compressionCodec instanceof SplittableCompressionCodec) {
                SplittableCompressionCodec splittableCompressionCodec = (SplittableCompressionCodec)compressionCodec;
                SplitCompressionInputStream cIn = splittableCompressionCodec.createInputStream((InputStream)fsin, this.decompressor(), this.start(), this.end(), SplittableCompressionCodec.READ_MODE.BYBLOCK);
                this.start_$eq(cIn.getAdjustedStart());
                this.end_$eq(cIn.getAdjustedEnd());
                in = cIn;
                this.filePosition_$eq((Seekable)cIn);
            } else {
                if (compressionCodec == null) throw new MatchError((Object)compressionCodec);
                CompressionCodec compressionCodec2 = compressionCodec;
                if (this.start() != 0L) {
                    throw new IOException("Cannot seek in " + codec.getClass().getSimpleName() + " compressed stream");
                }
                CompressionInputStream cIn = compressionCodec2.createInputStream((InputStream)fsin, this.decompressor());
                in = cIn;
                this.filePosition_$eq((Seekable)fsin);
            }
        } else {
            fsin.seek(this.start());
            this.countingIn_$eq(((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)fsin)).get());
            in = this.countingIn();
        }
        this.reader_$eq(new InputStreamReader((InputStream)in, charset));
        if (codec != null) return;
        Field sdField = this.reader().getClass().getDeclaredField("sd");
        sdField.setAccessible(true);
        Object sd = sdField.get(this.reader());
        Field readerLeftoverCharField = sd.getClass().getDeclaredField("haveLeftoverChar");
        readerLeftoverCharField.setAccessible(true);
        this.readerLeftoverCharFn_$eq((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)readerLeftoverCharField.get(sd)));
        Field bbField = sd.getClass().getDeclaredField("bb");
        bbField.setAccessible(true);
        this.readerByteBuffer_$eq((ByteBuffer)bbField.get(sd));
    }

    private long getFilePosition() {
        if (this.filePosition() != null) {
            return this.filePosition().getPos();
        }
        return this.start() + this.countingIn().getCount() - (long)this.readerByteBuffer().remaining() - (long)(this.readerLeftoverCharFn().apply$mcZ$sp() ? 1 : 0);
    }

    public boolean nextKeyValue() {
        this.currentKey_$eq(new LongWritable());
        this.currentValue_$eq(new Text());
        return this.next(this.currentKey(), this.currentValue());
    }

    private boolean next(LongWritable key, Text value) {
        if (this.readUntilStartElement()) {
            boolean bl;
            try {
                this.buffer().append(this.currentStartTag());
                this.readUntilEndElement(this.currentStartTag().endsWith(">"));
                key.set(this.getFilePosition());
                value.set(this.buffer().toString());
                bl = true;
            }
            finally {
                this.buffer_$eq(new StringBuilder());
            }
            return bl;
        }
        return false;
    }

    private boolean readUntilStartElement() {
        this.currentStartTag_$eq(this.startTag());
        int i = 0;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1 && (i != 0 || this.getFilePosition() <= this.end())) {
            char c = (char)cOrEOF;
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), i)) {
                if (i >= this.startTag().length() - 1) {
                    return true;
                }
                ++i;
                continue;
            }
            if (i == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                this.currentStartTag_$eq(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(this.startTag()), 1) + c);
                return true;
            }
            i = 0;
        }
        return false;
    }

    private boolean readUntilEndElement(boolean startTagClosed) {
        boolean canSelfClose;
        int si = 0;
        int ei = 0;
        int depth = 0;
        int prevC = 0;
        boolean bl = canSelfClose = !startTagClosed;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1) {
            char c = (char)cOrEOF;
            this.buffer().append(c);
            if (c == '>' && prevC != 47) {
                canSelfClose = false;
            }
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), si)) {
                if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                    ++si;
                    ++ei;
                } else if (si >= this.startTag().length() - 1) {
                    si = 0;
                    ei = 0;
                    ++depth;
                } else {
                    ++si;
                    ei = 0;
                }
            } else if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                if (ei >= this.endTag().length() - 1) {
                    if (depth == 0) {
                        return true;
                    }
                    si = 0;
                    ei = 0;
                    --depth;
                } else {
                    si = 0;
                    ++ei;
                }
            } else if (c == '>' && prevC == 47 && canSelfClose) {
                if (depth == 0) {
                    return true;
                }
                si = 0;
                ei = 0;
                --depth;
            } else if (si == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                si = 0;
                ei = 0;
                ++depth;
            } else {
                si = 0;
                ei = 0;
            }
            prevC = c;
        }
        return false;
    }

    public float getProgress() {
        if (this.start() == this.end()) {
            return 0.0f;
        }
        return package$.MODULE$.min(1.0f, (float)(this.getFilePosition() - this.start()) / (float)(this.end() - this.start()));
    }

    public LongWritable getCurrentKey() {
        return this.currentKey();
    }

    public Text getCurrentValue() {
        return this.currentValue();
    }

    public void close() {
        try {
            if (this.reader() != null) {
                this.reader().close();
                this.reader_$eq(null);
            }
        }
        finally {
            if (this.decompressor() != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor());
                this.decompressor_$eq(null);
            }
        }
    }
}

