/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00114QAD\b\u0003\u001fmA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!)A\u0006\u0001C\u0001[!)A\u0006\u0001C\u0001c!9!\b\u0001a\u0001\n#Y\u0004bB \u0001\u0001\u0004%\t\u0002\u0011\u0005\u0007\r\u0002\u0001\u000b\u0015\u0002\u001f\t\u000f\u001d\u0003\u0001\u0019!C\tw!9\u0001\n\u0001a\u0001\n#I\u0005BB&\u0001A\u0003&A\bC\u0003M\u0001\u0011\u0005S\nC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003]\u0001\u0011\u0005SL\u0001\nEK\u000eLW.\u00197D_2,XN\\*uCR\u001c(B\u0001\t\u0012\u0003!\u0019w\u000e\\;n]\u0006\u0014(B\u0001\n\u0014\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c2\u0001\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005J\u0007\u0002\u001f%\u0011Qe\u0004\u0002\f\u0007>dW/\u001c8Ti\u0006$8/A\u0005qe\u0016\u001c\u0017n]5p]\u000e\u0001\u0001CA\u000f*\u0013\tQcDA\u0002J]R\fQa]2bY\u0016\fa\u0001P5oSRtDc\u0001\u00180aA\u00111\u0005\u0001\u0005\u0006M\r\u0001\r\u0001\u000b\u0005\u0006W\r\u0001\r\u0001\u000b\u000b\u0003]IBQa\r\u0003A\u0002Q\n!\u0001\u001a;\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\u001a\u0012!\u0002;za\u0016\u001c\u0018BA\u001d7\u0005-!UmY5nC2$\u0016\u0010]3\u0002\u000bU\u0004\b/\u001a:\u0016\u0003q\u0002\"!N\u001f\n\u0005y2$a\u0002#fG&l\u0017\r\\\u0001\nkB\u0004XM]0%KF$\"!\u0011#\u0011\u0005u\u0011\u0015BA\"\u001f\u0005\u0011)f.\u001b;\t\u000f\u00153\u0011\u0011!a\u0001y\u0005\u0019\u0001\u0010J\u0019\u0002\rU\u0004\b/\u001a:!\u0003\u0015awn^3s\u0003%awn^3s?\u0012*\u0017\u000f\u0006\u0002B\u0015\"9Q)CA\u0001\u0002\u0004a\u0014A\u00027po\u0016\u0014\b%A\u0006hCRDWM]*uCR\u001cHcA!O-\")qj\u0003a\u0001!\u0006\u0019!o\\<\u0011\u0005E#V\"\u0001*\u000b\u0005M\u001b\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005U\u0013&aC%oi\u0016\u0014h.\u00197S_^DQaV\u0006A\u0002!\nqa\u001c:eS:\fG.\u0001\thCRDWM\u001d,bYV,7\u000b^1ugR\u0011\u0011I\u0017\u0005\u000672\u0001\r\u0001P\u0001\u0006m\u0006dW/Z\u0001\u0014G>dG.Z2uK\u0012\u001cF/\u0019;jgRL7m]\u000b\u0002=B\u0019QdX1\n\u0005\u0001t\"!B!se\u0006L\bCA\u000fc\u0013\t\u0019gDA\u0002B]f\u0004")
public final class DecimalColumnStats
implements ColumnStats {
    private final int precision;
    private final int scale;
    private Decimal upper;
    private Decimal lower;
    private int count;
    private int nullCount;
    private long sizeInBytes;

    @Override
    public void gatherNullStats() {
        ColumnStats.gatherNullStats$(this);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public int nullCount() {
        return this.nullCount;
    }

    @Override
    public void nullCount_$eq(int x$1) {
        this.nullCount = x$1;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void sizeInBytes_$eq(long x$1) {
        this.sizeInBytes = x$1;
    }

    public Decimal upper() {
        return this.upper;
    }

    public void upper_$eq(Decimal x$1) {
        this.upper = x$1;
    }

    public Decimal lower() {
        return this.lower;
    }

    public void lower_$eq(Decimal x$1) {
        this.lower = x$1;
    }

    @Override
    public void gatherStats(InternalRow row, int ordinal) {
        if (!row.isNullAt(ordinal)) {
            Decimal value = row.getDecimal(ordinal, this.precision, this.scale);
            this.gatherValueStats(value);
            return;
        }
        this.gatherNullStats();
    }

    public void gatherValueStats(Decimal value) {
        if (this.upper() == null || value.compareTo((Object)this.upper()) > 0) {
            this.upper_$eq(value);
        }
        if (this.lower() == null || value.compareTo((Object)this.lower()) < 0) {
            this.lower_$eq(value);
        }
        this.sizeInBytes_$eq(this.sizeInBytes() + 8L);
        this.count_$eq(this.count() + 1);
    }

    @Override
    public Object[] collectedStatistics() {
        return new Object[]{this.lower(), this.upper(), BoxesRunTime.boxToInteger((int)this.nullCount()), BoxesRunTime.boxToInteger((int)this.count()), BoxesRunTime.boxToLong((long)this.sizeInBytes())};
    }

    public DecimalColumnStats(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
        ColumnStats.$init$(this);
        this.upper = null;
        this.lower = null;
    }

    public DecimalColumnStats(DecimalType dt) {
        this(dt.precision(), dt.scale());
    }
}

