/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.streaming.WriteToStreamStatement;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.StreamingQuery;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.runtime.AsyncProgressTrackingMicroBatchExecution;
import org.apache.spark.sql.execution.streaming.runtime.AsyncProgressTrackingMicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.runtime.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.runtime.StreamExecution;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r\u0015c\u0001\u0002\u0015*\u0001QB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"11\n\u0001C\u0001W1C\u0001\u0002\u0015\u0001C\u0002\u0013\u00051&\u0015\u0005\u00077\u0002\u0001\u000b\u0011\u0002*\t\u000fq\u0003!\u0019!C\u0005;\"1A\r\u0001Q\u0001\nyCq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004}\u0001\u0001\u0006Ia\u001a\u0005\n\u0003+\u0001!\u0019!C\u0005\u0003/A\u0001\"!\n\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003/A\u0001\"!\u000b\u0001A\u0003%\u0011\u0011\u0004\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003C\u0006\u0002>\u0001\u0001\r\u00111A\u0005\n\u0005}\u0002bCA&\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_Aq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005m\u0003\u0001\"\u0001\u0002d!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBA?\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003;\u0004A\u0011AA@\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!!<\u0001\t\u0003\ty\u000fC\u0004\u0002t\u0002!\t!!>\t\u0011\u0005e\b\u0001\"\u0001,\u0003wDqAa\u0004\u0001\t\u0013\u0011\t\u0002C\u0004\u0003\u001e\u0001!IAa\b\t\u0013\te\u0006!%A\u0005\n\tm\u0006\"\u0003Bh\u0001E\u0005I\u0011\u0002Bi\u0011!\u0011)\u000e\u0001C\u0001W\t]\u0007BCB\n\u0001E\u0005I\u0011A\u0016\u0004\u0016!Q1\u0011\u0004\u0001\u0012\u0002\u0013\u00051f!\u0006\t\u0015\rm\u0001!%A\u0005\u0002-\u001ai\u0002\u0003\u0006\u0004\"\u0001\t\n\u0011\"\u0001,\u0007GA!ba\n\u0001#\u0003%\ta\u000bB^\u0011)\u0019I\u0003AI\u0001\n\u0003Y#\u0011\u001b\u0005\t\u0007W\u0001A\u0011A\u0016\u0004.!911\u0007\u0001\u0005\n\rU\"!F*ue\u0016\fW.\u001b8h#V,'/_'b]\u0006<WM\u001d\u0006\u0003U-\nqa\u00197bgNL7M\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ki\u0002\"AN\u001d\u000e\u0003]R!\u0001O\u0016\u0002\u0013M$(/Z1nS:<\u0017B\u0001\u00158!\tYd(D\u0001=\u0015\tiT&\u0001\u0005j]R,'O\\1m\u0013\tyDHA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\t\u001bU\"A\u0015\n\u0005\u0011K#\u0001D*qCJ\\7+Z:tS>t\u0017aB:rY\u000e{gN\u001a\t\u0003\u000f&k\u0011\u0001\u0013\u0006\u0003{-J!A\u0013%\u0003\u000fM\u000bFjQ8oM\u00061A(\u001b8jiz\"2!\u0014(P!\t\u0011\u0005\u0001C\u0003A\u0007\u0001\u0007\u0011\tC\u0003F\u0007\u0001\u0007a)A\u000bti\u0006$Xm\u0015;pe\u0016\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003I\u0003\"aU-\u000e\u0003QS!!\u0016,\u0002\u000bM$\u0018\r^3\u000b\u0005a:&B\u0001-,\u0003%)\u00070Z2vi&|g.\u0003\u0002[)\nA2\u000b^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014(+\u001a4\u0002-M$\u0018\r^3Ti>\u0014XmQ8pe\u0012Lg.\u0019;pe\u0002\n1\u0002\\5ti\u0016tWM\u001d\"vgV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b-\u00069!/\u001e8uS6,\u0017BA2a\u0005e\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014()^:\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\u0002\u001b\u0005\u001cG/\u001b<f#V,'/[3t+\u00059\u0007\u0003\u00025pcfl\u0011!\u001b\u0006\u0003U.\fq!\\;uC\ndWM\u0003\u0002m[\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00039\fQa]2bY\u0006L!\u0001]5\u0003\u000f!\u000b7\u000f['baB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005kRLGNC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(\u0001B+V\u0013\u0012\u0003\"A\u0011>\n\u0005mL#AD*ue\u0016\fW.\u001b8h#V,'/_\u0001\u000fC\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:!Q\u0019Ia0!\u0005\u0002\u0014A\u0019q0!\u0004\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t9!!\u0003\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002\f\u0005)!.\u0019<bq&!\u0011qBA\u0001\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002\u0016\u00059\u0012m\u0019;jm\u0016\fV/\u001a:jKN\u001c\u0006.\u0019:fI2{7m[\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?)\u0018\u0001\u00027b]\u001eLA!a\t\u0002\u001e\t1qJ\u00196fGR\f\u0001$Y2uSZ,\u0017+^3sS\u0016\u001c8\u000b[1sK\u0012dunY6!\u0003Q\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eT8dW\u0006)\u0012m^1jiR+'/\\5oCRLwN\u001c'pG.\u0004\u0013\u0001\b7bgR$VM]7j]\u0006$X\rZ)vKJLX\t_2faRLwN\\\u000b\u0003\u0003_\u0001b!!\r\u00024\u0005]R\"A7\n\u0007\u0005URN\u0001\u0004PaRLwN\u001c\t\u0004m\u0005e\u0012bAA\u001eo\t92\u000b\u001e:fC6LgnZ)vKJLX\t_2faRLwN\\\u0001!Y\u0006\u001cH\u000fV3s[&t\u0017\r^3e#V,'/_#yG\u0016\u0004H/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002B\u0005\u001d\u0003\u0003BA\u0019\u0003\u0007J1!!\u0012n\u0005\u0011)f.\u001b;\t\u0013\u0005%s\"!AA\u0002\u0005=\u0012a\u0001=%c\u0005iB.Y:u)\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0016C8-\u001a9uS>t\u0007\u0005\u000b\u0004\u0011}\u0006E\u0011qJ\u0011\u0003\u0003O\ta!Y2uSZ,WCAA+!\u0015\t\t$a\u0016z\u0013\r\tI&\u001c\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0004O\u0016$HcA=\u0002`!1\u0011\u0011\r\nA\u0002E\f!!\u001b3\u0015\u0007e\f)\u0007C\u0004\u0002bM\u0001\r!a\u001a\u0011\t\u0005%\u0014q\u000f\b\u0005\u0003W\n\u0019\bE\u0002\u0002n5l!!a\u001c\u000b\u0007\u0005E4'\u0001\u0004=e>|GOP\u0005\u0004\u0003kj\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$AB*ue&twMC\u0002\u0002v5\f1#Y<bSR\fe.\u001f+fe6Lg.\u0019;j_:$\"!!\u0011)\u000bQ\t\u0019)!#\u0011\r\u0005E\u0012QQA\u001c\u0013\r\t9)\u001c\u0002\u0007i\"\u0014xn^:2\u000fy\t9'a#\u0002>FJ1%!$\u0002\u0016\u0006M\u0016qS\u000b\u0005\u0003\u001f\u000b\t*\u0006\u0002\u0002h\u00119\u00111S\u001aC\u0002\u0005u%!\u0001+\n\t\u0005]\u0015\u0011T\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005mU.\u0001\u0004uQJ|wo]\t\u0005\u0003?\u000b)\u000b\u0005\u0003\u00022\u0005\u0005\u0016bAAR[\n9aj\u001c;iS:<\u0007\u0003BAT\u0003[sA!!\r\u0002*&\u0019\u00111V7\u0002\u000fA\f7m[1hK&!\u0011qVAY\u0005%!\u0006N]8xC\ndWMC\u0002\u0002,6\f\u0014bIA[\u0003o\u000bI,a'\u000f\t\u0005E\u0012qW\u0005\u0004\u00037k\u0017G\u0002\u0012\u000225\fYLA\u0003tG\u0006d\u0017-M\u0002'\u0003o!B!!1\u0002HB!\u0011\u0011GAb\u0013\r\t)-\u001c\u0002\b\u0005>|G.Z1o\u0011\u001d\tI-\u0006a\u0001\u0003\u0017\f\u0011\u0002^5nK>,H/T:\u0011\t\u0005E\u0012QZ\u0005\u0004\u0003\u001fl'\u0001\u0002'p]\u001eDS!FAB\u0003'\ftAHA4\u0003+\fY.M\u0005$\u0003\u001b\u000b)*a6\u0002\u0018FJ1%!.\u00028\u0006e\u00171T\u0019\u0007E\u0005ER.a/2\u0007\u0019\n9$A\bsKN,G\u000fV3s[&t\u0017\r^3e\u0003-\tG\r\u001a'jgR,g.\u001a:\u0015\t\u0005\u0005\u00131\u001d\u0005\b\u0003K<\u0002\u0019AAt\u0003!a\u0017n\u001d;f]\u0016\u0014\bc\u0001\u001c\u0002j&\u0019\u00111^\u001c\u0003-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJ\faB]3n_Z,G*[:uK:,'\u000f\u0006\u0003\u0002B\u0005E\bbBAs1\u0001\u0007\u0011q]\u0001\u000eY&\u001cH\u000fT5ti\u0016tWM]:\u0015\u0005\u0005]\bCBA\u0019\u0003/\n9/A\tq_N$H*[:uK:,'/\u0012<f]R$B!!\u0011\u0002~\"9\u0011q \u000eA\u0002\t\u0005\u0011!B3wK:$\b\u0003\u0002B\u0002\u0005\u0013q1A\u000eB\u0003\u0013\r\u00119aN\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&!!1\u0002B\u0007\u0005\u0015)e/\u001a8u\u0015\r\u00119aN\u0001\u0019kN,\u0017i]=oGB\u0013xn\u001a:fgN$&/Y2lS:<G\u0003BAa\u0005'AqA!\u0006\u001c\u0001\u0004\u00119\"\u0001\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\u0005\u0005\u0002j\te\u0011qMA4\u0013\u0011\u0011Y\"a\u001f\u0003\u00075\u000b\u0007/A\u0006de\u0016\fG/Z)vKJLHC\u0007B\u0011\u0005O\u0011iC!\r\u0003N\t=#1\rB7\u0005c\u0012)Ha \u0003\u000e\n\u0015\u0006cA0\u0003$%\u0019!Q\u00051\u0003+M#(/Z1nS:<\u0017+^3ss^\u0013\u0018\r\u001d9fe\"9!\u0011\u0006\u000fA\u0002\t-\u0012!E;tKJ\u001c\u0006/Z2jM&,GMT1nKB1\u0011\u0011GA\u001a\u0003OBqAa\f\u001d\u0001\u0004\u0011Y#A\u0010vg\u0016\u00148\u000b]3dS\u001aLW\rZ\"iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:DqAa\r\u001d\u0001\u0004\u0011)$\u0001\u0002eMB\"!q\u0007B!!\u0015\u0011%\u0011\bB\u001f\u0013\r\u0011Y$\u000b\u0002\b\t\u0006$\u0018m]3u!\u0011\u0011yD!\u0011\r\u0001\u0011a!1\tB\u0019\u0003\u0003\u0005\tQ!\u0001\u0003F\t\u0019q\fJ\u0019\u0012\t\u0005}%q\t\t\u0005\u0003c\u0011I%C\u0002\u0003L5\u00141!\u00118z\u0011\u001d\u0011)\u0002\ba\u0001\u0005/AqA!\u0015\u001d\u0001\u0004\u0011\u0019&\u0001\u0003tS:\\\u0007\u0003\u0002B+\u0005?j!Aa\u0016\u000b\t\te#1L\u0001\bG\u0006$\u0018\r\\8h\u0015\r\u0011ifK\u0001\nG>tg.Z2u_JLAA!\u0019\u0003X\t)A+\u00192mK\"9!Q\r\u000fA\u0002\t\u001d\u0014AC8viB,H/T8eKB\u0019aG!\u001b\n\u0007\t-tG\u0001\u0006PkR\u0004X\u000f^'pI\u0016DqAa\u001c\u001d\u0001\u0004\t\t-A\rvg\u0016$V-\u001c9DQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007b\u0002B:9\u0001\u0007\u0011\u0011Y\u0001\u001ee\u0016\u001cwN^3s\rJ|Wn\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"9!q\u000f\u000fA\u0002\te\u0014a\u0002;sS\u001e<WM\u001d\t\u0004m\tm\u0014b\u0001B?o\t9AK]5hO\u0016\u0014\bb\u0002BA9\u0001\u0007!1Q\u0001\riJLwmZ3s\u00072|7m\u001b\t\u0005\u0005\u000b\u0013I)\u0004\u0002\u0003\b*\u0011A/L\u0005\u0005\u0005\u0017\u00139IA\u0003DY>\u001c7\u000eC\u0005\u0003\u0010r\u0001\n\u00111\u0001\u0003\u0012\u0006y1-\u0019;bY><\u0017I\u001c3JI\u0016tG\u000f\u0005\u0004\u00022\u0005M\"1\u0013\t\t\u0003c\u0011)J!'\u0003 &\u0019!qS7\u0003\rQ+\b\u000f\\33!\u0011\u0011)Fa'\n\t\tu%q\u000b\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0005\u0005+\u0012\t+\u0003\u0003\u0003$\n]#AC%eK:$\u0018NZ5fe\"I!q\u0015\u000f\u0011\u0002\u0003\u0007!\u0011V\u0001\rG\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\t\u0007\u0003c\t\u0019Da+\u0011\t\t5&QW\u0007\u0003\u0005_SAA!\u0017\u00032*\u0019!1W\u0016\u0002\u0011\r\fG/\u00197zgRLAAa.\u00030\na1)\u0019;bY><G+\u00192mK\u000612M]3bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\n\u0014'\u0006\u0002\u0003>*\"!\u0011\u0013B`W\t\u0011\t\r\u0005\u0003\u0003D\n-WB\u0001Bc\u0015\u0011\u00119M!3\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0004[&!!Q\u001aBc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017GJ,\u0017\r^3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132eU\u0011!1\u001b\u0016\u0005\u0005S\u0013y,\u0001\u0006ti\u0006\u0014H/U;fef$\u0012$\u001fBm\u00057\u0014iN!;\u0003l\n5(q\u001eBy\u0005g\u0014)Pa>\u0003z\"9!\u0011F\u0010A\u0002\t-\u0002b\u0002B\u0018?\u0001\u0007!1\u0006\u0005\b\u0005gy\u0002\u0019\u0001Bpa\u0011\u0011\tO!:\u0011\u000b\t\u0013IDa9\u0011\t\t}\"Q\u001d\u0003\r\u0005O\u0014i.!A\u0001\u0002\u000b\u0005!Q\t\u0002\u0004?\u0012\u0012\u0004b\u0002B\u000b?\u0001\u0007!q\u0003\u0005\b\u0005#z\u0002\u0019\u0001B*\u0011\u001d\u0011)g\ba\u0001\u0005OB\u0011Ba\u001c !\u0003\u0005\r!!1\t\u0013\tMt\u0004%AA\u0002\u0005\u0005\u0007\"\u0003B<?A\u0005\t\u0019\u0001B=\u0011%\u0011\ti\bI\u0001\u0002\u0004\u0011\u0019\tC\u0005\u0003\u0010~\u0001\n\u00111\u0001\u0003\u0012\"I!qU\u0010\u0011\u0002\u0003\u0007!\u0011\u0016\u0015\u0006?\tu8\u0011\u0002\t\u0007\u0003c\t)Ia@\u0011\t\r\u00051QA\u0007\u0003\u0007\u0007Q1!a\u0001t\u0013\u0011\u00199aa\u0001\u0003!QKW.Z8vi\u0016C8-\u001a9uS>t\u0017g\u0002\u0010\u0002h\r-1\u0011C\u0019\nG\u00055\u0015QSB\u0007\u0003/\u000b\u0014bIA[\u0003o\u001by!a'2\r\t\n\t$\\A^c\r1#q`\u0001\u0015gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\r]!\u0006BAa\u0005\u007f\u000bAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012B\u0014\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0004 )\"!\u0011\u0010B`\u0003U\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%cA*\"a!\n+\t\t\r%qX\u0001\u0016gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u00192\u0003U\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%cI\naC\\8uS\u001aL\u0018+^3ssR+'/\\5oCRLwN\u001c\u000b\u0005\u0003\u0003\u001ay\u0003\u0003\u0004\u00042\u0019\u0002\r!_\u0001\u0010i\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0006QRO\u001c:fO&\u001cH/\u001a:UKJl\u0017N\\1uK\u0012\u001cFO]3b[R!\u0011\u0011IB\u001c\u0011\u0019\u0019\td\na\u0001s\"\u001a\u0001aa\u000f\u0011\t\ru2\u0011I\u0007\u0003\u0007\u007fQ1!a\u0002.\u0013\u0011\u0019\u0019ea\u0010\u0003\u0011\u00153x\u000e\u001c<j]\u001e\u0004")
public class StreamingQueryManager
extends org.apache.spark.sql.streaming.StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final SQLConf sqlConf;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private Option<StreamingQueryException> lastTerminatedQueryException;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private Option<StreamingQueryException> lastTerminatedQueryException() {
        return this.lastTerminatedQueryException;
    }

    private void lastTerminatedQueryException_$eq(Option<StreamingQueryException> x$1) {
        this.lastTerminatedQueryException = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
            bl = this.lastTerminatedQueryException() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQueryException_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])CollectionConverters$.MODULE$.ListHasAsScala(this.listenerBus().listeners()).asScala().toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    private boolean useAsyncProgressTracking(scala.collection.immutable.Map<String, String> extraOptions) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)extraOptions.getOrElse((Object)AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_ENABLED(), (Function0 & Serializable)() -> "false")));
    }

    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<?> df, scala.collection.immutable.Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        WriteToStreamStatement dataStreamWritePlan = new WriteToStreamStatement(userSpecifiedName, userSpecifiedCheckpointLocation, useTempCheckpointLocation, recoverFromCheckpointLocation, sink, outputMode, df.sparkSession().sessionState().newHadoopConf(), trigger instanceof ContinuousTrigger, analyzedPlan, catalogAndIdent, catalogTable);
        WriteToStream analyzedStreamWritePlan = (WriteToStream)this.sparkSession.sessionState().executePlan((LogicalPlan)dataStreamWritePlan, this.sparkSession.sessionState().executePlan$default$2()).analyzed();
        Tuple2 tuple2 = new Tuple2((Object)sink, (Object)trigger);
        if (tuple2 != null) {
            Trigger trigger2 = (Trigger)tuple2._2();
            if (tuple2._1() instanceof SupportsWrite && trigger2 instanceof ContinuousTrigger) {
                ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
                return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (Trigger)continuousTrigger, triggerClock, extraOptions, analyzedStreamWritePlan));
            }
        }
        MicroBatchExecution microBatchExecution = this.useAsyncProgressTracking(extraOptions) ? new AsyncProgressTrackingMicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan) : new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan);
        return new StreamingQueryWrapper(microBatchExecution);
    }

    private Option<Tuple2<TableCatalog, Identifier>> createQuery$default$11() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> createQuery$default$12() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<?> df, scala.collection.immutable.Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock, catalogAndIdent, catalogTable);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException("Cannot start query with id " + query.id() + " as another query with same id is already active. Perhaps you are attempting to restart a query from checkpoint that is already active. You may stop the old query by setting the SQL configuration: spark.conf.set(\"" + SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key() + "\", true) and retry.");
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping existing streaming query [id=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_ID, query.id())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"runId=", "], as a new run is being started."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.RUN_ID, oldQuery.runId())})))));
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable)x$3 -> {
            x$3.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw QueryExecutionErrors$.MODULE$.concurrentQueryInstanceError();
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime((long)0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public Option<Tuple2<TableCatalog, Identifier>> startQuery$default$11() {
        return None$.MODULE$;
    }

    public Option<CatalogTable> startQuery$default$12() {
        return None$.MODULE$;
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQueryException() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQueryException_$eq((Option<StreamingQueryException>)terminatedQuery.exception());
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            HashMap cfr_ignored_0 = (HashMap)this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Registered listener ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.CLASS_NAME, listener.getClass().getName())}))));
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$2) {
        String string = x$2.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$2)))) {
            throw new IllegalArgumentException("Cannot start query with name " + name + " as a query with that name is already active in this SparkSession");
        }
    }

    public StreamingQueryManager(SparkSession sparkSession, SQLConf sqlConf) {
        this.sparkSession = sparkSession;
        this.sqlConf = sqlConf;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env(), sqlConf);
        this.listenerBus = new StreamingQueryListenerBus((Option<LiveListenerBus>)new Some((Object)sparkSession.sparkContext().listenerBus()));
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable)classNames -> {
                SQLConf$.MODULE$.withExistingConf(this.sqlConf, (Function0)(JFunction0.mcV.sp & Serializable)() -> Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable)listener -> {
                    StreamingQueryManager.$anonfun$new$3($this, listener);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().streamingQueryStatusListener().foreach((Function1 & Serializable)listener -> {
                this.addListener(listener);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw QueryExecutionErrors$.MODULE$.registeringStreamingQueryListenerError(e);
        }
    }
}

