/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.ClusterData;
import org.apache.spark.ml.clustering.ClusterData$;
import org.apache.spark.ml.clustering.KMeansModel$;
import org.apache.spark.ml.clustering.KMeansModel$KMeansModelReader$;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.BaseReadWrite;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.GeneralMLWritable;
import org.apache.spark.ml.util.GeneralMLWriter;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SizeEstimator$;
import org.apache.spark.util.VersionUtils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUb\u0001\u0002\u001d:\u0001\u0011C\u0001B\u0017\u0001\u0003\u0006\u0004%\te\u0017\u0005\te\u0002\u0011\t\u0011)A\u00059\"IA\u000f\u0001BC\u0002\u0013\u0005\u0011(\u001e\u0005\ty\u0002\u0011\t\u0011)A\u0005m\"1Q\u0010\u0001C\u0001wyDq! \u0001\u0005\u0002m\n)\u0001\u0003\u0006\u0002\b\u0001A)\u0019!C\u0001\u0003\u0013Aq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011q\t\u0001\u0005B\u0005%\u0003bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003D\u0001\"a3\u0001\t\u0003Y\u0014Q\u001a\u0005\b\u0003+\u0004A\u0011IAl\u0011\u001d\t)\u000f\u0001C!\u0003ODq!a;\u0001\t\u0003\ni\u000fC\u0004\u0002r\u0002!\t%a=\t\u0011\u0005m\b\u0001\"\u0001>\u0003{D\u0001Ba\u0006\u0001\t\u0003j$\u0011\u0004\u0005\t\u0005?\u0001A\u0011I\u001f\u0003\"\u001d9!\u0011F\u001d\t\u0002\t-bA\u0002\u001d:\u0011\u0003\u0011i\u0003\u0003\u0004~1\u0011\u0005!1\n\u0005\b\u0005\u001bBB\u0011\tB(\u0011\u001d\u0011I\u0006\u0007C!\u000572qA!\u0019\u0019\u0001n\u0012\u0019\u0007\u0003\u0006\u0002@r\u0011)\u001a!C\u0001\u0005sB!B!\"\u001d\u0005#\u0005\u000b\u0011\u0002B>\u0011\u0019iH\u0004\"\u0001\u0003\b\"I\u0011\u0011\u0004\u000f\u0002\u0002\u0013\u0005!q\u0012\u0005\n\u0005'c\u0012\u0013!C\u0001\u0005+C\u0011B!+\u001d\u0003\u0003%\tEa+\t\u0013\t]F$!A\u0005\u0002\u0005%\u0001\"\u0003B]9\u0005\u0005I\u0011\u0001B^\u0011%\u0011\t\rHA\u0001\n\u0003\u0012\u0019\rC\u0005\u0003Rr\t\t\u0011\"\u0001\u0003T\"I!Q\u001c\u000f\u0002\u0002\u0013\u0005#q\u001c\u0005\n\u0005Gd\u0012\u0011!C!\u0005KD\u0011\"!:\u001d\u0003\u0003%\tEa:\t\u0013\t%H$!A\u0005B\t-xA\u0003Bx1\u0005\u0005\t\u0012A\u001e\u0003r\u001aQ!\u0011\r\r\u0002\u0002#\u00051Ha=\t\rudC\u0011AB\u0001\u0011%\t)\u000fLA\u0001\n\u000b\u00129\u000fC\u0005\u0004\u00041\n\t\u0011\"!\u0004\u0006!I1\u0011\u0002\u0017\u0002\u0002\u0013\u000551\u0002\u0005\n\u0007/a\u0013\u0011!C\u0005\u000731aa!\t\u0019\t\r\r\u0002BB?3\t\u0003\u0019)\u0003C\u0005\u0004*I\u0012\r\u0011\"\u0003\u0003,\"A11\u0006\u001a!\u0002\u0013\u0011i\u000bC\u0004\u0003ZI\"\te!\f\t\u0013\r]\u0001$!A\u0005\n\re!aC&NK\u0006t7/T8eK2T!AO\u001e\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002={\u0005\u0011Q\u000e\u001c\u0006\u0003}}\nQa\u001d9be.T!\u0001Q!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0015aA8sO\u000e\u00011#\u0002\u0001F\u0017:#\u0006c\u0001$H\u00136\t1(\u0003\u0002Iw\t)Qj\u001c3fYB\u0011!\nA\u0007\u0002sA\u0011!\nT\u0005\u0003\u001bf\u0012AbS'fC:\u001c\b+\u0019:b[N\u0004\"a\u0014*\u000e\u0003AS!!U\u001e\u0002\tU$\u0018\u000e\\\u0005\u0003'B\u0013\u0011cR3oKJ\fG.\u0014'Xe&$\u0018M\u00197f!\ryUkV\u0005\u0003-B\u0013!\u0003S1t)J\f\u0017N\\5oON+X.\\1ssB\u0011!\nW\u0005\u00033f\u0012QbS'fC:\u001c8+^7nCJL\u0018aA;jIV\tA\f\u0005\u0002^M:\u0011a\f\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u000e\u000ba\u0001\u0010:p_Rt$\"A2\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0014\u0017A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a2)\u0007\u0005Q\u0007\u000f\u0005\u0002l]6\tAN\u0003\u0002n{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005=d'!B*j]\u000e,\u0017%A9\u0002\u000bErSG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005)\u0004\u0018a\u00039be\u0016tG/T8eK2,\u0012A\u001e\t\u0003onl\u0011\u0001\u001f\u0006\u0003ueT!A_\u001f\u0002\u000b5dG.\u001b2\n\u0005aB\u0018\u0001\u00049be\u0016tG/T8eK2\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003J\u007f\u0006\r\u0001\"\u0002.\u0006\u0001\u0004a\u0006fA@ka\")A/\u0002a\u0001mR\t\u0011*A\u0006ok64U-\u0019;ve\u0016\u001cXCAA\u0006!\u0011\ti!a\u0004\u000e\u0003\tL1!!\u0005c\u0005\rIe\u000e\u001e\u0015\u0005\u000f)\f)\"\t\u0002\u0002\u0018\u0005)1G\f\u0019/a\u0005!1m\u001c9z)\rI\u0015Q\u0004\u0005\b\u0003?A\u0001\u0019AA\u0011\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014w\u0005)\u0001/\u0019:b[&!\u00111FA\u0013\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\u0005ka\u0006q1/\u001a;GK\u0006$XO]3t\u0007>dG\u0003BA\u001a\u0003ki\u0011\u0001\u0001\u0005\u0007\u0003oI\u0001\u0019\u0001/\u0002\u000bY\fG.^3)\t%Q\u00171H\u0011\u0003\u0003{\tQA\r\u00181]A\n\u0001c]3u!J,G-[2uS>t7i\u001c7\u0015\t\u0005M\u00121\t\u0005\u0007\u0003oQ\u0001\u0019\u0001/)\t)Q\u00171H\u0001\niJ\fgn\u001d4pe6$B!a\u0013\u0002nA!\u0011QJA4\u001d\u0011\ty%!\u0019\u000f\t\u0005E\u0013Q\f\b\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005ecbA0\u0002X%\t!)\u0003\u0002A\u0003&\u0011ahP\u0005\u0004\u0003?j\u0014aA:rY&!\u00111MA3\u0003\u001d\u0001\u0018mY6bO\u0016T1!a\u0018>\u0013\u0011\tI'a\u001b\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA2\u0003KBq!a\u001c\f\u0001\u0004\t\t(A\u0004eCR\f7/\u001a;1\t\u0005M\u0014q\u0010\t\u0007\u0003k\n9(a\u001f\u000e\u0005\u0005\u0015\u0014\u0002BA=\u0003K\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002~\u0005}D\u0002\u0001\u0003\r\u0003\u0003\u000bi'!A\u0001\u0002\u000b\u0005\u00111\u0011\u0002\u0004?\u0012\n\u0014\u0003BAC\u0003\u0017\u0003B!!\u0004\u0002\b&\u0019\u0011\u0011\u00122\u0003\u000f9{G\u000f[5oOB!\u0011QBAG\u0013\r\tyI\u0019\u0002\u0004\u0003:L\b\u0006B\u0006k\u0003w\tq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003/\u000b\u0019\u000b\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\u0011\ti*!\u001a\u0002\u000bQL\b/Z:\n\t\u0005\u0005\u00161\u0014\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBAS\u0019\u0001\u0007\u0011qS\u0001\u0007g\u000eDW-\\1)\u00071Q\u0007/A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005-\u0011Q\u0016\u0005\b\u0003_k\u0001\u0019AAY\u0003!1W-\u0019;ve\u0016\u001c\b\u0003BAZ\u0003sk!!!.\u000b\u0007\u0005]6(\u0001\u0004mS:\fGnZ\u0005\u0005\u0003w\u000b)L\u0001\u0004WK\u000e$xN\u001d\u0015\u0005\u001b)\f)\"\u0001\bdYV\u001cH/\u001a:DK:$XM]:\u0016\u0005\u0005\r\u0007CBA\u0007\u0003\u000b\f\t,C\u0002\u0002H\n\u0014Q!\u0011:sCfDCA\u00046\u0002<\u0005\u00192\r\\;ti\u0016\u00148)\u001a8uKJl\u0015\r\u001e:jqV\u0011\u0011q\u001a\t\u0005\u0003g\u000b\t.\u0003\u0003\u0002T\u0006U&AB'biJL\u00070A\u0003xe&$X-\u0006\u0002\u0002ZB\u0019q*a7\n\u0007\u0005u\u0007KA\bHK:,'/\u00197N\u0019^\u0013\u0018\u000e^3sQ\u0011\u0001\".!9\"\u0005\u0005\r\u0018!B\u0019/m9\u0002\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003qCC!\u00056\u0002\u0016\u000591/^7nCJLX#A,)\tIQ\u00171H\u0001\u000eKN$\u0018.\\1uK\u0012\u001c\u0016N_3\u0016\u0005\u0005U\b\u0003BA\u0007\u0003oL1!!?c\u0005\u0011auN\\4\u0002\u001b\r\u0014X-\u0019;f'VlW.\u0019:z)!\tyP!\u0002\u0003\n\t5\u0001\u0003BA\u0007\u0005\u0003I1Aa\u0001c\u0005\u0011)f.\u001b;\t\u000f\t\u001dA\u00031\u0001\u0002L\u0005Y\u0001O]3eS\u000e$\u0018n\u001c8t\u0011\u001d\u0011Y\u0001\u0006a\u0001\u0003\u0017\tqA\\;n\u0013R,'\u000fC\u0004\u0003\u0010Q\u0001\rA!\u0005\u0002\u0019Q\u0014\u0018-\u001b8j]\u001e\u001cun\u001d;\u0011\t\u00055!1C\u0005\u0004\u0005+\u0011'A\u0002#pk\ndW-A\u0006tCZ,7+^7nCJLH\u0003BA\u0000\u00057AaA!\b\u0016\u0001\u0004a\u0016\u0001\u00029bi\"\f1\u0002\\8bIN+X.\\1ssR1\u0011q B\u0012\u0005KAaA!\b\u0017\u0001\u0004a\u0006bBA8-\u0001\u0007\u00111\n\u0015\u0004\u0001)\u0004\u0018aC&NK\u0006t7/T8eK2\u0004\"A\u0013\r\u0014\u000fa\u0011yC!\u000e\u0003<A!\u0011Q\u0002B\u0019\u0013\r\u0011\u0019D\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\t=\u00139$S\u0005\u0004\u0005s\u0001&AC'M%\u0016\fG-\u00192mKB!!Q\bB$\u001b\t\u0011yD\u0003\u0003\u0003B\t\r\u0013AA5p\u0015\t\u0011)%\u0001\u0003kCZ\f\u0017\u0002\u0002B%\u0005\u007f\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"Aa\u000b\u0002\tI,\u0017\rZ\u000b\u0003\u0005#\u0002Ba\u0014B*\u0013&\u0019!Q\u000b)\u0003\u00115c%+Z1eKJDCA\u00076\u0002b\u0006!An\\1e)\rI%Q\f\u0005\u0007\u0005;Y\u0002\u0019\u0001/)\tmQ\u0017\u0011\u001d\u0002\b\u001f2$G)\u0019;b'\u001da\"q\u0006B3\u0005W\u0002B!!\u0004\u0003h%\u0019!\u0011\u000e2\u0003\u000fA\u0013x\u000eZ;diB!!Q\u000eB;\u001d\u0011\u0011yGa\u001d\u000f\u0007}\u0013\t(C\u0001d\u0013\r\t\u0019GY\u0005\u0005\u0005\u0013\u00129HC\u0002\u0002d\t,\"Aa\u001f\u0011\r\u00055\u0011Q\u0019B?!\u0011\u0011yHa!\u000e\u0005\t\u0005%bAA\\s&!\u00111\u0018BA\u0003=\u0019G.^:uKJ\u001cUM\u001c;feN\u0004C\u0003\u0002BE\u0005\u001b\u00032Aa#\u001d\u001b\u0005A\u0002bBA`?\u0001\u0007!1\u0010\u000b\u0005\u0005\u0013\u0013\t\nC\u0005\u0002@\u0002\u0002\n\u00111\u0001\u0003|\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BLU\u0011\u0011YH!',\u0005\tm\u0005\u0003\u0002BO\u0005Kk!Aa(\u000b\t\t\u0005&1U\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001c2\n\t\t\u001d&q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003.B!!q\u0016B[\u001b\t\u0011\tL\u0003\u0003\u00034\n\r\u0013\u0001\u00027b]\u001eL1a\u001aBY\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a#\u0003>\"I!q\u0018\u0013\u0002\u0002\u0003\u0007\u00111B\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0007C\u0002Bd\u0005\u001b\fY)\u0004\u0002\u0003J*\u0019!1\u001a2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003P\n%'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!6\u0003\\B!\u0011Q\u0002Bl\u0013\r\u0011IN\u0019\u0002\b\u0005>|G.Z1o\u0011%\u0011yLJA\u0001\u0002\u0004\tY)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002BW\u0005CD\u0011Ba0(\u0003\u0003\u0005\r!a\u0003\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0003\u0015\u0005\t5\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0003V\n5\b\"\u0003B`U\u0005\u0005\t\u0019AAF\u0003\u001dyE\u000e\u001a#bi\u0006\u00042Aa#-'\u0015a#Q\u001fB\u001e!!\u00119P!@\u0003|\t%UB\u0001B}\u0015\r\u0011YPY\u0001\beVtG/[7f\u0013\u0011\u0011yP!?\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0003r\u0006)\u0011\r\u001d9msR!!\u0011RB\u0004\u0011\u001d\tyl\fa\u0001\u0005w\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u000e\rM\u0001CBA\u0007\u0007\u001f\u0011Y(C\u0002\u0004\u0012\t\u0014aa\u00149uS>t\u0007\"CB\u000ba\u0005\u0005\t\u0019\u0001BE\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00077\u0001BAa,\u0004\u001e%!1q\u0004BY\u0005\u0019y%M[3di\n\t2*T3b]Nlu\u000eZ3m%\u0016\fG-\u001a:\u0014\u0007I\u0012\t\u0006\u0006\u0002\u0004(A\u0019!1\u0012\u001a\u0002\u0013\rd\u0017m]:OC6,\u0017AC2mCN\u001ch*Y7fAQ\u0019\u0011ja\f\t\r\tua\u00071\u0001]Q\u0011A\".!9)\t]Q\u0017\u0011\u001d")
public class KMeansModel
extends Model<KMeansModel>
implements KMeansParams,
GeneralMLWritable,
HasTrainingSummary<KMeansSummary> {
    private int numFeatures;
    private final String uid;
    private final org.apache.spark.mllib.clustering.KMeansModel parentModel;
    private Option<KMeansSummary> trainingSummary;
    private IntParam k;
    private Param<String> initMode;
    private IntParam initSteps;
    private Param<String> solver;
    private DoubleParam maxBlockSizeInMB;
    private Param<String> weightCol;
    private Param<String> distanceMeasure;
    private DoubleParam tol;
    private Param<String> predictionCol;
    private LongParam seed;
    private Param<String> featuresCol;
    private IntParam maxIter;
    private volatile boolean bitmap$0;

    public static KMeansModel load(String path) {
        return KMeansModel$.MODULE$.load(path);
    }

    public static MLReader<KMeansModel> read() {
        return KMeansModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<KMeansSummary> setSummary(Option<KMeansSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return KMeansParams.getK$(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams.getInitMode$(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams.getInitSteps$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<KMeansSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<KMeansSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param<String> x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.clustering.KMeansModel parentModel() {
        return this.parentModel;
    }

    private int numFeatures$lzycompute() {
        KMeansModel kMeansModel = this;
        synchronized (kMeansModel) {
            if (!this.bitmap$0) {
                this.numFeatures = ((Vector)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.parentModel().clusterCenters()))).size();
                this.bitmap$0 = true;
            }
        }
        return this.numFeatures;
    }

    public int numFeatures() {
        if (!this.bitmap$0) {
            return this.numFeatures$lzycompute();
        }
        return this.numFeatures;
    }

    @Override
    public KMeansModel copy(ParamMap extra) {
        KMeansModel copied = this.copyValues(new KMeansModel(this.uid(), this.parentModel()), extra);
        return (KMeansModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    public KMeansModel setFeaturesCol(String value) {
        return (KMeansModel)this.set(this.featuresCol(), value);
    }

    public KMeansModel setPredictionCol(String value) {
        return (KMeansModel)this.set(this.predictionCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1(KMeansModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1(null)));
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})), outputSchema.apply(this.$(this.predictionCol())).metadata());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = this.validateAndTransformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateNumValues(outputSchema, this.$(this.predictionCol()), this.parentModel().k());
        }
        return outputSchema;
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        return this.parentModel().predict(Vectors$.MODULE$.fromML(features));
    }

    public org.apache.spark.ml.linalg.Vector[] clusterCenters() {
        return (org.apache.spark.ml.linalg.Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.parentModel().clusterCenters()), (Function1 & Serializable)x$1 -> x$1.asML(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class));
    }

    public Matrix clusterCenterMatrix() {
        return Matrices$.MODULE$.fromVectors(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.clusterCenters())));
    }

    @Override
    public GeneralMLWriter write() {
        return new GeneralMLWriter(this);
    }

    @Override
    public String toString() {
        return "KMeansModel: uid=" + this.uid() + ", k=" + this.parentModel().k() + ", distanceMeasure=" + this.$(this.distanceMeasure()) + ", numFeatures=" + this.numFeatures();
    }

    @Override
    public KMeansSummary summary() {
        return (KMeansSummary)HasTrainingSummary.summary$(this);
    }

    @Override
    public long estimatedSize() {
        return SizeEstimator$.MODULE$.estimate((Object)this.parentModel().clusterCenters());
    }

    public void createSummary(Dataset<Row> predictions, int numIter, double trainingCost) {
        KMeansSummary summary = new KMeansSummary(predictions, this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), numIter, trainingCost);
        this.setSummary((Option<KMeansSummary>)new Some((Object)summary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$2(KMeansModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple2.mcID.sp(this.summary().numIter(), this.summary().trainingCost()), (Function2 & Serializable)(data, dos) -> {
            KMeansModel.$anonfun$saveSummary$1(data, dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$2(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        int n;
        double trainingCost;
        block3: {
            Tuple2 tuple2;
            block2: {
                public final class Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$3
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$3(KMeansModel $outer) {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModel.class.getClassLoader());
                tuple2 = (Tuple2)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> {
                    int numIter = dis.readInt();
                    double trainingCost = dis.readDouble();
                    return new Tuple2.mcID.sp(numIter, trainingCost);
                }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$3(null)));
                if (tuple2 == null) break block2;
                int numIter = tuple2._1$mcI$sp();
                trainingCost = tuple2._2$mcD$sp();
                if (!true) break block2;
                n = numIter;
                if (true) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        double d = trainingCost;
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(n, d);
        int numIter = sp2._1$mcI$sp();
        double trainingCost2 = sp2._2$mcD$sp();
        this.createSummary(dataset, numIter, trainingCost2);
    }

    public static final /* synthetic */ void $anonfun$saveSummary$1(Tuple2 data, DataOutputStream dos) {
        dos.writeInt(data._1$mcI$sp());
        dos.writeDouble(data._2$mcD$sp());
    }

    public KMeansModel(String uid, org.apache.spark.mllib.clustering.KMeansModel parentModel) {
        this.uid = uid;
        this.parentModel = parentModel;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasTol.$init$(this);
        HasDistanceMeasure.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        KMeansParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Statics.releaseFence();
    }

    public KMeansModel() {
        this("", null);
    }

    private static class KMeansModelReader
    extends MLReader<KMeansModel> {
        private final String className = KMeansModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public KMeansModel load(String path) {
            Vector[] vectorArray;
            SparkSession sparkSession = BaseReadWrite.sparkSession$(this);
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, sparkSession, this.className());
            String dataPath = new Path(path, "data").toString();
            if (VersionUtils$.MODULE$.majorVersion(metadata.sparkVersion()) >= 2) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator1$5
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.clustering.ClusterData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator1$5(KMeansModelReader $outer) {
                    }
                }
                ClusterData[] data = (ClusterData[])ReadWriteUtils$.MODULE$.loadArray(dataPath, sparkSession, (Function1 & Serializable)dis -> ClusterData$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(ClusterData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator1$5(null)));
                vectorArray = (Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])data), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.clusterIdx()), (Ordering)Ordering.Int$.MODULE$)), (Function1 & Serializable)x$4 -> x$4.clusterCenter(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class))), (Function1 & Serializable)v -> Vectors$.MODULE$.fromML((org.apache.spark.ml.linalg.Vector)v), ClassTag$.MODULE$.apply(Vector.class));
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.clustering.KMeansModel.OldData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator6$1(KMeansModelReader $outer) {
                    }
                }
                vectorArray = ((OldData)sparkSession.read().parquet(dataPath).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator6$1(null)))).head()).clusterCenters();
            }
            Vector[] clusterCenters = vectorArray;
            KMeansModel model = new KMeansModel(metadata.uid(), new org.apache.spark.mllib.clustering.KMeansModel(clusterCenters));
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class OldData
    implements Product,
    Serializable {
        private final Vector[] clusterCenters;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Vector[] clusterCenters() {
            return this.clusterCenters;
        }

        public OldData copy(Vector[] clusterCenters) {
            return new OldData(clusterCenters);
        }

        public Vector[] copy$default$1() {
            return this.clusterCenters();
        }

        public String productPrefix() {
            return "OldData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clusterCenters();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof OldData;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clusterCenters";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof OldData)) return false;
            boolean bl = true;
            if (!bl) return false;
            OldData oldData = (OldData)x$1;
            if (this.clusterCenters() != oldData.clusterCenters()) return false;
            if (!oldData.canEqual(this)) return false;
            return true;
        }

        public OldData(Vector[] clusterCenters) {
            this.clusterCenters = clusterCenters;
            Product.$init$((Product)this);
        }
    }
}

