/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Encode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.ToBinary$;
import org.apache.spark.sql.catalyst.expressions.UnBase64;
import org.apache.spark.sql.catalyst.expressions.Unhex;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str[, fmt]) - Converts the input `str` to a binary value based on the supplied `fmt`.\n      `fmt` can be a case-insensitive string literal of \"hex\", \"utf-8\", \"utf8\", or \"base64\".\n      By default, the binary format for conversion is \"hex\" if `fmt` is omitted.\n      The function returns NULL if at least one of the input parameters is NULL.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abc', 'utf-8');\n       abc\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tMa\u0001B\u0013'\u0001NB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005i!A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003V\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011B.\t\u000b}\u0003A\u0011\u00011\t\u0011\u0015\u0004\u0001R1A\u0005\u0002\u0019D\u0001b\u001d\u0001\t\u0006\u0004%\t%\u0015\u0005\u0006?\u0002!\t\u0001\u001e\u0005\u0006?\u0002!\tA\u001e\u0005\u0006s\u0002!\tE\u001a\u0005\u0006u\u0002!\te\u001f\u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011\u0011\u0005\u0001\u0005R\u0005\r\u0002\"CA\u0018\u0001\u0005\u0005I\u0011AA\u0019\u0011%\tI\u0004AI\u0001\n\u0003\tY\u0004C\u0005\u0002R\u0001\t\n\u0011\"\u0001\u0002T!I\u0011q\u000b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003;\u0002\u0011\u0011!C!\u0003?B\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\t\u0013\u0005e\u0004!!A\u0005\u0002\u0005m\u0004\"CAD\u0001\u0005\u0005I\u0011IAE\u0011%\t9\nAA\u0001\n\u0003\tI\nC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0011\u0002 \"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0013QU\u0004\n\u0003\u00134\u0013\u0011!E\u0001\u0003\u00174\u0001\"\n\u0014\u0002\u0002#\u0005\u0011Q\u001a\u0005\u0007?v!\t!!:\t\u0013\u0005\u001dX$!A\u0005F\u0005%\b\"CAv;\u0005\u0005I\u0011QAw\u0011%\t)0HI\u0001\n\u0003\tI\u0006C\u0005\u0002xv\t\t\u0011\"!\u0002z\"I!qA\u000f\u0012\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0005\u0013i\u0012\u0011!C\u0005\u0005\u0017\u0011\u0001\u0002V8CS:\f'/\u001f\u0006\u0003O!\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011FK\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u000e\u001d<}\u0011\u0003\"!\u000e\u001c\u000e\u0003\u0019J!a\u000e\u0014\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00026s%\u0011!H\n\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00026y%\u0011QH\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n9\u0001K]8ek\u000e$\bCA#N\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002Je\u00051AH]8pizJ\u0011!Q\u0005\u0003\u0019\u0002\u000bq\u0001]1dW\u0006<W-\u0003\u0002O\u001f\na1+\u001a:jC2L'0\u00192mK*\u0011A\nQ\u0001\u0005Kb\u0004(/F\u00015\u0003\u0015)\u0007\u0010\u001d:!\u0003\u00191wN]7biV\tQ\u000bE\u0002@-RJ!a\u0016!\u0003\r=\u0003H/[8o\u0003\u001d1wN]7bi\u0002\n1C\\;mY>s\u0017J\u001c<bY&$gi\u001c:nCR,\u0012a\u0017\t\u0003\u007fqK!!\u0018!\u0003\u000f\t{w\u000e\\3b]\u0006!b.\u001e7m\u001f:LeN^1mS\u00124uN]7bi\u0002\na\u0001P5oSRtD\u0003B1cG\u0012\u0004\"!\u000e\u0001\t\u000bA;\u0001\u0019\u0001\u001b\t\u000bM;\u0001\u0019A+\t\u000fe;\u0001\u0013!a\u00017\u0006\u0019a-\u001c;\u0016\u0003\u001d\u0004\"\u0001\u001b7\u000f\u0005%T\u0007CA$A\u0013\tY\u0007)\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6AQ\tA\u0001\u000f\u0005\u0002@c&\u0011!\u000f\u0011\u0002\niJ\fgn]5f]R\f1B]3qY\u0006\u001cW-\\3oiR\u0011\u0011-\u001e\u0005\u0006!*\u0001\r\u0001\u000e\u000b\u0004C^D\b\"\u0002)\f\u0001\u0004!\u0004\"B*\f\u0001\u0004!\u0014A\u00039sKR$\u0018PT1nK\u0006A1\r[5mIJ,g.F\u0001}!\r)U\u0010N\u0005\u0003}>\u00131aU3r\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u0007\u0001B!R?\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f)\nQ\u0001^=qKNLA!a\u0004\u0002\n\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037A\u0013\u0001C1oC2L8/[:\n\t\u0005}\u0011\u0011\u0004\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004i\u0005\u0015\u0002bBA\u0014!\u0001\u0007\u0011\u0011F\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003F\u0003W!\u0014bAA\u0017\u001f\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\bC\u0006M\u0012QGA\u001c\u0011\u001d\u0001\u0016\u0003%AA\u0002QBqaU\t\u0011\u0002\u0003\u0007Q\u000bC\u0004Z#A\u0005\t\u0019A.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\b\u0016\u0004i\u0005}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0003)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u000b\u0016\u0004+\u0006}\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u00037R3aWA \u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\r\t\u0005\u0003G\ni'\u0004\u0002\u0002f)!\u0011qMA5\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0014\u0001\u00026bm\u0006L1!\\A3\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\bE\u0002@\u0003kJ1!a\u001eA\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti(a!\u0011\u0007}\ny(C\u0002\u0002\u0002\u0002\u00131!\u00118z\u0011%\t)iFA\u0001\u0002\u0004\t\u0019(A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0003b!!$\u0002\u0014\u0006uTBAAH\u0015\r\t\t\nQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAK\u0003\u001f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u00191,a'\t\u0013\u0005\u0015\u0015$!AA\u0002\u0005u\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0019\u0002\"\"I\u0011Q\u0011\u000e\u0002\u0002\u0003\u0007\u00111O\u0001\u0007KF,\u0018\r\\:\u0015\u0007m\u000b9\u000bC\u0005\u0002\u0006n\t\t\u00111\u0001\u0002~!\u001a\u0002!a+\u00022\u0006M\u0016qWA]\u0003{\u000by,a1\u0002FB\u0019Q'!,\n\u0007\u0005=fEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005U\u0016Aa2\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;s72\u0002c-\u001c;^S\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\u00027\u000f\u001e:aAQ|\u0007%\u0019\u0011cS:\f'/\u001f\u0011wC2,X\r\t2bg\u0016$\u0007e\u001c8!i\",\u0007e];qa2LW\r\u001a\u0011aM6$\bM\f\u0006!A\u0001\u0002\u0003\u0005\t1g[R\u0004\u0007eY1oA\t,\u0007%\u0019\u0011dCN,W&\u001b8tK:\u001c\u0018\u000e^5wK\u0002\u001aHO]5oO\u0002b\u0017\u000e^3sC2\u0004sN\u001a\u0011#Q\u0016D(\u0005\f\u0011#kR4W\u0006\u000f\u0012-A\t*HO\u001a\u001d#Y\u0001z'\u000f\t\u0012cCN,g\u0007\u000e\u0012/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0005f\u0004C-\u001a4bk2$H\u0006\t;iK\u0002\u0012\u0017N\\1ss\u00022wN]7bi\u00022wN\u001d\u0011d_:4XM]:j_:\u0004\u0013n\u001d\u0011#Q\u0016D(\u0005I5gA\u00014W\u000e\u001e1!SN\u0004s.\\5ui\u0016$gF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019\u0002Jg\rI1uA1,\u0017m\u001d;!_:,\u0007e\u001c4!i\",\u0007%\u001b8qkR\u0004\u0003/\u0019:b[\u0016$XM]:!SN\u0004c*\u0016'M])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY,A\"\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'mY\u0014-A\u001d*HOZ\u00179O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u00192d\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAa\u0003\u0015\u0019df\r\u00181\u0003\u00159'o\\;qC\t\t9-\u0001\u0007tiJLgnZ0gk:\u001c7/\u0001\u0005U_\nKg.\u0019:z!\t)TdE\u0003\u001e\u0003\u001f\fY\u000e\u0005\u0005\u0002R\u0006]G'V.b\u001b\t\t\u0019NC\u0002\u0002V\u0002\u000bqA];oi&lW-\u0003\u0003\u0002Z\u0006M'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u0011Q\\Ar\u001b\t\tyN\u0003\u0003\u0002b\u0006%\u0014AA5p\u0013\rq\u0015q\u001c\u000b\u0003\u0003\u0017\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\nQ!\u00199qYf$r!YAx\u0003c\f\u0019\u0010C\u0003QA\u0001\u0007A\u0007C\u0003TA\u0001\u0007Q\u000bC\u0004ZAA\u0005\t\u0019A.\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002|\n\r\u0001\u0003B W\u0003{\u0004baPA\u0000iU[\u0016b\u0001B\u0001\u0001\n1A+\u001e9mKNB\u0001B!\u0002#\u0003\u0003\u0005\r!Y\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u000eA!\u00111\rB\b\u0013\u0011\u0011\t\"!\u001a\u0003\r=\u0013'.Z2u\u0001")
public class ToBinary
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private transient String fmt;
    private Expression replacement;
    private final Expression expr;
    private final Option<Expression> format;
    private final boolean nullOnInvalidFormat;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$3() {
        return ToBinary$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Option<Expression>, Object>> unapply(ToBinary x$0) {
        return ToBinary$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$3() {
        return ToBinary$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Object>, ToBinary> tupled() {
        return ToBinary$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, ToBinary>>> curried() {
        return ToBinary$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression expr() {
        return this.expr;
    }

    public Option<Expression> format() {
        return this.format;
    }

    public boolean nullOnInvalidFormat() {
        return this.nullOnInvalidFormat;
    }

    private String fmt$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if (!this.bitmap$trans$0) {
                this.fmt = (String)this.format().map((Function1 & Serializable)f -> {
                    Object value = f.eval(f.eval$default$1());
                    if (value == null) {
                        return null;
                    }
                    return ((UTF8String)value).toString().toLowerCase(Locale.ROOT);
                }).getOrElse((Function0 & Serializable)() -> "hex");
                this.bitmap$trans$0 = true;
            }
        }
        return this.fmt;
    }

    public String fmt() {
        if (!this.bitmap$trans$0) {
            return this.fmt$lzycompute();
        }
        return this.fmt;
    }

    private Expression replacement$lzycompute() {
        block11: {
            ToBinary toBinary = this;
            synchronized (toBinary) {
                Expression expression;
                block13: {
                    block14: {
                        block12: {
                            if ((byte)(this.bitmap$0 & 1) != 0) break block11;
                            if (this.fmt() != null) break block12;
                            expression = new Literal(null, (DataType)BinaryType$.MODULE$);
                            break block13;
                        }
                        String string = this.fmt();
                        switch (string == null ? 0 : string.hashCode()) {
                            case -1396204209: {
                                if (!"base64".equals(string)) break block14;
                                expression = new UnBase64(this.expr(), true);
                                break block13;
                            }
                            case 103195: {
                                if (!"hex".equals(string)) break block14;
                                expression = new Unhex(this.expr(), true);
                                break block13;
                            }
                            case 3600241: {
                                if ("utf8".equals(string)) {
                                    break;
                                }
                                break block14;
                            }
                            case 111607186: {
                                if ("utf-8".equals(string)) {
                                    break;
                                }
                                break block14;
                            }
                            default: {
                                break block14;
                            }
                        }
                        expression = Encode$.MODULE$.apply(this.expr(), Literal$.MODULE$.apply("UTF-8"));
                        break block13;
                    }
                    expression = new Literal(null, (DataType)BinaryType$.MODULE$);
                }
                this.replacement = expression;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_binary";
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.expr();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)this.children().map((Function1 & Serializable)x$32 -> StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        block5: {
            Expression f;
            block6: {
                block7: {
                    Option<Expression> option = this.format();
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    f = (Expression)some.value();
                    if (!f.foldable()) break block6;
                    if (f.dataType() instanceof StringType) break block7;
                    DataType dataType = f.dataType();
                    NullType$ nullType$ = NullType$.MODULE$;
                    if (dataType != null ? !dataType.equals(nullType$) : nullType$ != null) break block6;
                }
                if (this.isValidFormat$1() || this.nullOnInvalidFormat()) {
                    return ExpectsInputTypes.checkInputDataTypes$(this);
                }
                return new TypeCheckResult.DataTypeMismatch("INVALID_ARG_VALUE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"fmt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requireType"), (Object)("case-insensitive " + Cast$.MODULE$.toSQLType((AbstractDataType)StringTypeWithCollation$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"validValues"), (Object)"'hex', 'utf-8', 'utf8', or 'base64'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputValue"), (Object)Cast$.MODULE$.toSQLValue(this.fmt(), f.dataType()))}))));
            }
            if (!f.foldable()) {
                return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("fmt")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)StringTypeWithCollation$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(f))}))));
            }
            return new TypeCheckResult.DataTypeMismatch("INVALID_ARG_VALUE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"fmt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requireType"), (Object)("case-insensitive " + Cast$.MODULE$.toSQLType((AbstractDataType)StringTypeWithCollation$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"validValues"), (Object)"'hex', 'utf-8', 'utf8', or 'base64'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputValue"), (Object)Cast$.MODULE$.toSQLValue(f.eval(f.eval$default$1()), f.dataType()))}))));
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3());
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3());
    }

    public ToBinary copy(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        return new ToBinary(expr, format, nullOnInvalidFormat);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public boolean copy$default$3() {
        return this.nullOnInvalidFormat();
    }

    @Override
    public String productPrefix() {
        return "ToBinary";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.nullOnInvalidFormat());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToBinary;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "format";
            }
            case 2: {
                return "nullOnInvalidFormat";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToBinary)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToBinary toBinary = (ToBinary)x$1;
        if (this.nullOnInvalidFormat() != toBinary.nullOnInvalidFormat()) return false;
        Expression expression = this.expr();
        Expression expression2 = toBinary.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = toBinary.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!toBinary.canEqual(this)) return false;
        return true;
    }

    private final boolean isValidFormat$1() {
        return this.fmt() == null || ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hex", "utf-8", "utf8", "base64"}))).contains((Object)this.fmt());
    }

    public ToBinary(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        this.expr = expr;
        this.format = format;
        this.nullOnInvalidFormat = nullOnInvalidFormat;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public ToBinary(Expression expr) {
        this(expr, (Option<Expression>)None$.MODULE$, false);
    }

    public ToBinary(Expression expr, Expression format) {
        this(expr, (Option<Expression>)new Some((Object)format), false);
    }
}

