/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0\n  ", since="1.4.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001\u0002\u000f\u001e\u0001*BQ\u0001\u0012\u0001\u0005\u0002\u0015C\u0011b\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002%\t\u0013=\u0003\u0001\u0019!A!B\u0013A\u0005\"B)\u0001\t\u0003\u0012\u0006\"\u0002,\u0001\t#:\u0006\"\u00021\u0001\t\u0003\n\u0007\"\u00026\u0001\t\u0003\u0012\u0006\"B6\u0001\t\u0003b\u0007\"B:\u0001\t#\"\b\"B>\u0001\t\u0003b\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\u0007E\u0001!\t%a\u0006\t\u0011\u0005%\u0002!!A\u0005\u0002\u0015C\u0011\"a\u000b\u0001\u0003\u0003%\t%!\f\t\u0013\u0005u\u0002!!A\u0005\u0002\u0005}\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\ty\u0005AA\u0001\n\u0003\n\t\u0006C\u0005\u0002`\u0001\t\t\u0011\"\u0001\u0002b!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0013q\r\u0005\n\u0003W\u0002\u0011\u0011!C!\u0003[:\u0011\"!%\u001e\u0003\u0003E\t!a%\u0007\u0011qi\u0012\u0011!E\u0001\u0003+Ca\u0001\u0012\f\u0005\u0002\u00055\u0006\"CAX-\u0005\u0005IQIAY\u0011!\t\u0019LFA\u0001\n\u0003+\u0005\"CA[-\u0005\u0005I\u0011QA\\\u0011%\tiLFA\u0001\n\u0013\tyLA\rN_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oO&#%B\u0001\u0010 \u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0001\n\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001YsF\r\u001d\u0011\u00051jS\"A\u000f\n\u00059j\"A\u0004'fC\u001a,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003YAJ!!M\u000f\u0003!9{g\u000eZ3uKJl\u0017N\\5ti&\u001c\u0007CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$a\u0002)s_\u0012,8\r\u001e\t\u0003s\u0005s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005uJ\u0013A\u0002\u001fs_>$h(C\u00016\u0013\t\u0001E'A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%\u0001D*fe&\fG.\u001b>bE2,'B\u0001!5\u0003\u0019a\u0014N\\5u}Q\ta\t\u0005\u0002-\u0001\u0005)1m\\;oiB\u00111'S\u0005\u0003\u0015R\u0012A\u0001T8oO\"\u0012!\u0001\u0014\t\u0003g5K!A\u0014\u001b\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!\u00049beRLG/[8o\u001b\u0006\u001c8\u000e\u000b\u0002\u0004\u0019\u0006A1\u000f^1uK\u001a,H.F\u0001T!\t\u0019D+\u0003\u0002Vi\t9!i\\8mK\u0006t\u0017AE5oSRL\u0017\r\\5{K&sG/\u001a:oC2$\"\u0001W.\u0011\u0005MJ\u0016B\u0001.5\u0005\u0011)f.\u001b;\t\u000bq+\u0001\u0019A/\u0002\u001dA\f'\u000f^5uS>t\u0017J\u001c3fqB\u00111GX\u0005\u0003?R\u00121!\u00138u\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0002cKB\u0011AfY\u0005\u0003Iv\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u00151g\u00011\u0001h\u0003-qWm^\"iS2$'/\u001a8\u0011\u0007eB'-\u0003\u0002j\u0007\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\u00119,H\u000e\\1cY\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001/I\u0001\u0006if\u0004Xm]\u0005\u0003e>\u0014\u0001\u0002R1uCRK\b/Z\u0001\rKZ\fG.\u00138uKJt\u0017\r\u001c\u000b\u0003\u0011VDQA^\u0005A\u0002]\fQ!\u001b8qkR\u0004\"\u0001_=\u000e\u0003}I!A_\u0010\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$R!`A\u0004\u0003#\u00012A`A\u0002\u001b\u0005y(bAA\u0001;\u000591m\u001c3fO\u0016t\u0017bAA\u0003\u007f\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\n)\u0001\r!a\u0003\u0002\u0007\r$\b\u0010E\u0002\u007f\u0003\u001bI1!a\u0004\u0000\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0005\u000b\u0001\u0004i\u0018AA3w\u0003!qw\u000eZ3OC6,WCAA\r!\u0011\tY\"a\t\u000f\t\u0005u\u0011q\u0004\t\u0003wQJ1!!\t5\u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0005\u001b\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0005Y\u0006twM\u0003\u0002\u0002:\u0005!!.\u0019<b\u0013\u0011\t)#a\r\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003u\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002F\u0005-\u0003cA\u001a\u0002H%\u0019\u0011\u0011\n\u001b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002NA\t\t\u00111\u0001^\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000b\t\u0007\u0003+\nY&!\u0012\u000e\u0005\u0005]#bAA-i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0013q\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002T\u0003GB\u0011\"!\u0014\u0013\u0003\u0003\u0005\r!!\u0012\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003_\tI\u0007\u0003\u0005\u0002NM\t\t\u00111\u0001^\u0003\u0019)\u0017/^1mgR\u00191+a\u001c\t\u0013\u00055C#!AA\u0002\u0005\u0015\u0003f\u0005\u0001\u0002t\u0005e\u00141PA@\u0003\u0003\u000b))a\"\u0002\f\u00065\u0005c\u0001\u0017\u0002v%\u0019\u0011qO\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QP\u0001\u0005>)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015*A5\u0002#+\u001a;ve:\u001c\b%\\8o_R|g.[2bY2L\b%\u001b8de\u0016\f7/\u001b8hAY\"TFY5uA%tG/Z4feNt\u0003\u0005\u00165fA\u001d,g.\u001a:bi\u0016$\u0007%\u0013#!SN\u0004s-^1sC:$X-\u001a3\u000bA\u0001\u0002\u0003\u0005\t\u0011u_\u0002\u0012W\rI7p]>$xN\\5dC2d\u0017\u0010I5oGJ,\u0017m]5oO\u0002\ng\u000e\u001a\u0011v]&\fX/\u001a\u0017!EV$\bE\\8uA\r|gn]3dkRLg/\u001a\u0018!)\",\u0007eY;se\u0016tG\u000fI5na2,W.\u001a8uCRLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t9viN\u0004C\u000f[3!a\u0006\u0014H/\u001b;j_:\u0004\u0013\n\u0012\u0011j]\u0002\"\b.\u001a\u0011vaB,'\u000fI\u001a2A\tLGo\u001d\u0017!C:$\u0007\u0005\u001e5fA1|w/\u001a:!gM\u0002#-\u001b;tAI,\u0007O]3tK:$\b\u0005\u001e5fAI,7m\u001c:eA9,XNY3s\u0015\u0001\u0002\u0003\u0005\t\u0011!o&$\b.\u001b8!K\u0006\u001c\u0007\u000e\t9beRLG/[8o]\u0001\"\u0006.\u001a\u0011bgN,X\u000e\u001d;j_:\u0004\u0013n\u001d\u0011uQ\u0006$\b\u0005\u001e5fA\u0011\fG/\u0019\u0011ge\u0006lW\r\t5bg\u0002bWm]:!i\"\fg\u000eI\u0019!E&dG.[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u0014H/\u001b;j_:\u001cH\u0006I1oI\u0002*\u0017m\u00195!a\u0006\u0014H/\u001b;j_:\u0004\u0003.Y:!Y\u0016\u001c8\u000f\t;iC:\u0004\u0003\b\t2jY2LwN\u001c\u0011sK\u000e|'\u000fZ:/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007EZ;oGRLwN\u001c\u0011jg\u0002rwN\\\u0017eKR,'/\\5oSN$\u0018n\u0019\u0011cK\u000e\fWo]3!SR\u001c\bE]3tk2$\b\u0005Z3qK:$7\u000fI8oAA\f'\u000f^5uS>t\u0007%\u0013#t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019)A\u001a\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011R\u0001\u0006c9\"d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u001f\u000b!\"\\5tG~3WO\\2t\u0003eiuN\\8u_:L7-\u00197ms&s7M]3bg&tw-\u0013#\u0011\u0005122#\u0002\f\u0002\u0018\u0006\r\u0006#BAM\u0003?3UBAAN\u0015\r\ti\nN\u0001\beVtG/[7f\u0013\u0011\t\t+a'\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007\u0005\u0003\u0002&\u0006-VBAAT\u0015\u0011\tI+a\u000e\u0002\u0005%|\u0017b\u0001\"\u0002(R\u0011\u00111S\u0001\ti>\u001cFO]5oOR\u0011\u0011qF\u0001\u0006CB\u0004H._\u0001\bk:\f\u0007\u000f\u001d7z)\r\u0019\u0016\u0011\u0018\u0005\t\u0003wS\u0012\u0011!a\u0001\r\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u0005\u0007\u0003BA\u0019\u0003\u0007LA!!2\u00024\t1qJ\u00196fGR\u0004")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Nondeterministic,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID x$0) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(x$0);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(countTerm + " = 0L;");
        ctx.addPartitionInitializationStatement(partitionMaskTerm + " = ((long) partitionIndex) << 33;");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String nodeName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return this.prettyName() + "()";
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MonotonicallyIncreasingID && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic.$init$(this);
    }
}

