/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\tea\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0015\u0019\b\u0001\"\u0011X\u0011!!\b\u0001#b\u0001\n\u0013)\b\"\u0002?\u0001\t\u0003j\bbBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\ti\u0004\u0001C)\u0003\u007fA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005E\u0003!%A\u0005\u0002\u0005M\u0003\"CA5\u0001E\u0005I\u0011AA*\u0011%\tY\u0007AA\u0001\n\u0003\ni\u0007C\u0005\u0002~\u0001\t\t\u0011\"\u0001\u0002\u0000!I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#C\u0011\"a(\u0001\u0003\u0003%\t!!)\t\u0013\u0005\u0015\u0006!!A\u0005B\u0005\u001d\u0006\"CAV\u0001\u0005\u0005I\u0011IAW\u000f%\t\tNIA\u0001\u0012\u0003\t\u0019N\u0002\u0005\"E\u0005\u0005\t\u0012AAk\u0011\u0019\t6\u0004\"\u0001\u0002n\"I\u0011q^\u000e\u0002\u0002\u0013\u0015\u0013\u0011\u001f\u0005\n\u0003g\\\u0012\u0011!CA\u0003kD\u0011\"a?\u001c\u0003\u0003%\t)!@\t\u0013\t=1$!A\u0005\n\tE!!D'ba\u001a\u0013x.\\!se\u0006L8O\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0007N\u001c>!\t\t$'D\u0001#\u0013\t\u0019$E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011'N\u0005\u0003m\t\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"/\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(\u0001\u0003mK\u001a$X#A&\u0011\u0005Eb\u0015BA'#\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r\u0019F+\u0016\t\u0003c\u0001AQ!S\u0003A\u0002-CQaT\u0003A\u0002-\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001Y!\tA\u0014,\u0003\u0002[s\t9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\tQ\fE\u0002?=\u0002L!a\u0018%\u0003\u0007M+\u0017\u000f\u0005\u0002bI6\t!M\u0003\u0002dM\u0005)A/\u001f9fg&\u0011QM\u0019\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003[*\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\tI\u0006$\u0018\rV=qKV\t\u0001\u000f\u0005\u0002bc&\u0011!O\u0019\u0002\b\u001b\u0006\u0004H+\u001f9f\u0003!\u0019H/\u0019;fMVd\u0017AC7ba\n+\u0018\u000e\u001c3feV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zI\u0005!Q\u000f^5m\u0013\tY\bP\u0001\u000bBeJ\f\u0017PQ1tK\u0012l\u0015\r\u001d\"vS2$WM]\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0006}\u0006\r\u0011q\u0001\t\u0003q}L1!!\u0001:\u0005\r\te.\u001f\u0005\u0007\u0003\u000ba\u0001\u0019\u0001@\u0002\u0011-,\u00170\u0011:sCfDa!!\u0003\r\u0001\u0004q\u0018A\u0003<bYV,\u0017I\u001d:bs\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u001f\tY\"!\n\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006#\u0003\u001d\u0019w\u000eZ3hK:LA!!\u0007\u0002\u0014\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u001e5\u0001\r!a\b\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0012\u0005\u0005\u0012\u0002BA\u0012\u0003'\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002(5\u0001\r!a\u0004\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011Q\u0006\t\u0005\u0003_\t9D\u0004\u0003\u00022\u0005M\u0002C\u0001!:\u0013\r\t)$O\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U\u0012(A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)1+!\u0011\u0002F!1\u00111I\bA\u0002-\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002H=\u0001\raS\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0015\u0019\u0016QJA(\u0011\u001dI\u0005\u0003%AA\u0002-Cqa\u0014\t\u0011\u0002\u0003\u00071*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U#fA&\u0002X-\u0012\u0011\u0011\f\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003%)hn\u00195fG.,GMC\u0002\u0002de\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9'!\u0018\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\nAA[1wC&!\u0011\u0011HA:\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\tE\u00029\u0003\u0007K1!!\":\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rq\u00181\u0012\u0005\n\u0003\u001b+\u0012\u0011!a\u0001\u0003\u0003\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAJ!\u0015\t)*a'\u007f\u001b\t\t9JC\u0002\u0002\u001af\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti*a&\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00041\u0006\r\u0006\u0002CAG/\u0005\u0005\t\u0019\u0001@\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003_\nI\u000bC\u0005\u0002\u000eb\t\t\u00111\u0001\u0002\u0002\u00061Q-];bYN$2\u0001WAX\u0011!\ti)GA\u0001\u0002\u0004q\bf\u0005\u0001\u00024\u0006e\u00161XA`\u0003\u0003\f)-a2\u0002L\u00065\u0007cA\u0019\u00026&\u0019\u0011q\u0017\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QX\u0001\u0002\u0006)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015lKf\u001cH\u0006\t<bYV,7/\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA]LG\u000f\u001b\u0011bAA\f\u0017N\u001d\u0011pM\u0002\"\b.\u001a\u0011hSZ,g\u000eI6fs>2\u0018\r\\;fA\u0005\u0014(/Y=t]\u0001\nE\u000e\u001c\u0011fY\u0016lWM\u001c;t\u0015\u0001\u0002\u0003\u0005\t\u0011!S:\u00043.Z=tAMDw.\u001e7eA9|G\u000f\t2fA9,H\u000e\\\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111Y\u0001d\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEr\u0003\u0007\f\u00114]AJC\u0006I1se\u0006L\bf\n\u001a(Y\u0001:CgJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0018G\f\u0019;EI\u0012Cf\r\u00181u\t\"$% \u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011Z\u0001\u0006e9\"d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u001f\f\u0011\"\\1q?\u001a,hnY:\u0002\u001b5\u000b\u0007O\u0012:p[\u0006\u0013(/Y=t!\t\t4dE\u0003\u001c\u0003/\f\u0019\u000fE\u0004\u0002Z\u0006}7jS*\u000e\u0005\u0005m'bAAos\u00059!/\u001e8uS6,\u0017\u0002BAq\u00037\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t)/a;\u000e\u0005\u0005\u001d(\u0002BAu\u0003o\n!![8\n\u0007\u001d\u000b9\u000f\u0006\u0002\u0002T\u0006AAo\\*ue&tw\r\u0006\u0002\u0002p\u0005)\u0011\r\u001d9msR)1+a>\u0002z\")\u0011J\ba\u0001\u0017\")qJ\ba\u0001\u0017\u00069QO\\1qa2LH\u0003BA\u0000\u0005\u0017\u0001R\u0001\u000fB\u0001\u0005\u000bI1Aa\u0001:\u0005\u0019y\u0005\u000f^5p]B)\u0001Ha\u0002L\u0017&\u0019!\u0011B\u001d\u0003\rQ+\b\u000f\\33\u0011!\u0011iaHA\u0001\u0002\u0004\u0019\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0003\t\u0005\u0003c\u0012)\"\u0003\u0003\u0003\u0018\u0005M$AB(cU\u0016\u001cG\u000f")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays x$0) {
        return MapFromArrays$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        DataType keyType = ((ArrayType)this.left().dataType()).elementType();
        return TypeUtils$.MODULE$.checkForMapKeyType(keyType);
    }

    public MapType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    @Override
    public boolean stateful() {
        return true;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        MapFromArrays mapFromArrays = this;
        synchronized (mapFromArrays) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if (!this.bitmap$0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        return this.mapBuilder().from(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(keyArrayData, valueArrayData) -> {
            String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
            return ev.value() + " = " + builderTerm + ".from(" + keyArrayData + ".copy(), " + valueArrayData + ".copy());";
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    @Override
    public MapFromArrays withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

