% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\name{column_avro_functions}
\alias{column_avro_functions}
\alias{from_avro,characterOrColumn-method}
\alias{from_avro}
\alias{from_avro,Column-method}
\alias{to_avro,characterOrColumn-method}
\alias{to_avro}
\alias{to_avro,Column-method}
\title{Avro processing functions for Column operations}
\usage{
from_avro(x, ...)

to_avro(x, ...)

\S4method{from_avro}{characterOrColumn}(x, jsonFormatSchema, ...)

\S4method{to_avro}{characterOrColumn}(x, jsonFormatSchema = NULL)
}
\arguments{
\item{x}{Column to compute on.}

\item{...}{additional argument(s) passed as parser options.}

\item{jsonFormatSchema}{character Avro schema in JSON string format}
}
\description{
Avro processing functions defined for \code{Column}.
}
\details{
\code{from_avro} Converts a binary column of Avro format into its corresponding catalyst value.
The specified schema must match the read data, otherwise the behavior is undefined:
it may fail or return arbitrary result.
To deserialize the data with a compatible and evolved schema, the expected Avro schema can be
set via the option avroSchema.

\code{to_avro} Converts a column into binary of Avro format.
}
\note{
Avro is built-in but external data source module since Spark 2.4.
  Please deploy the application as per
  \href{https://spark.apache.org/docs/latest/sql-data-sources-avro.html#deploying}{
    the deployment section
  } of "Apache Avro Data Source Guide".

from_avro since 3.1.0

to_avro since 3.1.0
}
\examples{
\dontrun{
df <- createDataFrame(iris)
schema <- paste(
  c(
    '{"type": "record", "namespace": "example.avro", "name": "Iris", "fields": [',
    '{"type": ["double", "null"], "name": "Sepal_Length"},',
    '{"type": ["double", "null"], "name": "Sepal_Width"},',
    '{"type": ["double", "null"], "name": "Petal_Length"},',
    '{"type": ["double", "null"], "name": "Petal_Width"},',
    '{"type": ["string", "null"], "name": "Species"}]}'
  ),
  collapse="\\\\n"
)

df_serialized <- select(
  df,
  alias(to_avro(alias(struct(column("*")), "fields")), "payload")
)

df_deserialized <- select(
  df_serialized,
  from_avro(df_serialized$payload, schema)
)

head(df_deserialized)
}
}
\concept{avro functions}
