/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.base.Optional;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BufferedRows;
import org.apache.hive.beeline.IncrementalRows;

public class IncrementalRowsWithNormalization
extends IncrementalRows {
    private final int incrementalBufferRows;
    private BufferedRows buffer;

    IncrementalRowsWithNormalization(BeeLine beeLine, ResultSet rs) throws SQLException {
        super(beeLine, rs);
        this.incrementalBufferRows = beeLine.getOpts().getIncrementalBufferRows();
        this.buffer = new BufferedRows(beeLine, rs, (Optional<Integer>)Optional.of((Object)this.incrementalBufferRows));
        this.buffer.normalizeWidths();
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.buffer.hasNext()) {
                return true;
            }
            this.buffer = new BufferedRows(this.beeLine, this.rs, (Optional<Integer>)Optional.of((Object)this.incrementalBufferRows));
            if (this.normalizingWidths) {
                this.buffer.normalizeWidths();
            }
            if (!this.buffer.hasNext()) {
                return false;
            }
            this.buffer.next();
            return this.buffer.hasNext();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buffer.next();
    }
}

