/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.identity.SingleFieldId;

public class ByteId
extends SingleFieldId<Byte> {
    private byte key;

    public ByteId(Class pcClass, byte key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.targetClassName.hashCode() ^ key;
    }

    public ByteId(Class pcClass, Byte key) {
        this(pcClass, key != null ? key : (byte)0);
        this.assertKeyNotNull(key);
    }

    public ByteId(Class pcClass, String str) {
        this(pcClass, Byte.parseByte(str));
        this.assertKeyNotNull(str);
    }

    public ByteId() {
    }

    public byte getKey() {
        return this.key;
    }

    @Override
    public Byte getKeyAsObject() {
        return this.key;
    }

    public String toString() {
        return Byte.toString(this.key);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ByteId other = (ByteId)obj;
        return this.key == other.key;
    }

    public int compareTo(Object o) {
        if (o instanceof ByteId) {
            ByteId other = (ByteId)o;
            int result = super.compare(other);
            if (result == 0) {
                return this.key - other.key;
            }
            return result;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.key);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readByte();
    }
}

