/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkSubmit$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.IvyProperties;
import org.apache.spark.util.MavenUtils$;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DependencyUtils$
implements Logging {
    public static final DependencyUtils$ MODULE$ = new DependencyUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public IvyProperties getIvyProperties() {
        SeqOps seqOps;
        Seq seq = (Seq)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JAR_PACKAGES_EXCLUSIONS().key(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JAR_PACKAGES().key(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JAR_REPOSITORIES().key(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JAR_IVY_REPO_PATH().key(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JAR_IVY_SETTING_PATH().key(), (List)Nil$.MODULE$))))).map((Function1 & Serializable)x$1 -> (String)scala.sys.package$.MODULE$.props().get(x$1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 5) != 0) {
            throw new MatchError((Object)seq);
        }
        String packagesExclusions = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String packages = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        String repositories = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
        String ivyRepoPath = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
        String ivySettingsPath = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4);
        Tuple5 tuple5 = new Tuple5((Object)packagesExclusions, (Object)packages, (Object)repositories, (Object)ivyRepoPath, (Object)ivySettingsPath);
        String packagesExclusions2 = (String)tuple5._1();
        String packages2 = (String)tuple5._2();
        String repositories2 = (String)tuple5._3();
        String ivyRepoPath2 = (String)tuple5._4();
        String ivySettingsPath2 = (String)tuple5._5();
        return new IvyProperties(packagesExclusions2, packages2, repositories2, ivyRepoPath2, ivySettingsPath2);
    }

    public Seq<String> resolveMavenDependencies(URI uri) {
        IvyProperties ivyProperties = this.getIvyProperties();
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException("Invalid Ivy URI authority in uri " + uri.toString() + ": Expected 'org:module:version', found null.");
        }
        if (authority.split(":").length != 3) {
            throw new IllegalArgumentException("Invalid Ivy URI authority in uri " + uri.toString() + ": Expected 'org:module:version', found " + authority + ".");
        }
        Tuple3 tuple3 = MavenUtils$.MODULE$.parseQueryParams(uri);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        boolean transitive = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        String exclusionList = (String)tuple3._2();
        String repos = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)transitive), (Object)exclusionList, (Object)repos);
        boolean transitive2 = BoxesRunTime.unboxToBoolean((Object)tuple32._1());
        String exclusionList2 = (String)tuple32._2();
        String repos2 = (String)tuple32._3();
        String fullReposList = ((IterableOnceOps)new .colon.colon((Object)ivyProperties.repositories(), (List)new .colon.colon((Object)repos2, (List)Nil$.MODULE$)).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$resolveMavenDependencies$1(x$4)))).mkString(",");
        return this.resolveMavenDependencies(transitive2, exclusionList2, authority, fullReposList, ivyProperties.ivyRepoPath(), (Option<String>)Option$.MODULE$.apply((Object)ivyProperties.ivySettingsPath()));
    }

    public Seq<String> resolveMavenDependencies(boolean packagesTransitive, String packagesExclusions, String packages, String repositories, String ivyRepoPath, Option<String> ivySettingsPath) {
        IvySettings ivySettings;
        Nil$ exclusions = !StringUtils.isBlank((CharSequence)packagesExclusions) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)packagesExclusions.split(",")).toImmutableArraySeq() : Nil$.MODULE$;
        PrintStream printStream = SparkSubmit$.MODULE$.printStream();
        Option<String> option = ivySettingsPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            ivySettings = MavenUtils$.MODULE$.loadIvySettings(path, Option$.MODULE$.apply((Object)repositories), Option$.MODULE$.apply((Object)ivyRepoPath), printStream);
        } else if (None$.MODULE$.equals(option)) {
            ivySettings = MavenUtils$.MODULE$.buildIvySettings(Option$.MODULE$.apply((Object)repositories), Option$.MODULE$.apply((Object)ivyRepoPath), MavenUtils$.MODULE$.buildIvySettings$default$3(), printStream);
        } else {
            throw new MatchError(option);
        }
        IvySettings ivySettings2 = ivySettings;
        String x$1 = packages;
        IvySettings x$2 = ivySettings2;
        boolean x$3 = packagesTransitive;
        Nil$ x$4 = exclusions;
        Option x$5 = MavenUtils$.MODULE$.resolveMavenCoordinates$default$3();
        boolean x$6 = MavenUtils$.MODULE$.resolveMavenCoordinates$default$6();
        return MavenUtils$.MODULE$.resolveMavenCoordinates(x$1, x$2, x$5, x$3, (Seq)x$4, x$6, printStream);
    }

    public String resolveAndDownloadJars(String jars, String userJar, SparkConf sparkConf, Configuration hadoopConf) {
        File targetDir = Utils$.MODULE$.createTempDir();
        String userJarName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(userJar), File.separatorChar)));
        return (String)Option$.MODULE$.apply((Object)jars).map((Function1 & Serializable)x$5 -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.resolveGlobPaths((String)x$5, hadoopConf).split(",")), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains(userJarName)))).mkString(",")).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$resolveAndDownloadJars$3(x$7))).map((Function1 & Serializable)x$8 -> MODULE$.downloadFileList((String)x$8, targetDir, sparkConf, hadoopConf)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void addJarsToClassPath(String jars, MutableURLClassLoader loader) {
        if (jars != null) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])jars.split(",")), (Function1 & Serializable)jar -> {
                DependencyUtils$.MODULE$.addJarToClasspath(jar, loader);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public String downloadFileList(String fileList, File targetDir, SparkConf sparkConf, Configuration hadoopConf) {
        Predef$.MODULE$.require(fileList != null, (Function0 & Serializable)() -> "fileList cannot be null.");
        return ((IterableOnceOps)Utils$.MODULE$.stringToSeq(fileList).map((Function1 & Serializable)x$9 -> MODULE$.downloadFile((String)x$9, targetDir, sparkConf, hadoopConf))).mkString(",");
    }

    public String downloadFile(String path, File targetDir, SparkConf sparkConf, Configuration hadoopConf) {
        URI uri;
        block10: {
            block11: {
                Predef$.MODULE$.require(path != null, (Function0 & Serializable)() -> "path cannot be null.");
                uri = Utils$.MODULE$.resolveURI(path);
                String string = uri.getScheme();
                switch (string == null ? 0 : string.hashCode()) {
                    case 101730: {
                        if (!"ftp".equals(string)) break block10;
                        break block11;
                    }
                    case 3143036: {
                        if ("file".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    case 3213448: {
                        if (!"http".equals(string)) break block10;
                        break block11;
                    }
                    case 99617003: {
                        if (!"https".equals(string)) break block10;
                        break block11;
                    }
                    case 103145323: {
                        if ("local".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    default: {
                        break block10;
                    }
                }
                return path;
            }
            if (Utils$.MODULE$.isTesting()) {
                File file = new File(uri.getPath());
                return new File(targetDir, file.getName()).toURI().toString();
            }
        }
        String fname = new Path(uri).getName();
        File localFile = Utils$.MODULE$.doFetchFile(uri.toString(), targetDir, fname, sparkConf, hadoopConf);
        return localFile.toURI().toString();
    }

    public String resolveGlobPaths(String paths, Configuration hadoopConf) {
        Predef$.MODULE$.require(paths != null, (Function0 & Serializable)() -> "paths cannot be null.");
        return ((IterableOnceOps)Utils$.MODULE$.stringToSeq(paths).flatMap((Function1 & Serializable)path -> {
            Tuple2<URI, Option<String>> tuple2 = MODULE$.splitOnFragment((String)path);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            URI base = (URI)tuple2._1();
            Option fragment = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)base, (Object)fragment);
            URI base2 = (URI)tuple22._1();
            Option fragment2 = (Option)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)MODULE$.resolveGlobPath(base2, hadoopConf), (Object)fragment2);
            if (tuple23 != null) {
                String[] resolved = (String[])tuple23._1();
                Option option = (Option)tuple23._2();
                if (option instanceof Some && resolved.length > 1) {
                    throw new SparkException(base2.toString() + " resolves ambiguously to multiple files: " + Predef$.MODULE$.wrapRefArray((Object[])resolved).mkString(","));
                }
            }
            if (tuple23 != null) {
                String[] resolved = (String[])tuple23._1();
                Option option = (Option)tuple23._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String namedAs = (String)some.value();
                    return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])resolved), (Function1 & Serializable)x$11 -> x$11 + "#" + namedAs, ClassTag$.MODULE$.apply(String.class)));
                }
            }
            if (tuple23 != null) {
                String[] resolved = (String[])tuple23._1();
                return Predef$.MODULE$.wrapRefArray((Object[])resolved);
            }
            throw new MatchError((Object)tuple23);
        })).mkString(",");
    }

    public void addJarToClasspath(String localJar, MutableURLClassLoader loader) {
        block9: {
            URI uri;
            block8: {
                uri = Utils$.MODULE$.resolveURI(localJar);
                String string = uri.getScheme();
                switch (string == null ? 0 : string.hashCode()) {
                    case 3143036: {
                        if ("file".equals(string)) {
                            break;
                        }
                        break block8;
                    }
                    case 103145323: {
                        if ("local".equals(string)) {
                            break;
                        }
                        break block8;
                    }
                    default: {
                        break block8;
                    }
                }
                File file = new File(uri.getPath());
                if (file.exists()) {
                    loader.addURL(file.toURI().toURL());
                } else {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Local jar ", " does not exist, skipping."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)file)}))));
                }
                break block9;
            }
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skip remote jar ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URI$.MODULE$, (Object)uri)}))));
        }
    }

    public String mergeFileLists(Seq<String> lists) {
        Seq merged = (Seq)((IterableOps)lists.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$mergeFileLists$1(x$1)))).flatMap((Function1 & Serializable)str -> Utils$.MODULE$.stringToSeq((String)str));
        if (merged.nonEmpty()) {
            return merged.mkString(",");
        }
        return null;
    }

    private Tuple2<URI, Option<String>> splitOnFragment(String path) {
        URI uri = Utils$.MODULE$.resolveURI(path);
        URI withoutFragment = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        return new Tuple2((Object)withoutFragment, (Object)Option$.MODULE$.apply((Object)uri.getFragment()));
    }

    private String[] resolveGlobPath(URI uri, Configuration hadoopConf) {
        block10: {
            String string = uri.getScheme();
            switch (string == null ? 0 : string.hashCode()) {
                case 101730: {
                    if ("ftp".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 3213448: {
                    if ("http".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 99617003: {
                    if ("https".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 103145323: {
                    if ("local".equals(string)) {
                        break;
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            return (String[])((Object[])new String[]{uri.toString()});
        }
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConf);
        return (String[])Option$.MODULE$.apply((Object)fs.globStatus(new Path(uri))).map((Function1 & Serializable)status -> (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])status), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isFile()))), (Function1 & Serializable)x$13 -> x$13.getPath().toUri().toString(), ClassTag$.MODULE$.apply(String.class))).getOrElse((Function0 & Serializable)() -> (String[])((Object[])new String[]{uri.toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$resolveMavenDependencies$1(String x$4) {
        return !StringUtils.isBlank((CharSequence)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$resolveAndDownloadJars$3(String x$7) {
        String string = x$7;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mergeFileLists$1(CharSequence x$1) {
        return StringUtils.isBlank((CharSequence)x$1);
    }

    private DependencyUtils$() {
    }
}

