/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.package$;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.WebUITab;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.ui.scope.RDDOperationGraph$;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.xml.Attribute$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;
import scala.xml.transform.RewriteRule;
import scala.xml.transform.RuleTransformer;

public final class UIUtils$
implements Logging {
    public static final UIUtils$ MODULE$ = new UIUtils$();
    private static final String TABLE_CLASS_NOT_STRIPED;
    private static final String TABLE_CLASS_STRIPED;
    private static final String TABLE_CLASS_STRIPED_SORTABLE;
    private static final DateTimeFormatter dateTimeFormatter;
    private static final DateTimeFormatter batchTimeFormat;
    private static final DateTimeFormatter batchTimeFormatWithMilliseconds;
    private static final Regex ERROR_CLASS_REGEX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        TABLE_CLASS_NOT_STRIPED = "table table-bordered table-sm";
        TABLE_CLASS_STRIPED = MODULE$.TABLE_CLASS_NOT_STRIPED() + " table-striped";
        TABLE_CLASS_STRIPED_SORTABLE = MODULE$.TABLE_CLASS_STRIPED() + " sortable";
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss", Locale.US).withZone(ZoneId.systemDefault());
        batchTimeFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss", Locale.US).withZone(ZoneId.systemDefault());
        batchTimeFormatWithMilliseconds = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS", Locale.US).withZone(ZoneId.systemDefault());
        ERROR_CLASS_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\[(?<errorClass>[A-Z][A-Z_.]+[A-Z])]"));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String TABLE_CLASS_NOT_STRIPED() {
        return TABLE_CLASS_NOT_STRIPED;
    }

    public String TABLE_CLASS_STRIPED() {
        return TABLE_CLASS_STRIPED;
    }

    public String TABLE_CLASS_STRIPED_SORTABLE() {
        return TABLE_CLASS_STRIPED_SORTABLE;
    }

    private DateTimeFormatter dateTimeFormatter() {
        return dateTimeFormatter;
    }

    public String formatDate(Date date) {
        return this.dateTimeFormatter().format(date.toInstant());
    }

    public String formatDate(long timestamp) {
        return this.dateTimeFormatter().format(Instant.ofEpochMilli(timestamp));
    }

    public String formatDuration(long milliseconds) {
        if (milliseconds < 100L) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d ms"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)milliseconds)}));
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < 1.0) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.1f s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        if (seconds < (double)60) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.0f s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)10) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.1f min"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        if (minutes < (double)60) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.0f min"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        double hours = minutes / (double)60;
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.1f h"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)hours)}));
    }

    public String formatDurationVerbose(long ms) {
        Object object;
        Object object2 = new Object();
        try {
            try {
                long second = 1000L;
                long minute = 60L * second;
                long hour = 60L * minute;
                long day = 24L * hour;
                long week = 7L * day;
                long year = 365L * day;
                String millisecondsString = ms >= second && ms % second == 0L ? "" : ms % second + " ms";
                String secondString = UIUtils$.toString$1(ms % minute / second, "second");
                String minuteString = UIUtils$.toString$1(ms % hour / minute, "minute");
                String hourString = UIUtils$.toString$1(ms % day / hour, "hour");
                String dayString = UIUtils$.toString$1(ms % week / day, "day");
                String weekString = UIUtils$.toString$1(ms % year / week, "week");
                String yearString = UIUtils$.toString$1(ms / year, "year");
                new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)second)), (Object)millisecondsString), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)minute)), (Object)(secondString + " " + millisecondsString)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)hour)), (Object)(minuteString + " " + secondString)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)day)), (Object)(hourString + " " + minuteString + " " + secondString)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)week)), (Object)(dayString + " " + hourString + " " + minuteString)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)year)), (Object)(weekString + " " + dayString + " " + hourString)), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)x0$1 -> {
                    UIUtils$.$anonfun$formatDurationVerbose$1(ms, object2, x0$1);
                    return BoxedUnit.UNIT;
                });
                object = yearString + " " + weekString + " " + dayString;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Error converting time to string", (Throwable)e);
                object = "";
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = (String)ex.value();
            }
            throw ex;
        }
        return object;
    }

    private DateTimeFormatter batchTimeFormat() {
        return batchTimeFormat;
    }

    private DateTimeFormatter batchTimeFormatWithMilliseconds() {
        return batchTimeFormatWithMilliseconds;
    }

    public String formatBatchTime(long batchTime, long batchInterval, boolean showYYYYMMSS, TimeZone timezone) {
        DateTimeFormatter format = batchInterval < 1000L ? this.batchTimeFormatWithMilliseconds() : this.batchTimeFormat();
        DateTimeFormatter formatWithZone = timezone == null ? format : format.withZone(timezone.toZoneId());
        String formattedBatchTime = formatWithZone.format(Instant.ofEpochMilli(batchTime));
        if (showYYYYMMSS) {
            return formattedBatchTime;
        }
        return formattedBatchTime.substring(formattedBatchTime.indexOf(32) + 1);
    }

    public boolean formatBatchTime$default$3() {
        return true;
    }

    public TimeZone formatBatchTime$default$4() {
        return null;
    }

    public String formatNumber(double records) {
        Tuple2 tuple2;
        double trillion = 1.0E12;
        double billion = 1.0E9;
        double million = 1000000.0;
        double thousand = 1000.0;
        Tuple2 tuple22 = records >= (double)2 * trillion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / trillion)), (Object)" T") : (records >= (double)2 * billion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / billion)), (Object)" B") : (records >= (double)2 * million ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / million)), (Object)" M") : (tuple2 = records >= (double)2 * thousand ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / thousand)), (Object)" K") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)records), (Object)""))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double value = tuple2._1$mcD$sp();
        String unit = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)value), (Object)unit);
        double value2 = tuple23._1$mcD$sp();
        String unit2 = (String)tuple23._2();
        if (unit2.isEmpty()) {
            return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%d"), Locale.US, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)value2))}));
        }
        return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.1f%s"), Locale.US, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value2), unit2}));
    }

    public String uiRoot(HttpServletRequest request) {
        Option knoxBasePath = Option$.MODULE$.apply((Object)request.getHeader("X-Forwarded-Context"));
        return (String)scala.sys.package$.MODULE$.props().get("spark.ui.proxyBase").orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"APPLICATION_WEB_PROXY_BASE")).orElse((Function0 & Serializable)() -> knoxBasePath).getOrElse((Function0 & Serializable)() -> "");
    }

    public String prependBaseUri(HttpServletRequest request, String basePath, String resource) {
        return this.uiRoot(request) + basePath + resource;
    }

    public String prependBaseUri$default$2() {
        return "";
    }

    public String prependBaseUri$default$3() {
        return "";
    }

    public scala.collection.immutable.Seq<Node> commonHeaderNodes(HttpServletRequest request) {
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-type"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("content", (Seq)new Text("width=device-width, initial-scale=1"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("name", (Seq)new Text("viewport"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/bootstrap.min.css", this.prependBaseUri$default$3()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/vis-timeline-graph2d.min.css", this.prependBaseUri$default$3()), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/webui.css", this.prependBaseUri$default$3()), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/timeline-view.css", this.prependBaseUri$default$3()), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md6);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/sorttable.js", this.prependBaseUri$default$3()), (MetaData)$md7);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery-3.5.1.min.js", this.prependBaseUri$default$3()), (MetaData)$md8);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/vis-timeline-graph2d.min.js", this.prependBaseUri$default$3()), (MetaData)$md9);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/bootstrap.bundle.min.js", this.prependBaseUri$default$3()), (MetaData)$md10);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/initialize-tooltips.js", this.prependBaseUri$default$3()), (MetaData)$md11);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/table.js", this.prependBaseUri$default$3()), (MetaData)$md12);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/timeline-view.js", this.prependBaseUri$default$3()), (MetaData)$md13);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/log-view.js", this.prependBaseUri$default$3()), (MetaData)$md14);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/webui.js", this.prependBaseUri$default$3()), (MetaData)$md15);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md16 = Null$.MODULE$;
        $md16 = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md16);
        $md16 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/scroll-button.js", this.prependBaseUri$default$3()), (MetaData)$md16);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("setUIRoot('"));
        $buf2.$amp$plus((Object)this.uiRoot(request));
        $buf2.$amp$plus((Object)new Text("')"));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    public scala.collection.immutable.Seq<Node> vizHeaderNodes(HttpServletRequest request) {
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md);
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/spark-dag-viz.css", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/d3.min.js", this.prependBaseUri$default$3()), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/dagre-d3.min.js", this.prependBaseUri$default$3()), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/graphlib-dot.min.js", this.prependBaseUri$default$3()), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/spark-dag-viz.js", this.prependBaseUri$default$3()), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    public scala.collection.immutable.Seq<Node> dataTablesHeaderNodes(HttpServletRequest request) {
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md);
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/dataTables.bootstrap4.min.css", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/jquery.dataTables.min.css", this.prependBaseUri$default$3()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/webui-dataTables.css", this.prependBaseUri$default$3()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.dataTables.min.js", this.prependBaseUri$default$3()), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.cookies.2.2.0.min.js", this.prependBaseUri$default$3()), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.blockUI.min.js", this.prependBaseUri$default$3()), (MetaData)$md6);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/dataTables.bootstrap4.min.js", this.prependBaseUri$default$3()), (MetaData)$md7);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.mustache.js", this.prependBaseUri$default$3()), (MetaData)$md8);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    public scala.collection.immutable.Seq<Node> headerSparkPage(HttpServletRequest request, String title, Function0<scala.collection.immutable.Seq<Node>> content, SparkUITab activeTab, Option<String> helpText, boolean showVisualization, boolean useDataTables) {
        String appName = activeTab.appName();
        String shortAppName = appName.length() < 36 ? appName : StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(appName), 32) + "...";
        scala.collection.immutable.Seq header = (scala.collection.immutable.Seq)activeTab.headerTabs().map((Function1 & Serializable)tab -> {
            Null$ $md = Null$.MODULE$;
            WebUITab webUITab = tab;
            SparkUITab sparkUITab = activeTab;
            $md = new UnprefixedAttribute("class", !(webUITab != null ? !webUITab.equals(sparkUITab) : sparkUITab != null) ? "nav-item active" : "nav-item", (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("href", MODULE$.prependBaseUri(request, activeTab.basePath(), "/" + tab.prefix() + "/"), (MetaData)$md2);
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("nav-link"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)tab.name());
            $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n      "));
            return new Elem(null, "li", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        });
        scala.collection.immutable.Seq helpButton = (scala.collection.immutable.Seq)helpText.map((Function1 & Serializable)x$2 -> MODULE$.tooltip((String)x$2, "top")).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.commonHeaderNodes(request));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("setAppBasePath('"));
        $buf3.$amp$plus((Object)activeTab.basePath());
        $buf3.$amp$plus((Object)new Text("')"));
        $buf2.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(showVisualization ? this.vizHeaderNodes(request) : scala.package$.MODULE$.Seq().empty()));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(useDataTables ? this.dataTablesHeaderNodes(request) : scala.package$.MODULE$.Seq().empty()));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("shortcut icon"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)appName);
        $buf4.$amp$plus((Object)new Text(" - "));
        $buf4.$amp$plus((Object)title);
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("navbar navbar-expand-md navbar-light bg-light mb-4"), (MetaData)$md2);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("navbar-header"), (MetaData)$md3);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("navbar-brand"), (MetaData)$md4);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n              "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/", this.prependBaseUri$default$3()), (MetaData)$md5);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n                "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md6);
        $buf9.$amp$plus((Object)new Elem(null, "img", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n                "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("version"), (MetaData)$md7);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)activeTab.appSparkVersion());
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n              "));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("aria-label", (Seq)new Text("Toggle navigation"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("aria-expanded", (Seq)new Text("false"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("aria-controls", (Seq)new Text("navbarCollapse"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("data-target", (Seq)new Text("#navbarCollapse"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("data-toggle", (Seq)new Text("collapse"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("button"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("navbar-toggler"), (MetaData)$md8);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n            "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("navbar-toggler-icon"), (MetaData)$md9);
        $buf11.$amp$plus((Object)new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "button", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("id", (Seq)new Text("navbarCollapse"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("collapse navbar-collapse"), (MetaData)$md10);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("navbar-nav mr-auto"), (MetaData)$md11);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)header);
        $buf12.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf12.$amp$plus((Object)new Text("\n            "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("class", (Seq)new Text("navbar-text navbar-right d-none d-md-block"), (MetaData)$md12);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n              "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("text-nowrap"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("title", appName, (MetaData)$md13);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)shortAppName);
        $buf14.$amp$plus((Object)new Elem(null, "strong", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf14.$amp$plus((Object)new Text("\n              "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("class", (Seq)new Text("text-nowrap"), (MetaData)$md14);
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("application UI"));
        $buf14.$amp$plus((Object)new Elem(null, "span", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf14.$amp$plus((Object)new Text("\n            "));
        $buf12.$amp$plus((Object)new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "nav", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("class", (Seq)new Text("container-fluid"), (MetaData)$md15);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n          "));
        Null$ $md16 = Null$.MODULE$;
        $md16 = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md16);
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n            "));
        Null$ $md17 = Null$.MODULE$;
        $md17 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md17);
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("\n              "));
        Null$ $md18 = Null$.MODULE$;
        $md18 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: bottom; white-space: nowrap; overflow: hidden;\n                text-overflow: ellipsis;"), (MetaData)$md18);
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n                "));
        $buf20.$amp$plus((Object)title);
        $buf20.$amp$plus((Object)new Text("\n                "));
        $buf20.$amp$plus((Object)helpButton);
        $buf20.$amp$plus((Object)new Text("\n              "));
        $buf19.$amp$plus((Object)new Elem(null, "h3", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
        $buf19.$amp$plus((Object)new Text("\n            "));
        $buf18.$amp$plus((Object)new Elem(null, "div", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
        $buf18.$amp$plus((Object)new Text("\n          "));
        $buf17.$amp$plus((Object)new Elem(null, "div", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf17.$amp$plus((Object)new Text("\n          "));
        Null$ $md19 = Null$.MODULE$;
        $md19 = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md19);
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("\n            "));
        Null$ $md20 = Null$.MODULE$;
        $md20 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md20);
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("\n              "));
        $buf22.$amp$plus(content.apply());
        $buf22.$amp$plus((Object)new Text("\n            "));
        $buf21.$amp$plus((Object)new Elem(null, "div", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
        $buf21.$amp$plus((Object)new Text("\n          "));
        $buf17.$amp$plus((Object)new Elem(null, "div", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
        $buf17.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public Option<String> headerSparkPage$default$5() {
        return None$.MODULE$;
    }

    public boolean headerSparkPage$default$6() {
        return false;
    }

    public boolean headerSparkPage$default$7() {
        return false;
    }

    public scala.collection.immutable.Seq<Node> basicSparkPage(HttpServletRequest request, Function0<scala.collection.immutable.Seq<Node>> content, String title, boolean useDataTables) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.commonHeaderNodes(request));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(useDataTables ? this.dataTablesHeaderNodes(request) : scala.package$.MODULE$.Seq().empty()));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("shortcut icon"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)title);
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("container-fluid"), (MetaData)$md2);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md4);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle; display: inline-block;"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/", this.prependBaseUri$default$3()), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("style", (Seq)new Text("text-decoration: none"), (MetaData)$md6);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n                  "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md7);
        $buf9.$amp$plus((Object)new Elem(null, "img", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n                  "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("style", (Seq)new Text("margin-right: 15px;"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("version"), (MetaData)$md8);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)package$.MODULE$.SPARK_VERSION());
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n                "));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n                "));
        $buf8.$amp$plus((Object)title);
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf7.$amp$plus((Object)new Elem(null, "h3", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md9);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md10);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n              "));
        $buf12.$amp$plus(content.apply());
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public boolean basicSparkPage$default$4() {
        return false;
    }

    public <T> scala.collection.immutable.Seq<Node> listingTable(scala.collection.immutable.Seq<String> headers, Function1<T, scala.collection.immutable.Seq<Node>> generateDataRow, Iterable<T> data2, boolean fixedWidth, Option<String> id, scala.collection.immutable.Seq<String> headerClasses, boolean stripeRowsWithCss, boolean sortable, scala.collection.immutable.Seq<Option<String>> tooltipHeaders) {
        String _tableClass = stripeRowsWithCss ? this.TABLE_CLASS_STRIPED() : this.TABLE_CLASS_NOT_STRIPED();
        Object listingTableClass = sortable ? _tableClass + " sortable" : _tableClass;
        double colWidth = 100.0 / (double)headers.size();
        Object colWidthAttr = fixedWidth ? colWidth + "%" : "";
        boolean newlinesInHeader = headers.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("\n")));
        LazyList headerRow = ((LazyList)headers.to(IterableFactory$.MODULE$.toFactory((IterableFactory)scala.package$.MODULE$.LazyList()))).zipWithIndex().map(arg_0 -> UIUtils$.$anonfun$listingTable$3((String)colWidthAttr, tooltipHeaders, headerClasses, newlinesInHeader, arg_0));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", id.map((Function1 & Serializable)data -> Text$.MODULE$.apply(data)), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (String)listingTableClass, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)headerRow);
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(data2.map((Function1 & Serializable)r -> (scala.collection.immutable.Seq)generateDataRow.apply(r)));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public <T> boolean listingTable$default$4() {
        return false;
    }

    public <T> Option<String> listingTable$default$5() {
        return None$.MODULE$;
    }

    public <T> scala.collection.immutable.Seq<String> listingTable$default$6() {
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <T> boolean listingTable$default$7() {
        return true;
    }

    public <T> boolean listingTable$default$8() {
        return true;
    }

    public <T> scala.collection.immutable.Seq<Option<String>> listingTable$default$9() {
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
    }

    public scala.collection.immutable.Seq<Node> makeProgressBar(int started, int completed, int failed, int skipped, scala.collection.immutable.Map<String, Object> reasonToNumKilled, int total) {
        double ratio = total == 0 ? 100.0 : (double)completed / (double)total * (double)100;
        String completeWidth = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("width: %s%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)ratio)}));
        int boundedStarted = scala.math.package$.MODULE$.min(started, total - completed);
        double startRatio = total == 0 ? 0.0 : (double)boundedStarted / (double)total * (double)100;
        String startWidth = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("width: %s%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)startRatio)}));
        String killTaskReasonText = ((IterableOnceOps)((IterableOps)reasonToNumKilled.toSeq().sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)UIUtils$.$anonfun$makeProgressBar$1(x$4)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String reason = (String)tuple2._1();
                int count = tuple2._2$mcI$sp();
                return " (" + count + " killed: " + reason + ")";
            }
            throw new MatchError((Object)tuple2);
        })).mkString();
        String progressTitle = completed + "/" + total + (started > 0 ? " (" + started + " running)" : "") + (failed > 0 ? " (" + failed + " failed)" : "") + (skipped > 0 ? " (" + skipped + " skipped)" : "") + killTaskReasonText;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("progress"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("title", progressTitle, (MetaData)$md2);
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("text-align:center; position:absolute; width:100%;"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completed));
        $buf2.$amp$plus((Object)new Text("/"));
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)total));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(failed == 0 && skipped == 0 && started > 0 ? "(" + started + " running)" : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(failed > 0 ? "(" + failed + " failed)" : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(skipped > 0 ? "(" + skipped + " skipped)" : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)killTaskReasonText);
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", completeWidth, (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("progress-bar progress-completed"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", startWidth, (MetaData)$md4);
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("progress-bar progress-started"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public scala.collection.immutable.Seq<Node> showDagVizForStage(int stageId, Option<RDDOperationGraph> graph) {
        return NodeSeq$.MODULE$.seqToNodeSeq(this.showDagViz((Seq<RDDOperationGraph>)Option$.MODULE$.option2Iterable(graph).toSeq(), false));
    }

    public Seq<Node> showDagVizForJob(int jobId, Seq<RDDOperationGraph> graphs) {
        return this.showDagViz(graphs, true);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> showDagViz(Seq<RDDOperationGraph> graphs, boolean forJob) {
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onclick", "toggleDagViz(" + forJob + ");", (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-dag-viz"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", forJob ? "job-dag-viz" : "stage-dag-viz", (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-dag-viz-arrow arrow-closed"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", forJob ? ToolTips$.MODULE$.JOB_DAG() : ToolTips$.MODULE$.STAGE_DAG(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          DAG Visualization\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("dag-viz-graph"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("display:none"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("dag-viz-metadata"), (MetaData)$md5);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(graphs.map((Function1 & Serializable)g -> {
            String stageId = g.rootCluster().id().replaceAll(RDDOperationGraph$.MODULE$.STAGE_CLUSTER_PREFIX(), "");
            String skipped = Boolean.toString(g.rootCluster().name().contains("skipped"));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("skipped", skipped, (MetaData)$md);
            $md = new UnprefixedAttribute("stage-id", stageId, (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("stage-metadata"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n              "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("dot-file"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)RDDOperationGraph$.MODULE$.makeDotFile((RDDOperationGraph)g));
            $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus(g.incomingEdges().map((Function1 & Serializable)e -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("incoming-edge"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.fromId()));
                $buf.$amp$plus((Object)new Text(","));
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.toId()));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            }));
            $buf.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus(g.outgoingEdges().map((Function1 & Serializable)e -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("outgoing-edge"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.fromId()));
                $buf.$amp$plus((Object)new Text(","));
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.toId()));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            }));
            $buf.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus(((IterableOps)((IterableOps)g.rootCluster().getCachedNodes().map((Function1 & Serializable)n -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("cached-rdd"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)n.id()));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            })).$plus$plus((IterableOnce)g.rootCluster().getBarrierClusters().map((Function1 & Serializable)c -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("barrier-rdd"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)c.id());
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            }))).$plus$plus((IterableOnce)g.rootCluster().getIndeterminateNodes().map((Function1 & Serializable)n -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("indeterminate-rdd"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)n.id()));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            })));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Seq<Node> tooltip(String text, String position) {
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      ("));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("title", text, (MetaData)$md);
        $md = new UnprefixedAttribute("data-placement", position, (MetaData)$md);
        $md = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("?"));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text(")\n    "));
        return new Elem(null, "sup", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    public NodeSeq makeDescription(String desc, String basePathUri, boolean plainText) {
        Text text;
        try {
            Elem xml = (Elem)XML$.MODULE$.loadString("<span class=\"description-input\">" + desc + "</span>");
            Set allowedNodeLabels = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "span", "br"}));
            Set allowedAttributes = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"class", "href"}));
            NodeSeq illegalNodes = (NodeSeq)xml.$bslash$bslash("_").filterNot((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)UIUtils$.$anonfun$makeDescription$1(allowedNodeLabels, allowedAttributes, node)));
            if (illegalNodes.nonEmpty()) {
                throw new IllegalArgumentException("Only HTML anchors allowed in job descriptions\n" + ((IterableOnceOps)illegalNodes.map((Function1 & Serializable)n -> n.label() + " in " + n)).mkString("\n\t"));
            }
            scala.collection.immutable.Seq allLinks = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)xml.$bslash$bslash("a").flatMap((Function1 & Serializable)x$6 -> x$6.attributes())).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UIUtils$.$anonfun$makeDescription$6(x$7)))).map((Function1 & Serializable)x$8 -> x$8.value().toString());
            if (allLinks.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)UIUtils$.$anonfun$makeDescription$8(x$9)))) {
                throw new IllegalArgumentException("Links in job descriptions must be root-relative:\n" + allLinks.mkString("\n\t"));
            }
            RewriteRule rule = plainText ? new RewriteRule(){

                public scala.collection.immutable.Seq<Node> transform(Node n2) {
                    boolean bl = false;
                    Elem elem = null;
                    Node node = n2;
                    if (node instanceof Elem) {
                        bl = true;
                        elem = (Elem)node;
                        if (elem.child().isEmpty()) {
                            return Text$.MODULE$.apply(elem.text());
                        }
                    }
                    if (bl) {
                        return Text$.MODULE$.apply(NodeSeq$.MODULE$.seqToNodeSeq((Seq)elem.child().flatMap((Function1 & Serializable)n -> this.transform((Node)n))).text());
                    }
                    return n2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$transform$1(org.apache.spark.ui.UIUtils$$anon$1 scala.xml.Node )}, serializedLambda);
                }
            } : new RewriteRule(basePathUri){
                private final String basePathUri$1;

                public scala.collection.immutable.Seq<Node> transform(Node n) {
                    Elem elem;
                    Node node = n;
                    if (node instanceof Elem && (elem = (Elem)node).$bslash("@href").nonEmpty()) {
                        String relativePath = ((Seq)elem.attribute("href").get()).toString();
                        String fullUri = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.basePathUri$1), "/") + "/" + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(relativePath), "/");
                        return elem.$percent((MetaData)Attribute$.MODULE$.apply(null, "href", fullUri, (MetaData)Null$.MODULE$));
                    }
                    return n;
                }
                {
                    this.basePathUri$1 = basePathUri$1;
                }
            };
            text = NodeSeq$.MODULE$.seqToNodeSeq(new RuleTransformer((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RewriteRule[]{rule})).transform((Node)xml));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                if (plainText) {
                    text = Text$.MODULE$.apply(desc);
                } else {
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", (Seq)new Text("description-input"), (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)desc);
                    Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
                    text = elem;
                }
            }
            throw throwable;
        }
        return text;
    }

    public boolean makeDescription$default$3() {
        return false;
    }

    public String decodeURLParameter(String urlParam) {
        String param = urlParam;
        String decodedParam = URLDecoder.decode(param, StandardCharsets.UTF_8.name());
        while (true) {
            String string = param;
            String string2 = decodedParam;
            if (!(string == null ? string2 != null : !string.equals(string2))) break;
            param = decodedParam;
            decodedParam = URLDecoder.decode(param, StandardCharsets.UTF_8.name());
        }
        return param;
    }

    public MultivaluedStringMap decodeURLParameter(MultivaluedMap<String, String> params) {
        MultivaluedStringMap decodedParameters = new MultivaluedStringMap();
        params.forEach((encodeKey, encodeValues) -> {
            String decodeKey = MODULE$.decodeURLParameter((String)encodeKey);
            LinkedList decodeValues = new LinkedList();
            encodeValues.forEach(v -> decodeValues.add(MODULE$.decodeURLParameter((String)v)));
            decodedParameters.addAll((Object)decodeKey, decodeValues);
        });
        return decodedParameters;
    }

    public int getTimeZoneOffset() {
        return TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000 / 60;
    }

    public String makeHref(boolean proxy, String id, String origHref) {
        if (proxy) {
            String proxyPrefix = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"spark.ui.proxyBase", (Function0 & Serializable)() -> "");
            return proxyPrefix + "/proxy/" + id;
        }
        return origHref;
    }

    public Response buildErrorResponse(Response.Status status, String msg) {
        return Response.status((Response.Status)status).entity((Object)msg).type("text/plain").build();
    }

    public Tuple2<Object, scala.collection.immutable.Map<String, Object>>[] durationDataPadding(Tuple2<Object, Map<String, Long>>[] values) {
        Set operationLabels = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])values), (Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.SetHasAsScala(((Map)x$10._2()).keySet()).asScala(), ClassTag$.MODULE$.apply(String.class))).toSet();
        return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])values), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long xValue = tuple2._1$mcJ$sp();
                Map yValue = (Map)tuple2._2();
                Set dataPadding = (Set)operationLabels.map((Function1 & Serializable)opLabel -> {
                    if (yValue.containsKey(opLabel)) {
                        return new Tuple2(opLabel, (Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Long2long((Long)yValue.get(opLabel))));
                    }
                    return new Tuple2(opLabel, (Object)BoxesRunTime.boxToDouble((double)0.0));
                });
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)xValue), (Object)dataPadding.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public scala.collection.immutable.Seq<Node> detailsUINode(boolean isMultiline, String message) {
        if (isMultiline) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("expand-details"), (MetaData)$md);
            $md = new UnprefixedAttribute("onclick", (Seq)new Text("this.parentNode.querySelector('.stacktrace-details').classList.toggle('collapsed')"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        +details\n      "));
            Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("stacktrace-details collapsed"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)message);
            $buf2.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n        "));
            return elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        }
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
    }

    private final Regex ERROR_CLASS_REGEX() {
        return ERROR_CLASS_REGEX;
    }

    public Tuple2<String, Object> errorSummary(String errorMessage) {
        String string;
        boolean isMultiline = true;
        Option maybeErrorClass = this.ERROR_CLASS_REGEX().findFirstMatchIn((CharSequence)errorMessage).map((Function1 & Serializable)x$11 -> x$11.group("errorClass"));
        if (maybeErrorClass.nonEmpty() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)maybeErrorClass.get()))) {
            string = (String)maybeErrorClass.get();
        } else if (errorMessage.indexOf(10) >= 0) {
            string = errorMessage.substring(0, errorMessage.indexOf(10));
        } else if (errorMessage.indexOf(":") >= 0) {
            string = errorMessage.substring(0, errorMessage.indexOf(":"));
        } else {
            isMultiline = false;
            string = errorMessage;
        }
        String errorClassOrBrief = string;
        return new Tuple2((Object)errorClassOrBrief, (Object)BoxesRunTime.boxToBoolean((boolean)isMultiline));
    }

    public scala.collection.immutable.Seq<Node> errorMessageCell(String errorMessage) {
        Tuple2<String, Object> tuple2 = this.errorSummary(errorMessage);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String summary = (String)tuple2._1();
        boolean isMultiline = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)summary, (Object)BoxesRunTime.boxToBoolean((boolean)isMultiline));
        String summary2 = (String)tuple22._1();
        boolean isMultiline2 = tuple22._2$mcZ$sp();
        scala.collection.immutable.Seq<Node> details = this.detailsUINode(isMultiline2, errorMessage);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)summary2);
        $buf.$amp$plus(details);
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public String formatImportJavaScript(HttpServletRequest request, String sourceFile, scala.collection.immutable.Seq<String> methods) {
        String methodsStr = methods.mkString("{", ", ", "}");
        String sourceFileStr = this.prependBaseUri(request, sourceFile, this.prependBaseUri$default$3());
        return "import " + methodsStr + " from \"" + sourceFileStr + "\";";
    }

    private static final String toString$1(long num, String unit) {
        if (num == 0L) {
            return "";
        }
        if (num == 1L) {
            return num + " " + unit;
        }
        return num + " " + unit + "s";
    }

    public static final /* synthetic */ void $anonfun$formatDurationVerbose$1(long ms$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long durationLimit = tuple2._1$mcJ$sp();
            String durationString = (String)tuple2._2();
            if (ms$1 < durationLimit) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)durationString);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String getClass$1(int index, scala.collection.immutable.Seq headerClasses$1) {
        if (index < headerClasses$1.size()) {
            return (String)headerClasses$1.apply(index);
        }
        return "";
    }

    private static final Option getTooltip$1(int index, scala.collection.immutable.Seq tooltipHeaders$1) {
        if (index < tooltipHeaders$1.size()) {
            return (Option)tooltipHeaders$1.apply(index);
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private static final scala.collection.immutable.Seq getHeaderContent$1(String header, boolean newlinesInHeader$1) {
        if (newlinesInHeader$1) {
            void var3_3;
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])header.split("\n")), (Function1 & Serializable)t -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text(" "));
                $buf.$amp$plus(t);
                $buf.$amp$plus((Object)new Text(" "));
                return new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }, ClassTag$.MODULE$.apply(Elem.class)));
            $buf.$amp$plus((Object)new Text("\n        "));
            return new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
        }
        return Text$.MODULE$.apply(header);
    }

    public static final /* synthetic */ Node $anonfun$listingTable$3(String colWidthAttr$1, scala.collection.immutable.Seq tooltipHeaders$1, scala.collection.immutable.Seq headerClasses$1, boolean newlinesInHeader$1, Tuple2 x) {
        Option option = UIUtils$.getTooltip$1(x._2$mcI$sp(), tooltipHeaders$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            String tooltip = (String)some.value();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", UIUtils$.getClass$1(x._2$mcI$sp(), headerClasses$1), (MetaData)$md);
            $md = new UnprefixedAttribute("width", colWidthAttr$1, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n              "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("title", tooltip, (MetaData)$md2);
            $md2 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n                "));
            $buf2.$amp$plus((Object)UIUtils$.getHeaderContent$1((String)x._1(), newlinesInHeader$1));
            $buf2.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "th", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }
        if (None$.MODULE$.equals(option)) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", UIUtils$.getClass$1(x._2$mcI$sp(), headerClasses$1), (MetaData)$md);
            $md = new UnprefixedAttribute("width", colWidthAttr$1, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)UIUtils$.getHeaderContent$1((String)x._1(), newlinesInHeader$1));
            return new Elem(null, "th", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ int $anonfun$makeProgressBar$1(Tuple2 x$4) {
        return -x$4._2$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$makeDescription$1(Set allowedNodeLabels$1, Set allowedAttributes$1, Node node) {
        return allowedNodeLabels$1.contains((Object)node.label()) && ((IterableOnceOps)node.attributes().map((Function1 & Serializable)x$5 -> x$5.key())).forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)allowedAttributes$1.contains((Object)elem)));
    }

    public static final /* synthetic */ boolean $anonfun$makeDescription$6(MetaData x$7) {
        String string = x$7.key();
        String string2 = "href";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeDescription$8(String x$9) {
        return !x$9.startsWith("/");
    }

    private UIUtils$() {
    }
}

