/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005=d!B\u0010!\u0001\tB\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000bm\u0002A\u0011\u0001\u001f\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\"1Q\t\u0001Q\u0001\n\tCqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003H\u0011\u0019i\u0005\u0001)A\u0005\u0011\"9a\n\u0001b\u0001\n\u0013y\u0005B\u0002-\u0001A\u0003%\u0001\u000bC\u0004Z\u0001\t\u0007I\u0011\u0002.\t\ry\u0003\u0001\u0015!\u0003\\\u0011\u001dy\u0006\u00011A\u0005\n\u001dCq\u0001\u0019\u0001A\u0002\u0013%\u0011\r\u0003\u0004h\u0001\u0001\u0006K\u0001\u0013\u0005\bQ\u0002\u0001\r\u0011\"\u0003H\u0011\u001dI\u0007\u00011A\u0005\n)Da\u0001\u001c\u0001!B\u0013A\u0005bB7\u0001\u0001\u0004%IA\u001c\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0011\u0019A\b\u0001)Q\u0005_\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bbBA\u0004\u0001\u0001\u0006Ia\u001f\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017A\u0001\"!\b\u0001A\u0003%\u0011Q\u0002\u0005\b\u0003[\u0001A\u0011BA\u0018\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u001b\u0001\t\u0013\ty\u0003C\u0004\u0002l\u0001!\t!a\f\t\u000f\u00055\u0004\u0001\"\u0001\u00020\t\u00112i\u001c8t_2,\u0007K]8he\u0016\u001c8OQ1s\u0015\t\t#%\u0001\u0002vS*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xmE\u0002\u0001S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a#\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001b2\u0005\u001daunZ4j]\u001e\f!a]2\u0004\u0001A\u0011\u0001(O\u0007\u0002E%\u0011!H\t\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uz\u0004C\u0001 \u0001\u001b\u0005\u0001\u0003\"B\u001b\u0003\u0001\u00049\u0014AA\"S+\u0005\u0011\u0005C\u0001\u0016D\u0013\t!5F\u0001\u0003DQ\u0006\u0014\u0018aA\"SA\u0005\u0001R\u000f\u001d3bi\u0016\u0004VM]5pI6\u001bVmY\u000b\u0002\u0011B\u0011!&S\u0005\u0003\u0015.\u0012A\u0001T8oO\u0006\tR\u000f\u001d3bi\u0016\u0004VM]5pI6\u001bVm\u0019\u0011\u0002\u001d\u0019L'o\u001d;EK2\f\u00170T*fG\u0006ya-\u001b:ti\u0012+G.Y=N'\u0016\u001c\u0007%A\u0004d_:\u001cx\u000e\\3\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0005%|'\"A+\u0002\t)\fg/Y\u0005\u0003/J\u00131\u0002\u0015:j]R\u001cFO]3b[\u0006A1m\u001c8t_2,\u0007%A\u0007UKJl\u0017N\\1m/&$G\u000f[\u000b\u00027B\u0011!\u0006X\u0005\u0003;.\u00121!\u00138u\u00039!VM]7j]\u0006dw+\u001b3uQ\u0002\na\u0002\\1ti\u001aKg.[:i)&lW-\u0001\nmCN$h)\u001b8jg\"$\u0016.\\3`I\u0015\fHC\u00012f!\tQ3-\u0003\u0002eW\t!QK\\5u\u0011\u001d1g\"!AA\u0002!\u000b1\u0001\u001f\u00132\u0003=a\u0017m\u001d;GS:L7\u000f\u001b+j[\u0016\u0004\u0013A\u00047bgR,\u0006\u000fZ1uKRKW.Z\u0001\u0013Y\u0006\u001cH/\u00169eCR,G+[7f?\u0012*\u0017\u000f\u0006\u0002cW\"9a-EA\u0001\u0002\u0004A\u0015a\u00047bgR,\u0006\u000fZ1uKRKW.\u001a\u0011\u0002\u001f1\f7\u000f\u001e)s_\u001e\u0014Xm]:CCJ,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003eR\u000bA\u0001\\1oO&\u0011A/\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002'1\f7\u000f\u001e)s_\u001e\u0014Xm]:CCJ|F%Z9\u0015\u0005\t<\bb\u00024\u0015\u0003\u0003\u0005\ra\\\u0001\u0011Y\u0006\u001cH\u000f\u0015:pOJ,7o\u001d\"be\u0002\nQ\u0001^5nKJ,\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018AC2p]\u000e,(O]3oi*\u0019\u0011\u0011\u0001+\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u000bi(\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u00061A/[7fe\u0002\n1\u0002^5nKJ4U\u000f^;sKV\u0011\u0011Q\u0002\u0019\u0005\u0003\u001f\tI\u0002E\u0003}\u0003#\t)\"C\u0002\u0002\u0014u\u0014qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0005\u0003/\tI\u0002\u0004\u0001\u0005\u0017\u0005m\u0011$!A\u0001\u0002\u000b\u0005\u0011q\u0004\u0002\u0003\u007fA\nA\u0002^5nKJ4U\u000f^;sK\u0002\nB!!\t\u0002(A\u0019!&a\t\n\u0007\u0005\u00152FA\u0004O_RD\u0017N\\4\u0011\u0007A\fI#C\u0002\u0002,E\u0014aa\u00142kK\u000e$\u0018a\u0002:fMJ,7\u000f\u001b\u000b\u0002E\u0006!1\u000f[8x)\u0015\u0011\u0017QGA\u001d\u0011\u0019\t9d\u0007a\u0001\u0011\u0006\u0019an\\<\t\u000f\u0005m2\u00041\u0001\u0002>\u000511\u000f^1hKN\u0004b!a\u0010\u0002P\u0005Uc\u0002BA!\u0003\u0017rA!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f2\u0014A\u0002\u001fs_>$h(C\u0001-\u0013\r\tieK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t&a\u0015\u0003\u0007M+\u0017OC\u0002\u0002N-\u0002B!a\u0016\u0002f5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0002wc)!\u0011qLA1\u0003\r\t\u0007/\u001b\u0006\u0004\u0003G\u0012\u0013AB:uCR,8/\u0003\u0003\u0002h\u0005e#!C*uC\u001e,G)\u0019;b\u0003\u0015\u0019G.Z1s\u0003%1\u0017N\\5tQ\u0006cG.\u0001\u0003ti>\u0004\b")
public class ConsoleProgressBar
implements Logging {
    private final SparkContext sc;
    private final char CR;
    private final long updatePeriodMSec;
    private final long firstDelayMSec;
    private final PrintStream console;
    private final int TerminalWidth;
    private long lastFinishTime;
    private long lastUpdateTime;
    private String lastProgressBar;
    private final ScheduledExecutorService timer;
    private final ScheduledFuture<?> timerFuture;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private char CR() {
        return this.CR;
    }

    private long updatePeriodMSec() {
        return this.updatePeriodMSec;
    }

    private long firstDelayMSec() {
        return this.firstDelayMSec;
    }

    private PrintStream console() {
        return this.console;
    }

    private int TerminalWidth() {
        return this.TerminalWidth;
    }

    private long lastFinishTime() {
        return this.lastFinishTime;
    }

    private void lastFinishTime_$eq(long x$1) {
        this.lastFinishTime = x$1;
    }

    private long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    private void lastUpdateTime_$eq(long x$1) {
        this.lastUpdateTime = x$1;
    }

    private String lastProgressBar() {
        return this.lastProgressBar;
    }

    private void lastProgressBar_$eq(String x$1) {
        this.lastProgressBar = x$1;
    }

    private ScheduledExecutorService timer() {
        return this.timer;
    }

    private ScheduledFuture<?> timerFuture() {
        return this.timerFuture;
    }

    private synchronized void refresh() {
        long now = System.currentTimeMillis();
        if (now - this.lastFinishTime() < this.firstDelayMSec()) {
            return;
        }
        Seq stages = (Seq)this.sc.statusStore().activeStages().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConsoleProgressBar.$anonfun$refresh$1(this, now, s)));
        if (stages.length() > 0) {
            this.show(now, (Seq<StageData>)((Seq)stages.take(3)));
            return;
        }
    }

    private void show(long now, Seq<StageData> stages) {
        String bar;
        int width = this.TerminalWidth() / stages.length();
        String string = bar = ((IterableOnceOps)stages.map((Function1 & Serializable)s -> {
            String string;
            int total = s.numTasks();
            String header = "[Stage " + s.stageId() + ":";
            String tailer = "(" + s.numCompleteTasks() + " + " + s.numActiveTasks() + ") / " + total + "]";
            int w = width - header.length() - tailer.length();
            if (w > 0) {
                int percent = w * s.numCompleteTasks() / total;
                string = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), w).map((Function1 & Serializable)i -> ConsoleProgressBar.$anonfun$show$2(percent, BoxesRunTime.unboxToInt((Object)i))).mkString("");
            } else {
                string = "";
            }
            String bar = string;
            return header + bar + tailer;
        })).mkString("");
        String string2 = this.lastProgressBar();
        if ((string != null ? !string.equals(string2) : string2 != null) || now - this.lastUpdateTime() > 60000L) {
            this.console().print(this.CR() + bar + this.CR());
            this.lastUpdateTime_$eq(now);
        }
        this.lastProgressBar_$eq(bar);
    }

    private void clear() {
        if (!this.lastProgressBar().isEmpty()) {
            this.console().printf(this.CR() + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), this.TerminalWidth()) + this.CR(), new Object[0]);
            this.lastProgressBar_$eq("");
            return;
        }
    }

    public synchronized void finishAll() {
        this.clear();
        this.lastFinishTime_$eq(System.currentTimeMillis());
    }

    public void stop() {
        this.timerFuture().cancel(false);
        ThreadUtils$.MODULE$.shutdown(this.timer(), ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$refresh$1(ConsoleProgressBar $this, long now$1, StageData s) {
        return now$1 - ((Date)s.submissionTime().get()).getTime() > $this.firstDelayMSec();
    }

    public static final /* synthetic */ String $anonfun$show$2(int percent$1, int i) {
        if (i < percent$1) {
            return "=";
        }
        if (i == percent$1) {
            return ">";
        }
        return " ";
    }

    public ConsoleProgressBar(SparkContext sc) {
        this.sc = sc;
        Logging.$init$((Logging)this);
        this.CR = (char)13;
        this.updatePeriodMSec = BoxesRunTime.unboxToLong((Object)sc.conf().get(UI$.MODULE$.UI_CONSOLE_PROGRESS_UPDATE_INTERVAL()));
        this.firstDelayMSec = 500L;
        this.console = System.err;
        this.TerminalWidth = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"COLUMNS", (Function0 & Serializable)() -> "80")));
        this.lastFinishTime = 0L;
        this.lastUpdateTime = 0L;
        this.lastProgressBar = "";
        this.timer = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("refresh progress");
        this.timerFuture = this.timer().scheduleAtFixedRate(() -> this.refresh(), this.firstDelayMSec(), this.updatePeriodMSec(), TimeUnit.MILLISECONDS);
    }
}

