/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.checksum;

import java.util.zip.Checksum;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.shuffle.checksum.ShuffleChecksumHelper;

public interface ShuffleChecksumSupport {
    default public Checksum[] createPartitionChecksums(int numPartitions, SparkConf conf) {
        if (((Boolean)conf.get(package$.MODULE$.SHUFFLE_CHECKSUM_ENABLED())).booleanValue()) {
            String checksumAlgorithm = conf.get(package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM());
            return ShuffleChecksumHelper.createPartitionChecksums((int)numPartitions, (String)checksumAlgorithm);
        }
        return ShuffleChecksumHelper.EMPTY_CHECKSUM;
    }

    default public long[] getChecksumValues(Checksum[] partitionChecksums) {
        int numPartitions = partitionChecksums.length;
        long[] checksumValues = new long[numPartitions];
        for (int i = 0; i < numPartitions; ++i) {
            checksumValues[i] = partitionChecksums[i].getValue();
        }
        return checksumValues;
    }
}

