/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.executor.ConstructorCleaner;
import org.apache.spark.executor.RemoteClassLoaderError;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.ParentClassLoader;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;
import org.apache.xbean.asm9.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\u000e\u001d\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0005A!A!\u0002\u0013i\u0005\"B)\u0001\t\u0003\u0011\u0006b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007E\u0002\u0001\u000b\u0011\u0002/\t\u000f\r\u0004!\u0019!C\u0001I\"1q\r\u0001Q\u0001\n\u0015Dq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004q\u0001\u0001\u0006IA\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u0019a\b\u0001)A\u0005g\")Q\u0010\u0001C!}\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t)\u0003\u0001C!\u0003OA\u0011\"!\u0013\u0001\u0005\u0004%I!a\u0013\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u001bBq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0002\u0014\u000bb,7-\u001e;pe\u000ec\u0017m]:M_\u0006$WM\u001d\u0006\u0003;y\t\u0001\"\u001a=fGV$xN\u001d\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011c\u0001\u0001']A\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0005Y\u0006twMC\u0001,\u0003\u0011Q\u0017M^1\n\u00055B#aC\"mCN\u001cHj\\1eKJ\u0004\"a\f\u001a\u000e\u0003AR!!\r\u0010\u0002\u0011%tG/\u001a:oC2L!a\r\u0019\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g!\t1t'D\u0001\u001f\u0013\tAdDA\u0005Ta\u0006\u00148nQ8oM\u0006\u0019QM\u001c<\u0011\u0005YZ\u0014B\u0001\u001f\u001f\u0005!\u0019\u0006/\u0019:l\u000b:4\u0018\u0001C2mCN\u001cXK]5\u0011\u0005}BeB\u0001!G!\t\tE)D\u0001C\u0015\t\u0019E%\u0001\u0004=e>|GO\u0010\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\tR\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H\t\u00061\u0001/\u0019:f]R\f!#^:fe\u000ec\u0017m]:QCRDg)\u001b:tiB\u0011ajT\u0007\u0002\t&\u0011\u0001\u000b\u0012\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q11+\u0016,X1f\u0003\"\u0001\u0016\u0001\u000e\u0003qAQ\u0001\u000e\u0004A\u0002UBQ!\u000f\u0004A\u0002iBQ!\u0010\u0004A\u0002yBQa\u0013\u0004A\u0002\u0019BQ\u0001\u0014\u0004A\u00025\u000b1!\u001e:j+\u0005a\u0006CA/a\u001b\u0005q&BA0+\u0003\rqW\r^\u0005\u0003Cz\u00131!\u0016*J\u0003\u0011)(/\u001b\u0011\u0002\u0013\u0011L'/Z2u_JLX#A3\u0011\u0005\u001d2\u0017BA%)\u0003)!\u0017N]3di>\u0014\u0018\u0010I\u0001\ra\u0006\u0014XM\u001c;M_\u0006$WM]\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011QNH\u0001\u0005kRLG.\u0003\u0002pY\n\t\u0002+\u0019:f]R\u001cE.Y:t\u0019>\fG-\u001a:\u0002\u001bA\f'/\u001a8u\u0019>\fG-\u001a:!\u0003\u001d1W\r^2i\r:,\u0012a\u001d\t\u0005\u001dRtd/\u0003\u0002v\t\nIa)\u001e8di&|g.\r\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s*\n!![8\n\u0005mD(aC%oaV$8\u000b\u001e:fC6\f\u0001BZ3uG\"4e\u000eI\u0001\fO\u0016$(+Z:pkJ\u001cW\rF\u0002\u0000\u0003\u000b\u00012!XA\u0001\u0013\r\t\u0019A\u0018\u0002\u0004+Jc\u0005BBA\u0004\u001f\u0001\u0007a(\u0001\u0003oC6,\u0017\u0001D4fiJ+7o\\;sG\u0016\u001cH\u0003BA\u0007\u0003/\u0001R!a\u0004\u0002\u0014}l!!!\u0005\u000b\u00055T\u0013\u0002BA\u000b\u0003#\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\"1\u0011q\u0001\tA\u0002y\n1cZ3u%\u0016\u001cx.\u001e:dK\u0006\u001b8\u000b\u001e:fC6$2A^A\u000f\u0011\u0019\t9!\u0005a\u0001}\u0005yr-\u001a;DY\u0006\u001c8OU3t_V\u00148-Z!t'R\u0014X-Y7M_\u000e\fG\u000e\\=\u0015\u0007Y\f\u0019\u0003\u0003\u0004\u0002\bI\u0001\rAP\u0001\nM&tGm\u00117bgN$B!!\u000b\u0002HA\"\u00111FA\u001b!\u0015y\u0014QFA\u0019\u0013\r\tyC\u0013\u0002\u0006\u00072\f7o\u001d\t\u0005\u0003g\t)\u0004\u0004\u0001\u0005\u0017\u0005]2#!A\u0001\u0002\u000b\u0005\u0011\u0011\b\u0002\u0004?\u0012\n\u0014\u0003BA\u001e\u0003\u0003\u00022ATA\u001f\u0013\r\ty\u0004\u0012\u0002\b\u001d>$\b.\u001b8h!\rq\u00151I\u0005\u0004\u0003\u000b\"%aA!os\"1\u0011qA\nA\u0002y\nac\u0015+S\u000b\u0006kuLT(U?\u001a{UK\u0014#`%\u0016;U\tW\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n\t\"A\u0003sK\u001e,\u00070\u0003\u0003\u0002X\u0005E#a\u0002)biR,'O\\\u0001\u0018'R\u0013V)Q'`\u001d>#vLR(V\u001d\u0012{&+R$F1\u0002\n1eZ3u\u00072\f7o\u001d$jY\u0016Le\u000e];u'R\u0014X-Y7Ge>l7\u000b]1sWJ\u00036\tF\u0002w\u0003?Ba!!\u0019\u0017\u0001\u0004q\u0014\u0001\u00029bi\"\fQeZ3u\u00072\f7o\u001d$jY\u0016Le\u000e];u'R\u0014X-Y7Ge>lg)\u001b7f'f\u001cH/Z7\u0015\t\u0005\u001d\u0014Q\u000e\u000b\u0004m\u0006%\u0004BBA6/\u0001\u0007a(A\bqCRD\u0017J\u001c#je\u0016\u001cGo\u001c:z\u0011\u001d\tyg\u0006a\u0001\u0003c\n!BZ5mKNK8\u000f^3n!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\n!AZ:\u000b\u0007\u0005m\u0004%\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003\u007f\n)H\u0001\u0006GS2,7+_:uK6\f\u0001CZ5oI\u000ec\u0017m]:M_\u000e\fG\u000e\\=\u0015\t\u0005\u0015\u0015Q\u0013\t\u0006\u001d\u0006\u001d\u00151R\u0005\u0004\u0003\u0013#%AB(qi&|g\u000e\r\u0003\u0002\u000e\u0006E\u0005#B \u0002.\u0005=\u0005\u0003BA\u001a\u0003##1\"a%\u0019\u0003\u0003\u0005\tQ!\u0001\u0002:\t\u0019q\f\n\u001a\t\r\u0005\u001d\u0001\u00041\u0001?\u0003U\u0011X-\u00193B]\u0012$&/\u00198tM>\u0014Xn\u00117bgN$b!a'\u0002(\u0006%\u0006#\u0002(\u0002\u001e\u0006\u0005\u0016bAAP\t\n)\u0011I\u001d:bsB\u0019a*a)\n\u0007\u0005\u0015FI\u0001\u0003CsR,\u0007BBA\u00043\u0001\u0007a\b\u0003\u0004\u0002,f\u0001\rA^\u0001\u0003S:\f\u0011\"\u001e:m\u000b:\u001cw\u000eZ3\u0015\u0007y\n\t\f\u0003\u0004\u00024j\u0001\rAP\u0001\u0004gR\u0014\b")
public class ExecutorClassLoader
extends ClassLoader
implements Logging {
    private final SparkEnv env;
    private final String classUri;
    private final boolean userClassPathFirst;
    private final URI uri;
    private final String directory;
    private final ParentClassLoader parentLoader;
    private final Function1<String, InputStream> fetchFn;
    private final Pattern org$apache$spark$executor$ExecutorClassLoader$$STREAM_NOT_FOUND_REGEX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public URI uri() {
        return this.uri;
    }

    public String directory() {
        return this.directory;
    }

    public ParentClassLoader parentLoader() {
        return this.parentLoader;
    }

    private Function1<String, InputStream> fetchFn() {
        return this.fetchFn;
    }

    @Override
    public URL getResource(String name) {
        return this.parentLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.parentLoader().getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.userClassPathFirst) {
            InputStream res = this.getClassResourceAsStreamLocally(name);
            if (res != null) {
                return res;
            }
            return this.parentLoader().getResourceAsStream(name);
        }
        InputStream res = this.parentLoader().getResourceAsStream(name);
        if (res != null) {
            return res;
        }
        return this.getClassResourceAsStreamLocally(name);
    }

    private InputStream getClassResourceAsStreamLocally(String name) {
        InputStream inputStream;
        block3: {
            try {
                if (name.endsWith(".class")) {
                    inputStream = (InputStream)this.fetchFn().apply((Object)name);
                    break block3;
                }
                inputStream = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                inputStream = null;
            }
        }
        return inputStream;
    }

    @Override
    public Class<?> findClass(String name) {
        Class clazz;
        if (this.userClassPathFirst) {
            return (Class)this.findClassLocally(name).getOrElse((Function0 & Serializable)() -> this.parentLoader().loadClass(name));
        }
        try {
            clazz = this.parentLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            Option<Class<?>> classOption;
            Option<Class<?>> option;
            try {
                option = this.findClassLocally(name);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 instanceof RemoteClassLoaderError) {
                    RemoteClassLoaderError remoteClassLoaderError = (RemoteClassLoaderError)throwable3;
                    throw remoteClassLoaderError;
                }
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw new RemoteClassLoaderError(name, throwable2);
                }
                throw throwable;
            }
            Option<Class<?>> option2 = classOption = option;
            if (None$.MODULE$.equals(option2)) {
                throw new ClassNotFoundException(name, e);
            }
            if (option2 instanceof Some) {
                Class a;
                Some some = (Some)option2;
                clazz = a = (Class)some.value();
            }
            throw new MatchError(option2);
        }
        return clazz;
    }

    public Pattern org$apache$spark$executor$ExecutorClassLoader$$STREAM_NOT_FOUND_REGEX() {
        return this.org$apache$spark$executor$ExecutorClassLoader$$STREAM_NOT_FOUND_REGEX;
    }

    private InputStream getClassFileInputStreamFromSparkRPC(String path) {
        ReadableByteChannel channel = this.env.rpcEnv().openChannel(this.classUri + "/" + this.urlEncode(path));
        return new FilterInputStream(this, channel, path){
            private final /* synthetic */ ExecutorClassLoader $outer;
            private final String path$1;

            private /* synthetic */ int super$read() {
                return super.read();
            }

            private /* synthetic */ int super$read(byte[] x$1, int x$2, int x$3) {
                return super.read(x$1, x$2, x$3);
            }

            public int read() {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> this.super$read());
            }

            public int read(byte[] b, int offset, int len) {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> this.super$read(b, offset, len));
            }

            private int toClassNotFound(Function0<Object> fn) {
                int n;
                try {
                    n = fn.apply$mcI$sp();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    RuntimeException runtimeException;
                    Throwable throwable3 = throwable;
                    if (throwable3 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable3).getMessage() != null && this.$outer.org$apache$spark$executor$ExecutorClassLoader$$STREAM_NOT_FOUND_REGEX().matcher(runtimeException.getMessage()).matches()) {
                        throw new ClassNotFoundException(this.path$1, runtimeException);
                    }
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        throw new RemoteClassLoaderError(this.path$1, throwable2);
                    }
                    throw throwable;
                }
                return n;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$1 = path$1;
                super(Channels.newInputStream(channel$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(org.apache.spark.executor.ExecutorClassLoader$$anon$1 ), $anonfun$read$2(org.apache.spark.executor.ExecutorClassLoader$$anon$1 byte[] int int )}, serializedLambda);
            }
        };
    }

    private InputStream getClassFileInputStreamFromFileSystem(FileSystem fileSystem, String pathInDirectory) {
        FSDataInputStream fSDataInputStream;
        Path path = new Path(this.directory(), pathInDirectory);
        try {
            fSDataInputStream = fileSystem.open(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassNotFoundException("Class file not found at path " + path);
        }
        return fSDataInputStream;
    }

    public Option<Class<?>> findClassLocally(String name) {
        None$ none$;
        block12: {
            None$ none$2;
            InputStream inputStream;
            block11: {
                String pathInDirectory = name.replace('.', '/') + ".class";
                inputStream = null;
                try {
                    try {
                        inputStream = (InputStream)this.fetchFn().apply((Object)pathInDirectory);
                        byte[] bytes = this.readAndTransformClass(name, inputStream);
                        none$2 = new Some(this.defineClass(name, bytes, 0, bytes.length));
                    }
                    catch (ClassNotFoundException e) {
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Did not load class " + name + " from REPL class server at " + this.uri(), (Throwable)e);
                        none$2 = None$.MODULE$;
                    }
                    catch (Exception e) {
                        this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check existence of class ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)name)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"on REPL class server at ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URI$.MODULE$, (Object)this.uri())})))), (Throwable)e);
                        if (this.userClassPathFirst) {
                            none$2 = None$.MODULE$;
                            break block11;
                        }
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {
                            this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception while closing inputStream", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
            }
            none$ = none$2;
            if (inputStream == null) break block12;
            try {
                inputStream.close();
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception while closing inputStream", (Throwable)e);
            }
        }
        return none$;
    }

    public byte[] readAndTransformClass(String name, InputStream in) {
        if (name.startsWith("line") && name.endsWith("$iw$")) {
            ClassReader cr = new ClassReader(in);
            ClassWriter cw = new ClassWriter(3);
            ConstructorCleaner cleaner = new ConstructorCleaner(name, (ClassVisitor)cw);
            cr.accept((ClassVisitor)cleaner, 0);
            return cw.toByteArray();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        boolean done = false;
        while (!done) {
            int num = in.read(bytes);
            if (num >= 0) {
                bos.write(bytes, 0, num);
                continue;
            }
            done = true;
        }
        return bos.toByteArray();
    }

    public String urlEncode(String str) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(str), '/')), (Function1 & Serializable)part -> URLEncoder.encode(part, StandardCharsets.UTF_8.name()), ClassTag$.MODULE$.apply(String.class))).mkString("/");
    }

    public ExecutorClassLoader(SparkConf conf, SparkEnv env, String classUri, ClassLoader parent, boolean userClassPathFirst) {
        Function1 & Serializable intersect;
        block3: {
            this.env = env;
            this.classUri = classUri;
            this.userClassPathFirst = userClassPathFirst;
            super(null);
            Logging.$init$((Logging)this);
            this.uri = new URI(classUri);
            this.directory = this.uri().getPath();
            this.parentLoader = new ParentClassLoader(parent);
            String string = this.uri().getScheme();
            switch (string == null ? 0 : string.hashCode()) {
                case 109638365: {
                    if (!"spark".equals(string)) break;
                    intersect = (Function1 & Serializable)path -> this.getClassFileInputStreamFromSparkRPC((String)path);
                    break block3;
                }
            }
            FileSystem fileSystem = FileSystem.get((URI)this.uri(), (Configuration)SparkHadoopUtil$.MODULE$.get().newConfiguration(conf));
            intersect = (Function1 & Serializable)pathInDirectory -> this.getClassFileInputStreamFromFileSystem(fileSystem, (String)pathInDirectory);
        }
        this.fetchFn = intersect;
        this.org$apache$spark$executor$ExecutorClassLoader$$STREAM_NOT_FOUND_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Stream '.*' was not found.")).pattern();
    }
}

