/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkFiles$;
import org.apache.spark.api.python.EncryptedPythonBroadcastServer;
import org.apache.spark.api.python.PythonBroadcast;
import org.apache.spark.api.python.PythonFunction;
import org.apache.spark.api.python.PythonRDD$;
import org.apache.spark.api.python.PythonWorker;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.CollectionAccumulator;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class PythonWorkerUtils$
implements Logging {
    public static final PythonWorkerUtils$ MODULE$ = new PythonWorkerUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void writeUTF(String str, DataOutputStream dataOut) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        this.writeBytes(bytes, dataOut);
    }

    public void writeBytes(byte[] bytes, DataOutputStream dataOut) {
        dataOut.writeInt(bytes.length);
        dataOut.write(bytes);
    }

    public void writePythonVersion(String pythonVer, DataOutputStream dataOut) {
        this.writeUTF(pythonVer, dataOut);
    }

    public void writeSparkFiles(Option<String> jobArtifactUUID, scala.collection.immutable.Set<String> pythonIncludes, DataOutputStream dataOut) {
        String root = (String)jobArtifactUUID.map((Function1 & Serializable)uuid -> new File(SparkFiles$.MODULE$.getRootDirectory(), (String)uuid).getAbsolutePath()).getOrElse((Function0 & Serializable)() -> SparkFiles$.MODULE$.getRootDirectory());
        this.writeUTF(root, dataOut);
        dataOut.writeInt(pythonIncludes.size());
        pythonIncludes.foreach((Function1 & Serializable)include -> {
            PythonWorkerUtils$.MODULE$.writeUTF(include, dataOut);
            return BoxedUnit.UNIT;
        });
    }

    public void writeBroadcasts(Seq<Broadcast<PythonBroadcast>> broadcastVars, PythonWorker worker, SparkEnv env, DataOutputStream dataOut) {
        scala.collection.mutable.Set<Object> oldBids = PythonRDD$.MODULE$.getWorkerBroadcasts(worker);
        scala.collection.immutable.Set newBids = ((IterableOnceOps)broadcastVars.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.id()))).toSet();
        scala.collection.mutable.Set toRemove = (scala.collection.mutable.Set)oldBids.diff((Set)newBids);
        scala.collection.immutable.Set addedBids = (scala.collection.immutable.Set)newBids.diff(oldBids);
        int cnt = toRemove.size() + addedBids.size();
        boolean needsDecryptionServer = env.serializerManager().encryptionEnabled() && addedBids.nonEmpty();
        dataOut.writeBoolean(needsDecryptionServer);
        dataOut.writeInt(cnt);
        if (needsDecryptionServer) {
            Seq idsAndFiles = (Seq)broadcastVars.flatMap((Function1 & Serializable)broadcast -> {
                if (!oldBids.contains((Object)BoxesRunTime.boxToLong((long)broadcast.id()))) {
                    oldBids.add((Object)BoxesRunTime.boxToLong((long)broadcast.id()));
                    return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)broadcast.id()), (Object)((PythonBroadcast)broadcast.value()).path()));
                }
                return None$.MODULE$;
            });
            EncryptedPythonBroadcastServer server = new EncryptedPythonBroadcastServer(env, (Seq<Tuple2<Object, String>>)idsAndFiles);
            Object object = server.connInfo();
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                dataOut.writeInt(n);
                this.writeUTF(server.secret(), dataOut);
            } else if (object instanceof String) {
                String string = (String)object;
                dataOut.writeInt(-1);
                this.writeUTF(string, dataOut);
            } else {
                throw new MatchError(object);
            }
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "broadcast decryption server setup on " + server.connInfo());
            PythonWorkerUtils$.sendBidsToRemove$1(toRemove, dataOut, oldBids);
            idsAndFiles.foreach((Function1 & Serializable)x0$1 -> {
                PythonWorkerUtils$.$anonfun$writeBroadcasts$5(dataOut, x0$1);
                return BoxedUnit.UNIT;
            });
            dataOut.flush();
        } else {
            PythonWorkerUtils$.sendBidsToRemove$1(toRemove, dataOut, oldBids);
            broadcastVars.foreach((Function1 & Serializable)broadcast -> {
                if (!oldBids.contains((Object)BoxesRunTime.boxToLong((long)broadcast.id()))) {
                    dataOut.writeLong(broadcast.id());
                    MODULE$.writeUTF(((PythonBroadcast)broadcast.value()).path(), dataOut);
                    return BoxesRunTime.boxToBoolean((boolean)oldBids.add((Object)BoxesRunTime.boxToLong((long)broadcast.id())));
                }
                return BoxedUnit.UNIT;
            });
        }
        dataOut.flush();
    }

    public void writePythonFunction(PythonFunction func, DataOutputStream dataOut) {
        this.writeBytes((byte[])func.command().toArray((ClassTag)ClassTag$.MODULE$.Byte()), dataOut);
    }

    public String readUTF(DataInputStream dataIn) {
        return this.readUTF(dataIn.readInt(), dataIn);
    }

    public String readUTF(int length, DataInputStream dataIn) {
        return new String(this.readBytes(length, dataIn), StandardCharsets.UTF_8);
    }

    public byte[] readBytes(DataInputStream dataIn) {
        return this.readBytes(dataIn.readInt(), dataIn);
    }

    public byte[] readBytes(int length, DataInputStream dataIn) {
        if (length == 0) {
            return Array$.MODULE$.emptyByteArray();
        }
        byte[] obj = new byte[length];
        dataIn.readFully(obj);
        return obj;
    }

    public void receiveAccumulatorUpdates(Option<CollectionAccumulator<byte[]>> maybeAccumulator, DataInputStream dataIn) {
        int numAccumulatorUpdates = dataIn.readInt();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numAccumulatorUpdates).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            byte[] update = MODULE$.readBytes(dataIn);
            maybeAccumulator.foreach((Function1 & Serializable)x$3 -> {
                x$3.add(update);
                return BoxedUnit.UNIT;
            });
        });
    }

    private static final void sendBidsToRemove$1(scala.collection.mutable.Set toRemove$1, DataOutputStream dataOut$2, scala.collection.mutable.Set oldBids$1) {
        toRemove$1.foreach((Function1)(JFunction1.mcZJ.sp & Serializable)bid -> {
            dataOut$2.writeLong(-bid - 1L);
            return oldBids$1.remove((Object)BoxesRunTime.boxToLong((long)bid));
        });
    }

    public static final /* synthetic */ void $anonfun$writeBroadcasts$5(DataOutputStream dataOut$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long id = tuple2._1$mcJ$sp();
            dataOut$2.writeLong(id);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private PythonWorkerUtils$() {
    }
}

