/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClientImpl;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2AppStatusStore;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2EventManager;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener$;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class HiveThriftServer2$
implements Logging {
    public static final HiveThriftServer2$ MODULE$ = new HiveThriftServer2$();
    private static Option<ThriftServerTab> uiTab;
    private static HiveThriftServer2Listener listener;
    private static HiveThriftServer2EventManager eventManager;
    private static final AtomicBoolean systemExitOnError;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        uiTab = None$.MODULE$;
        systemExitOnError = new AtomicBoolean(true);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<ThriftServerTab> uiTab() {
        return uiTab;
    }

    public void uiTab_$eq(Option<ThriftServerTab> x$1) {
        uiTab = x$1;
    }

    public HiveThriftServer2Listener listener() {
        return listener;
    }

    public void listener_$eq(HiveThriftServer2Listener x$1) {
        listener = x$1;
    }

    public HiveThriftServer2EventManager eventManager() {
        return eventManager;
    }

    public void eventManager_$eq(HiveThriftServer2EventManager x$1) {
        eventManager = x$1;
    }

    public AtomicBoolean systemExitOnError() {
        return systemExitOnError;
    }

    @DeveloperApi
    public HiveThriftServer2 startWithSparkSession(SparkSession sparkSession, boolean exitOnError) {
        this.systemExitOnError().set(exitOnError);
        HiveClientImpl executionHive = HiveUtils$.MODULE$.newClientForExecution(sparkSession.sparkContext().conf(), sparkSession.sessionState().newHadoopConf());
        ServerUtils.cleanUpScratchDir((HiveConf)executionHive.conf());
        HiveThriftServer2 server = new HiveThriftServer2(sparkSession);
        server.init(executionHive.conf());
        server.start();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "HiveThriftServer2 started");
        this.createListenerAndUI(server, sparkSession.sparkContext());
        return server;
    }

    @DeveloperApi
    public HiveThriftServer2 startWithContext(SQLContext sqlContext) {
        return this.startWithSparkSession(sqlContext.sparkSession(), true);
    }

    private void createListenerAndUI(HiveThriftServer2 server, SparkContext sc) {
        ElementTrackingStore kvStore = (ElementTrackingStore)sc.statusStore().store();
        this.eventManager_$eq(new HiveThriftServer2EventManager(sc));
        this.listener_$eq(new HiveThriftServer2Listener(kvStore, sc.conf(), (Option<HiveServer2>)new Some((Object)server), HiveThriftServer2Listener$.MODULE$.$lessinit$greater$default$4()));
        sc.listenerBus().addToStatusQueue((SparkListenerInterface)this.listener());
        this.uiTab_$eq((Option<ThriftServerTab>)(BoxesRunTime.unboxToBoolean((Object)sc.getConf().get(UI$.MODULE$.UI_ENABLED())) ? new Some((Object)new ThriftServerTab(new HiveThriftServer2AppStatusStore((KVStore)kvStore), ThriftServerTab$.MODULE$.getSparkUI(sc))) : None$.MODULE$));
    }

    public void main(String[] args) {
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-h") || ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"--help")) {
            HiveServer2.main(args);
            return;
        }
        Utils$.MODULE$.initDaemon(this.log());
        HiveServer2.ServerOptionsProcessor optionsProcessor = new HiveServer2.ServerOptionsProcessor("HiveThriftServer2");
        optionsProcessor.parse(args);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Starting SparkContext");
        SparkSQLEnv$.MODULE$.init();
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSQLEnv$.MODULE$.stop(SparkSQLEnv$.MODULE$.stop$default$1());
            MODULE$.uiTab().foreach((Function1 & Serializable)x$3 -> {
                x$3.detach();
                return BoxedUnit.UNIT;
            });
        });
        try {
            this.startWithContext(SparkSQLEnv$.MODULE$.sparkSession().sqlContext());
            if (SparkSQLEnv$.MODULE$.sparkContext().stopped().get()) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "SparkContext has stopped even if HiveServer2 has started, so exit");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Error starting HiveThriftServer2", (Throwable)e);
            System.exit(-1);
        }
    }

    private HiveThriftServer2$() {
    }
}

