/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r-g\u0001\u0002\u001f>\t\"CQ\u0001\u001b\u0001\u0005\u0002%DQa\u001b\u0001\u0005B1DqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0018\u0001\u0001\u000b\u0011\u0002?\t\u0011\u0005e\u0001A1A\u0005\nmDq!a\u0007\u0001A\u0003%A\u0010\u0003\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003|\u0011\u001d\ty\u0002\u0001Q\u0001\nqDq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBA=\u0001\u0011\u0005\u00131\u0010\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\tY\n\u0001C!\u0003;Cq!a+\u0001\t\u0003\ni\u000bC\u0004\u00022\u0002!\t%a-\t\u0013\u0005u\u0006!%A\u0005\u0002\u0005}\u0006bBAk\u0001\u0011\u0005\u0013q\u001b\u0005\b\u0003g\u0004A\u0011IA{\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000bAqAa\u0004\u0001\t\u0003\u0012\t\u0002C\u0004\u0003T\u0001!\tE!\u0016\t\u000f\tm\u0003\u0001\"\u0011\u0003^!9!Q\u0010\u0001\u0005B\t}\u0004\"\u0003BC\u0001\t\u0007IQ\u0002BD\u0011!\u00119\n\u0001Q\u0001\u000e\t%\u0005b\u0002BM\u0001\u0011\u0005#1\u0014\u0004\u0007\u0005\u0007\u0004\u0001A!2\t\r!lB\u0011\u0001Bh\u0011\u001d\u0011\u0019.\bC!\u0005+DqAa8\u001e\t\u0003\u0012\t\u000fC\u0004\u0003p\u0002!\tE!=\t\u000f\t}\b\u0001\"\u0011\u0004\u0002!91Q\u0002\u0001\u0005B\r=\u0001bBB\t\u0001\u0011\u00053q\u0002\u0005\b\u0007'\u0001A\u0011IB\b\u0011\u001d\u0019)\u0002\u0001C!\u0007/Aqa!\u000b\u0001\t\u0003\u001aY\u0003C\u0004\u00046\u0001!\tea\u000e\t\u000f\rm\u0002\u0001\"\u0011\u0004>!91\u0011\n\u0001\u0005B\r-\u0003\u0002CB1\u0001\u0005\u0005I\u0011A5\t\u0013\r\r\u0004!!A\u0005B\r\u0015\u0004\"CB4\u0001\u0005\u0005I\u0011AB5\u0011%\u0019Y\u0007AA\u0001\n\u0003\u0019i\u0007C\u0005\u0004t\u0001\t\t\u0011\"\u0011\u0004v!I1q\u0010\u0001\u0002\u0002\u0013\u00051\u0011\u0011\u0005\n\u0007\u000b\u0003\u0011\u0011!C!\u0007\u000fC\u0011ba#\u0001\u0003\u0003%\te!$\t\u0013\r=\u0005!!A\u0005B\rE\u0005\"CBJ\u0001\u0005\u0005I\u0011IBK\u000f%\u0019I*PA\u0001\u0012\u0013\u0019YJ\u0002\u0005={\u0005\u0005\t\u0012BBO\u0011\u0019Ag\u0007\"\u0001\u00046\"I1q\u0012\u001c\u0002\u0002\u0013\u00153\u0011\u0013\u0005\t\u0007o3\u0014\u0011!CAS\"I1\u0011\u0018\u001c\u0002\u0002\u0013\u000551\u0018\u0005\n\u0007\u00034\u0014\u0011!C\u0005\u0007\u0007\u0014q\u0002U8ti\u001e\u0014Xm\u001d#jC2,7\r\u001e\u0006\u0003}}\nAA\u001b3cG*\u0011\u0001)Q\u0001\u0004gFd'B\u0001\"D\u0003\u0015\u0019\b/\u0019:l\u0015\t!U)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\r\u0006\u0019qN]4\u0004\u0001M1\u0001!S'T-r\u0003\"AS&\u000e\u0003uJ!\u0001T\u001f\u0003\u0017)#'m\u0019#jC2,7\r\u001e\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!~\n\u0001bY1uC2L8\u000f^\u0005\u0003%>\u0013QbU)M\u0007>tg\rS3ma\u0016\u0014\bC\u0001&U\u0013\t)VHA\tO_2+w-Y2z\u0015\u0012\u00135)\u0012:s_J\u0004\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002^K:\u0011al\u0019\b\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u001e\u000ba\u0001\u0010:p_Rt\u0014\"A-\n\u0005\u0011D\u0016a\u00029bG.\fw-Z\u0005\u0003M\u001e\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u001a-\u0002\rqJg.\u001b;?)\u0005Q\u0007C\u0001&\u0001\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002naB\u0011qK\\\u0005\u0003_b\u0013qAQ8pY\u0016\fg\u000eC\u0003r\u0005\u0001\u0007!/A\u0002ve2\u0004\"a]<\u000f\u0005Q,\bCA0Y\u0013\t1\b,\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<Y\u0003m\u0019X\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8ogV\tA\u0010E\u0003~\u0003\u000b\tI!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\nS6lW\u000f^1cY\u0016T1!a\u0001Y\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u000fq(aA*fiB!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00027b]\u001eT!!a\u0005\u0002\t)\fg/Y\u0005\u0004q\u00065\u0011\u0001H:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u0019gV\u0004\bo\u001c:uK\u0012\u001cFO]5oO\u001a+hn\u0019;j_:\u001c\u0018!G:vaB|'\u000f^3e'R\u0014\u0018N\\4Gk:\u001cG/[8og\u0002\n!c];qa>\u0014H/\u001a3Gk:\u001cG/[8og\u0006\u00192/\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8tA\u0005\u0019\u0012n]*vaB|'\u000f^3e\rVt7\r^5p]R\u0019Q.!\n\t\r\u0005\u001d\u0012\u00021\u0001s\u0003!1WO\\2OC6,\u0017!G5t\u001f\nTWm\u0019;O_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:$2!\\A\u0017\u0011\u001d\tyC\u0003a\u0001\u0003c\t\u0011!\u001a\t\u0005\u0003g\t9$\u0004\u0002\u00026)\u0019\u0001)!\u0005\n\t\u0005e\u0012Q\u0007\u0002\r'FcU\t_2faRLwN\\\u0001\u0010O\u0016$8)\u0019;bYf\u001cH\u000fV=qKRQ\u0011qHA)\u00037\ny&a\u0019\u0011\u000b]\u000b\t%!\u0012\n\u0007\u0005\r\u0003L\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J \u0002\u000bQL\b/Z:\n\t\u0005=\u0013\u0011\n\u0002\t\t\u0006$\u0018\rV=qK\"9\u00111K\u0006A\u0002\u0005U\u0013aB:rYRK\b/\u001a\t\u0004/\u0006]\u0013bAA-1\n\u0019\u0011J\u001c;\t\r\u0005u3\u00021\u0001s\u0003!!\u0018\u0010]3OC6,\u0007bBA1\u0017\u0001\u0007\u0011QK\u0001\u0005g&TX\rC\u0004\u0002f-\u0001\r!a\u001a\u0002\u00055$\u0007\u0003BA$\u0003SJA!a\u001b\u0002J\tyQ*\u001a;bI\u0006$\u0018MQ;jY\u0012,'/\u0001\bu_\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0011\u0005}\u0012\u0011OA:\u0003oBa!!\u0018\r\u0001\u0004\u0011\bbBA;\u0019\u0001\u0007\u0011QK\u0001\naJ,7-[:j_:Dq!!\u001a\r\u0001\u0004\t9'\u0001\u0012d_:4XM\u001d;KCZ\fG+[7fgR\fW\u000e\u001d+p)&lWm\u001d;b[BtEK\u0017\u000b\u0005\u0003{\nI\t\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\u0011\t\u0019)!\u0005\u0002\tQLW.Z\u0005\u0005\u0003\u000f\u000b\tIA\u0007M_\u000e\fG\u000eR1uKRKW.\u001a\u0005\b\u0003\u0017k\u0001\u0019AAG\u0003\u0005!\b\u0003BA\u001a\u0003\u001fKA!!%\u00026\tIA+[7fgR\fW\u000e]\u0001#G>tg/\u001a:u)&lWm\u001d;b[BtEK\u0017+p\u0015\u00064\u0018\rV5nKN$\u0018-\u001c9\u0015\t\u00055\u0015q\u0013\u0005\b\u00033s\u0001\u0019AA?\u0003\raG\r^\u0001\fO\u0016$(\n\u0012\"D)f\u0004X\r\u0006\u0003\u0002 \u0006\u001d\u0006#B,\u0002B\u0005\u0005\u0006c\u0001&\u0002$&\u0019\u0011QU\u001f\u0003\u0011)#'m\u0019+za\u0016Dq!!+\u0010\u0001\u0004\t)%\u0001\u0002ei\u0006A\u0012n]\"bg\u000e\fG-\u001b8h)J,hnY1uKR\u000b'\r\\3\u0015\u0005\u0005=\u0006\u0003B,\u0002B5\f\u0001cZ3u)J,hnY1uKF+XM]=\u0015\u000bI\f),!/\t\r\u0005]\u0016\u00031\u0001s\u0003\u0015!\u0018M\u00197f\u0011%\tY,\u0005I\u0001\u0002\u0004\ty+A\u0004dCN\u001c\u0017\rZ3\u00025\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005'\u0006BAX\u0003\u0007\\#!!2\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001fD\u0016AC1o]>$\u0018\r^5p]&!\u00111[Ae\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\fE\u00164wN]3GKR\u001c\u0007\u000e\u0006\u0004\u0002Z\u0006}\u0017\u0011\u001e\t\u0004/\u0006m\u0017bAAo1\n!QK\\5u\u0011\u001d\t\to\u0005a\u0001\u0003G\f!bY8o]\u0016\u001cG/[8o!\u0011\t\u0019$!:\n\t\u0005\u001d\u0018Q\u0007\u0002\u000b\u0007>tg.Z2uS>t\u0007bBAv'\u0001\u0007\u0011Q^\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b#B:\u0002pJ\u0014\u0018bAAys\n\u0019Q*\u00199\u00021\u001d,G/\u00169eCR,7i\u001c7v[:$\u0016\u0010]3Rk\u0016\u0014\u0018\u0010F\u0004s\u0003o\fY0a@\t\r\u0005eH\u00031\u0001s\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0003\u0004\u0002~R\u0001\rA]\u0001\u000bG>dW/\u001c8OC6,\u0007B\u0002B\u0001)\u0001\u0007!/A\u0006oK^$\u0015\r^1UsB,\u0017aH4fiV\u0003H-\u0019;f\u0007>dW/\u001c8Ok2d\u0017MY5mSRL\u0018+^3ssR9!Oa\u0002\u0003\n\t-\u0001BBA}+\u0001\u0007!\u000f\u0003\u0004\u0002~V\u0001\rA\u001d\u0005\u0007\u0005\u001b)\u0002\u0019A7\u0002\u0015%\u001ch*\u001e7mC\ndW-A\u0006de\u0016\fG/Z%oI\u0016DHc\u0003:\u0003\u0014\t]!1\u0006B!\u0005#BaA!\u0006\u0017\u0001\u0004\u0011\u0018!C5oI\u0016Dh*Y7f\u0011\u001d\u0011IB\u0006a\u0001\u00057\t!\u0002^1cY\u0016LE-\u001a8u!\u0011\u0011iBa\n\u000e\u0005\t}!\u0002\u0002B\u0011\u0005G\tqaY1uC2|wMC\u0002\u0003&}\n\u0011bY8o]\u0016\u001cGo\u001c:\n\t\t%\"q\u0004\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002B\u0017-\u0001\u0007!qF\u0001\bG>dW/\u001c8t!\u00159&\u0011\u0007B\u001b\u0013\r\u0011\u0019\u0004\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0005o\u0011i$\u0004\u0002\u0003:)!!1\bB\u0012\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\t}\"\u0011\b\u0002\u000f\u001d\u0006lW\r\u001a*fM\u0016\u0014XM\\2f\u0011\u001d\u0011\u0019E\u0006a\u0001\u0005\u000b\n\u0011cY8mk6t7\u000f\u0015:pa\u0016\u0014H/[3t!!\u00119E!\u0014\u00036\t=SB\u0001B%\u0015\u0011\u0011Y%!\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003c\u0014I\u0005\u0005\u0004\u0003H\t5#O\u001d\u0005\b\u0003W4\u0002\u0019\u0001B(\u0003]I7oU=oi\u0006DXI\u001d:pe\n+7\u000f^#gM>\u0014H\u000fF\u0002n\u0005/BqA!\u0017\u0018\u0001\u0004\t\t$A\u0005fq\u000e,\u0007\u000f^5p]\u0006Y\u0011N\u001c3fq\u0016C\u0018n\u001d;t)%i'q\fB2\u0005K\u00129\u0007C\u0004\u0003ba\u0001\r!a9\u0002\t\r|gN\u001c\u0005\u0007\u0005+A\u0002\u0019\u0001:\t\u000f\te\u0001\u00041\u0001\u0003\u001c!9!\u0011\u000e\rA\u0002\t-\u0014aB8qi&|gn\u001d\t\u0005\u0005[\u0012I(\u0004\u0002\u0003p)\u0019aH!\u001d\u000b\t\tM$QO\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0003x}\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\tm$q\u000e\u0002\f\u0015\u0012\u00135i\u00149uS>t7/A\u0005ee>\u0004\u0018J\u001c3fqR)!O!!\u0003\u0004\"1!QC\rA\u0002IDqA!\u0007\u001a\u0001\u0004\u0011Y\"\u0001\u000bqO\u0006c'/Z1es\u0016C\u0018n\u001d;t%\u0016<W\r_\u000b\u0003\u0005\u0013\u0003BAa#\u0003\u00146\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\u0011Y\u0005W\u0005\u0005\u0005+\u0013iIA\u0003SK\u001e,\u00070A\u000bqO\u0006c'/Z1es\u0016C\u0018n\u001d;t%\u0016<W\r\u001f\u0011\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0007\u0003\u001e\nE&1\u0017B\\\u0005w\u0013yL\u0005\u0004\u0003 \n\r&\u0011\u0016\u0004\u0007\u0005C\u0003\u0001A!(\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007u\u0013)+C\u0002\u0003(\u001e\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0011\t\t-&QV\u0007\u0002\u0003&\u0019!qV!\u0003\u001dM\u0003\u0018M]6UQJ|w/\u00192mK\"9\u0011q\u0006\u000fA\u0002\t\r\u0006B\u0002B[9\u0001\u0007!/A\u0005d_:$\u0017\u000e^5p]\"9!\u0011\u0018\u000fA\u0002\u00055\u0018!E7fgN\fw-\u001a)be\u0006lW\r^3sg\"1!Q\u0018\u000fA\u0002I\f1\u0002Z3tGJL\u0007\u000f^5p]\"1!\u0011\u0019\u000fA\u00025\f\u0011\"[:Sk:$\u0018.\\3\u0003%A{7\u000f^4sKN\u001c\u0016\u000b\u0014\"vS2$WM]\n\u0004;\t\u001d\u0007\u0003\u0002Be\u0005\u0017l\u0011\u0001A\u0005\u0004\u0005\u001b\\%A\u0004&E\u0005\u000e\u001b\u0016\u000b\u0014\"vS2$WM\u001d\u000b\u0003\u0005#\u00042A!3\u001e\u000311\u0018n]5u\u000bb$(/Y2u)\u0015\u0011(q\u001bBn\u0011\u0019\u0011In\ba\u0001e\u0006)a-[3mI\"1!Q\\\u0010A\u0002I\faa]8ve\u000e,\u0017!\u0006<jg&$()\u001b8bef\f%/\u001b;i[\u0016$\u0018n\u0019\u000b\be\n\r(q\u001dBv\u0011\u0019\u0011)\u000f\ta\u0001e\u0006!a.Y7f\u0011\u0019\u0011I\u000f\ta\u0001e\u0006\tA\u000e\u0003\u0004\u0003n\u0002\u0002\rA]\u0001\u0002e\u0006\t2m\\7qS2,W\t\u001f9sKN\u001c\u0018n\u001c8\u0015\t\tM(Q\u001f\t\u0005/\u0006\u0005#\u000fC\u0004\u0003x\u0006\u0002\rA!?\u0002\t\u0015D\bO\u001d\t\u0005\u0005o\u0011Y0\u0003\u0003\u0003~\ne\"AC#yaJ,7o]5p]\u0006a1m\\7qS2,g+\u00197vKR!11AB\u0005!\r96QA\u0005\u0004\u0007\u000fA&aA!os\"911\u0002\u0012A\u0002\r\r\u0011!\u0002<bYV,\u0017!D:vaB|'\u000f^:MS6LG/F\u0001n\u00039\u0019X\u000f\u001d9peR\u001cxJ\u001a4tKR\f1c];qa>\u0014Ho\u001d+bE2,7+Y7qY\u0016\fabZ3u)\u0006\u0014G.Z*b[BdW\rF\u0002s\u00073Aqaa\u0007'\u0001\u0004\u0019i\"\u0001\u0004tC6\u0004H.\u001a\t\u0005\u0007?\u0019)#\u0004\u0002\u0004\")!11\u0005B9\u0003\t1('\u0003\u0003\u0004(\r\u0005\"a\u0004+bE2,7+Y7qY\u0016LeNZ8\u0002\u0017I,g.Y7f)\u0006\u0014G.\u001a\u000b\u0006e\u000e52\u0011\u0007\u0005\b\u0007_9\u0003\u0019\u0001B\u000e\u0003!yG\u000e\u001a+bE2,\u0007bBB\u001aO\u0001\u0007!1D\u0001\t]\u0016<H+\u00192mK\u0006y2m\u001c8wKJ$(*\u0019<b)&lWm\u001d;b[B$v\u000eV5nKN$\u0018-\u001c9\u0015\t\u000555\u0011\b\u0005\b\u0003\u0017C\u0003\u0019AAG\u0003U\u0019wN\u001c<feRT\u0015M^1ECR,Gk\u001c#bi\u0016$Baa\u0010\u0004FA!\u00111GB!\u0013\u0011\u0019\u0019%!\u000e\u0003\t\u0011\u000bG/\u001a\u0005\b\u0007\u000fJ\u0003\u0019AB \u0003\u0005!\u0017!F;qI\u0006$X-\u0012=ue\u0006\u001cu\u000e\\;n]6+G/\u0019\u000b\u000b\u00033\u001ciea\u0014\u0004Z\ru\u0003b\u0002B1U\u0001\u0007\u00111\u001d\u0005\b\u0007#R\u0003\u0019AB*\u0003\u0011\u00118/\u001c3\u0011\t\u0005M2QK\u0005\u0005\u0007/\n)DA\tSKN,H\u000e^*fi6+G/\u0019#bi\u0006Dqaa\u0017+\u0001\u0004\t)&A\u0005d_2,XN\\%eq\"91q\f\u0016A\u0002\u0005\u001d\u0014\u0001C7fi\u0006$\u0017\r^1\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA+\u00039\u0001(o\u001c3vGR,E.Z7f]R$Baa\u0001\u0004p!I1\u0011\u000f\u0018\u0002\u0002\u0003\u0007\u0011QK\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r]\u0004CBB=\u0007w\u001a\u0019!\u0004\u0002\u0002\u0002%!1QPA\u0001\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00075\u001c\u0019\tC\u0005\u0004rA\n\t\u00111\u0001\u0004\u0004\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tIa!#\t\u0013\rE\u0014'!AA\u0002\u0005U\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0011AB3rk\u0006d7\u000fF\u0002n\u0007/C\u0011b!\u001d5\u0003\u0003\u0005\raa\u0001\u0002\u001fA{7\u000f^4sKN$\u0015.\u00197fGR\u0004\"A\u0013\u001c\u0014\u000bY\u001ayja+\u0011\u000b\r\u00056q\u00156\u000e\u0005\r\r&bABS1\u00069!/\u001e8uS6,\u0017\u0002BBU\u0007G\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c81!\u0011\u0019ika-\u000e\u0005\r=&\u0002BBY\u0003#\t!![8\n\u0007\u0019\u001cy\u000b\u0006\u0002\u0004\u001c\u0006)\u0011\r\u001d9ms\u00069QO\\1qa2LHcA7\u0004>\"A1q\u0018\u001e\u0002\u0002\u0003\u0007!.A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!2\u0011\t\u0005-1qY\u0005\u0005\u0007\u0013\fiA\u0001\u0004PE*,7\r\u001e")
public class PostgresDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedStringFunctions;
    private final Set<String> supportedFunctions;
    private final Regex pgAlreadyExistsRegex;

    public static boolean unapply(PostgresDialect x$0) {
        return PostgresDialect$.MODULE$.unapply(x$0);
    }

    public static PostgresDialect apply() {
        return PostgresDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedStringFunctions() {
        return this.supportedStringFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        String string = e.getSQLState();
        String string2 = "42P01";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = e.getSQLState();
        String string4 = "3F000";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = e.getSQLState();
        String string6 = "42704";
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (7 == n2) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (5 == n2) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (-7 == n2) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                return new Some((Object)BinaryType$.MODULE$);
            }
        }
        if (8 == n2) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return new Some((Object)StringType$.MODULE$);
            }
        }
        if (93 == n2 && "timestamptz".equalsIgnoreCase(typeName) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (92 == n2 && "timetz".equalsIgnoreCase(typeName)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (1 == n2 && "bpchar".equalsIgnoreCase(typeName) && size == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (1111 == n2) {
            bl = true;
            n = n2;
            if ("void".equalsIgnoreCase(typeName)) {
                return new Some((Object)NullType$.MODULE$);
            }
        }
        if (bl) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("text".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (2003 == n2) {
            Option<DataType> elementType = this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, md);
            return elementType.map((Function1 & Serializable)et -> {
                Metadata metadata = md.build();
                int dim = metadata.contains("arrayDimension") ? (int)metadata.getLong("arrayDimension") : 1;
                return (DataType)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dim).foldLeft(et, (Function2 & Serializable)(acc, x$1) -> ArrayType$.MODULE$.apply(acc));
            });
        }
        return None$.MODULE$;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, MetadataBuilder md) {
        boolean bl = false;
        String string = null;
        String string2 = typeName;
        if ("bool".equals(string2)) {
            return new Some((Object)BooleanType$.MODULE$);
        }
        if ("bit".equals(string2)) {
            bl = true;
            string = string2;
            if (precision == 1) {
                return new Some((Object)BooleanType$.MODULE$);
            }
        }
        if (bl) {
            md.putBoolean("pg_bit_array_type", true);
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("int2".equals(string2)) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if ("int4".equals(string2)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if ("int8".equals(string2) ? true : "oid".equals(string2)) {
            return new Some((Object)LongType$.MODULE$);
        }
        if ("float4".equals(string2)) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if ("float8".equals(string2)) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        if ("varchar".equals(string2)) {
            return new Some((Object)new VarcharType(precision));
        }
        if ("bpchar".equals(string2) && precision == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("char".equals(string2) ? true : "bpchar".equals(string2)) {
            return new Some((Object)new CharType(precision));
        }
        if ("text".equals(string2) ? true : ("cidr".equals(string2) ? true : ("inet".equals(string2) ? true : ("json".equals(string2) ? true : ("jsonb".equals(string2) ? true : ("uuid".equals(string2) ? true : ("xml".equals(string2) ? true : ("tsvector".equals(string2) ? true : ("tsquery".equals(string2) ? true : ("macaddr".equals(string2) ? true : ("macaddr8".equals(string2) ? true : ("txid_snapshot".equals(string2) ? true : ("point".equals(string2) ? true : ("line".equals(string2) ? true : ("lseg".equals(string2) ? true : ("box".equals(string2) ? true : ("path".equals(string2) ? true : ("polygon".equals(string2) ? true : ("circle".equals(string2) ? true : ("pg_lsn".equals(string2) ? true : ("varbit".equals(string2) ? true : ("interval".equals(string2) ? true : "pg_snapshot".equals(string2))))))))))))))))))))))) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("bytea".equals(string2)) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("timestamptz".equals(string2) ? true : "timetz".equals(string2)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ("timestamp".equals(string2) ? true : "time".equals(string2)) {
            return new Some((Object)this.getTimestampType(md.build()));
        }
        if ("date".equals(string2)) {
            return new Some((Object)DateType$.MODULE$);
        }
        if (("numeric".equals(string2) ? true : "decimal".equals(string2)) && precision > 0) {
            int scale = (int)md.build().getLong("scale");
            return new Some((Object)DecimalType$.MODULE$.bounded(precision, scale));
        }
        if ("numeric".equals(string2) ? true : "decimal".equals(string2)) {
            return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        }
        if ("money".equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)StringType$.MODULE$);
    }

    @Override
    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return t.toLocalDateTime();
    }

    @Override
    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("TEXT", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BYTEA", -2));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT4", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT8", 8));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH TIME ZONE", 93));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        if (dataType instanceof ArrayType && ((et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType || et instanceof ArrayType)) {
            return this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(typeName + "[]", 2003));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE ONLY " + table + " CASCADE";
        }
        return "TRUNCATE TABLE ONLY " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) > 0) {
            connection.setAutoCommit(false);
            return;
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String indexType;
        Object indexProperties;
        String[] columnList;
        block1: {
            columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
            indexProperties = "";
            Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String indexType2 = (String)tuple2._1();
            String[] indexPropertyList = (String[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType2, (Object)indexPropertyList);
            indexType = (String)tuple22._1();
            String[] indexPropertyList2 = (String[])tuple22._2();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2))) break block1;
            indexProperties = "WITH (" + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(", ") + ")";
        }
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.quoteIdentifier(tableIdent.name()) + " " + indexType + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + (String)indexProperties;
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return Option$.MODULE$.apply((Object)exception.getSQLState()).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("42")));
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM pg_indexes WHERE tablename = '" + tableIdent.name() + "' AND indexname = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName);
    }

    private final Regex pgAlreadyExistsRegex() {
        return this.pgAlreadyExistsRegex;
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 48220673: {
                    if (!"2BP01".equals(string)) break;
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
                case 49567037: {
                    if (!"42704".equals(string)) break;
                    String string2 = condition;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 49591065: {
                    if (!"42P07".equals(string)) break;
                    String string4 = condition;
                    String string5 = "FAILED_JDBC.CREATE_INDEX";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        throw new IndexAlreadyExistsException((String)messageParameters.apply((Object)"indexName"), (String)messageParameters.apply((Object)"tableName"), (Option)new Some((Object)e));
                    }
                    String string6 = condition;
                    String string7 = "FAILED_JDBC.RENAME_TABLE";
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        String newTable = (String)messageParameters.apply((Object)"newName");
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                    }
                    Option tblRegexp = this.pgAlreadyExistsRegex().findFirstMatchIn((CharSequence)sQLException.getMessage());
                    if (tblRegexp.nonEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(((Regex.MatchData)tblRegexp.get()).group(1));
                    }
                    return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        PostgresSQLBuilder postgresSQLBuilder = new PostgresSQLBuilder(this);
        try {
            some = new Some((Object)postgresSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$6 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$6))})), ClassTag$.MODULE$.apply(String.class))).mkString("'\\x", "", "'::bytea");
        }
        return super.compileValue(object);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE BERNOULLI (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        if (!Predef$.MODULE$.wrapRefArray((Object[])oldTable.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newTable.namespace()))) {
            throw QueryCompilationErrors$.MODULE$.cannotRenameTableAcrossSchemaError();
        }
        return "ALTER TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " RENAME TO " + newTable.name();
    }

    @Override
    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        long l = t.getTime();
        if (9223372036825200000L == l) {
            return new Timestamp(LocalDateTime.of(9999, 12, 31, 23, 59, 59, 999999999).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Timestamp(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return t;
    }

    @Override
    public Date convertJavaDateToDate(Date d) {
        long l = d.getTime();
        if (9223372036825200000L == l) {
            return new Date(LocalDateTime.of(9999, 12, 31, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Date(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return d;
    }

    @Override
    public void updateExtraColumnMeta(Connection conn, ResultSetMetaData rsmd, int columnIdx, MetadataBuilder metadata) {
        int n = rsmd.getColumnType(columnIdx);
        switch (n) {
            case 2003: {
                String tableName = rsmd.getTableName(columnIdx);
                String columnName = rsmd.getColumnName(columnIdx);
                String query = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT pg_attribute.attndims\n             |FROM pg_attribute\n             |  JOIN pg_class ON pg_attribute.attrelid = pg_class.oid\n             |  JOIN pg_namespace ON pg_class.relnamespace = pg_namespace.oid\n             |WHERE pg_class.relname = '" + tableName + "' and pg_attribute.attname = '" + columnName + "'\n             |"));
                try {
                    Using$.MODULE$.resource((Object)conn.createStatement(), (Function1 & Serializable)stmt -> Using$.MODULE$.resource((Object)stmt.executeQuery(query), (Function1 & Serializable)rs -> {
                        if (rs.next()) {
                            return metadata.putLong("arrayDimension", Math.max(1L, rs.getLong(1)));
                        }
                        return BoxedUnit.UNIT;
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                }
                catch (SQLException e) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get array dimension for column ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COLUMN_NAME$.MODULE$, (Object)columnName)}))), (Throwable)e);
                }
                return;
            }
        }
    }

    public PostgresDialect copy() {
        return new PostgresDialect();
    }

    public String productPrefix() {
        return "PostgresDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PostgresDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof PostgresDialect && ((PostgresDialect)x$1).canEqual(this);
    }

    public PostgresDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedStringFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"RPAD", "LPAD"}));
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus(this.supportedStringFunctions());
        this.pgAlreadyExistsRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:.*)relation \"(.*)\" already exists"));
    }

    public class PostgresSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(String field, String source) {
            String string;
            block5: {
                String string2 = field;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1351979174: {
                        if (!"YEAR_OF_WEEK".equals(string2)) break;
                        string = "ISOYEAR";
                        break block5;
                    }
                    case 2074232729: {
                        if (!"DAY_OF_WEEK".equals(string2)) break;
                        string = "ISODOW";
                        break block5;
                    }
                    case 2074292194: {
                        if (!"DAY_OF_YEAR".equals(string2)) break;
                        string = "DOY";
                        break block5;
                    }
                }
                string = field;
            }
            String postgresField = string;
            return super.visitExtract(postgresField, source);
        }

        public String visitBinaryArithmetic(String name, String l, String r) {
            return l + " " + name.replace('^', '#') + " " + r;
        }

        public /* synthetic */ PostgresDialect org$apache$spark$sql$jdbc$PostgresDialect$PostgresSQLBuilder$$$outer() {
            return (PostgresDialect)this.$outer;
        }

        public PostgresSQLBuilder(PostgresDialect $outer) {
        }
    }
}

