/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import org.sparkproject.guava.annotations.VisibleForTesting;

public final class OffHeapColumnVector
extends WritableColumnVector {
    private static final boolean bigEndianPlatform = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private long nulls = 0L;
    private long data = 0L;
    private long lengthData = 0L;
    private long offsetData = 0L;

    public static OffHeapColumnVector[] allocateColumns(int capacity, StructType schema) {
        return OffHeapColumnVector.allocateColumns(capacity, schema.fields());
    }

    public static OffHeapColumnVector[] allocateColumns(int capacity, StructField[] fields) {
        OffHeapColumnVector[] vectors = new OffHeapColumnVector[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vectors[i] = new OffHeapColumnVector(capacity, fields[i].dataType());
        }
        return vectors;
    }

    public OffHeapColumnVector(int capacity, DataType type) {
        super(capacity, type);
        this.reserveInternal(capacity);
        this.reset();
    }

    @VisibleForTesting
    public long valuesNativeAddress() {
        return this.data;
    }

    @Override
    protected void releaseMemory() {
        Platform.freeMemory((long)this.nulls);
        Platform.freeMemory((long)this.data);
        Platform.freeMemory((long)this.lengthData);
        Platform.freeMemory((long)this.offsetData);
        this.nulls = 0L;
        this.data = 0L;
        this.lengthData = 0L;
        this.offsetData = 0L;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void putNotNull(int rowId) {
        Platform.putByte(null, (long)(this.nulls + (long)rowId), (byte)0);
    }

    @Override
    public void putNull(int rowId) {
        Platform.putByte(null, (long)(this.nulls + (long)rowId), (byte)1);
        ++this.numNulls;
    }

    @Override
    public void putNulls(int rowId, int count) {
        long offset = this.nulls + (long)rowId;
        int i = 0;
        while (i < count) {
            Platform.putByte(null, (long)offset, (byte)1);
            ++i;
            ++offset;
        }
        this.numNulls += count;
    }

    @Override
    public void putNotNulls(int rowId, int count) {
        if (!this.hasNull()) {
            return;
        }
        long offset = this.nulls + (long)rowId;
        int i = 0;
        while (i < count) {
            Platform.putByte(null, (long)offset, (byte)0);
            ++i;
            ++offset;
        }
    }

    public boolean isNullAt(int rowId) {
        return this.isAllNull || Platform.getByte(null, (long)(this.nulls + (long)rowId)) == 1;
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        Platform.putByte(null, (long)(this.data + (long)rowId), (byte)((byte)(value ? 1 : 0)));
    }

    @Override
    public void putBooleans(int rowId, int count, boolean value) {
        byte v = (byte)(value ? 1 : 0);
        for (int i = 0; i < count; ++i) {
            Platform.putByte(null, (long)(this.data + (long)rowId + (long)i), (byte)v);
        }
    }

    @Override
    public void putBooleans(int rowId, byte src) {
        Platform.putByte(null, (long)(this.data + (long)rowId), (byte)((byte)(src & 1)));
        Platform.putByte(null, (long)(this.data + (long)rowId + 1L), (byte)((byte)(src >>> 1 & 1)));
        Platform.putByte(null, (long)(this.data + (long)rowId + 2L), (byte)((byte)(src >>> 2 & 1)));
        Platform.putByte(null, (long)(this.data + (long)rowId + 3L), (byte)((byte)(src >>> 3 & 1)));
        Platform.putByte(null, (long)(this.data + (long)rowId + 4L), (byte)((byte)(src >>> 4 & 1)));
        Platform.putByte(null, (long)(this.data + (long)rowId + 5L), (byte)((byte)(src >>> 5 & 1)));
        Platform.putByte(null, (long)(this.data + (long)rowId + 6L), (byte)((byte)(src >>> 6 & 1)));
        Platform.putByte(null, (long)(this.data + (long)rowId + 7L), (byte)((byte)(src >>> 7 & 1)));
    }

    public boolean getBoolean(int rowId) {
        return Platform.getByte(null, (long)(this.data + (long)rowId)) == 1;
    }

    public boolean[] getBooleans(int rowId, int count) {
        assert (this.dictionary == null);
        boolean[] array = new boolean[count];
        for (int i = 0; i < count; ++i) {
            array[i] = Platform.getByte(null, (long)(this.data + (long)rowId + (long)i)) == 1;
        }
        return array;
    }

    @Override
    public void putByte(int rowId, byte value) {
        Platform.putByte(null, (long)(this.data + (long)rowId), (byte)value);
    }

    @Override
    public void putBytes(int rowId, int count, byte value) {
        for (int i = 0; i < count; ++i) {
            Platform.putByte(null, (long)(this.data + (long)rowId + (long)i), (byte)value);
        }
    }

    @Override
    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)rowId), (long)count);
    }

    public byte getByte(int rowId) {
        if (this.dictionary == null) {
            return Platform.getByte(null, (long)(this.data + (long)rowId));
        }
        return (byte)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    public byte[] getBytes(int rowId, int count) {
        byte[] array = new byte[count];
        if (this.dictionary == null) {
            Platform.copyMemory(null, (long)(this.data + (long)rowId), (Object)array, (long)Platform.BYTE_ARRAY_OFFSET, (long)count);
        } else {
            for (int i = 0; i < count; ++i) {
                if (this.isNullAt(rowId + i)) continue;
                array[i] = (byte)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId + i));
            }
        }
        return array;
    }

    @Override
    protected UTF8String getBytesAsUTF8String(int rowId, int count) {
        return UTF8String.fromAddress(null, (long)(this.data + (long)rowId), (int)count);
    }

    @Override
    public ByteBuffer getByteBuffer(int rowId, int count) {
        return ByteBuffer.wrap(this.getBytes(rowId, count));
    }

    @Override
    public void putShort(int rowId, short value) {
        Platform.putShort(null, (long)(this.data + 2L * (long)rowId), (short)value);
    }

    @Override
    public void putShorts(int rowId, int count, short value) {
        long offset = this.data + 2L * (long)rowId;
        int i = 0;
        while (i < count) {
            Platform.putShort(null, (long)offset, (short)value);
            ++i;
            offset += 2L;
        }
    }

    @Override
    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)((long)Platform.SHORT_ARRAY_OFFSET + (long)srcIndex * 2L), null, (long)(this.data + 2L * (long)rowId), (long)((long)count * 2L));
    }

    @Override
    public void putShorts(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)rowId * 2L), (long)((long)count * 2L));
    }

    public short getShort(int rowId) {
        if (this.dictionary == null) {
            return Platform.getShort(null, (long)(this.data + 2L * (long)rowId));
        }
        return (short)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    public short[] getShorts(int rowId, int count) {
        short[] array = new short[count];
        if (this.dictionary == null) {
            Platform.copyMemory(null, (long)(this.data + (long)rowId * 2L), (Object)array, (long)Platform.SHORT_ARRAY_OFFSET, (long)((long)count * 2L));
        } else {
            for (int i = 0; i < count; ++i) {
                if (this.isNullAt(rowId + i)) continue;
                array[i] = (short)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId + i));
            }
        }
        return array;
    }

    @Override
    public void putInt(int rowId, int value) {
        Platform.putInt(null, (long)(this.data + 4L * (long)rowId), (int)value);
    }

    @Override
    public void putInts(int rowId, int count, int value) {
        long offset = this.data + 4L * (long)rowId;
        int i = 0;
        while (i < count) {
            Platform.putInt(null, (long)offset, (int)value);
            ++i;
            offset += 4L;
        }
    }

    @Override
    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)((long)Platform.INT_ARRAY_OFFSET + (long)srcIndex * 4L), null, (long)(this.data + 4L * (long)rowId), (long)((long)count * 4L));
    }

    @Override
    public void putInts(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)rowId * 4L), (long)((long)count * 4L));
    }

    @Override
    public void putIntsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(srcIndex + Platform.BYTE_ARRAY_OFFSET), null, (long)(this.data + 4L * (long)rowId), (long)((long)count * 4L));
        } else {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            long offset = this.data + 4L * (long)rowId;
            int i = 0;
            while (i < count) {
                Platform.putInt(null, (long)offset, (int)Integer.reverseBytes(Platform.getInt((Object)src, (long)srcOffset)));
                ++i;
                offset += 4L;
                srcOffset += 4;
            }
        }
    }

    public int getInt(int rowId) {
        if (this.dictionary == null) {
            return Platform.getInt(null, (long)(this.data + 4L * (long)rowId));
        }
        return this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    public int[] getInts(int rowId, int count) {
        int[] array = new int[count];
        if (this.dictionary == null) {
            Platform.copyMemory(null, (long)(this.data + (long)rowId * 4L), (Object)array, (long)Platform.INT_ARRAY_OFFSET, (long)((long)count * 4L));
        } else {
            for (int i = 0; i < count; ++i) {
                if (this.isNullAt(rowId + i)) continue;
                array[i] = this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId + i));
            }
        }
        return array;
    }

    @Override
    public int getDictId(int rowId) {
        assert (this.dictionary == null) : "A ColumnVector dictionary should not have a dictionary for itself.";
        return Platform.getInt(null, (long)(this.data + 4L * (long)rowId));
    }

    @Override
    public void putLong(int rowId, long value) {
        Platform.putLong(null, (long)(this.data + 8L * (long)rowId), (long)value);
    }

    @Override
    public void putLongs(int rowId, int count, long value) {
        long offset = this.data + 8L * (long)rowId;
        int i = 0;
        while (i < count) {
            Platform.putLong(null, (long)offset, (long)value);
            ++i;
            offset += 8L;
        }
    }

    @Override
    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)((long)Platform.LONG_ARRAY_OFFSET + (long)srcIndex * 8L), null, (long)(this.data + 8L * (long)rowId), (long)((long)count * 8L));
    }

    @Override
    public void putLongs(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)rowId * 8L), (long)((long)count * 8L));
    }

    @Override
    public void putLongsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(srcIndex + Platform.BYTE_ARRAY_OFFSET), null, (long)(this.data + 8L * (long)rowId), (long)((long)count * 8L));
        } else {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            long offset = this.data + 8L * (long)rowId;
            int i = 0;
            while (i < count) {
                Platform.putLong(null, (long)offset, (long)Long.reverseBytes(Platform.getLong((Object)src, (long)srcOffset)));
                ++i;
                offset += 8L;
                srcOffset += 8;
            }
        }
    }

    public long getLong(int rowId) {
        if (this.dictionary == null) {
            return Platform.getLong(null, (long)(this.data + 8L * (long)rowId));
        }
        return this.dictionary.decodeToLong(this.dictionaryIds.getDictId(rowId));
    }

    public long[] getLongs(int rowId, int count) {
        long[] array = new long[count];
        if (this.dictionary == null) {
            Platform.copyMemory(null, (long)(this.data + (long)rowId * 8L), (Object)array, (long)Platform.LONG_ARRAY_OFFSET, (long)((long)count * 8L));
        } else {
            for (int i = 0; i < count; ++i) {
                if (this.isNullAt(rowId + i)) continue;
                array[i] = this.dictionary.decodeToLong(this.dictionaryIds.getDictId(rowId + i));
            }
        }
        return array;
    }

    @Override
    public void putFloat(int rowId, float value) {
        Platform.putFloat(null, (long)(this.data + (long)rowId * 4L), (float)value);
    }

    @Override
    public void putFloats(int rowId, int count, float value) {
        long offset = this.data + 4L * (long)rowId;
        int i = 0;
        while (i < count) {
            Platform.putFloat(null, (long)offset, (float)value);
            ++i;
            offset += 4L;
        }
    }

    @Override
    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)((long)Platform.FLOAT_ARRAY_OFFSET + (long)srcIndex * 4L), null, (long)(this.data + 4L * (long)rowId), (long)((long)count * 4L));
    }

    @Override
    public void putFloats(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)rowId * 4L), (long)((long)count * 4L));
    }

    @Override
    public void putFloatsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            this.putFloats(rowId, count, src, srcIndex);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            long offset = this.data + 4L * (long)rowId;
            int i = 0;
            while (i < count) {
                Platform.putFloat(null, (long)offset, (float)bb.getFloat(srcIndex + 4 * i));
                ++i;
                offset += 4L;
            }
        }
    }

    public float getFloat(int rowId) {
        if (this.dictionary == null) {
            return Platform.getFloat(null, (long)(this.data + (long)rowId * 4L));
        }
        return this.dictionary.decodeToFloat(this.dictionaryIds.getDictId(rowId));
    }

    public float[] getFloats(int rowId, int count) {
        float[] array = new float[count];
        if (this.dictionary == null) {
            Platform.copyMemory(null, (long)(this.data + (long)rowId * 4L), (Object)array, (long)Platform.FLOAT_ARRAY_OFFSET, (long)((long)count * 4L));
        } else {
            for (int i = 0; i < count; ++i) {
                if (this.isNullAt(rowId + i)) continue;
                array[i] = this.dictionary.decodeToFloat(this.dictionaryIds.getDictId(rowId + i));
            }
        }
        return array;
    }

    @Override
    public void putDouble(int rowId, double value) {
        Platform.putDouble(null, (long)(this.data + (long)rowId * 8L), (double)value);
    }

    @Override
    public void putDoubles(int rowId, int count, double value) {
        long offset = this.data + 8L * (long)rowId;
        int i = 0;
        while (i < count) {
            Platform.putDouble(null, (long)offset, (double)value);
            ++i;
            offset += 8L;
        }
    }

    @Override
    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)((long)Platform.DOUBLE_ARRAY_OFFSET + (long)srcIndex * 8L), null, (long)(this.data + 8L * (long)rowId), (long)((long)count * 8L));
    }

    @Override
    public void putDoubles(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)rowId * 8L), (long)((long)count * 8L));
    }

    @Override
    public void putDoublesLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            this.putDoubles(rowId, count, src, srcIndex);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            long offset = this.data + 8L * (long)rowId;
            int i = 0;
            while (i < count) {
                Platform.putDouble(null, (long)offset, (double)bb.getDouble(srcIndex + 8 * i));
                ++i;
                offset += 8L;
            }
        }
    }

    public double getDouble(int rowId) {
        if (this.dictionary == null) {
            return Platform.getDouble(null, (long)(this.data + (long)rowId * 8L));
        }
        return this.dictionary.decodeToDouble(this.dictionaryIds.getDictId(rowId));
    }

    public double[] getDoubles(int rowId, int count) {
        double[] array = new double[count];
        if (this.dictionary == null) {
            Platform.copyMemory(null, (long)(this.data + (long)rowId * 8L), (Object)array, (long)Platform.DOUBLE_ARRAY_OFFSET, (long)((long)count * 8L));
        } else {
            for (int i = 0; i < count; ++i) {
                if (this.isNullAt(rowId + i)) continue;
                array[i] = this.dictionary.decodeToDouble(this.dictionaryIds.getDictId(rowId + i));
            }
        }
        return array;
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        assert (offset >= 0 && offset + length <= this.childColumns[0].capacity);
        Platform.putInt(null, (long)(this.lengthData + 4L * (long)rowId), (int)length);
        Platform.putInt(null, (long)(this.offsetData + 4L * (long)rowId), (int)offset);
    }

    @Override
    public int getArrayLength(int rowId) {
        return Platform.getInt(null, (long)(this.lengthData + 4L * (long)rowId));
    }

    @Override
    public int getArrayOffset(int rowId) {
        return Platform.getInt(null, (long)(this.offsetData + 4L * (long)rowId));
    }

    @Override
    public int putByteArray(int rowId, byte[] value, int offset, int length) {
        int result = this.arrayData().appendBytes(length, value, offset);
        Platform.putInt(null, (long)(this.lengthData + 4L * (long)rowId), (int)length);
        Platform.putInt(null, (long)(this.offsetData + 4L * (long)rowId), (int)result);
        return result;
    }

    @Override
    protected void reserveInternal(int newCapacity) {
        int oldCapacity;
        int n = oldCapacity = this.nulls == 0L ? 0 : this.capacity;
        if (this.isArray() || this.type instanceof MapType) {
            this.lengthData = Platform.reallocateMemory((long)this.lengthData, (long)((long)oldCapacity * 4L), (long)((long)newCapacity * 4L));
            this.offsetData = Platform.reallocateMemory((long)this.offsetData, (long)((long)oldCapacity * 4L), (long)((long)newCapacity * 4L));
        } else if (this.type instanceof ByteType || this.type instanceof BooleanType) {
            this.data = Platform.reallocateMemory((long)this.data, (long)oldCapacity, (long)newCapacity);
        } else if (this.type instanceof ShortType) {
            this.data = Platform.reallocateMemory((long)this.data, (long)((long)oldCapacity * 2L), (long)((long)newCapacity * 2L));
        } else if (this.type instanceof IntegerType || this.type instanceof FloatType || this.type instanceof DateType || DecimalType.is32BitDecimalType((DataType)this.type) || this.type instanceof YearMonthIntervalType) {
            this.data = Platform.reallocateMemory((long)this.data, (long)((long)oldCapacity * 4L), (long)((long)newCapacity * 4L));
        } else if (this.type instanceof LongType || this.type instanceof DoubleType || DecimalType.is64BitDecimalType((DataType)this.type) || this.type instanceof TimestampType || this.type instanceof TimestampNTZType || this.type instanceof DayTimeIntervalType || this.type instanceof TimeType) {
            this.data = Platform.reallocateMemory((long)this.data, (long)((long)oldCapacity * 8L), (long)((long)newCapacity * 8L));
        } else if (this.childColumns == null) {
            throw new RuntimeException("Unhandled " + String.valueOf(this.type));
        }
        this.nulls = Platform.reallocateMemory((long)this.nulls, (long)oldCapacity, (long)newCapacity);
        Platform.setMemory((long)(this.nulls + (long)oldCapacity), (byte)0, (long)(newCapacity - oldCapacity));
        this.capacity = newCapacity;
    }

    @Override
    protected OffHeapColumnVector reserveNewColumn(int capacity, DataType type) {
        return new OffHeapColumnVector(capacity, type);
    }
}

