/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.execution.streaming.state.DeactivateInstances;
import org.apache.spark.sql.execution.streaming.state.GetLaggingStoresForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLatestSnapshotVersionForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLocation;
import org.apache.spark.sql.execution.streaming.state.LogLaggingStateStores;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstance;
import org.apache.spark.sql.execution.streaming.state.ReportSnapshotUploaded;
import org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StopCoordinator$;
import org.apache.spark.sql.execution.streaming.state.VerifyIfInstanceActive;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\n\u0014\t\tB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u001dI\u0005A1A\u0005\n)Ca\u0001\u0018\u0001!\u0002\u0013Y\u0005bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B0\t\u000f\u0011\u0004!\u0019!C\u0005K\"1a\r\u0001Q\u0001\n\u0001Dqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004v\u0001\u0001\u0006I!\u001b\u0005\u0006m\u0002!Ia\u001e\u0005\u0006w\u0002!I\u0001 \u0005\u0006{\u0002!\tE \u0005\b\u00037\u0001A\u0011BA\u000f\u0005U\u0019F/\u0019;f'R|'/Z\"p_J$\u0017N\\1u_JT!\u0001F\u000b\u0002\u000bM$\u0018\r^3\u000b\u0005Y9\u0012!C:ue\u0016\fW.\u001b8h\u0015\tA\u0012$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M!\u0001aI\u00150!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!&L\u0007\u0002W)\u0011AfG\u0001\u0004eB\u001c\u0017B\u0001\u0018,\u0005U!\u0006N]3bIN\u000bg-\u001a*qG\u0016sG\r]8j]R\u0004\"\u0001M\u001a\u000e\u0003ER!AM\u000e\u0002\u0011%tG/\u001a:oC2L!\u0001N\u0019\u0003\u000f1{wmZ5oO\u00061!\u000f]2F]Z,\u0012a\u000e\t\u0003UaJ!!O\u0016\u0003\rI\u00038-\u00128w\u0003\u001d\u0011\boY#om\u0002\nqa]9m\u0007>tg-F\u0001>!\tq\u0004)D\u0001@\u0015\t\u0011\u0014$\u0003\u0002B\u007f\t91+\u0015'D_:4\u0017\u0001C:rY\u000e{gN\u001a\u0011\u0002\rqJg.\u001b;?)\r)u\t\u0013\t\u0003\r\u0002i\u0011a\u0005\u0005\u0006k\u0015\u0001\ra\u000e\u0005\u0006w\u0015\u0001\r!P\u0001\nS:\u001cH/\u00198dKN,\u0012a\u0013\t\u0005\u0019F\u001bf+D\u0001N\u0015\tqu*A\u0004nkR\f'\r\\3\u000b\u0005A+\u0013AC2pY2,7\r^5p]&\u0011!+\u0014\u0002\b\u0011\u0006\u001c\b.T1q!\t1E+\u0003\u0002V'\t!2\u000b^1uKN#xN]3Qe>4\u0018\u000eZ3s\u0013\u0012\u0004\"a\u0016.\u000e\u0003aS!!W\u000e\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA.Y\u0005e)\u00050Z2vi>\u00148)Y2iKR\u000b7o\u001b'pG\u0006$\u0018n\u001c8\u0002\u0015%t7\u000f^1oG\u0016\u001c\b%\u0001\u0011ti\u0006$Xm\u0015;pe\u0016d\u0015\r^3tiV\u0003Hn\\1eK\u0012\u001cf.\u00199tQ>$X#A0\u0011\t1\u000b6\u000b\u0019\t\u0003\r\u0006L!AY\n\u0003'Ms\u0017\r]:i_R,\u0006\u000f\\8bI\u00163XM\u001c;\u0002CM$\u0018\r^3Ti>\u0014X\rT1uKN$X\u000b\u001d7pC\u0012,Gm\u00158baNDw\u000e\u001e\u0011\u00025\u0011,g-Y;miNs\u0017\r]:i_R,\u0006\u000f\\8bI\u00163XM\u001c;\u0016\u0003\u0001\f1\u0004Z3gCVdGo\u00158baNDw\u000e^+qY>\fG-\u0012<f]R\u0004\u0013a\b7bgR4U\u000f\u001c7T]\u0006\u00048\u000f[8u\u0019\u0006<'+\u001a9peR$\u0016.\\3NgV\t\u0011\u000e\u0005\u0003M#*\u0014\bCA6q\u001b\u0005a'BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\u0005+VKE\t\u0005\u0002%g&\u0011A/\n\u0002\u0005\u0019>tw-\u0001\u0011mCN$h)\u001e7m':\f\u0007o\u001d5pi2\u000bwMU3q_J$H+[7f\u001bN\u0004\u0013AI:i_VdGmQ8pe\u0012Lg.\u0019;peJ+\u0007o\u001c:u':\f\u0007o\u001d5pi2\u000bw-F\u0001y!\t!\u00130\u0003\u0002{K\t9!i\\8mK\u0006t\u0017\u0001H2p_J$\u0017N\\1u_Jd\u0015m\u001a*fa>\u0014H/\u00138uKJ4\u0018\r\\\u000b\u0002e\u0006y!/Z2fSZ,\u0017I\u001c3SKBd\u0017\u0010F\u0002\u0000\u0003#\u0001r\u0001JA\u0001\u0003\u000b\tY!C\u0002\u0002\u0004\u0015\u0012q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0004I\u0005\u001d\u0011bAA\u0005K\t\u0019\u0011I\\=\u0011\u0007\u0011\ni!C\u0002\u0002\u0010\u0015\u0012A!\u00168ji\"9\u00111\u0003\tA\u0002\u0005U\u0011aB2p]R,\u0007\u0010\u001e\t\u0004U\u0005]\u0011bAA\rW\tq!\u000b]2DC2d7i\u001c8uKb$\u0018!\u00054j]\u0012d\u0015mZ4j]\u001e\u001cFo\u001c:fgRQ\u0011qDA\u001c\u0003w\ty$a\u0011\u0011\u000b\u0005\u0005\u0012\u0011G*\u000f\t\u0005\r\u0012Q\u0006\b\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011F\u0011\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013bAA\u0018K\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u00111aU3r\u0015\r\ty#\n\u0005\u0007\u0003s\t\u0002\u0019\u00016\u0002\u0015E,XM]=Sk:LE\r\u0003\u0004\u0002>E\u0001\rA]\u0001\u0011e\u00164WM]3oG\u00164VM]:j_:Da!!\u0011\u0012\u0001\u0004\u0011\u0018A\u0005:fM\u0016\u0014XM\\2f)&lWm\u001d;b[BDa!!\u0012\u0012\u0001\u0004A\u0018\u0001F5t)\u0016\u0014X.\u001b8bi&tw\r\u0016:jO\u001e,'\u000f")
public class StateStoreCoordinator
implements ThreadSafeRpcEndpoint,
Logging {
    private final RpcEnv rpcEnv;
    private final SQLConf sqlConf;
    private final HashMap<StateStoreProviderId, ExecutorCacheTaskLocation> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances;
    private final HashMap<StateStoreProviderId, SnapshotUploadEvent> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot;
    private final SnapshotUploadEvent org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent;
    private final HashMap<UUID, Object> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final RpcEndpointRef self() {
        return RpcEndpoint.self$((RpcEndpoint)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return RpcEndpoint.receive$((RpcEndpoint)this);
    }

    public void onError(Throwable cause) {
        RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
    }

    public void onConnected(RpcAddress remoteAddress) {
        RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onDisconnected(RpcAddress remoteAddress) {
        RpcEndpoint.onDisconnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
        RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
    }

    public void onStart() {
        RpcEndpoint.onStart$((RpcEndpoint)this);
    }

    public void onStop() {
        RpcEndpoint.onStop$((RpcEndpoint)this);
    }

    public final void stop() {
        RpcEndpoint.stop$((RpcEndpoint)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public SQLConf sqlConf() {
        return this.sqlConf;
    }

    public HashMap<StateStoreProviderId, ExecutorCacheTaskLocation> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances;
    }

    public HashMap<StateStoreProviderId, SnapshotUploadEvent> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot;
    }

    public SnapshotUploadEvent org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent;
    }

    public HashMap<UUID, Object> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs;
    }

    public boolean org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag() {
        return this.sqlConf().stateStoreCoordinatorReportSnapshotUploadLag();
    }

    public long org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$coordinatorLagReportInterval() {
        return this.sqlConf().stateStoreCoordinatorSnapshotLagReportInterval();
    }

    public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
        return new Serializable(this, context){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StateStoreCoordinator $outer;
            private final RpcCallContext context$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ReportActiveInstance) {
                    ReportActiveInstance reportActiveInstance = (ReportActiveInstance)A1;
                    StateStoreProviderId id = reportActiveInstance.storeId();
                    String host = reportActiveInstance.host();
                    String executorId = reportActiveInstance.executorId();
                    Seq<StateStoreProviderId> providerIdsToCheck = reportActiveInstance.providerIdsToCheck();
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Reported state store " + id + " is active at " + executorId);
                    ExecutorCacheTaskLocation taskLocation = new ExecutorCacheTaskLocation(host, executorId);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().put((Object)id, (Object)taskLocation);
                    Seq providerIdsToUnload = (Seq)providerIdsToCheck.filter((Function1 & Serializable)providerId -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$2(this, taskLocation, providerId)));
                    this.context$1.reply((Object)providerIdsToUnload);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof VerifyIfInstanceActive) {
                    boolean bl;
                    VerifyIfInstanceActive verifyIfInstanceActive = (VerifyIfInstanceActive)A1;
                    StateStoreProviderId id = verifyIfInstanceActive.storeId();
                    String execId = verifyIfInstanceActive.executorId();
                    Option option = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)id);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ExecutorCacheTaskLocation location = (ExecutorCacheTaskLocation)some.value();
                        String string = location.executorId();
                        String string2 = execId;
                        bl = !(string != null ? !string.equals(string2) : string2 != null);
                    } else if (None$.MODULE$.equals(option)) {
                        bl = false;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boolean response = bl;
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Verified that state store " + id + " is active: " + response);
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)response));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLocation) {
                    GetLocation getLocation = (GetLocation)A1;
                    StateStoreProviderId id = getLocation.storeId();
                    Option executorId = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)id).map((Function1 & Serializable)x$2 -> x$2.toString());
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got location of the state store " + id + ": " + executorId);
                    this.context$1.reply((Object)executorId);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof DeactivateInstances) {
                    DeactivateInstances deactivateInstances = (DeactivateInstances)A1;
                    UUID runId = deactivateInstances.runId();
                    Seq storeIdsToRemove = ((IterableOnceOps)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().keys().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$8(runId, x$3)))).toSeq();
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().$minus$minus$eq((IterableOnce)storeIdsToRemove);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().$minus$minus$eq((IterableOnce)storeIdsToRemove);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().$minus$eq((Object)runId);
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deactivating instances related to checkpoint location " + runId + ": " + storeIdsToRemove.mkString(", "));
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ReportSnapshotUploaded) {
                    ReportSnapshotUploaded reportSnapshotUploaded = (ReportSnapshotUploaded)A1;
                    StateStoreProviderId providerId2 = reportSnapshotUploaded.providerId();
                    long version = reportSnapshotUploaded.version();
                    long timestamp = reportSnapshotUploaded.timestamp();
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot version " + version + " was uploaded for state store " + providerId2);
                    Object object = !this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId2).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$11(version, x$4))) ? this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().put((Object)providerId2, (Object)new SnapshotUploadEvent(version, timestamp)) : BoxedUnit.UNIT;
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof LogLaggingStateStores) {
                    Seq<StateStoreProviderId> laggingStores;
                    LogLaggingStateStores logLaggingStateStores = (LogLaggingStateStores)A1;
                    UUID queryRunId = logLaggingStateStores.queryRunId();
                    long latestVersion = logLaggingStateStores.latestVersion();
                    boolean isTerminatingTrigger = logLaggingStateStores.isTerminatingTrigger();
                    long currentTimestamp = System.currentTimeMillis();
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag() && (laggingStores = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(queryRunId, latestVersion, currentTimestamp, isTerminatingTrigger)).nonEmpty()) {
                        this.$outer.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"StateStoreCoordinator Snapshot Lag Report for "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_RUN_ID$.MODULE$, (Object)queryRunId)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Number of state stores falling behind: "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_LAGGING_STORES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)laggingStores.size()))})))));
                        long timeSinceLastReport = currentTimestamp - BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().getOrElse((Object)queryRunId, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                        if (timeSinceLastReport > this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$coordinatorLagReportInterval()) {
                            this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().put((Object)queryRunId, (Object)BoxesRunTime.boxToLong((long)currentTimestamp));
                            ((IterableOnceOps)((IterableOps)laggingStores.sortBy((Function1 & Serializable)x$5 -> (SnapshotUploadEvent)$this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().getOrElse(x$5, (Function0 & Serializable)() -> $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent()), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).take(this.$outer.sqlConf().stateStoreCoordinatorMaxLaggingStoresToReport())).foreach((Function1 & Serializable)providerId -> {
                                $anonfun$receiveAndReply$1.$anonfun$applyOrElse$16(this, queryRunId, latestVersion, currentTimestamp, providerId);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLatestSnapshotVersionForTesting) {
                    GetLatestSnapshotVersionForTesting getLatestSnapshotVersionForTesting = (GetLatestSnapshotVersionForTesting)A1;
                    StateStoreProviderId providerId3 = getLatestSnapshotVersionForTesting.providerId();
                    Option version = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId3).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$18(x$6)));
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got latest snapshot version of the state store " + providerId3 + ": " + version);
                    this.context$1.reply((Object)version);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLaggingStoresForTesting) {
                    GetLaggingStoresForTesting getLaggingStoresForTesting = (GetLaggingStoresForTesting)A1;
                    UUID queryRunId = getLaggingStoresForTesting.queryRunId();
                    long latestVersion = getLaggingStoresForTesting.latestVersion();
                    boolean isTerminatingTrigger = getLaggingStoresForTesting.isTerminatingTrigger();
                    long currentTimestamp = System.currentTimeMillis();
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag()) {
                        Seq<StateStoreProviderId> laggingStores = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(queryRunId, latestVersion, currentTimestamp, isTerminatingTrigger);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got lagging state stores: " + laggingStores.mkString(", "));
                        this.context$1.reply(laggingStores);
                        return (B1)BoxedUnit.UNIT;
                    }
                    this.context$1.reply((Object)package$.MODULE$.Seq().empty());
                    return (B1)BoxedUnit.UNIT;
                }
                if (StopCoordinator$.MODULE$.equals(A1)) {
                    this.$outer.stop();
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "StateStoreCoordinator stopped");
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ReportActiveInstance) {
                    return true;
                }
                if (object instanceof VerifyIfInstanceActive) {
                    return true;
                }
                if (object instanceof GetLocation) {
                    return true;
                }
                if (object instanceof DeactivateInstances) {
                    return true;
                }
                if (object instanceof ReportSnapshotUploaded) {
                    return true;
                }
                if (object instanceof LogLaggingStateStores) {
                    return true;
                }
                if (object instanceof GetLatestSnapshotVersionForTesting) {
                    return true;
                }
                if (object instanceof GetLaggingStoresForTesting) {
                    return true;
                }
                return StopCoordinator$.MODULE$.equals(object);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(ExecutorCacheTaskLocation taskLocation$1, ExecutorCacheTaskLocation x$1) {
                ExecutorCacheTaskLocation executorCacheTaskLocation = x$1;
                ExecutorCacheTaskLocation executorCacheTaskLocation2 = taskLocation$1;
                return executorCacheTaskLocation == null ? executorCacheTaskLocation2 != null : !executorCacheTaskLocation.equals(executorCacheTaskLocation2);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2($anonfun$receiveAndReply$1 $this, ExecutorCacheTaskLocation taskLocation$1, StateStoreProviderId providerId) {
                Option providerLoc = $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)providerId);
                return BoxesRunTime.unboxToBoolean((Object)providerLoc.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$3(taskLocation$1, x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$8(UUID runId$1, StateStoreProviderId x$3) {
                UUID uUID = x$3.queryRunId();
                UUID uUID2 = runId$1;
                return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$11(long version$1, SnapshotUploadEvent x$4) {
                return x$4.version() >= version$1;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$16($anonfun$receiveAndReply$1 $this, UUID queryRunId$1, long latestVersion$1, long currentTimestamp$1, StateStoreProviderId providerId) {
                MessageWithContext messageWithContext;
                MessageWithContext baseLogMessage = $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"StateStoreCoordinator Snapshot Lag Detected for "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_RUN_ID$.MODULE$, (Object)queryRunId$1)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Store ID: ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_ID$.MODULE$, (Object)providerId.storeId())}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(Latest batch ID: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)latestVersion$1))})));
                Option option = $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SnapshotUploadEvent snapshotEvent = (SnapshotUploadEvent)some.value();
                    long versionDelta = latestVersion$1 - snapshotEvent.version();
                    long timeDelta = currentTimestamp$1 - snapshotEvent.timestamp();
                    messageWithContext = baseLogMessage.$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{", "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"latest snapshot: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SNAPSHOT_EVENT$.MODULE$, (Object)snapshotEvent)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version delta: "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SNAPSHOT_EVENT_VERSION_DELTA$.MODULE$, (Object)BoxesRunTime.boxToLong((long)versionDelta))}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time delta: ", "ms)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SNAPSHOT_EVENT_TIME_DELTA$.MODULE$, (Object)BoxesRunTime.boxToLong((long)timeDelta))})));
                } else if (None$.MODULE$.equals(option)) {
                    messageWithContext = baseLogMessage.$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{", latest snapshot: no upload for query run)"}))).log((Seq)Nil$.MODULE$));
                } else {
                    throw new MatchError((Object)option);
                }
                MessageWithContext logMessage = messageWithContext;
                $this.$outer.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMessage));
            }

            public static final /* synthetic */ long $anonfun$applyOrElse$18(SnapshotUploadEvent x$6) {
                return x$6.version();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.context$1 = context$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId java.lang.String ), $anonfun$applyOrElse$10(long org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$11$adapted(long org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent ), $anonfun$applyOrElse$12(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 java.util.UUID scala.collection.immutable.Seq ), $anonfun$applyOrElse$13(), $anonfun$applyOrElse$14(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$15(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 ), $anonfun$applyOrElse$16$adapted(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 java.util.UUID long long org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$17(org.apache.spark.internal.MessageWithContext ), $anonfun$applyOrElse$18$adapted(org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent ), $anonfun$applyOrElse$19(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId scala.Option ), $anonfun$applyOrElse$2$adapted(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 org.apache.spark.scheduler.ExecutorCacheTaskLocation org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$20(scala.collection.immutable.Seq ), $anonfun$applyOrElse$21(), $anonfun$applyOrElse$3$adapted(org.apache.spark.scheduler.ExecutorCacheTaskLocation org.apache.spark.scheduler.ExecutorCacheTaskLocation ), $anonfun$applyOrElse$4(), $anonfun$applyOrElse$5(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId boolean ), $anonfun$applyOrElse$6(org.apache.spark.scheduler.ExecutorCacheTaskLocation ), $anonfun$applyOrElse$7(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId scala.Option ), $anonfun$applyOrElse$8$adapted(java.util.UUID org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$9(java.util.UUID scala.collection.immutable.Seq )}, serializedLambda);
            }
        };
    }

    public Seq<StateStoreProviderId> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(UUID queryRunId, long referenceVersion, long referenceTimestamp, boolean isTerminatingTrigger) {
        long snapshotVersionDeltaMultiplier = this.sqlConf().stateStoreCoordinatorMultiplierForMinVersionDiffToLog();
        long maintenanceIntervalMultiplier = this.sqlConf().stateStoreCoordinatorMultiplierForMinTimeDiffToLog();
        int minDeltasForSnapshot = this.sqlConf().stateStoreMinDeltasForSnapshot();
        long maintenanceInterval = this.sqlConf().streamingMaintenanceInterval();
        long minVersionDeltaForLogging = snapshotVersionDeltaMultiplier * (long)minDeltasForSnapshot;
        long minTimeDeltaForLogging = maintenanceIntervalMultiplier * maintenanceInterval;
        return ((IterableOnceOps)((IterableOps)this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().view().keys().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StateStoreCoordinator.$anonfun$findLaggingStores$1(queryRunId, x$7)))).filter((Function1 & Serializable)storeProviderId -> BoxesRunTime.boxToBoolean((boolean)StateStoreCoordinator.$anonfun$findLaggingStores$2(this, referenceVersion, minVersionDeltaForLogging, referenceTimestamp, minTimeDeltaForLogging, isTerminatingTrigger, storeProviderId)))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$findLaggingStores$1(UUID queryRunId$2, StateStoreProviderId x$7) {
        UUID uUID = x$7.queryRunId();
        UUID uUID2 = queryRunId$2;
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findLaggingStores$2(StateStoreCoordinator $this, long referenceVersion$1, long minVersionDeltaForLogging$1, long referenceTimestamp$1, long minTimeDeltaForLogging$1, boolean isTerminatingTrigger$1, StateStoreProviderId storeProviderId) {
        SnapshotUploadEvent latestSnapshot = (SnapshotUploadEvent)$this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().getOrElse((Object)storeProviderId, (Function0 & Serializable)() -> $this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent());
        boolean isBehindOnVersions = referenceVersion$1 - latestSnapshot.version() > minVersionDeltaForLogging$1;
        boolean isBehindOnTime = referenceTimestamp$1 - latestSnapshot.timestamp() > minTimeDeltaForLogging$1;
        return isBehindOnVersions && (isTerminatingTrigger$1 || isBehindOnTime);
    }

    public StateStoreCoordinator(RpcEnv rpcEnv, SQLConf sqlConf) {
        this.rpcEnv = rpcEnv;
        this.sqlConf = sqlConf;
        RpcEndpoint.$init$((RpcEndpoint)this);
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent = new SnapshotUploadEvent(0L, 0L);
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs = new HashMap();
    }
}

