/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.streaming.WriteToStreamStatement;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.StreamingQuery;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.AsyncProgressTrackingMicroBatchExecution;
import org.apache.spark.sql.execution.streaming.AsyncProgressTrackingMicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r\u0005c\u0001\u0002\u0015*\u0001QB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"11\n\u0001C\u0001W1C\u0001\u0002\u0015\u0001C\u0002\u0013\u00051&\u0015\u0005\u00077\u0002\u0001\u000b\u0011\u0002*\t\u000fq\u0003!\u0019!C\u0005;\"1!\r\u0001Q\u0001\nyCqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004{\u0001\u0001\u0006I!\u001a\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"!\t\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003'A\u0001\"!\n\u0001A\u0003%\u0011Q\u0003\u0005\f\u0003O\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0003C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0002bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003WAq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005]\u0003\u0001\"\u0001\u0002`!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBA=\u0001\u0011\u0005\u00111\u0018\u0005\b\u00033\u0004A\u0011AA>\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!!;\u0001\t\u0003\tY\u000fC\u0004\u0002p\u0002!\t!!=\t\u0011\u0005U\b\u0001\"\u0001,\u0003oDqAa\u0003\u0001\t\u0013\u0011i\u0001C\u0004\u0003\u001a\u0001!IAa\u0007\t\u0013\tU\u0006!%A\u0005\n\t]\u0006\"\u0003Bf\u0001E\u0005I\u0011\u0002Bg\u0011!\u0011\t\u000e\u0001C\u0001W\tM\u0007BCB\b\u0001E\u0005I\u0011A\u0016\u0004\u0012!Q1Q\u0003\u0001\u0012\u0002\u0013\u00051f!\u0005\t\u0015\r]\u0001!%A\u0005\u0002-\u001aI\u0002\u0003\u0006\u0004\u001e\u0001\t\n\u0011\"\u0001,\u0007?A!ba\t\u0001#\u0003%\ta\u000bB\\\u0011)\u0019)\u0003AI\u0001\n\u0003Y#Q\u001a\u0005\t\u0007O\u0001A\u0011A\u0016\u0004*!91q\u0006\u0001\u0005\n\rE\"!F*ue\u0016\fW.\u001b8h#V,'/_'b]\u0006<WM\u001d\u0006\u0003U-\nqa\u00197bgNL7M\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ki\u0002\"AN\u001d\u000e\u0003]R!\u0001O\u0016\u0002\u0013M$(/Z1nS:<\u0017B\u0001\u00158!\tYd(D\u0001=\u0015\tiT&\u0001\u0005j]R,'O\\1m\u0013\tyDHA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\t\u001bU\"A\u0015\n\u0005\u0011K#\u0001D*qCJ\\7+Z:tS>t\u0017aB:rY\u000e{gN\u001a\t\u0003\u000f&k\u0011\u0001\u0013\u0006\u0003{-J!A\u0013%\u0003\u000fM\u000bFjQ8oM\u00061A(\u001b8jiz\"2!\u0014(P!\t\u0011\u0005\u0001C\u0003A\u0007\u0001\u0007\u0011\tC\u0003F\u0007\u0001\u0007a)A\u000bti\u0006$Xm\u0015;pe\u0016\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003I\u0003\"aU-\u000e\u0003QS!!\u0016,\u0002\u000bM$\u0018\r^3\u000b\u0005a:&B\u0001-,\u0003%)\u00070Z2vi&|g.\u0003\u0002[)\nA2\u000b^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014(+\u001a4\u0002-M$\u0018\r^3Ti>\u0014XmQ8pe\u0012Lg.\u0019;pe\u0002\n1\u0002\\5ti\u0016tWM\u001d\"vgV\ta\f\u0005\u0002`A6\ta+\u0003\u0002b-\nI2\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'OQ;t\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u00035\t7\r^5wKF+XM]5fgV\tQ\r\u0005\u0003g[><X\"A4\u000b\u0005!L\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003U.\f!bY8mY\u0016\u001cG/[8o\u0015\u0005a\u0017!B:dC2\f\u0017B\u00018h\u0005\u001dA\u0015m\u001d5NCB\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\tU$\u0018\u000e\u001c\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018O\u0001\u0003V+&#\u0005C\u0001\"y\u0013\tI\u0018F\u0001\bTiJ,\u0017-\\5oOF+XM]=\u0002\u001d\u0005\u001cG/\u001b<f#V,'/[3tA!2\u0011\u0002`A\u0007\u0003\u001f\u00012!`A\u0005\u001b\u0005q(bA@\u0002\u0002\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0011QA\u0001\u000bC:tw\u000e^1uS>t'BAA\u0004\u0003\u0015Q\u0017M^1y\u0013\r\tYA \u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f#!!\u0005\u0002/\u0005\u001cG/\u001b<f#V,'/[3t'\"\f'/\u001a3M_\u000e\\WCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eg\u0006!A.\u00198h\u0013\u0011\ty\"!\u0007\u0003\r=\u0013'.Z2u\u0003a\t7\r^5wKF+XM]5fgNC\u0017M]3e\u0019>\u001c7\u000eI\u0001\u0015C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:dunY6\u0002+\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>tGj\\2lA\u0005aB.Y:u)\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0016C8-\u001a9uS>tWCAA\u0016!\u0019\ti#a\f\u000245\t1.C\u0002\u00022-\u0014aa\u00149uS>t\u0007c\u0001\u001c\u00026%\u0019\u0011qG\u001c\u0003/M#(/Z1nS:<\u0017+^3ss\u0016C8-\u001a9uS>t\u0017\u0001\t7bgR$VM]7j]\u0006$X\rZ)vKJLX\t_2faRLwN\\0%KF$B!!\u0010\u0002DA!\u0011QFA \u0013\r\t\te\u001b\u0002\u0005+:LG\u000fC\u0005\u0002F=\t\t\u00111\u0001\u0002,\u0005\u0019\u0001\u0010J\u0019\u0002;1\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]\u0002Bc\u0001\u0005?\u0002\u000e\u0005-\u0013EAA\u0012\u0003\u0019\t7\r^5wKV\u0011\u0011\u0011\u000b\t\u0006\u0003[\t\u0019f^\u0005\u0004\u0003+Z'!B!se\u0006L\u0018aA4fiR\u0019q/a\u0017\t\r\u0005u#\u00031\u0001p\u0003\tIG\rF\u0002x\u0003CBq!!\u0018\u0014\u0001\u0004\t\u0019\u0007\u0005\u0003\u0002f\u0005Md\u0002BA4\u0003_\u00022!!\u001bl\u001b\t\tYGC\u0002\u0002nM\na\u0001\u0010:p_Rt\u0014bAA9W\u00061\u0001K]3eK\u001aLA!!\u001e\u0002x\t11\u000b\u001e:j]\u001eT1!!\u001dl\u0003M\tw/Y5u\u0003:LH+\u001a:nS:\fG/[8o)\t\ti\u0004K\u0003\u0015\u0003\u007f\n)\t\u0005\u0004\u0002.\u0005\u0005\u00151G\u0005\u0004\u0003\u0007['A\u0002;ie><8/M\u0004\u001f\u0003G\n9)!/2\u0013\r\nI)!%\u00020\u0006MU\u0003BAF\u0003\u001b+\"!a\u0019\u0005\u000f\u0005=5G1\u0001\u0002\u001a\n\tA+\u0003\u0003\u0002\u0014\u0006U\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\u0018.\fa\u0001\u001e5s_^\u001c\u0018\u0003BAN\u0003C\u0003B!!\f\u0002\u001e&\u0019\u0011qT6\u0003\u000f9{G\u000f[5oOB!\u00111UAU\u001d\u0011\ti#!*\n\u0007\u0005\u001d6.A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0016Q\u0016\u0002\n)\"\u0014xn^1cY\u0016T1!a*lc%\u0019\u0013\u0011WAZ\u0003k\u000b9J\u0004\u0003\u0002.\u0005M\u0016bAALWF2!%!\fl\u0003o\u0013Qa]2bY\u0006\f4AJA\u001a)\u0011\ti,a1\u0011\t\u00055\u0012qX\u0005\u0004\u0003\u0003\\'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000b,\u0002\u0019AAd\u0003%!\u0018.\\3pkRl5\u000f\u0005\u0003\u0002.\u0005%\u0017bAAfW\n!Aj\u001c8hQ\u0015)\u0012qPAhc\u001dq\u00121MAi\u0003/\f\u0014bIAE\u0003#\u000b\u0019.a%2\u0013\r\n\t,a-\u0002V\u0006]\u0015G\u0002\u0012\u0002.-\f9,M\u0002'\u0003g\tqB]3tKR$VM]7j]\u0006$X\rZ\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0003\u0002>\u0005}\u0007bBAq/\u0001\u0007\u00111]\u0001\tY&\u001cH/\u001a8feB\u0019a'!:\n\u0007\u0005\u001dxG\u0001\fTiJ,\u0017-\\5oOF+XM]=MSN$XM\\3s\u00039\u0011X-\\8wK2K7\u000f^3oKJ$B!!\u0010\u0002n\"9\u0011\u0011\u001d\rA\u0002\u0005\r\u0018!\u00047jgRd\u0015n\u001d;f]\u0016\u00148\u000f\u0006\u0002\u0002tB1\u0011QFA*\u0003G\f\u0011\u0003]8ti2K7\u000f^3oKJ,e/\u001a8u)\u0011\ti$!?\t\u000f\u0005m(\u00041\u0001\u0002~\u0006)QM^3oiB!\u0011q B\u0003\u001d\r1$\u0011A\u0005\u0004\u0005\u00079\u0014AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\n\t\t\u001d!\u0011\u0002\u0002\u0006\u000bZ,g\u000e\u001e\u0006\u0004\u0005\u00079\u0014\u0001G;tK\u0006\u001b\u0018P\\2Qe><'/Z:t)J\f7m[5oOR!\u0011Q\u0018B\b\u0011\u001d\u0011\tb\u0007a\u0001\u0005'\tA\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0002\"!\u001a\u0003\u0016\u0005\r\u00141M\u0005\u0005\u0005/\t9HA\u0002NCB\f1b\u0019:fCR,\u0017+^3ssRQ\"Q\u0004B\u0012\u0005S\u0011iC!\u0013\u0003L\t}#\u0011\u000eB7\u0005c\u0012YH!#\u0003\"B\u0019qLa\b\n\u0007\t\u0005bKA\u000bTiJ,\u0017-\\5oOF+XM]=Xe\u0006\u0004\b/\u001a:\t\u000f\t\u0015B\u00041\u0001\u0003(\u0005\tRo]3s'B,7-\u001b4jK\u0012t\u0015-\\3\u0011\r\u00055\u0012qFA2\u0011\u001d\u0011Y\u0003\ba\u0001\u0005O\tq$^:feN\u0003XmY5gS\u0016$7\t[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011\u001d\u0011y\u0003\ba\u0001\u0005c\t!\u0001\u001a41\t\tM\"Q\b\t\u0006\u0005\nU\"\u0011H\u0005\u0004\u0005oI#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0005w\u0011i\u0004\u0004\u0001\u0005\u0019\t}\"QFA\u0001\u0002\u0003\u0015\tA!\u0011\u0003\u0007}#\u0013'\u0005\u0003\u0002\u001c\n\r\u0003\u0003BA\u0017\u0005\u000bJ1Aa\u0012l\u0005\r\te.\u001f\u0005\b\u0005#a\u0002\u0019\u0001B\n\u0011\u001d\u0011i\u0005\ba\u0001\u0005\u001f\nAa]5oWB!!\u0011\u000bB.\u001b\t\u0011\u0019F\u0003\u0003\u0003V\t]\u0013aB2bi\u0006dwn\u001a\u0006\u0004\u00053Z\u0013!C2p]:,7\r^8s\u0013\u0011\u0011iFa\u0015\u0003\u000bQ\u000b'\r\\3\t\u000f\t\u0005D\u00041\u0001\u0003d\u0005Qq.\u001e;qkRlu\u000eZ3\u0011\u0007Y\u0012)'C\u0002\u0003h]\u0012!bT;uaV$Xj\u001c3f\u0011\u001d\u0011Y\u0007\ba\u0001\u0003{\u000b\u0011$^:f)\u0016l\u0007o\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"9!q\u000e\u000fA\u0002\u0005u\u0016!\b:fG>4XM\u001d$s_6\u001c\u0005.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000f\tMD\u00041\u0001\u0003v\u00059AO]5hO\u0016\u0014\bc\u0001\u001c\u0003x%\u0019!\u0011P\u001c\u0003\u000fQ\u0013\u0018nZ4fe\"9!Q\u0010\u000fA\u0002\t}\u0014\u0001\u0004;sS\u001e<WM]\"m_\u000e\\\u0007\u0003\u0002BA\u0005\u000bk!Aa!\u000b\u0005Il\u0013\u0002\u0002BD\u0005\u0007\u0013Qa\u00117pG.D\u0011Ba#\u001d!\u0003\u0005\rA!$\u0002\u001f\r\fG/\u00197pO\u0006sG-\u00133f]R\u0004b!!\f\u00020\t=\u0005\u0003CA\u0017\u0005#\u0013)Ja'\n\u0007\tM5N\u0001\u0004UkBdWM\r\t\u0005\u0005#\u00129*\u0003\u0003\u0003\u001a\nM#\u0001\u0004+bE2,7)\u0019;bY><\u0007\u0003\u0002B)\u0005;KAAa(\u0003T\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u0013\t\rF\u0004%AA\u0002\t\u0015\u0016\u0001D2bi\u0006dwn\u001a+bE2,\u0007CBA\u0017\u0003_\u00119\u000b\u0005\u0003\u0003*\nEVB\u0001BV\u0015\u0011\u0011)F!,\u000b\u0007\t=6&\u0001\u0005dCR\fG._:u\u0013\u0011\u0011\u0019La+\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\u0002-\r\u0014X-\u0019;f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%cE*\"A!/+\t\t5%1X\u0016\u0003\u0005{\u0003BAa0\u0003H6\u0011!\u0011\u0019\u0006\u0005\u0005\u0007\u0014)-A\u0005v]\u000eDWmY6fI*\u0019\u00111A6\n\t\t%'\u0011\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AF2sK\u0006$X-U;fef$C-\u001a4bk2$H%\r\u001a\u0016\u0005\t='\u0006\u0002BS\u0005w\u000b!b\u001d;beR\fV/\u001a:z)e9(Q\u001bBl\u00053\u0014)Oa:\u0003j\n-(Q\u001eBx\u0005c\u0014\u0019P!>\t\u000f\t\u0015r\u00041\u0001\u0003(!9!1F\u0010A\u0002\t\u001d\u0002b\u0002B\u0018?\u0001\u0007!1\u001c\u0019\u0005\u0005;\u0014\t\u000fE\u0003C\u0005k\u0011y\u000e\u0005\u0003\u0003<\t\u0005H\u0001\u0004Br\u00053\f\t\u0011!A\u0003\u0002\t\u0005#aA0%e!9!\u0011C\u0010A\u0002\tM\u0001b\u0002B'?\u0001\u0007!q\n\u0005\b\u0005Cz\u0002\u0019\u0001B2\u0011%\u0011Yg\bI\u0001\u0002\u0004\ti\fC\u0005\u0003p}\u0001\n\u00111\u0001\u0002>\"I!1O\u0010\u0011\u0002\u0003\u0007!Q\u000f\u0005\n\u0005{z\u0002\u0013!a\u0001\u0005\u007fB\u0011Ba# !\u0003\u0005\rA!$\t\u0013\t\rv\u0004%AA\u0002\t\u0015\u0006&B\u0010\u0003z\u000e\u0015\u0001CBA\u0017\u0003\u0003\u0013Y\u0010\u0005\u0003\u0003~\u000e\u0005QB\u0001B\u0000\u0015\ty\u0018/\u0003\u0003\u0004\u0004\t}(\u0001\u0005+j[\u0016|W\u000f^#yG\u0016\u0004H/[8oc\u001dq\u00121MB\u0004\u0007\u001b\t\u0014bIAE\u0003#\u001bI!a%2\u0013\r\n\t,a-\u0004\f\u0005]\u0015G\u0002\u0012\u0002.-\f9,M\u0002'\u0005w\fAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012:TCAB\nU\u0011\tiLa/\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u001111\u0004\u0016\u0005\u0005k\u0012Y,A\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%\r\u0019\u0016\u0005\r\u0005\"\u0006\u0002B@\u0005w\u000bQc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012\n\u0014'A\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%\r\u001a\u0002-9|G/\u001b4z#V,'/\u001f+fe6Lg.\u0019;j_:$B!!\u0010\u0004,!11Q\u0006\u0014A\u0002]\fq\u0002^3s[&t\u0017\r^3e#V,'/_\u0001\u001bk:\u0014XmZ5ti\u0016\u0014H+\u001a:nS:\fG/\u001a3TiJ,\u0017-\u001c\u000b\u0005\u0003{\u0019\u0019\u0004\u0003\u0004\u0004.\u001d\u0002\ra\u001e\u0015\u0004\u0001\r]\u0002\u0003BB\u001d\u0007{i!aa\u000f\u000b\u0007\u0005\rQ&\u0003\u0003\u0004@\rm\"\u0001C#w_24\u0018N\\4")
public class StreamingQueryManager
extends org.apache.spark.sql.streaming.StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final SQLConf sqlConf;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private Option<StreamingQueryException> lastTerminatedQueryException;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private Option<StreamingQueryException> lastTerminatedQueryException() {
        return this.lastTerminatedQueryException;
    }

    private void lastTerminatedQueryException_$eq(Option<StreamingQueryException> x$1) {
        this.lastTerminatedQueryException = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
            bl = this.lastTerminatedQueryException() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQueryException_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])CollectionConverters$.MODULE$.ListHasAsScala(this.listenerBus().listeners()).asScala().toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    private boolean useAsyncProgressTracking(scala.collection.immutable.Map<String, String> extraOptions) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)extraOptions.getOrElse((Object)AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_ENABLED(), (Function0 & Serializable)() -> "false")));
    }

    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<?> df, scala.collection.immutable.Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        WriteToStreamStatement dataStreamWritePlan = new WriteToStreamStatement(userSpecifiedName, userSpecifiedCheckpointLocation, useTempCheckpointLocation, recoverFromCheckpointLocation, sink, outputMode, df.sparkSession().sessionState().newHadoopConf(), trigger instanceof ContinuousTrigger, analyzedPlan, catalogAndIdent, catalogTable);
        WriteToStream analyzedStreamWritePlan = (WriteToStream)this.sparkSession.sessionState().executePlan((LogicalPlan)dataStreamWritePlan, this.sparkSession.sessionState().executePlan$default$2()).analyzed();
        Tuple2 tuple2 = new Tuple2((Object)sink, (Object)trigger);
        if (tuple2 != null) {
            Trigger trigger2 = (Trigger)tuple2._2();
            if (tuple2._1() instanceof SupportsWrite && trigger2 instanceof ContinuousTrigger) {
                ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
                return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (Trigger)continuousTrigger, triggerClock, extraOptions, analyzedStreamWritePlan));
            }
        }
        MicroBatchExecution microBatchExecution = this.useAsyncProgressTracking(extraOptions) ? new AsyncProgressTrackingMicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan) : new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan);
        return new StreamingQueryWrapper(microBatchExecution);
    }

    private Option<Tuple2<TableCatalog, Identifier>> createQuery$default$11() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> createQuery$default$12() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<?> df, scala.collection.immutable.Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock, catalogAndIdent, catalogTable);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException("Cannot start query with id " + query.id() + " as another query with same id is already active. Perhaps you are attempting to restart a query from checkpoint that is already active. You may stop the old query by setting the SQL configuration: spark.conf.set(\"" + SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key() + "\", true) and retry.");
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping existing streaming query [id=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_ID$.MODULE$, (Object)query.id())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"runId=", "], as a new run is being started."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RUN_ID$.MODULE$, (Object)oldQuery.runId())})))));
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable)x$3 -> {
            x$3.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw QueryExecutionErrors$.MODULE$.concurrentQueryInstanceError();
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime((long)0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public Option<Tuple2<TableCatalog, Identifier>> startQuery$default$11() {
        return None$.MODULE$;
    }

    public Option<CatalogTable> startQuery$default$12() {
        return None$.MODULE$;
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQueryException() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQueryException_$eq((Option<StreamingQueryException>)terminatedQuery.exception());
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            HashMap cfr_ignored_0 = (HashMap)this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Registered listener ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)listener.getClass().getName())}))));
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$2) {
        String string = x$2.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$2)))) {
            throw new IllegalArgumentException("Cannot start query with name " + name + " as a query with that name is already active in this SparkSession");
        }
    }

    public StreamingQueryManager(SparkSession sparkSession, SQLConf sqlConf) {
        this.sparkSession = sparkSession;
        this.sqlConf = sqlConf;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env(), sqlConf);
        this.listenerBus = new StreamingQueryListenerBus((Option<LiveListenerBus>)new Some((Object)sparkSession.sparkContext().listenerBus()));
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable)classNames -> {
                SQLConf$.MODULE$.withExistingConf(this.sqlConf, (Function0)(JFunction0.mcV.sp & Serializable)() -> Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable)listener -> {
                    StreamingQueryManager.$anonfun$new$3($this, listener);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().streamingQueryStatusListener().foreach((Function1 & Serializable)listener -> {
                this.addListener(listener);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw QueryExecutionErrors$.MODULE$.registeringStreamingQueryListenerError(e);
        }
    }
}

