/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.util.CacheNode;
import org.apache.hadoop.yarn.util.LRUCacheHashMap;

public class LRUCache<K, V> {
    private final long expireTimeMs;
    private final Map<K, CacheNode<V>> cache;

    public LRUCache(int capacity) {
        this(capacity, -1L);
    }

    public LRUCache(int capacity, long expireTimeMs) {
        this.cache = new LRUCacheHashMap<K, CacheNode<V>>(capacity, true);
        this.expireTimeMs = expireTimeMs;
    }

    public synchronized V get(K key) {
        CacheNode<V> cacheNode = this.cache.get(key);
        if (cacheNode != null && this.expireTimeMs > 0L && Time.now() > cacheNode.getCacheTime() + this.expireTimeMs) {
            this.cache.remove(key);
            return null;
        }
        return cacheNode == null ? null : (V)cacheNode.get();
    }

    public synchronized V put(K key, V value) {
        this.cache.put(key, new CacheNode<V>(value));
        return value;
    }

    @VisibleForTesting
    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }
}

