/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.text.DecimalFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.util.Quantile;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableInverseQuantiles
extends MutableQuantiles {
    @VisibleForTesting
    public static final Quantile[] INVERSE_QUANTILES = new Quantile[]{new InversePercentile(50.0), new InversePercentile(25.0), new InversePercentile(10.0), new InversePercentile(5.0), new InversePercentile(1.0)};

    public MutableInverseQuantiles(String name, String description, String sampleName, String valueName, int intervalSecs) {
        super(name, description, sampleName, valueName, intervalSecs);
    }

    @Override
    void setQuantiles(String ucName, String uvName, String desc, String lvName, DecimalFormat df) {
        for (int i = 0; i < INVERSE_QUANTILES.length; ++i) {
            double inversePercentile = 100.0 * (1.0 - MutableInverseQuantiles.INVERSE_QUANTILES[i].quantile);
            String nameTemplate = ucName + df.format(inversePercentile) + "thInversePercentile" + uvName;
            String descTemplate = df.format(inversePercentile) + " inverse percentile " + lvName + " with " + this.getInterval() + " second interval for " + desc;
            this.addQuantileInfo(i, Interns.info(nameTemplate, descTemplate));
        }
    }

    @Override
    public synchronized Quantile[] getQuantiles() {
        return INVERSE_QUANTILES;
    }

    static class InversePercentile
    extends Quantile {
        InversePercentile(double inversePercentile) {
            super(inversePercentile / 100.0, inversePercentile / 1000.0);
        }
    }
}

