/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.DecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
class ByteBufferDecodingState
extends DecodingState {
    ByteBuffer[] inputs;
    ByteBuffer[] outputs;
    int[] erasedIndexes;
    boolean usingDirectBuffer;

    ByteBufferDecodingState(RawErasureDecoder decoder, ByteBuffer[] inputs, int[] erasedIndexes, ByteBuffer[] outputs) {
        this.decoder = decoder;
        this.inputs = inputs;
        this.outputs = outputs;
        this.erasedIndexes = erasedIndexes;
        ByteBuffer validInput = CoderUtil.findFirstValidInput(inputs);
        this.decodeLength = validInput.remaining();
        this.usingDirectBuffer = validInput.isDirect();
        this.checkParameters(inputs, erasedIndexes, outputs);
        this.checkInputBuffers(inputs);
        this.checkOutputBuffers(outputs);
    }

    ByteBufferDecodingState(RawErasureDecoder decoder, int decodeLength, int[] erasedIndexes, ByteBuffer[] inputs, ByteBuffer[] outputs) {
        this.decoder = decoder;
        this.decodeLength = decodeLength;
        this.erasedIndexes = erasedIndexes;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    ByteArrayDecodingState convertToByteArrayState() {
        ByteBuffer buffer;
        int i;
        int[] inputOffsets = new int[this.inputs.length];
        int[] outputOffsets = new int[this.outputs.length];
        byte[][] newInputs = new byte[this.inputs.length][];
        byte[][] newOutputs = new byte[this.outputs.length][];
        for (i = 0; i < this.inputs.length; ++i) {
            buffer = this.inputs[i];
            if (buffer == null) continue;
            inputOffsets[i] = buffer.arrayOffset() + buffer.position();
            newInputs[i] = buffer.array();
        }
        for (i = 0; i < this.outputs.length; ++i) {
            buffer = this.outputs[i];
            outputOffsets[i] = buffer.arrayOffset() + buffer.position();
            newOutputs[i] = buffer.array();
        }
        ByteArrayDecodingState baeState = new ByteArrayDecodingState(this.decoder, this.decodeLength, this.erasedIndexes, newInputs, inputOffsets, newOutputs, outputOffsets);
        return baeState;
    }

    void checkInputBuffers(ByteBuffer[] buffers) {
        int validInputs = 0;
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            if (buffer.remaining() != this.decodeLength) {
                throw new HadoopIllegalArgumentException("Invalid buffer, not of length " + this.decodeLength);
            }
            if (buffer.isDirect() != this.usingDirectBuffer) {
                throw new HadoopIllegalArgumentException("Invalid buffer, isDirect should be " + this.usingDirectBuffer);
            }
            ++validInputs;
        }
        if (validInputs < this.decoder.getNumDataUnits()) {
            throw new HadoopIllegalArgumentException("No enough valid inputs are provided, not recoverable");
        }
    }

    void checkOutputBuffers(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) {
                throw new HadoopIllegalArgumentException("Invalid buffer found, not allowing null");
            }
            if (buffer.remaining() != this.decodeLength) {
                throw new HadoopIllegalArgumentException("Invalid buffer, not of length " + this.decodeLength);
            }
            if (buffer.isDirect() == this.usingDirectBuffer) continue;
            throw new HadoopIllegalArgumentException("Invalid buffer, isDirect should be " + this.usingDirectBuffer);
        }
    }
}

