/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.handler.StatisticsHandler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Metrics(name="HttpServer2", about="HttpServer2 metrics", context="http")
public class HttpServer2Metrics {
    private final StatisticsHandler handler;
    private final int port;

    @Metric(value={"number of requested that have been asynchronously dispatched"})
    public int asyncDispatches() {
        return this.handler.getAsyncDispatches();
    }

    @Metric(value={"total number of async requests"})
    public int asyncRequests() {
        return this.handler.getAsyncRequests();
    }

    @Metric(value={"currently waiting async requests"})
    public int asyncRequestsWaiting() {
        return this.handler.getAsyncRequestsWaiting();
    }

    @Metric(value={"maximum number of waiting async requests"})
    public int asyncRequestsWaitingMax() {
        return this.handler.getAsyncRequestsWaitingMax();
    }

    @Metric(value={"number of dispatches"})
    public int dispatched() {
        return this.handler.getDispatched();
    }

    @Metric(value={"number of dispatches currently active"})
    public int dispatchedActive() {
        return this.handler.getDispatchedActive();
    }

    @Metric(value={"maximum number of active dispatches being handled"})
    public int dispatchedActiveMax() {
        return this.handler.getDispatchedActiveMax();
    }

    @Metric(value={"maximum time spend in dispatch handling (in ms)"})
    public long dispatchedTimeMax() {
        return this.handler.getDispatchedTimeMax();
    }

    @Metric(value={"mean time spent in dispatch handling (in ms)"})
    public double dispatchedTimeMean() {
        return this.handler.getDispatchedTimeMean();
    }

    @Metric(value={"standard deviation for dispatch handling (in ms)"})
    public double dispatchedTimeStdDev() {
        return this.handler.getDispatchedTimeStdDev();
    }

    @Metric(value={"total time spent in dispatch handling (in ms)"})
    public long dispatchedTimeTotal() {
        return this.handler.getDispatchedTimeTotal();
    }

    @Metric(value={"number of async requests requests that have expired"})
    public int expires() {
        return this.handler.getExpires();
    }

    @Metric(value={"number of requests"})
    public int requests() {
        return this.handler.getRequests();
    }

    @Metric(value={"number of requests currently active"})
    public int requestsActive() {
        return this.handler.getRequestsActive();
    }

    @Metric(value={"maximum number of active requests"})
    public int requestsActiveMax() {
        return this.handler.getRequestsActiveMax();
    }

    @Metric(value={"maximum time spend handling requests (in ms)"})
    public long requestTimeMax() {
        return this.handler.getRequestTimeMax();
    }

    @Metric(value={"mean time spent handling requests (in ms)"})
    public double requestTimeMean() {
        return this.handler.getRequestTimeMean();
    }

    @Metric(value={"standard deviation for request handling (in ms)"})
    public double requestTimeStdDev() {
        return this.handler.getRequestTimeStdDev();
    }

    @Metric(value={"total time spend in all request handling (in ms)"})
    public long requestTimeTotal() {
        return this.handler.getRequestTimeTotal();
    }

    @Metric(value={"number of requests with 1xx response status"})
    public int responses1xx() {
        return this.handler.getResponses1xx();
    }

    @Metric(value={"number of requests with 2xx response status"})
    public int responses2xx() {
        return this.handler.getResponses2xx();
    }

    @Metric(value={"number of requests with 3xx response status"})
    public int responses3xx() {
        return this.handler.getResponses3xx();
    }

    @Metric(value={"number of requests with 4xx response status"})
    public int responses4xx() {
        return this.handler.getResponses4xx();
    }

    @Metric(value={"number of requests with 5xx response status"})
    public int responses5xx() {
        return this.handler.getResponses5xx();
    }

    @Metric(value={"total number of bytes across all responses"})
    public long responsesBytesTotal() {
        return this.handler.getResponsesBytesTotal();
    }

    @Metric(value={"time in milliseconds stats have been collected for"})
    public long statsOnMs() {
        return this.handler.getStatsOnMs();
    }

    HttpServer2Metrics(StatisticsHandler handler, int port) {
        this.handler = handler;
        this.port = port;
    }

    static HttpServer2Metrics create(StatisticsHandler handler, int port) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        HttpServer2Metrics metrics = new HttpServer2Metrics(handler, port);
        metrics.remove();
        return ms.register("HttpServer2-" + port, "HttpServer2 metrics", metrics);
    }

    void remove() {
        DefaultMetricsSystem.removeSourceName("HttpServer2-" + this.port);
    }
}

