/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class NumericHistogram {
    private int nbins = 0;
    private int nusedbins = 0;
    private List<Coord> bins = null;
    private Random prng = new Random(31183L);

    public void reset() {
        this.bins = null;
        this.nusedbins = 0;
        this.nbins = 0;
    }

    public int getNumBins() {
        return this.nbins;
    }

    public int getUsedBins() {
        return this.nusedbins;
    }

    public void setUsedBins(int nusedBins) {
        this.nusedbins = nusedBins;
    }

    public boolean isReady() {
        return this.nbins != 0;
    }

    public Coord getBin(int b) {
        return this.bins.get(b);
    }

    public void addBin(double x, double y, int b) {
        Coord coord = new Coord();
        coord.x = x;
        coord.y = y;
        this.bins.add(b, coord);
    }

    public void allocate(int num_bins) {
        this.nbins = num_bins;
        this.bins = new ArrayList<Coord>();
        this.nusedbins = 0;
    }

    public void merge(NumericHistogram other) {
        if (other == null) {
            return;
        }
        if (this.nbins == 0 || this.nusedbins == 0) {
            this.nbins = other.nbins;
            this.nusedbins = other.nusedbins;
            this.bins = new ArrayList<Coord>(this.nusedbins);
            for (int i = 0; i < other.nusedbins; ++i) {
                Coord bin = new Coord();
                bin.x = other.getBin((int)i).x;
                bin.y = other.getBin((int)i).y;
                this.bins.add(bin);
            }
        } else {
            Coord bin;
            ArrayList<Coord> tmp_bins = new ArrayList<Coord>(this.nusedbins + other.nusedbins);
            for (int i = 0; i < this.nusedbins; ++i) {
                bin = new Coord();
                bin.x = this.bins.get((int)i).x;
                bin.y = this.bins.get((int)i).y;
                tmp_bins.add(bin);
            }
            for (int j = 0; j < other.nusedbins; ++j) {
                bin = new Coord();
                bin.x = other.getBin((int)j).x;
                bin.y = other.getBin((int)j).y;
                tmp_bins.add(bin);
            }
            Collections.sort(tmp_bins);
            this.bins = tmp_bins;
            this.nusedbins += other.nusedbins;
            this.trim();
        }
    }

    public void add(double v) {
        int bin = 0;
        int l = 0;
        int r = this.nusedbins;
        while (l < r) {
            bin = (l + r) / 2;
            if (this.bins.get((int)bin).x > v) {
                r = bin;
                continue;
            }
            if (!(this.bins.get((int)bin).x < v)) break;
            l = ++bin;
        }
        if (bin < this.nusedbins && this.bins.get((int)bin).x == v) {
            this.bins.get((int)bin).y += 1.0;
        } else {
            Coord newBin = new Coord();
            newBin.x = v;
            newBin.y = 1.0;
            this.bins.add(bin, newBin);
            if (++this.nusedbins > this.nbins) {
                this.trim();
            }
        }
    }

    private void trim() {
        while (this.nusedbins > this.nbins) {
            double smallestdiff = this.bins.get((int)1).x - this.bins.get((int)0).x;
            int smallestdiffloc = 0;
            int smallestdiffcount = 1;
            for (int i = 1; i < this.nusedbins - 1; ++i) {
                double diff = this.bins.get((int)(i + 1)).x - this.bins.get((int)i).x;
                if (diff < smallestdiff) {
                    smallestdiff = diff;
                    smallestdiffloc = i;
                    smallestdiffcount = 1;
                    continue;
                }
                if (diff != smallestdiff) continue;
                ++smallestdiffcount;
                if (!(this.prng.nextDouble() <= 1.0 / (double)smallestdiffcount)) continue;
                smallestdiffloc = i;
            }
            double d = this.bins.get((int)smallestdiffloc).y + this.bins.get((int)(smallestdiffloc + 1)).y;
            Coord smallestdiffbin = this.bins.get(smallestdiffloc);
            smallestdiffbin.x *= smallestdiffbin.y / d;
            smallestdiffbin.x += this.bins.get((int)(smallestdiffloc + 1)).x / d * this.bins.get((int)(smallestdiffloc + 1)).y;
            smallestdiffbin.y = d;
            this.bins.remove(smallestdiffloc + 1);
            --this.nusedbins;
        }
    }

    public static class Coord
    implements Comparable<Coord> {
        public double x;
        public double y;

        @Override
        public int compareTo(Coord other) {
            return Double.compare(this.x, other.x);
        }
    }
}

