/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.SparkException;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class Catalogs$ {
    public static final Catalogs$ MODULE$ = new Catalogs$();

    public CatalogPlugin load(String name, SQLConf conf) throws CatalogNotFoundException, SparkException {
        CatalogPlugin catalogPlugin;
        String string;
        try {
            String _pluginClassName = conf.getConfString("spark.sql.catalog." + name);
            if (name.contains(".")) {
                throw QueryExecutionErrors$.MODULE$.invalidCatalogNameError(name);
            }
            string = _pluginClassName;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw QueryExecutionErrors$.MODULE$.catalogNotFoundError(name);
        }
        String pluginClassName = string;
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        try {
            Class<?> pluginClass = loader.loadClass(pluginClassName);
            if (!CatalogPlugin.class.isAssignableFrom(pluginClass)) {
                throw QueryExecutionErrors$.MODULE$.catalogPluginClassNotImplementedError(name, pluginClassName);
            }
            CatalogPlugin plugin = (CatalogPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            plugin.initialize(name, this.catalogOptions(name, conf));
            catalogPlugin = plugin;
        }
        catch (ClassNotFoundException e) {
            throw QueryExecutionErrors$.MODULE$.catalogPluginClassNotFoundForCatalogError(name, pluginClassName, e);
        }
        catch (NoSuchMethodException e) {
            throw QueryExecutionErrors$.MODULE$.catalogFailToFindPublicNoArgConstructorError(name, pluginClassName, e);
        }
        catch (IllegalAccessException e) {
            throw QueryExecutionErrors$.MODULE$.catalogFailToCallPublicNoArgConstructorError(name, pluginClassName, e);
        }
        catch (InstantiationException e) {
            throw QueryExecutionErrors$.MODULE$.cannotInstantiateAbstractCatalogPluginClassError(name, pluginClassName, e);
        }
        catch (InvocationTargetException e) {
            throw QueryExecutionErrors$.MODULE$.failedToInstantiateConstructorForCatalogError(name, pluginClassName, e);
        }
        return catalogPlugin;
    }

    private CaseInsensitiveStringMap catalogOptions(String name, SQLConf conf) {
        Pattern prefix = Pattern.compile("^spark\\.sql\\.catalog\\." + name + "\\.(.+)");
        HashMap<String, String> options = new HashMap<String, String>();
        conf.getAllConfs().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Matcher matcher = prefix.matcher(key);
                if (matcher.matches() && matcher.groupCount() > 0) {
                    return options.put(matcher.group(1), value);
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        return new CaseInsensitiveStringMap(options);
    }

    private Catalogs$() {
    }
}

