/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.xml;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\u000f\u001f\u0001-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")a\t\u0001C\u0001\u000f\"91\n\u0001a\u0001\n\u0013a\u0005b\u0002)\u0001\u0001\u0004%I!\u0015\u0005\u0007/\u0002\u0001\u000b\u0015B'\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0013I\u0006\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%A\u0007\u00011A\u0001B\u0003&!\fC\u0004j\u0001\u0001\u0007I\u0011\u00026\t\u000fM\u0004\u0001\u0019!C\u0005i\"1a\u000f\u0001Q!\n-Dqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004\u007f\u0001\u0001\u0006I!\u001f\u0005\b\u007f\u0002\u0011\r\u0011\"\u0003y\u0011\u001d\t\t\u0001\u0001Q\u0001\neD\u0001\"a\u0001\u0001\u0005\u0004%I\u0001\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003z\u0011!\t9\u0001\u0001b\u0001\n\u0013A\bbBA\u0005\u0001\u0001\u0006I!\u001f\u0005\t\u0003\u0017\u0001!\u0019!C\u0005q\"9\u0011Q\u0002\u0001!\u0002\u0013I\b\u0002CA\b\u0001\t\u0007I\u0011\u0002=\t\u000f\u0005E\u0001\u0001)A\u0005s\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\ty\u0003\u0001C\u0005\u0003c\u0011A\u0002W7m)>\\WM\\5{KJT!a\b\u0011\u0002\u0007alGN\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a7\u001b\u0005!$BA\u001b%\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001c5\u0005\u001daunZ4j]\u001e\f1\"\u001b8qkR\u001cFO]3b[B\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0003S>T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Aw\tY\u0011J\u001c9viN#(/Z1n\u0003\u001dy\u0007\u000f^5p]N\u0004\"a\u0011#\u000e\u0003yI!!\u0012\u0010\u0003\u0015akGn\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011&S\u0005CA\"\u0001\u0011\u0015A4\u00011\u0001:\u0011\u0015\t5\u00011\u0001C\u0003\u0019\u0011X-\u00193feV\tQ\n\u0005\u0002;\u001d&\u0011qj\u000f\u0002\u000f\u0005V4g-\u001a:fIJ+\u0017\rZ3s\u0003)\u0011X-\u00193fe~#S-\u001d\u000b\u0003%V\u0003\"!L*\n\u0005Qs#\u0001B+oSRDqAV\u0003\u0002\u0002\u0003\u0007Q*A\u0002yIE\nqA]3bI\u0016\u0014\b%A\bdkJ\u0014XM\u001c;Ti\u0006\u0014H\u000fV1h+\u0005Q\u0006CA.c\u001d\ta\u0006\r\u0005\u0002^]5\taL\u0003\u0002`U\u00051AH]8pizJ!!\u0019\u0018\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003C:\n1cY;se\u0016tGo\u0015;beR$\u0016mZ0%KF$\"AU4\t\u000fYC\u0011\u0011!a\u00015\u0006\u00012-\u001e:sK:$8\u000b^1siR\u000bw\rI\u0001\u0007EV4g-\u001a:\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u000f5,H/\u00192mK*\u0011\u0001OL\u0001\u000bG>dG.Z2uS>t\u0017B\u0001:n\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\u0006Q!-\u001e4gKJ|F%Z9\u0015\u0005I+\bb\u0002,\f\u0003\u0003\u0005\ra[\u0001\bEV4g-\u001a:!\u0003!\u0019H/\u0019:u)\u0006<W#A=\u0011\u0005ilX\"A>\u000b\u0005ql\u0014\u0001\u00027b]\u001eL!aY>\u0002\u0013M$\u0018M\u001d;UC\u001e\u0004\u0013AB3oIR\u000bw-A\u0004f]\u0012$\u0016m\u001a\u0011\u0002\u0019\r|W.\\3oiN#\u0018M\u001d;\u0002\u001b\r|W.\\3oiN#\u0018M\u001d;!\u0003)\u0019w.\\7f]R,e\u000eZ\u0001\fG>lW.\u001a8u\u000b:$\u0007%\u0001\u0006dI\u0006$\u0018m\u0015;beR\f1b\u00193bi\u0006\u001cF/\u0019:uA\u0005A1\rZ1uC\u0016sG-A\u0005dI\u0006$\u0018-\u00128eA\u0005!a.\u001a=u)\t\t9\u0002\u0005\u0003.\u00033Q\u0016bAA\u000e]\t1q\n\u001d;j_:\faB]3bIVsG/\u001b7NCR\u001c\u0007\u000e\u0006\u0003\u0002\"\u0005\u001d\u0002cA\u0017\u0002$%\u0019\u0011Q\u0005\u0018\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011\u0006\u000eA\u0002i\u000b1!\u001a8e\u0003U\u0011X-\u00193V]RLGn\u0015;beR,E.Z7f]R$\"!!\t\u0002'I,\u0017\rZ+oi&dWI\u001c3FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u00121\u0007\u0005\b\u0003ka\u0002\u0019AA\u0011\u00039\u0019H/\u0019:u)\u0006<7\t\\8tK\u0012\u0004")
public class XmlTokenizer
implements Logging {
    private final XmlOptions options;
    private BufferedReader reader;
    private String currentStartTag;
    private StringBuilder buffer;
    private final String startTag;
    private final String endTag;
    private final String commentStart;
    private final String commentEnd;
    private final String cdataStart;
    private final String cdataEnd;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private BufferedReader reader() {
        return this.reader;
    }

    private void reader_$eq(BufferedReader x$1) {
        this.reader = x$1;
    }

    private String currentStartTag() {
        return this.currentStartTag;
    }

    private void currentStartTag_$eq(String x$1) {
        this.currentStartTag = x$1;
    }

    private StringBuilder buffer() {
        return this.buffer;
    }

    private void buffer_$eq(StringBuilder x$1) {
        this.buffer = x$1;
    }

    private String startTag() {
        return this.startTag;
    }

    private String endTag() {
        return this.endTag;
    }

    private String commentStart() {
        return this.commentStart;
    }

    private String commentEnd() {
        return this.commentEnd;
    }

    private String cdataStart() {
        return this.cdataStart;
    }

    private String cdataEnd() {
        return this.cdataEnd;
    }

    public Option<String> next() {
        None$ nextString;
        block13: {
            nextString = None$.MODULE$;
            try {
                try {
                    if (this.readUntilStartElement()) {
                        this.buffer().append(this.currentStartTag());
                        this.readUntilEndElement(this.currentStartTag().endsWith(">"));
                        nextString = new Some((Object)this.buffer().toString());
                        this.buffer_$eq(new StringBuilder());
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 instanceof FileNotFoundException) {
                        FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable3;
                        if (this.options.ignoreMissingFiles()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipping the rest of the content in the missing file during schema inference", (Throwable)fileNotFoundException);
                            break block13;
                        }
                    }
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        Throwable throwable4 = ExceptionUtils.getRootCause((Throwable)throwable2);
                        if (throwable4 instanceof AccessControlException ? true : throwable4 instanceof BlockMissingException) {
                            this.reader().close();
                            this.reader_$eq(null);
                            throw throwable2;
                        }
                        if (!(throwable4 instanceof RuntimeException ? true : throwable4 instanceof IOException) || !this.options.ignoreCorruptFiles()) {
                            if (throwable4 != null) {
                                Throwable throwable5 = throwable4;
                                this.reader().close();
                                this.reader_$eq(null);
                                throw throwable5;
                            }
                            throw new MatchError((Object)throwable4);
                        }
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipping the rest of the content in the corrupted file during schema inference", throwable2);
                        break block13;
                    }
                    throw throwable;
                }
            }
            finally {
                if (nextString.isEmpty() && this.reader() != null) {
                    this.reader().close();
                    this.reader_$eq(null);
                }
            }
        }
        return nextString;
    }

    private boolean readUntilMatch(String end) {
        int i = 0;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1) {
            char c = (char)cOrEOF;
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(end), i)) {
                if (++i < end.length()) continue;
                return true;
            }
            i = 0;
        }
        return false;
    }

    private boolean readUntilStartElement() {
        this.currentStartTag_$eq(this.startTag());
        int i = 0;
        int commentIdx = 0;
        int cdataIdx = 0;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1) {
            char c = (char)cOrEOF;
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.commentStart()), commentIdx)) {
                if (commentIdx >= this.commentStart().length() - 1) {
                    commentIdx = 0;
                    v0 = BoxesRunTime.boxToBoolean((boolean)this.readUntilMatch(this.commentEnd()));
                } else {
                    ++commentIdx;
                    v0 = BoxedUnit.UNIT;
                }
            } else {
                commentIdx = 0;
                v0 = BoxedUnit.UNIT;
            }
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.cdataStart()), cdataIdx)) {
                if (cdataIdx >= this.cdataStart().length() - 1) {
                    cdataIdx = 0;
                    v1 = BoxesRunTime.boxToBoolean((boolean)this.readUntilMatch(this.cdataEnd()));
                } else {
                    ++cdataIdx;
                    v1 = BoxedUnit.UNIT;
                }
            } else {
                cdataIdx = 0;
                v1 = BoxedUnit.UNIT;
            }
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), i)) {
                if (i >= this.startTag().length() - 1) {
                    return true;
                }
                ++i;
                continue;
            }
            if (i == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                this.currentStartTag_$eq(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(this.startTag()), 1) + c);
                return true;
            }
            i = 0;
        }
        return false;
    }

    private boolean readUntilEndElement(boolean startTagClosed) {
        boolean canSelfClose;
        int si = 0;
        int ei = 0;
        int commentIdx = 0;
        boolean cdataIdx = false;
        int depth = 0;
        int prevC = 0;
        boolean bl = canSelfClose = !startTagClosed;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1) {
            char c = (char)cOrEOF;
            this.buffer().append(c);
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.commentStart()), commentIdx)) {
                if (commentIdx >= this.commentStart().length() - 1) {
                    this.buffer().setLength(this.buffer().length() - this.commentStart().length());
                    commentIdx = 0;
                    v1 = BoxesRunTime.boxToBoolean((boolean)this.readUntilMatch(this.commentEnd()));
                } else {
                    ++commentIdx;
                    v1 = BoxedUnit.UNIT;
                }
            } else {
                commentIdx = 0;
                v1 = BoxedUnit.UNIT;
            }
            if (c == '>' && prevC != 47) {
                canSelfClose = false;
            }
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), si)) {
                if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                    ++si;
                    ++ei;
                } else if (si >= this.startTag().length() - 1) {
                    si = 0;
                    ei = 0;
                    ++depth;
                } else {
                    ++si;
                    ei = 0;
                }
            } else if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                if (ei >= this.endTag().length() - 1) {
                    if (depth == 0) {
                        return true;
                    }
                    si = 0;
                    ei = 0;
                    --depth;
                } else {
                    si = 0;
                    ++ei;
                }
            } else if (c == '>' && prevC == 47 && canSelfClose) {
                if (depth == 0) {
                    return true;
                }
                si = 0;
                ei = 0;
                --depth;
            } else if (si == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                si = 0;
                ei = 0;
                ++depth;
            } else {
                si = 0;
                ei = 0;
            }
            prevC = c;
        }
        return false;
    }

    public XmlTokenizer(InputStream inputStream, XmlOptions options) {
        this.options = options;
        Logging.$init$((Logging)this);
        this.reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(options.charset())));
        this.buffer = new StringBuilder();
        this.startTag = "<" + options.rowTag() + ">";
        this.endTag = "</" + options.rowTag() + ">";
        this.commentStart = "<!--";
        this.commentEnd = "-->";
        this.cdataStart = "<![CDATA[";
        this.cdataEnd = "]]>";
    }
}

