/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, k, maxItemsTracked) - Returns top k items with their frequency.\n      `k` An optional INTEGER literal greater than 0. If k is not specified, it defaults to 5.\n      `maxItemsTracked` An optional INTEGER literal greater than or equal to k. If maxItemsTracked is not specified, it defaults to 10000.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(expr) FROM VALUES (0), (0), (1), (1), (2), (3), (4), (4) AS tab(expr);\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n\n      > SELECT _FUNC_(expr, 2) FROM VALUES 'a', 'b', 'c', 'c', 'c', 'c', 'd', 'd' AS tab(expr);\n       [{\"item\":\"c\",\"count\":4},{\"item\":\"d\",\"count\":2}]\n\n      > SELECT _FUNC_(expr, 10, 100) FROM VALUES (0), (1), (1), (2), (2), (2) AS tab(expr);\n       [{\"item\":2,\"count\":3},{\"item\":1,\"count\":2},{\"item\":0,\"count\":1}]\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001\u0002'N\u0001rC!\"a\u0006\u0001\u0005+\u0007I\u0011AA\r\u0011%\tY\u0002\u0001B\tB\u0003%\u0011\u0010\u0003\u0006\u0002\u001e\u0001\u0011)\u001a!C\u0001\u00033A\u0011\"a\b\u0001\u0005#\u0005\u000b\u0011B=\t\u0015\u0005\u0005\u0002A!f\u0001\n\u0003\tI\u0002C\u0005\u0002$\u0001\u0011\t\u0012)A\u0005s\"Q\u0011Q\u0005\u0001\u0003\u0016\u0004%\t!a\n\t\u0015\u0005=\u0002A!E!\u0002\u0013\tI\u0003\u0003\u0006\u00022\u0001\u0011)\u001a!C\u0001\u0003OA!\"a\r\u0001\u0005#\u0005\u000b\u0011BA\u0015\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u000e\u0001\t\u0003\t)\u0005C\u0004\u00026\u0001!\t!!\u0015\t\u000f\u0005U\u0002\u0001\"\u0001\u0002Z!9\u0011Q\u0007\u0001\u0005\u0002\u0005}\u0003bBA\u001b\u0001\u0011\u0005\u0011Q\r\u0005\u000b\u0003S\u0002\u0001R1A\u0005\n\u0005-\u0004BCA=\u0001!\u0015\r\u0011\"\u0003\u0002(!Q\u00111\u0010\u0001\t\u0006\u0004%I!a\n\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u001a!9\u0011q\u0010\u0001\u0005B\u0005e\u0001bBAA\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!a)\u0001\t\u0003\nY\u0007C\u0004\u0002&\u0002!\t%a*\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\tI\u000f\u0001C!\u0003WDq!!=\u0001\t\u0003\n\u0019\u0010C\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\t\u001d\u0001\u0001\"\u0015\u0003\n!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\n\u0005k\u0001\u0011\u0011!C\u0001\u0005oA\u0011Ba\u0011\u0001#\u0003%\tA!\u0012\t\u0013\tm\u0003!%A\u0005\u0002\t\u0015\u0003\"\u0003B/\u0001E\u0005I\u0011\u0001B#\u0011%\u0011y\u0006AI\u0001\n\u0003\u0011\t\u0007C\u0005\u0003f\u0001\t\n\u0011\"\u0001\u0003b!I!q\r\u0001\u0002\u0002\u0013\u0005#\u0011\u000e\u0005\n\u0005s\u0002\u0011\u0011!C\u0001\u0003OA\u0011Ba\u001f\u0001\u0003\u0003%\tA! \t\u0013\t\r\u0005!!A\u0005B\t\u0015\u0005\"\u0003BJ\u0001\u0005\u0005I\u0011\u0001BK\u0011%\u0011I\nAA\u0001\n\u0003\u0012Y\nC\u0005\u0003 \u0002\t\t\u0011\"\u0011\u0003\"\u001e9!QY'\t\u0002\t\u001dgA\u0002'N\u0011\u0003\u0011I\rC\u0004\u00026M\"\tAa7\t\u0013\tu7G1A\u0005\n\u0005\u001d\u0002\u0002\u0003Bpg\u0001\u0006I!!\u000b\t\u0013\t\u00058G1A\u0005\n\u0005\u001d\u0002\u0002\u0003Brg\u0001\u0006I!!\u000b\t\u0013\t\u00158G1A\u0005\n\u0005\u001d\u0002\u0002\u0003Btg\u0001\u0006I!!\u000b\t\u000f\t%8\u0007\"\u0003\u0003l\"9!\u0011`\u001a\u0005\n\tm\bb\u0002B\u0000g\u0011%1\u0011\u0001\u0005\b\u0007\u000f\u0019D\u0011BB\u0005\u0011\u001d\u0019ia\rC\u0005\u0007\u001fAqa!\u00064\t\u0013\u00199\u0002C\u0004\u0002&N\"\taa\u0007\t\u000f\r\u00152\u0007\"\u0003\u0004(!91qF\u001a\u0005\n\rE\u0002bBB\u001eg\u0011%1Q\b\u0005\n\u0007\u001b\u001a\u0014\u0011!CA\u0007\u001fB\u0011ba\u00174#\u0003%\tA!\u0019\t\u0013\ru3'%A\u0005\u0002\t\u0005\u0004\"CB0g\u0005\u0005I\u0011QB1\u0011%\u0019\u0019hMI\u0001\n\u0003\u0011\t\u0007C\u0005\u0004vM\n\n\u0011\"\u0001\u0003b!I1qO\u001a\u0002\u0002\u0013%1\u0011\u0010\u0002\u000b\u0003B\u0004(o\u001c=U_B\\%B\u0001(P\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002Q#\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00116+\u0001\u0005dCR\fG._:u\u0015\t!V+A\u0002tc2T!AV,\u0002\u000bM\u0004\u0018M]6\u000b\u0005aK\u0016AB1qC\u000eDWMC\u0001[\u0003\ry'oZ\u0002\u0001'\u0019\u0001Ql\\:}\u007fB\u0019alX1\u000e\u00035K!\u0001Y'\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\rE\u0002cO&l\u0011a\u0019\u0006\u0003I\u0016\f1B\u001a:fcV,gnY5fg*\u0011amV\u0001\rI\u0006$\u0018m]6fi\u000eDWm]\u0005\u0003Q\u000e\u00141\"\u0013;f[N\u001c6.\u001a;dQB\u0011!.\\\u0007\u0002W*\tA.A\u0003tG\u0006d\u0017-\u0003\u0002oW\n\u0019\u0011I\\=\u0011\u0005A\fX\"A(\n\u0005I|%AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0007Q<\u00180D\u0001v\u0015\t1\u0018+A\u0003ue\u0016,7/\u0003\u0002yk\nYA+\u001a:oCJLH*[6f!\t\u0001(0\u0003\u0002|\u001f\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005)l\u0018B\u0001@l\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0001\u0002\u00129!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u00057\u00061AH]8pizJ\u0011\u0001\\\u0005\u0004\u0003\u001fY\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)B\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u0010-\fA!\u001a=qeV\t\u00110A\u0003fqB\u0014\b%A\u0001l\u0003\tY\u0007%A\bnCbLE/Z7t)J\f7m[3e\u0003Ai\u0017\r_%uK6\u001cHK]1dW\u0016$\u0007%\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\t\tI\u0003E\u0002k\u0003WI1!!\fl\u0005\rIe\u000e^\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018!F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0011\u0005y\u0003\u0001BBA\f\u0017\u0001\u0007\u0011\u0010\u0003\u0004\u0002\u001e-\u0001\r!\u001f\u0005\u0007\u0003CY\u0001\u0019A=\t\u0013\u0005\u00152\u0002%AA\u0002\u0005%\u0002\"CA\u0019\u0017A\u0005\t\u0019AA\u0015)!\tI$a\u0012\u0002L\u0005=\u0003BBA%\u0019\u0001\u0007\u00110A\u0003dQ&dG\r\u0003\u0004\u0002N1\u0001\r!_\u0001\u0005i>\u00048\n\u0003\u0004\u0002\"1\u0001\r!\u001f\u000b\t\u0003s\t\u0019&!\u0016\u0002X!1\u0011\u0011J\u0007A\u0002eDq!!\u0014\u000e\u0001\u0004\tI\u0003C\u0004\u0002\"5\u0001\r!!\u000b\u0015\r\u0005e\u00121LA/\u0011\u0019\tIE\u0004a\u0001s\"1\u0011Q\n\bA\u0002e$b!!\u000f\u0002b\u0005\r\u0004BBA%\u001f\u0001\u0007\u0011\u0010C\u0004\u0002N=\u0001\r!!\u000b\u0015\t\u0005e\u0012q\r\u0005\u0007\u0003\u0013\u0002\u0002\u0019A=\u0002\u0019%$X-\u001c#bi\u0006$\u0016\u0010]3\u0016\u0005\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M4+A\u0003usB,7/\u0003\u0003\u0002x\u0005E$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\t-4\u0016\r\\\u0001\u0013[\u0006D\u0018\n^3ngR\u0013\u0018mY6fIZ\u000bG.A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAD!\u0019\t\t!!#\u0002\u000e&!\u00111RA\u000b\u0005\r\u0019V-\u001d\t\u0005\u0003_\ny)\u0003\u0003\u0002\u0012\u0006E$\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti*U\u0001\tC:\fG._:jg&!\u0011\u0011UAN\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#A1\u0002\rU\u0004H-\u0019;f)\u0015\t\u0017QVAY\u0011\u0019\tyk\u0007a\u0001C\u00061!-\u001e4gKJDq!a-\u001c\u0001\u0004\t),A\u0003j]B,H\u000f\u0005\u0003\u00028\u0006eV\"A)\n\u0007\u0005m\u0016KA\u0006J]R,'O\\1m%><\u0018!B7fe\u001e,G#B1\u0002B\u0006\r\u0007BBAX9\u0001\u0007\u0011\r\u0003\u0004\u00024r\u0001\r!Y\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002J\u0006U\u0007\u0003BAf\u0003#l!!!4\u000b\u0007\u0005=\u0017+\u0001\u0003vi&d\u0017\u0002BAj\u0003\u001b\u0014\u0001cR3oKJL7-\u0011:sCf$\u0015\r^1\t\r\u0005=V\u00041\u0001b\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002\\\u0006\u001d\b#\u00026\u0002^\u0006\u0005\u0018bAApW\n)\u0011I\u001d:bsB\u0019!.a9\n\u0007\u0005\u00158N\u0001\u0003CsR,\u0007BBAX=\u0001\u0007\u0011-A\u0006eKN,'/[1mSj,GcA1\u0002n\"9\u0011q^\u0010A\u0002\u0005m\u0017!D:u_J\fw-\u001a$pe6\fG/A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\t)0a?\u0011\u0007y\u000b90C\u0002\u0002z6\u00131#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016Dq!!@!\u0001\u0004\tI#A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002v\n\r\u0001b\u0002B\u0003C\u0001\u0007\u0011\u0011F\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000fe\u0014YAa\u0004\u0003\u0014!1!Q\u0002\u0012A\u0002e\fqA\\3x\u000bb\u0004(\u000f\u0003\u0004\u0003\u0012\t\u0002\r!_\u0001\u0005]\u0016<8\n\u0003\u0004\u0003\u0016\t\u0002\r!_\u0001\u0013]\u0016<X*\u0019=Ji\u0016l7\u000f\u0016:bG.,G-\u0001\u0005ok2d\u0017M\u00197f+\t\u0011Y\u0002E\u0002k\u0005;I1Aa\bl\u0005\u001d\u0011un\u001c7fC:\f!\u0002\u001d:fiRLh*Y7f+\t\u0011)\u0003\u0005\u0003\u0003(\t=b\u0002\u0002B\u0015\u0005W\u00012!!\u0002l\u0013\r\u0011ic[\u0001\u0007!J,G-\u001a4\n\t\tE\"1\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t52.\u0001\u0003d_BLH\u0003DA\u001d\u0005s\u0011YD!\u0010\u0003@\t\u0005\u0003\u0002CA\fKA\u0005\t\u0019A=\t\u0011\u0005uQ\u0005%AA\u0002eD\u0001\"!\t&!\u0003\u0005\r!\u001f\u0005\n\u0003K)\u0003\u0013!a\u0001\u0003SA\u0011\"!\r&!\u0003\u0005\r!!\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\t\u0016\u0004s\n%3F\u0001B&!\u0011\u0011iEa\u0016\u000e\u0005\t=#\u0002\u0002B)\u0005'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tU3.\u0001\u0006b]:|G/\u0019;j_:LAA!\u0017\u0003P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005GRC!!\u000b\u0003J\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003lA!!Q\u000eB<\u001b\t\u0011yG\u0003\u0003\u0003r\tM\u0014\u0001\u00027b]\u001eT!A!\u001e\u0002\t)\fg/Y\u0005\u0005\u0005c\u0011y'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007%\u0014y\bC\u0005\u0003\u00026\n\t\u00111\u0001\u0002*\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\"\u0011\u000b\t%%qR5\u000e\u0005\t-%b\u0001BGW\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE%1\u0012\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u001c\t]\u0005\u0002\u0003BA_\u0005\u0005\t\u0019A5\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005W\u0012i\nC\u0005\u0003\u0002B\n\t\u00111\u0001\u0002*\u00051Q-];bYN$BAa\u0007\u0003$\"A!\u0011Q\u0019\u0002\u0002\u0003\u0007\u0011\u000eK\n\u0001\u0005O\u0013iKa,\u00034\nU&\u0011\u0018B^\u0005\u007f\u0013\t\rE\u0002q\u0005SK1Aa+P\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!-\u0002\u0005\u0003S\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(\u000f\f\u0011lY\u0001j\u0017\r_%uK6\u001cHK]1dW\u0016$\u0017\u0006I\u0017!%\u0016$XO\u001d8tAQ|\u0007\u000fI6!SR,Wn\u001d\u0011xSRD\u0007\u0005\u001e5fSJ\u0004cM]3rk\u0016t7-\u001f\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011aW\u0002\u0004\u0013I\u001c\u0011paRLwN\\1mA%sE+R$F%\u0002b\u0017\u000e^3sC2\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\u0002d\u0006I%gA-\u0004\u0013n\u001d\u0011o_R\u00043\u000f]3dS\u001aLW\r\u001a\u0017!SR\u0004C-\u001a4bk2$8\u000f\t;pAUr#\u0002\t\u0011!A\u0001\u0002\u0003-\\1y\u0013R,Wn\u001d+sC\u000e\\W\r\u001a1!\u0003:\u0004s\u000e\u001d;j_:\fG\u000eI%O)\u0016;UI\u0015\u0011mSR,'/\u00197!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011pe\u0002*\u0017/^1mAQ|\u0007e\u001b\u0018!\u0013\u001a\u0004S.\u0019=Ji\u0016l7\u000f\u0016:bG.,G\rI5tA9|G\u000fI:qK\u000eLg-[3eY\u0001JG\u000f\t3fM\u0006,H\u000e^:!i>\u0004\u0013\u0007\r\u00191a9R\u0001\u0005\t\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\\\u0003\u0011m\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK3yaJL\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0003'\u000b\u0017!QAJC\u0006\t\u00152S1\u0002\u0003&M\u0015-A!\u0012\u0014\u0006\f\u0011)g%b\u0003\u0005\u000b\u001b*Y\u0001BC'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015fqB\u0014\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\w\nJG/Z7#uAb#eY8v]R\u0014#HM?-w\nJG/Z7#uQb#eY8v]R\u0014#HM?-w\nJG/Z7#uEb#eY8v]R\u0014#HM?-w\nJG/Z7#uIb#eY8v]R\u0014#(M?-w\nJG/Z7#uMb#eY8v]R\u0014#(M?^\u0015)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS\r\u001f9sY\u0001\u0012\u0014\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003s%Y\u0014-A\u001d\u0012w\u0005\f\u0011(G\u001eb\u0003eJ2(Y\u0001:3m\n\u0017!O\r<C\u0006I\u0014eO1\u0002s\u0005Z\u0014!\u0003N\u0003C/\u00192)Kb\u0004(/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7n\u0014\u0013\u000e^3nEi\u00123M\t\u0017#G>,h\u000e\u001e\u0012;iud3PI5uK6\u0014#H\t3#Y\t\u001aw.\u001e8uEi\u0012T0\u0018\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0015D\bO\u001d\u0017!cAb\u0003%\r\u00191S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152S1\u0002\u0003&M\u0015-A!\u0012\u0014\u0006\f\u0011)e%b\u0003\u0005\u000b\u001a*A\u0005\u001b\u0006\u0005^1cQ\u0015D\bO]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u001b;f[\nR$\u0007\f\u0012d_VtGO\t\u001e4{2Z(%\u001b;f[\nR\u0014\u0007\f\u0012d_VtGO\t\u001e3{2Z(%\u001b;f[\nR\u0004\u0007\f\u0012d_VtGO\t\u001e2{vS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005{\u000b\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t\r\u0017!\u0002\u001b/c9\u0002\u0014AC!qaJ|\u0007\u0010V8q\u0017B\u0011alM\n\u0006g\t-'\u0011\u001b\t\u0004U\n5\u0017b\u0001BhW\n1\u0011I\\=SK\u001a\u0004BAa5\u0003Z6\u0011!Q\u001b\u0006\u0005\u0005/\u0014\u0019(\u0001\u0002j_&!\u00111\u0003Bk)\t\u00119-A\u0005E\u000b\u001a\u000bU\u000b\u0014+`\u0017\u0006QA)\u0012$B+2#vl\u0013\u0011\u00023\u0011+e)Q+M)~k\u0015\tW0J)\u0016k5k\u0018+S\u0003\u000e[U\tR\u0001\u001b\t\u00163\u0015)\u0016'U?6\u000b\u0005lX%U\u000b6\u001bv\f\u0016*B\u0007.+E\tI\u0001\u0018\u001b\u0006Cv,\u0013+F\u001bN{FKU!D\u0017\u0016#u\fT%N\u0013R\u000b\u0001$T!Y?&#V)T*`)J\u000b5iS#E?2KU*\u0013+!\u0003Y\u0019\u0007.Z2l\u000bb\u0004(/Z:tS>tgj\u001c;Ok2dGC\u0002Bw\u0005g\u0014)\u0010E\u0002k\u0005_L1A!=l\u0005\u0011)f.\u001b;\t\r\u0005]1\b1\u0001z\u0011\u001d\u00119p\u000fa\u0001\u0005K\t\u0001\"\u001a=qe:\u000bW.Z\u0001\u0007G\",7m[&\u0015\t\t5(Q \u0005\b\u0003;a\u0004\u0019AA\u0015\u0003Q\u0019\u0007.Z2l\u001b\u0006D\u0018\n^3ngR\u0013\u0018mY6fIR1!Q^B\u0002\u0007\u000bAq!!\t>\u0001\u0004\tI\u0003C\u0004\u0002\u001eu\u0002\r!!\u000b\u0002#\u001d,GOU3tk2$H)\u0019;b)f\u0004X\r\u0006\u0003\u0002n\r-\u0001bBA5}\u0001\u0007\u0011QN\u0001\u0014SN$\u0015\r^1UsB,7+\u001e9q_J$X\r\u001a\u000b\u0005\u00057\u0019\t\u0002C\u0004\u0004\u0014}\u0002\r!!\u001c\u0002\u0011%$X-\u001c+za\u0016\fQbY1m\u001b\u0006DX*\u00199TSj,G\u0003BA\u0015\u00073Aq!!\tA\u0001\u0004\tI\u0003F\u0003b\u0007;\u0019\t\u0003\u0003\u0004\u0004 \u0005\u0003\r!_\u0001\u000fSR,W.\u0012=qe\u0016\u001c8/[8o\u0011\u001d\u0019\u0019#\u0011a\u0001\u0003S\t!\"\\1y\u001b\u0006\u00048+\u001b>f\u0003I)\b\u000fZ1uKN[W\r^2i\u0005V4g-\u001a:\u0015\u000f\u0005\u001cIca\u000b\u0004.!11q\u0004\"A\u0002eDa!a,C\u0001\u0004\t\u0007bBAZ\u0005\u0002\u0007\u0011QW\u0001\u000eO\u0016tWI^1m%\u0016\u001cX\u000f\u001c;\u0015\u0011\u0005%71GB\u001c\u0007sAaa!\u000eD\u0001\u0004\t\u0017aC5uK6\u001c8k[3uG\"Dq!!\bD\u0001\u0004\tI\u0003C\u0004\u0002j\r\u0003\r!!\u001c\u0002\u001d\u001d,gnU6fi\u000eD7+\u001a:EKR!1qHB&!\u0015\u0019\tea\u0012j\u001b\t\u0019\u0019EC\u0002\u0004F\u0015\faaY8n[>t\u0017\u0002BB%\u0007\u0007\u0012\u0011#\u0011:sCf|e-\u0013;f[N\u001cVM\u001d#f\u0011\u001d\t\u0019\u000b\u0012a\u0001\u0003[\nQ!\u00199qYf$B\"!\u000f\u0004R\rM3QKB,\u00073Ba!a\u0006F\u0001\u0004I\bBBA\u000f\u000b\u0002\u0007\u0011\u0010\u0003\u0004\u0002\"\u0015\u0003\r!\u001f\u0005\n\u0003K)\u0005\u0013!a\u0001\u0003SA\u0011\"!\rF!\u0003\u0005\r!!\u000b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\u0019ga\u001c\u0011\u000b)\u001c)g!\u001b\n\u0007\r\u001d4N\u0001\u0004PaRLwN\u001c\t\u000bU\u000e-\u00140_=\u0002*\u0005%\u0012bAB7W\n1A+\u001e9mKVB\u0011b!\u001dI\u0003\u0003\u0005\r!!\u000f\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\rm\u0004\u0003\u0002B7\u0007{JAaa \u0003p\t1qJ\u00196fGR\u0004")
public class ApproxTopK
extends TypedImperativeAggregate<ItemsSketch<Object>>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
Serializable {
    private DataType itemDataType;
    private int kVal;
    private int maxItemsTrackedVal;
    private final Expression expr;
    private final Expression k;
    private final Expression maxItemsTracked;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$5() {
        return ApproxTopK$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return ApproxTopK$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproxTopK x$0) {
        return ApproxTopK$.MODULE$.unapply(x$0);
    }

    public static int apply$default$5() {
        return ApproxTopK$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return ApproxTopK$.MODULE$.apply$default$4();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression expr() {
        return this.expr;
    }

    public Expression k() {
        return this.k;
    }

    public Expression maxItemsTracked() {
        return this.maxItemsTracked;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType itemDataType$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.itemDataType = this.expr().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.itemDataType;
    }

    private DataType itemDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.itemDataType$lzycompute();
        }
        return this.itemDataType;
    }

    /*
     * WARNING - void declaration
     */
    private int kVal$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$checkExpressionNotNull(this.k(), "k");
                int kVal = BoxesRunTime.unboxToInt((Object)this.k().eval(this.k().eval$default$1()));
                ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$checkK(kVal);
                this.kVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.kVal;
    }

    private int kVal() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.kVal$lzycompute();
        }
        return this.kVal;
    }

    /*
     * WARNING - void declaration
     */
    private int maxItemsTrackedVal$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$checkExpressionNotNull(this.maxItemsTracked(), "maxItemsTracked");
                int maxItemsTrackedVal = BoxesRunTime.unboxToInt((Object)this.maxItemsTracked().eval(this.maxItemsTracked().eval$default$1()));
                ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$checkMaxItemsTracked(maxItemsTrackedVal, this.kVal());
                this.maxItemsTrackedVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.maxItemsTrackedVal;
    }

    private int maxItemsTrackedVal() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.maxItemsTrackedVal$lzycompute();
        }
        return this.maxItemsTrackedVal;
    }

    @Override
    public Expression first() {
        return this.expr();
    }

    @Override
    public Expression second() {
        return this.k();
    }

    @Override
    public Expression third() {
        return this.maxItemsTracked();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$isDataTypeSupported(this.itemDataType())) {
            return new TypeCheckResult.TypeCheckFailure(this.itemDataType().typeName() + " columns are not supported");
        }
        if (!this.k().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("K must be a constant literal");
        }
        if (!this.maxItemsTracked().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("Number of items tracked must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$getResultDataType(this.itemDataType());
    }

    @Override
    public ItemsSketch<Object> createAggregationBuffer() {
        int maxMapSize = ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$calMaxMapSize(this.maxItemsTrackedVal());
        return ApproxTopK$.MODULE$.createAggregationBuffer(this.expr(), maxMapSize);
    }

    @Override
    public ItemsSketch<Object> update(ItemsSketch<Object> buffer, InternalRow input) {
        return ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$updateSketchBuffer(this.expr(), buffer, input);
    }

    @Override
    public ItemsSketch<Object> merge(ItemsSketch<Object> buffer, ItemsSketch<Object> input) {
        return buffer.merge(input);
    }

    public GenericArrayData eval(ItemsSketch<Object> buffer) {
        return ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$genEvalResult(buffer, this.kVal(), this.itemDataType());
    }

    @Override
    public byte[] serialize(ItemsSketch<Object> buffer) {
        return buffer.toByteArray(ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ItemsSketch<Object> deserialize(byte[] storageFormat) {
        return ItemsSketch.getInstance((Memory)Memory.wrap((byte[])storageFormat), ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression withNewChildrenInternal(Expression newExpr, Expression newK, Expression newMaxItemsTracked) {
        return this.copy(newExpr, newK, newMaxItemsTracked, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k");
    }

    public ApproxTopK copy(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopK(expr, k, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Expression copy$default$2() {
        return this.k();
    }

    public Expression copy$default$3() {
        return this.maxItemsTracked();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopK";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.k();
            }
            case 2: {
                return this.maxItemsTracked();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopK;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "k";
            }
            case 2: {
                return "maxItemsTracked";
            }
            case 3: {
                return "mutableAggBufferOffset";
            }
            case 4: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopK)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopK approxTopK = (ApproxTopK)x$1;
        if (this.mutableAggBufferOffset() != approxTopK.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approxTopK.inputAggBufferOffset()) return false;
        Expression expression = this.expr();
        Expression expression2 = approxTopK.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.k();
        Expression expression4 = approxTopK.k();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxItemsTracked();
        Expression expression6 = approxTopK.maxItemsTracked();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!approxTopK.canEqual(this)) return false;
        return true;
    }

    public ApproxTopK(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.expr = expr;
        this.k = k;
        this.maxItemsTracked = maxItemsTracked;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproxTopK(Expression child, Expression topK, Expression maxItemsTracked) {
        this(child, topK, maxItemsTracked, 0, 0);
    }

    public ApproxTopK(Expression child, int topK, int maxItemsTracked) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxItemsTracked)), 0, 0);
    }

    public ApproxTopK(Expression child, Expression topK) {
        this(child, topK, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }

    public ApproxTopK(Expression child, int topK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }

    public ApproxTopK(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$DEFAULT_K())), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$ApproxTopK$$DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }
}

