/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.SparkDateTimeException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple10;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields. The result data type is consistent with the value of configuration `spark.sql.timestampType`. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from 0 to 60.\n              The value can be either an integer like 13 , or a fraction like 13.123.\n              If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 1);\n       2019-06-30 23:59:01\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\r-b\u0001B\"E\u0001FC\u0001B\u001c\u0001\u0003\u0016\u0004%\ta\u001c\u0005\tg\u0002\u0011\t\u0012)A\u0005a\"AA\u000f\u0001BK\u0002\u0013\u0005q\u000e\u0003\u0005v\u0001\tE\t\u0015!\u0003q\u0011!1\bA!f\u0001\n\u0003y\u0007\u0002C<\u0001\u0005#\u0005\u000b\u0011\u00029\t\u0011a\u0004!Q3A\u0005\u0002=D\u0001\"\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\tu\u0002\u0011)\u001a!C\u0001_\"A1\u0010\u0001B\tB\u0003%\u0001\u000f\u0003\u0005}\u0001\tU\r\u0011\"\u0001p\u0011!i\bA!E!\u0002\u0013\u0001\b\u0002\u0003@\u0001\u0005+\u0007I\u0011A@\t\u0015\u0005\u001d\u0001A!E!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\n\u0001\u0011)\u001a!C\u0001\u0003\u0017A!\"a\b\u0001\u0005#\u0005\u000b\u0011BA\u0007\u0011)\t\t\u0003\u0001BK\u0002\u0013\u0005\u00111\u0005\u0005\u000b\u0003W\u0001!\u0011#Q\u0001\n\u0005\u0015\u0002BCA\u0017\u0001\tU\r\u0011\"\u0011\u00020!Q\u0011Q\b\u0001\u0003\u0012\u0003\u0006I!!\r\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011\u0011\f\u0001\u0005B\u0005\r\u0002bBA \u0001\u0011\u0005\u00111\f\u0005\b\u0003\u007f\u0001A\u0011AA5\u0011\u001d\tI\b\u0001C!\u0003wBq!a!\u0001\t\u0003\n)\tC\u0004\u0002\u0010\u0002!\t%a\t\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u0003G\u0004A\u0011IAs\u0011\u001d\u0011\t\u0001\u0001C!\u0005\u0007AqA!\u0002\u0001\t#\u00129\u0001C\u0005\u0003\u0014\u0001\t\t\u0011\"\u0001\u0003\u0016!I!1\u0006\u0001\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005\u0007\u0002\u0011\u0013!C\u0001\u0005[A\u0011B!\u0012\u0001#\u0003%\tA!\f\t\u0013\t\u001d\u0003!%A\u0005\u0002\t5\u0002\"\u0003B%\u0001E\u0005I\u0011\u0001B\u0017\u0011%\u0011Y\u0005AI\u0001\n\u0003\u0011i\u0003C\u0005\u0003N\u0001\t\n\u0011\"\u0001\u0003P!I!1\u000b\u0001\u0012\u0002\u0013\u0005!Q\u000b\u0005\n\u00053\u0002\u0011\u0013!C\u0001\u00057B\u0011Ba\u0018\u0001#\u0003%\tA!\u0019\t\u0013\t\u0015\u0004!!A\u0005B\t\u001d\u0004\"\u0003B:\u0001\u0005\u0005I\u0011\u0001B;\u0011%\u00119\bAA\u0001\n\u0003\u0011I\bC\u0005\u0003\u0000\u0001\t\t\u0011\"\u0011\u0003\u0002\"I!q\u0012\u0001\u0002\u0002\u0013\u0005!\u0011\u0013\u0005\n\u0005+\u0003\u0011\u0011!C!\u0005/C\u0011Ba'\u0001\u0003\u0003%\tE!(\b\u0013\t\u001dG)!A\t\u0002\t%g\u0001C\"E\u0003\u0003E\tAa3\t\u000f\u0005}R\u0007\"\u0001\u0003d\"I!Q]\u001b\u0002\u0002\u0013\u0015#q\u001d\u0005\n\u0005S,\u0014\u0011!CA\u0005WD\u0011b!\u00016#\u0003%\tAa\u0014\t\u0013\r\rQ'%A\u0005\u0002\tU\u0003\"CB\u0003kE\u0005I\u0011\u0001B.\u0011%\u00199!NI\u0001\n\u0003\u0011\t\u0007C\u0005\u0004\nU\n\t\u0011\"!\u0004\f!I1\u0011D\u001b\u0012\u0002\u0013\u0005!q\n\u0005\n\u00077)\u0014\u0013!C\u0001\u0005+B\u0011b!\b6#\u0003%\tAa\u0017\t\u0013\r}Q'%A\u0005\u0002\t\u0005\u0004\"CB\u0011k\u0005\u0005I\u0011BB\u0012\u00055i\u0015m[3US6,7\u000f^1na*\u0011QIR\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002H\u0011\u0006A1-\u0019;bYf\u001cHO\u0003\u0002J\u0015\u0006\u00191/\u001d7\u000b\u0005-c\u0015!B:qCJ\\'BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001%ZKFL\u0019\t\u0003'Rk\u0011\u0001R\u0005\u0003+\u0012\u00131cU3qi\u0016t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aU,\n\u0005a#%a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\t\u0019&,\u0003\u0002\\\t\n1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002^A6\taLC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tgLA\u0004Qe>$Wo\u0019;\u0011\u0005\r\\gB\u00013j\u001d\t)\u0007.D\u0001g\u0015\t9\u0007+\u0001\u0004=e>|GOP\u0005\u0002?&\u0011!NX\u0001\ba\u0006\u001c7.Y4f\u0013\taWN\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002k=\u0006!\u00110Z1s+\u0005\u0001\bCA*r\u0013\t\u0011HI\u0001\u0006FqB\u0014Xm]:j_:\fQ!_3be\u0002\nQ!\\8oi\"\fa!\\8oi\"\u0004\u0013a\u00013bs\u0006!A-Y=!\u0003\u0011Aw.\u001e:\u0002\u000b!|WO\u001d\u0011\u0002\u00075Lg.\u0001\u0003nS:\u0004\u0013aA:fG\u0006!1/Z2!\u0003!!\u0018.\\3{_:,WCAA\u0001!\u0011i\u00161\u00019\n\u0007\u0005\u0015aL\u0001\u0004PaRLwN\\\u0001\ni&lWM_8oK\u0002\n!\u0002^5nKj{g.Z%e+\t\ti\u0001E\u0003^\u0003\u0007\ty\u0001\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"!\u001a0\n\u0007\u0005]a,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/q\u0016a\u0003;j[\u0016TvN\\3JI\u0002\n1BZ1jY>sWI\u001d:peV\u0011\u0011Q\u0005\t\u0004;\u0006\u001d\u0012bAA\u0015=\n9!i\\8mK\u0006t\u0017\u0001\u00044bS2|e.\u0012:s_J\u0004\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]\u0002*A\u0003usB,7/\u0003\u0003\u0002<\u0005U\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0013\u0011\fG/\u0019+za\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\f\u0002D\u0005\u0015\u0013qIA%\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0013QKA,!\t\u0019\u0006\u0001C\u0003o+\u0001\u0007\u0001\u000fC\u0003u+\u0001\u0007\u0001\u000fC\u0003w+\u0001\u0007\u0001\u000fC\u0003y+\u0001\u0007\u0001\u000fC\u0003{+\u0001\u0007\u0001\u000fC\u0003}+\u0001\u0007\u0001\u000f\u0003\u0005\u007f+A\u0005\t\u0019AA\u0001\u0011%\tI!\u0006I\u0001\u0002\u0004\ti\u0001C\u0005\u0002\"U\u0001\n\u00111\u0001\u0002&!I\u0011QF\u000b\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\u000f]VdG.\u00138u_2,'/\u00198u)9\t\u0019%!\u0018\u0002`\u0005\u0005\u00141MA3\u0003OBQA\\\fA\u0002ADQ\u0001^\fA\u0002ADQA^\fA\u0002ADQ\u0001_\fA\u0002ADQA_\fA\u0002ADQ\u0001`\fA\u0002A$\u0002#a\u0011\u0002l\u00055\u0014qNA9\u0003g\n)(a\u001e\t\u000b9D\u0002\u0019\u00019\t\u000bQD\u0002\u0019\u00019\t\u000bYD\u0002\u0019\u00019\t\u000baD\u0002\u0019\u00019\t\u000biD\u0002\u0019\u00019\t\u000bqD\u0002\u0019\u00019\t\u000byD\u0002\u0019\u00019\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!! \u0011\t\r\fy\b]\u0005\u0004\u0003\u0003k'aA*fc\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005\u001d\u0005#B2\u0002\u0000\u0005%\u0005\u0003BA\u001a\u0003\u0017KA!!$\u00026\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\t]VdG.\u00192mK\u0006aq/\u001b;i)&lWMW8oKR\u0019a+!&\t\u000f\u0005%A\u00041\u0001\u0002\u0010\u0005AAo\\'jGJ|7\u000f\u0006\t\u0002\u001c\u0006\u0005\u0016\u0011VAV\u0003[\u000by+!-\u0002<B\u0019Q,!(\n\u0007\u0005}eLA\u0002B]fDaA\\\u000fA\u0002\u0005\r\u0006cA/\u0002&&\u0019\u0011q\u00150\u0003\u0007%sG\u000f\u0003\u0004u;\u0001\u0007\u00111\u0015\u0005\u0007mv\u0001\r!a)\t\ral\u0002\u0019AAR\u0011\u0019QX\u00041\u0001\u0002$\"9\u00111W\u000fA\u0002\u0005U\u0016\u0001D:fG\u0006sG-T5de>\u001c\b\u0003BA\u001a\u0003oKA!!/\u00026\t9A)Z2j[\u0006d\u0007bBA_;\u0001\u0007\u0011qX\u0001\u0007u>tW-\u00133\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006!A/[7f\u0015\t\tI-\u0001\u0003kCZ\f\u0017\u0002BAg\u0003\u0007\u0014aAW8oK&#\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003EAN\u0003'\f).a6\u0002Z\u0006m\u0017Q\\Ap\u0011\u0019qg\u00041\u0001\u0002\u001c\"1AO\ba\u0001\u00037CaA\u001e\u0010A\u0002\u0005m\u0005B\u0002=\u001f\u0001\u0004\tY\n\u0003\u0004{=\u0001\u0007\u00111\u0014\u0005\u0007yz\u0001\r!a'\t\ryt\u0002\u0019AAq!\u0015i\u00161AAN\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002h\u0006M\u0018Q \t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q\u001e#\u0002\u000f\r|G-Z4f]&!\u0011\u0011_Av\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA{?\u0001\u0007\u0011q_\u0001\u0004GRD\b\u0003BAu\u0003sLA!a?\u0002l\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u0000?\u0001\u0007\u0011q]\u0001\u0003KZ\f\u0001B\\8eK:\u000bW.Z\u000b\u0003\u0003\u001f\tqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\t\u0005\r#\u0011\u0002\u0005\b\u0005\u0017\t\u0003\u0019\u0001B\u0007\u0003-qWm^\"iS2$'/\u001a8\u0011\t\r\u0014y\u0001]\u0005\u0004\u0005#i'AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)Y\t\u0019Ea\u0006\u0003\u001a\tm!Q\u0004B\u0010\u0005C\u0011\u0019C!\n\u0003(\t%\u0002b\u00028#!\u0003\u0005\r\u0001\u001d\u0005\bi\n\u0002\n\u00111\u0001q\u0011\u001d1(\u0005%AA\u0002ADq\u0001\u001f\u0012\u0011\u0002\u0003\u0007\u0001\u000fC\u0004{EA\u0005\t\u0019\u00019\t\u000fq\u0014\u0003\u0013!a\u0001a\"AaP\tI\u0001\u0002\u0004\t\t\u0001C\u0005\u0002\n\t\u0002\n\u00111\u0001\u0002\u000e!I\u0011\u0011\u0005\u0012\u0011\u0002\u0003\u0007\u0011Q\u0005\u0005\n\u0003[\u0011\u0003\u0013!a\u0001\u0003c\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00030)\u001a\u0001O!\r,\u0005\tM\u0002\u0003\u0002B\u001b\u0005\u007fi!Aa\u000e\u000b\t\te\"1H\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0010_\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\u00129DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011\tF\u000b\u0003\u0002\u0002\tE\u0012AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005/RC!!\u0004\u00032\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012JTC\u0001B/U\u0011\t)C!\r\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cA*\"Aa\u0019+\t\u0005E\"\u0011G\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t%\u0004\u0003\u0002B6\u0005cj!A!\u001c\u000b\t\t=\u0014qY\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001c\t5\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAR\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a'\u0003|!I!QP\u0018\u0002\u0002\u0003\u0007\u00111U\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0005C\u0002BC\u0005\u0017\u000bY*\u0004\u0002\u0003\b*\u0019!\u0011\u00120\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u000e\n\u001d%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\n\u0003\u0014\"I!QP\u0019\u0002\u0002\u0003\u0007\u00111T\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003j\te\u0005\"\u0003B?e\u0005\u0005\t\u0019AAR\u0003\u0019)\u0017/^1mgR!\u0011Q\u0005BP\u0011%\u0011ihMA\u0001\u0002\u0004\tY\nK\f\u0001\u0005G\u0013IKa+\u00030\nE&Q\u0017B\\\u0005w\u0013iL!1\u0003DB\u00191K!*\n\u0007\t\u001dFIA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t5\u0016A!9`\rVs5i\u0018\u0015zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs2\u0002\u0003n\\;sY\u0001j\u0017N\u001c\u0017!g\u0016\u001c7\f\f\u0011uS6,'p\u001c8f;&\u0002S\u0006I\"sK\u0006$X\r\t;j[\u0016\u001cH/Y7qA\u0019\u0014x.\u001c\u0011zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs2\u0002\u0003n\\;sY\u0001j\u0017N\u001c\u0017!g\u0016\u001c\u0007%\u00198eAQLW.\u001a>p]\u0016\u0004c-[3mINt\u0003\u0005\u00165fAI,7/\u001e7uA\u0011\fG/\u0019\u0011usB,\u0007%[:!G>t7/[:uK:$\be^5uQ\u0002\"\b.\u001a\u0011wC2,X\rI8gA\r|gNZ5hkJ\fG/[8oA\u0001\u001c\b/\u0019:l]M\fHN\f;j[\u0016\u001cH/Y7q)f\u0004X\r\u0019\u0018!\u0013\u001a\u0004C\u000f[3!G>tg-[4ve\u0006$\u0018n\u001c8!AN\u0004\u0018M]6/gFdg&\u00198tS:*g.\u00192mK\u0012\u0004\u0007%[:!M\u0006d7/\u001a\u0017!i\",\u0007EZ;oGRLwN\u001c\u0011sKR,(O\\:!\u001dVcE\nI8oA%tg/\u00197jI\u0002Jg\u000e];ug:\u0002s\n\u001e5fe^L7/\u001a\u0017!SR\u0004s/\u001b7mAQD'o\\<!C:\u0004SM\u001d:pe\u0002Jgn\u001d;fC\u0012t\u0013!C1sOVlWM\u001c;tC\t\u0011\u0019,ACL\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Q>,(\u000fI\u0017!i\",\u0007\u0005[8ve6zg-\f3bs\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!a\u0001\"x\u000e\t\u001a4\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001j\u0017N\u001c\u0011.AQDW\rI7j]V$X-L8g[!|WO\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u0011u_\u0002*\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u000e\u0004S\u0006\t;iK\u0002\u001aXmY8oI6zg-L7j]V$X\rI1oI\u0002JGo\u001d\u0011nS\u000e\u0014x.\f4sC\u000e$\u0018n\u001c8!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000e\t\u0019!i>\u0004c\u0007\r\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007E^1mk\u0016\u00043-\u00198!E\u0016\u0004S-\u001b;iKJ\u0004\u0013M\u001c\u0011j]R,w-\u001a:!Y&\\W\rI\u00194A1\u0002sN\u001d\u0011bA\u0019\u0014\u0018m\u0019;j_:\u0004C.[6fAE\u001ad&\r\u001a4])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Je\r\t;iK\u0002\u001aXm\u0019\u0011be\u001e,X.\u001a8uA\u0015\fX/\u00197tAQ|\u0007E\u000e\u0019-AQDW\rI:fG>tGm\u001d\u0011gS\u0016dG\rI5tAM,GO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;pAA\u0002\u0013M\u001c3!c\u0001j\u0017N\\;uK\u0002J7\u000fI1eI\u0016$\u0007\u0005^8!i\",\u0007EZ5oC2\u0004C/[7fgR\fW\u000e\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.\u001a>p]\u0016\u0004S\u0006\t;iK\u0002\"\u0018.\\3!u>tW\rI5eK:$\u0018NZ5fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001\u001aU\t\u0016\u0017!+R\u001b\u0005%\u00198eA\u0015$8M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003:\u0006\u0019iB\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aE\"D\u0006I\u00193Y\u0001\u0012\u0004\b\f\u00117Y\u0001\u001a\u0004\u0007\f\u00115k9B\u0004hN\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014\u0007N\u00172e5\u0012\u0004\b\t\u00197uM\u0002$\bN\u001b/qa:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u001a1cQb\u0003%\r\u001a-AIBD\u0006\t\u001c-AM\u0002D\u0006\t\u001b6]aBt\u0007\f\u0011(\u0007\u0016#v%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nD'L\u00193[I:\u0004EM\u0019;gARD'\u000e\u00189q]R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002c\u0007\f\u00114a1\u0002#g\r\u0017!keb\u0003E\u000e\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001d.a]j\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'M\u001d-AYb\u0003e\r\u0019-AI\u001aD\u0006I\u001b:Y\u0001\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aEJT\u0006\r\u001c.gA\u0002#g\r\u001e6si\u0002\u0014G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015ok2dG\u0006I\u001c-AI\u0012D\u0006I\u00196Y\u0001\u001a\u0004\u0007\f\u00111SmR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B`\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#A!2\u0002\u000bMr\u0003G\f\u0019\u0002\u001b5\u000b7.\u001a+j[\u0016\u001cH/Y7q!\t\u0019VgE\u00036\u0005\u001b\u0014I\u000e\u0005\u000b\u0003P\nU\u0007\u000f\u001d9qaB\f\t!!\u0004\u0002&\u0005E\u00121I\u0007\u0003\u0005#T1Aa5_\u0003\u001d\u0011XO\u001c;j[\u0016LAAa6\u0003R\n\u0011\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u00191!\u0011\u0011YN!9\u000e\u0005\tu'\u0002\u0002Bp\u0003\u000f\f!![8\n\u00071\u0014i\u000e\u0006\u0002\u0003J\u0006AAo\\*ue&tw\r\u0006\u0002\u0003j\u0005)\u0011\r\u001d9msR1\u00121\tBw\u0005_\u0014\tPa=\u0003v\n](\u0011 B~\u0005{\u0014y\u0010C\u0003oq\u0001\u0007\u0001\u000fC\u0003uq\u0001\u0007\u0001\u000fC\u0003wq\u0001\u0007\u0001\u000fC\u0003yq\u0001\u0007\u0001\u000fC\u0003{q\u0001\u0007\u0001\u000fC\u0003}q\u0001\u0007\u0001\u000f\u0003\u0005\u007fqA\u0005\t\u0019AA\u0001\u0011%\tI\u0001\u000fI\u0001\u0002\u0004\ti\u0001C\u0005\u0002\"a\u0002\n\u00111\u0001\u0002&!I\u0011Q\u0006\u001d\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0003(A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u0013:\u0003A\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\n\u0004'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r51Q\u0003\t\u0006;\u0006\r1q\u0002\t\u0012;\u000eE\u0001\u000f\u001d9qaB\f\t!!\u0004\u0002&\u0005E\u0012bAB\n=\n9A+\u001e9mKF\u0002\u0004\"CB\f{\u0005\u0005\t\u0019AA\"\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%s\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB\u0013!\u0011\u0011Yga\n\n\t\r%\"Q\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private final DataType dataType;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static DataType $lessinit$greater$default$10() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>> unapply(MakeTimestamp x$0) {
        return MakeTimestamp$.MODULE$.unapply(x$0);
    }

    public static DataType apply$default$10() {
        return MakeTimestamp$.MODULE$.apply$default$10();
    }

    public static boolean apply$default$9() {
        return MakeTimestamp$.MODULE$.apply$default$9();
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, Function1<DataType, MakeTimestamp>>>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.year(), (List)new .colon.colon((Object)this.month(), (List)new .colon.colon((Object)this.day(), (List)new .colon.colon((Object)this.hour(), (List)new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.sec(), (List)Nil$.MODULE$)))))).$plus$plus(this.timezone());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)new DecimalType(16, 6), (List)Nil$.MODULE$)))))).$plus$plus((IterableOnce)this.timezone().map((Function1 & Serializable)x$10 -> StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())));
    }

    @Override
    public boolean nullable() {
        if (this.failOnError()) {
            return this.children().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nullable()));
        }
        return true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$9();
        DataType x$10 = this.copy$default$10();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1, x$9, x$10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndMicros, ZoneId zoneId) {
        try {
            LocalDateTime localDateTime;
            Predef$.MODULE$.assert(secAndMicros.scale() == 6, (Function0 & Serializable)() -> "Seconds fraction must have 6 digits for microseconds but got " + secAndMicros.scale());
            long unscaledSecFrac = secAndMicros.toUnscaledLong();
            int totalMicros = (int)unscaledSecFrac;
            int seconds = Math.floorDiv(totalMicros, 1000000);
            int nanos = Math.floorMod(totalMicros, 1000000) * 1000;
            if (seconds == 60) {
                if (nanos != 0) throw QueryExecutionErrors$.MODULE$.invalidFractionOfSecondError(secAndMicros.toDouble());
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            Long l = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant())) : BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt));
            return l;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            DateTimeException dateTimeException = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkDateTimeException) {
                SparkDateTimeException sparkDateTimeException = (SparkDateTimeException)throwable2;
                if (this.failOnError()) {
                    throw sparkDateTimeException;
                }
            }
            if (throwable2 instanceof DateTimeException) {
                bl = true;
                dateTimeException = (DateTimeException)throwable2;
                if (this.failOnError()) {
                    throw QueryExecutionErrors$.MODULE$.ansiDateTimeArgumentOutOfRange(dateTimeException);
                }
            }
            if (!bl) throw throwable;
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName()), "$");
        String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.ansiDateTimeArgumentOutOfRange(e);" : ev.isNull() + " = true;";
        String failOnSparkErrorBranch = this.failOnError() ? "throw e;" : ev.isNull() + " = true;";
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable)tz -> dtu + ".getZoneId(" + tz + ".toString())").getOrElse((Function0 & Serializable)() -> zid);
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            String toMicrosCode = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |java.time.Instant instant = ldt.atZone(" + zoneId + ").toInstant();\n           |" + ev.value() + " = " + dtu + ".instantToMicros(instant);\n           |")) : ev.value() + " = " + dtu + ".localDateTimeToMicros(ldt);";
            return "\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = " + secAndNanos + ".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = " + d + "$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((" + secAndNanos + ".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              " + year + ", " + month + ", " + day + ", " + hour + ", " + min + ", 0, 0).plusMinutes(1);\n          } else {\n            throw QueryExecutionErrors.invalidFractionOfSecondError(" + secAndNanos + ".toDouble());\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(" + year + ", " + month + ", " + day + ", " + hour + ", " + min + ", seconds, nanos);\n        }\n        " + toMicrosCode + "\n      } catch (org.apache.spark.SparkDateTimeException e) {\n        " + failOnSparkErrorBranch + "\n      } catch (java.time.DateTimeException e) {\n        " + failOnErrorBranch + "\n      }";
        });
    }

    @Override
    public String nodeName() {
        return "make_timestamp";
    }

    @Override
    public MakeTimestamp withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        None$ timezoneOpt = this.timezone().isDefined() ? new Some(newChildren.apply(6)) : None$.MODULE$;
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Option<Expression>)timezoneOpt, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId, failOnError, dataType);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public DataType copy$default$10() {
        return this.dataType();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    public boolean copy$default$9() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.year();
            }
            case 1: {
                return this.month();
            }
            case 2: {
                return this.day();
            }
            case 3: {
                return this.hour();
            }
            case 4: {
                return this.min();
            }
            case 5: {
                return this.sec();
            }
            case 6: {
                return this.timezone();
            }
            case 7: {
                return this.timeZoneId();
            }
            case 8: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
            case 9: {
                return this.dataType();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "year";
            }
            case 1: {
                return "month";
            }
            case 2: {
                return "day";
            }
            case 3: {
                return "hour";
            }
            case 4: {
                return "min";
            }
            case 5: {
                return "sec";
            }
            case 6: {
                return "timezone";
            }
            case 7: {
                return "timeZoneId";
            }
            case 8: {
                return "failOnError";
            }
            case 9: {
                return "dataType";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        if (this.failOnError() != makeTimestamp.failOnError()) return false;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = makeTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        this.dataType = dataType;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), (DataType)SQLConf$.MODULE$.get().timestampType());
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), (DataType)SQLConf$.MODULE$.get().timestampType());
    }
}

