/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1.0 _FUNC_ '1';\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005H\u0001\tE\t\u0015!\u0003C\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015a\u0006\u0001\"\u0015^\u0011\u0015)\u0007\u0001\"\u0015g\u0011\u001dY\u0007!!A\u0005\u00021Dqa\u001c\u0001\u0012\u0002\u0013\u0005\u0001\u000fC\u0004|\u0001E\u0005I\u0011\u00019\t\u000fq\u0004\u0011\u0011!C!{\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001a\u0001\u0005\u0005I\u0011IA\u001b\u0011%\tI\u0004AA\u0001\n\u0003\nYdB\u0005\u0002fq\t\t\u0011#\u0001\u0002h\u0019A1\u0004HA\u0001\u0012\u0003\tI\u0007\u0003\u0004I+\u0011\u0005\u0011\u0011\u0011\u0005\n\u0003\u0007+\u0012\u0011!C#\u0003\u000bC\u0011\"a\"\u0016\u0003\u0003%\t)!#\t\u0013\u0005=U#!A\u0005\u0002\u0006E\u0005\"CAR+\u0005\u0005I\u0011BAS\u0005=aUm]:UQ\u0006twJ]#rk\u0006d'BA\u000f\u001f\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005}\u0001\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Qc\u0006\u000e\t\u0003W1j\u0011\u0001H\u0005\u0003[q\u0011\u0001CQ5oCJL8i\\7qCJL7o\u001c8\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011Q'\u0010\b\u0003mmr!a\u000e\u001e\u000e\u0003aR!!\u000f\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014B\u0001\u001f1\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005q\u0002\u0014\u0001\u00027fMR,\u0012A\u0011\t\u0003W\rK!\u0001\u0012\u000f\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)[E\n\u0005\u0002,\u0001!)\u0001)\u0002a\u0001\u0005\")a)\u0002a\u0001\u0005\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#A(\u0011\u0005=\u0002\u0016BA)1\u0005\u001d\u0011un\u001c7fC:\faa]=nE>dW#\u0001+\u0011\u0005UKfB\u0001,X!\t9\u0004'\u0003\u0002Ya\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tA\u0006'\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002_C\u000e\u0004\"aL0\n\u0005\u0001\u0004$aA!os\")!\r\u0003a\u0001=\u00061\u0011N\u001c9viFBQ\u0001\u001a\u0005A\u0002y\u000ba!\u001b8qkR\u0014\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r\u0011u-\u001b\u0005\u0006Q&\u0001\rAQ\u0001\b]\u0016<H*\u001a4u\u0011\u0015Q\u0017\u00021\u0001C\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$2AS7o\u0011\u001d\u0001%\u0002%AA\u0002\tCqA\u0012\u0006\u0011\u0002\u0003\u0007!)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003ET#A\u0011:,\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0013Ut7\r[3dW\u0016$'B\u0001=1\u0003)\tgN\\8uCRLwN\\\u0005\u0003uV\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0011\u0001\u00026bm\u0006L1AWA\u0001\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0001E\u00020\u0003#I1!a\u00051\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rq\u0016\u0011\u0004\u0005\n\u00037y\u0011\u0011!a\u0001\u0003\u001f\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0011!\u0015\t\u0019#!\u000b_\u001b\t\t)CC\u0002\u0002(A\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY#!\n\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u001f\u0006E\u0002\u0002CA\u000e#\u0005\u0005\t\u0019\u00010\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004}\u0006]\u0002\"CA\u000e%\u0005\u0005\t\u0019AA\b\u0003\u0019)\u0017/^1mgR\u0019q*!\u0010\t\u0011\u0005m1#!AA\u0002yCs\u0003AA!\u0003\u000f\nI%!\u0014\u0002P\u0005M\u0013QKA-\u00037\ny&!\u0019\u0011\u0007-\n\u0019%C\u0002\u0002Fq\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002L\u0005qU\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t1fqB\u0014\u0018\u0007\u0019\u0011jg\u0002bWm]:!i\"\fg\u000eI8sA\u0015\fX/\u00197!i>\u0004\u0003-\u001a=qeJ\u0002g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011\u0011K\u0001\u0003\u0014*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeJ\u0002S\u0006\t;iK\u0002\"xo\u001c\u0011fqB\u0014Xm]:j_:\u001c\b%\\;ti\u0002\u0012W\rI:b[\u0016\u0004C/\u001f9fA=\u0014\beY1oA\t,\u0007eY1ti\u0016$\u0007\u0005^8!C\u0002\u001aw.\\7p]\u0002\"\u0018\u0010]3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eA5,8\u000f\u001e\u0011cK\u0002\n\u0007\u0005^=qK\u0002\"\b.\u0019;!G\u0006t\u0007EY3!_J$WM]3e]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-A5\f\u0007\u000f\t;za\u0016\u0004\u0013n\u001d\u0011o_R\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0017!g>\u0004\u0013\u000e\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001J7\u000f\t8pi\u0002\u001aX\u000f\u001d9peR,GM\f\u0011G_J\u00043m\\7qY\u0016D\b\u0005^=qKN\u00043/^2iA\u0005\u0014(/Y=0gR\u0014Xo\u0019;-AQDW\r\t3bi\u0006\u0004C/\u001f9fg\u0002zg\r\t4jK2$7\u000fI7vgRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011cK\u0002z'\u000fZ3sC\ndWM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002X\u0005\u0011yJ\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00113A}3UKT\"`AIZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013G\f\u0019!?\u001a+fjQ0!OE:3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015!?\u001a+fjQ0!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%\u000b\u0011`\rVs5i\u0018\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171q5\u0002\u0014\u0007\t\u00195uE:$(\u000e\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\n\u0004e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA/\u0003\u0015\td\u0006\r\u00181\u0003\u00159'o\\;qC\t\t\u0019'A\bqe\u0016$\u0017nY1uK~3WO\\2t\u0003=aUm]:UQ\u0006twJ]#rk\u0006d\u0007CA\u0016\u0016'\u0015)\u00121NA<!\u001d\ti'a\u001dC\u0005*k!!a\u001c\u000b\u0007\u0005E\u0004'A\u0004sk:$\u0018.\\3\n\t\u0005U\u0014q\u000e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BA=\u0003\u007fj!!a\u001f\u000b\t\u0005u\u0014QA\u0001\u0003S>L1APA>)\t\t9'\u0001\u0005u_N#(/\u001b8h)\u0005q\u0018!B1qa2LH#\u0002&\u0002\f\u00065\u0005\"\u0002!\u0019\u0001\u0004\u0011\u0005\"\u0002$\u0019\u0001\u0004\u0011\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003'\u000by\nE\u00030\u0003+\u000bI*C\u0002\u0002\u0018B\u0012aa\u00149uS>t\u0007#B\u0018\u0002\u001c\n\u0013\u0015bAAOa\t1A+\u001e9mKJB\u0001\"!)\u001a\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAT!\ry\u0018\u0011V\u0005\u0005\u0003W\u000b\tA\u0001\u0004PE*,7\r\u001e")
public class LessThanOrEqual
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThanOrEqual x$0) {
        return LessThanOrEqual$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThanOrEqual> tupled() {
        return LessThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThanOrEqual>> curried() {
        return LessThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return "<=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lteq(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public LessThanOrEqual copy(Expression left, Expression right) {
        return new LessThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThanOrEqual;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public LessThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

