/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Extract$;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(field FROM source) - Extracts a part of the date or timestamp or time or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted\n          - Supported string values of `field` for dates and timestamps are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the year field\n              - \"YEAROFWEEK\" - the ISO 8601 week-numbering year that the datetime falls in. For example, 2005-01-02 is part of the 53rd week of year 2004, so the result is 2004\n              - \"QUARTER\", (\"QTR\") - the quarter (1 - 4) of the year that the datetime falls in\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the month field (1 - 12)\n              - \"WEEK\", (\"W\", \"WEEKS\") - the number of the ISO 8601 week-of-week-based-year. A week is considered to start on a Monday and week 1 is the first week with >3 days. In the ISO week-numbering system, it is possible for early-January dates to be part of the 52nd or 53rd week of the previous year, and for late-December dates to be part of the first week of the next year. For example, 2005-01-02 is part of the 53rd week of year 2004, while 2012-12-31 is part of the first week of 2013\n              - \"DAY\", (\"D\", \"DAYS\") - the day of the month field (1 - 31)\n              - \"DAYOFWEEK\",(\"DOW\") - the day of the week for datetime as Sunday(1) to Saturday(7)\n              - \"DAYOFWEEK_ISO\",(\"DOW_ISO\") - ISO 8601 based day of the week for datetime as Monday(1) to Sunday(7)\n              - \"DOY\" - the day of the year (1 - 365/366)\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - The hour field (0 - 23)\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - the minutes field (0 - 59)\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - the seconds field, including fractional parts\n          - Supported string values of `field` for interval(which consists of `months`, `days`, `microseconds`) are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the total `months` / 12\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the total `months` % 12\n              - \"DAY\", (\"D\", \"DAYS\") - the `days` part of interval\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - how many hours the `microseconds` contains\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - how many minutes left after taking hours from `microseconds`\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - how many second with fractions left after taking hours and minutes from `microseconds`\n          - Supported string values of `field` for time (which consists of `hour`, `minute`, `second`) are(case insensitive):\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - The hour field (0 - 23)\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - the minutes field (0 - 59)\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - the seconds field, including fractional parts up to micro second precision. Returns a DECIMAL(8, 6) precision value.\n      * source - a date or timestamp or time or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(YEAR FROM TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_(week FROM timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_(doy FROM DATE'2019-08-12');\n       224\n      > SELECT _FUNC_(SECONDS FROM timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_(days FROM interval 5 days 3 hours 7 minutes);\n       5\n      > SELECT _FUNC_(seconds FROM interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n      > SELECT _FUNC_(MONTH FROM INTERVAL '2021-11' YEAR TO MONTH);\n       11\n      > SELECT _FUNC_(MINUTE FROM INTERVAL '123 23:55:59.002001' DAY TO SECOND);\n       55\n      > SELECT _FUNC_(HOUR FROM time '09:08:01.000001');\n       9\n      > SELECT _FUNC_(MINUTE FROM time '09:08:01.000001');\n       8\n      > SELECT _FUNC_(SECOND FROM time '09:08:01.000001');\n       1.000001\n  ", note="\n    The _FUNC_ function is equivalent to `date_part(field, source)`.\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001\u0002\u0010 \u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005[!AA\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005N\u0001\tE\t\u0015!\u0003.\u0011!q\u0005A!f\u0001\n\u0003Q\u0005\u0002C(\u0001\u0005#\u0005\u000b\u0011B\u0017\t\u000bA\u0003A\u0011A)\t\u000bA\u0003A\u0011\u0001,\t\u000be\u0003A\u0011\t.\t\u000by\u0003A\u0011I0\t\u000b-\u0004A\u0011\u000b7\t\u000f=\u0004\u0011\u0011!C\u0001a\"9A\u000fAI\u0001\n\u0003)\b\u0002CA\u0001\u0001E\u0005I\u0011A;\t\u0011\u0005\r\u0001!%A\u0005\u0002UD\u0011\"!\u0002\u0001\u0003\u0003%\t%a\u0002\t\u0013\u0005]\u0001!!A\u0005\u0002\u0005e\u0001\"CA\u0011\u0001\u0005\u0005I\u0011AA\u0012\u0011%\ty\u0003AA\u0001\n\u0003\n\t\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0001\u0002B!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003':q!a! \u0011\u0003\t)I\u0002\u0004\u001f?!\u0005\u0011q\u0011\u0005\u0007!b!\t!!'\t\u000f\u0005m\u0005\u0004\"\u0001\u0002\u001e\"I\u0011q\u0015\r\u0002\u0002\u0013\u0005\u0015\u0011\u0016\u0005\n\u0003cC\u0012\u0011!CA\u0003gC\u0011\"!2\u0019\u0003\u0003%I!a2\u0003\u000f\u0015CHO]1di*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001[E\"t'\u0010\t\u0003]=j\u0011aH\u0005\u0003a}\u0011!\"\u0012=qe\u0016\u001c8/[8o!\tq#'\u0003\u00024?\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\tqS'\u0003\u00027?\t!\u0012J\u001c5fe&$\u0018I\\1msNL7OU;mKN\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\r:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005.\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005\u0015K\u0014a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!R\u001d\u0002\u000b\u0019LW\r\u001c3\u0016\u00035\naAZ5fY\u0012\u0004\u0013AB:pkJ\u001cW-A\u0004t_V\u00148-\u001a\u0011\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e^\u0001\re\u0016\u0004H.Y2f[\u0016tG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI\u001bF+\u0016\t\u0003]\u0001AQ!S\u0004A\u00025BQ\u0001T\u0004A\u00025BQAT\u0004A\u00025\"2AU,Y\u0011\u0015I\u0005\u00021\u0001.\u0011\u0015a\u0005\u00021\u0001.\u0003)\u0001\u0018M]1nKR,'o]\u000b\u00027B\u0019a\bX\u0017\n\u0005uC%aA*fc\u0006iQ.Y6f'Fc5\u000b\u001e:j]\u001e$\"\u0001\u00195\u0011\u0005\u0005,gB\u00012d!\t\u0001\u0015(\u0003\u0002es\u00051\u0001K]3eK\u001aL!AZ4\u0003\rM#(/\u001b8h\u0015\t!\u0017\bC\u0003j\u0015\u0001\u0007!.A\u0006dQ&dGM]3o'Fc\u0005c\u0001 ]A\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"!L7\t\u000b9\\\u0001\u0019A\u0017\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR!!+\u001d:t\u0011\u001dIE\u0002%AA\u00025Bq\u0001\u0014\u0007\u0011\u0002\u0003\u0007Q\u0006C\u0004O\u0019A\u0005\t\u0019A\u0017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\taO\u000b\u0002.o.\n\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003{f\n!\"\u00198o_R\fG/[8o\u0013\ty(PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003'\tAA[1wC&\u0019a-!\u0004\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0001c\u0001\u001d\u0002\u001e%\u0019\u0011qD\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00121\u0006\t\u0004q\u0005\u001d\u0012bAA\u0015s\t\u0019\u0011I\\=\t\u0013\u00055\"#!AA\u0002\u0005m\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00024A1\u0011QGA\u001e\u0003Ki!!a\u000e\u000b\u0007\u0005e\u0012(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0010\u00028\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019%!\u0013\u0011\u0007a\n)%C\u0002\u0002He\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002.Q\t\t\u00111\u0001\u0002&\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tI!a\u0014\t\u0013\u00055R#!AA\u0002\u0005m\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002D\u0005U\u0003\"CA\u0017-\u0005\u0005\t\u0019AA\u0013Qm\u0001\u0011\u0011LA0\u0003C\n)'a\u001a\u0002l\u00055\u0014\u0011OA:\u0003o\nI(! \u0002\u0000A\u0019a&a\u0017\n\u0007\u0005usDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\r\u0014\u0001Y0G+:\u001bu\f\u000b4jK2$\u0007E\u0012*P\u001b\u0002\u001ax.\u001e:dK&\u0002S\u0006I#yiJ\f7\r^:!C\u0002\u0002\u0018M\u001d;!_\u001a\u0004C\u000f[3!I\u0006$X\rI8sAQLW.Z:uC6\u0004\be\u001c:!i&lW\rI8sA%tG/\u001a:wC2\u00043o\\;sG\u0016t\u0013!C1sOVlWM\u001c;tC\t\tI'ALE\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002c-[3mI\u0002j\u0003e]3mK\u000e$8\u000fI<iS\u000eD\u0007\u0005]1si\u0002zg\r\t;iK\u0002\u001ax.\u001e:dK\u0002\u001a\bn\\;mI\u0002\u0012W\rI3yiJ\f7\r^3e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011TkB\u0004xN\u001d;fI\u0002\u001aHO]5oO\u00022\u0018\r\\;fg\u0002zg\r\t1gS\u0016dG\r\u0019\u0011g_J\u0004C-\u0019;fg\u0002\ng\u000e\u001a\u0011uS6,7\u000f^1naN\u0004\u0013M]3)G\u0006\u001cX\rI5og\u0016t7/\u001b;jm\u0016L#H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!Ee+\u0015I\u0015\u0012-A!\u0012\u0013L\t\u0017!Ee+\u0015IU*#Y\u0001\u0012\u0013L\u0015\u0012-A\tJ&k\u0015\u0012*A5\u0002C\u000f[3!s\u0016\f'\u000f\t4jK2$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#3\u0016\u000b%k\u0014$X\u000b\u0016[%\u0005I\u0017!i\",\u0007%S*PAa2\u0004'\r\u0011xK\u0016\\WF\\;nE\u0016\u0014\u0018N\\4!s\u0016\f'\u000f\t;iCR\u0004C\u000f[3!I\u0006$X\r^5nK\u00022\u0017\r\u001c7tA%tg\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003E\r\u00191k5\u0002\u0014'\f\u00193A%\u001c\b\u0005]1si\u0002zg\r\t;iK\u0002*4G\u001d3!o\u0016,7\u000eI8gAe,\u0017M\u001d\u00113aA\"D\u0006I:pAQDW\r\t:fgVdG\u000fI5tAI\u0002\u0004\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\nV+\u0011*U\u000bJ\u0013C\u0006\t\u0015##R\u0013&%\u000b\u0011.AQDW\rI9vCJ$XM\u001d\u0011)c\u0001j\u0003\u0005N\u0015!_\u001a\u0004C\u000f[3!s\u0016\f'\u000f\t;iCR\u0004C\u000f[3!I\u0006$X\r^5nK\u00022\u0017\r\u001c7tA%t'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b>sE\u000b\u0013\u0012-A!\u0012Sj\u0014(#Y\u0001\u0012Sj\u0014(TE1\u0002#%T(O)\"\u001b&%\u000b\u0011.AQDW\rI7p]RD\u0007EZ5fY\u0012\u0004\u0003&\r\u0011.AE\u0012\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E]+Ui\u0013\u0012-A!\u0012sK\t\u0017!E]+UiS*#S\u0001j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007\u0005\u001e5fA%\u001bv\n\t\u001d7aE\u0002s/Z3l[=4Wf^3fW6\u0012\u0017m]3e[e,\u0017M\u001d\u0018!\u0003\u0002:X-Z6!SN\u00043m\u001c8tS\u0012,'/\u001a3!i>\u00043\u000f^1si\u0002zg\u000eI1!\u001b>tG-Y=!C:$\u0007e^3fW\u0002\n\u0004%[:!i\",\u0007EZ5sgR\u0004s/Z3lA]LG\u000f\u001b\u0011?g\u0001\"\u0017-_:/A%s\u0007\u0005\u001e5fA%\u001bv\nI<fK.lc.^7cKJLgn\u001a\u0011tsN$X-\u001c\u0017!SR\u0004\u0013n\u001d\u0011q_N\u001c\u0018N\u00197fA\u0019|'\u000fI3be2LXFS1ok\u0006\u0014\u0018\u0010\t3bi\u0016\u001c\b\u0005^8!E\u0016\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fAU\u0012d\u000e\u001a\u0011pe\u0002*4G\u001d3!o\u0016,7\u000eI8gAQDW\r\t9sKZLw.^:!s\u0016\f'\u000f\f\u0011b]\u0012\u0004cm\u001c:!Y\u0006$X-\f#fG\u0016l'-\u001a:!I\u0006$Xm\u001d\u0011u_\u0002\u0012W\r\t9beR\u0004sN\u001a\u0011uQ\u0016\u0004c-\u001b:ti\u0002:X-Z6!_\u001a\u0004C\u000f[3!]\u0016DH\u000fI=fCJt\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002#\u0007\r\u00196[A\nT\u0006\r\u001a!SN\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fAU\u001a$\u000f\u001a\u0011xK\u0016\\\u0007e\u001c4!s\u0016\f'\u000f\t\u001a1aQb\u0003e\u001e5jY\u0016\u0004#\u0007M\u00193[E\u0012TfM\u0019!SN\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fA\u0019L'o\u001d;!o\u0016,7\u000eI8gAI\u0002\u0014g\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\"\u0015)\u0017\u0012-A!\u0012CI\t\u0017!E\u0011\u000b\u0015l\u0015\u0012*A5\u0002C\u000f[3!I\u0006L\be\u001c4!i\",\u0007%\\8oi\"\u0004c-[3mI\u0002B\u0013\u0007I\u0017!gEJ#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\t\u0006KvJR,F\u000b.\u0013C\u0006\u000b\u0012E\u001f^\u0013\u0013\u0006I\u0017!i\",\u0007\u0005Z1zA=4\u0007\u0005\u001e5fA],Wm\u001b\u0011g_J\u0004C-\u0019;fi&lW\rI1tAM+h\u000eZ1zQEJ\u0003\u0005^8!'\u0006$XO\u001d3bs\":\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011\u000b\u0015l\u0014$X\u000b\u0016[u,S*PE1B#\u0005R(X?&\u001bvJI\u0015![\u0001J5k\u0014\u00119mA\n\u0004EY1tK\u0012\u0004C-Y=!_\u001a\u0004C\u000f[3!o\u0016,7\u000e\t4pe\u0002\"\u0017\r^3uS6,\u0007%Y:!\u001b>tG-Y=)c%\u0002Co\u001c\u0011Tk:$\u0017-\u001f\u00158S)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#P3\n\u0002S\u0006\t;iK\u0002\"\u0017-\u001f\u0011pM\u0002\"\b.\u001a\u0011zK\u0006\u0014\b\u0005K\u0019![\u0001\u001ad'N\u00184mYJ#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u0011>+&K\t\u0017!Q\tB%\u0005\f\u0011#\u0011>+&k\u0015\u0012-A\tB%K\t\u0017!E!\u00136KI\u0015![\u0001\"\u0006.\u001a\u0011i_V\u0014\bEZ5fY\u0012\u0004\u0003\u0006\r\u0011.AI\u001a\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5Ke*\u0016+FE1\u0002\u0003FI'#Y\u0001\u0012S*\u0013(#Y\u0001\u0012S*\u0013(TE1\u0002#%T%O+R+5KI\u0015![\u0001\"\b.\u001a\u0011nS:,H/Z:!M&,G\u000e\u001a\u0011)a\u0001j\u0003%N\u001d*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#eU#D\u001f:#%\u0005\f\u0011)EM\u0013C\u0006\t\u0012T\u000b\u000e\u0013C\u0006\t\u0012T\u000b\u000e{e\nR*#Y\u0001\u00123+R\"TE%\u0002S\u0006\t;iK\u0002\u001aXmY8oIN\u0004c-[3mI2\u0002\u0013N\\2mk\u0012Lgn\u001a\u0011ge\u0006\u001cG/[8oC2\u0004\u0003/\u0019:ug*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!'V\u0004\bo\u001c:uK\u0012\u00043\u000f\u001e:j]\u001e\u0004c/\u00197vKN\u0004sN\u001a\u0011aM&,G\u000e\u001a1!M>\u0014\b%\u001b8uKJ4\u0018\r\u001c\u0015xQ&\u001c\u0007\u000eI2p]NL7\u000f^:!_\u001a\u0004\u0003-\\8oi\"\u001c\b\r\f\u0011aI\u0006L8\u000f\u0019\u0017!A6L7M]8tK\u000e|g\u000eZ:aS\u0001\n'/\u001a\u0015dCN,\u0007%\u001b8tK:\u001c\u0018\u000e^5wK&R$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#3\u0016\u000b%K\t\u0017!Q\tJ&\u0005\f\u0011#3\u0016\u000b%k\u0015\u0012-A\tJ&K\t\u0017!Ee\u00136KI\u0015![\u0001\"\b.\u001a\u0011u_R\fG\u000e\t1n_:$\bn\u001d1!_\u0001\n$G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5{e\n\u0016%#Y\u0001B#%T(OE1\u0002#%T(O'\nb\u0003EI'P\u001dRC5KI\u0015![\u0001\"\b.\u001a\u0011u_R\fG\u000e\t1n_:$\bn\u001d1!K\u0001\n$G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011\u000b\u0015L\t\u0017!Q\t\"%\u0005\f\u0011#\t\u0006K6KI\u0015![\u0001\"\b.\u001a\u0011aI\u0006L8\u000f\u0019\u0011qCJ$\be\u001c4!S:$XM\u001d<bY*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t%P+J\u0013C\u0006\t\u0015#\u0011\nb\u0003E\t%P+J\u001b&\u0005\f\u0011#\u0011J\u0013C\u0006\t\u0012I%N\u0013\u0013\u0006I\u0017!Q><\b%\\1os\u0002Bw.\u001e:tAQDW\r\t1nS\u000e\u0014xn]3d_:$7\u000f\u0019\u0011d_:$\u0018-\u001b8t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%O+R+%\u0005\f\u0011)E5\u0013C\u0006\t\u0012N\u0013:\u0013C\u0006\t\u0012N\u0013:\u001b&\u0005\f\u0011#\u001b&sU\u000bV#TE%\u0002S\u0006\t5po\u0002j\u0017M\\=![&tW\u000f^3tA1,g\r\u001e\u0011bMR,'\u000f\t;bW&tw\r\t5pkJ\u001c\bE\u001a:p[\u0002\u0002W.[2s_N,7m\u001c8eg\u0002T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012T\u000b\u000e{e\n\u0012\u0012-A!\u00123K\t\u0017!EM+5I\t\u0017!EM+5i\u0014(E'\nb\u0003EI*F\u0007N\u0013\u0013\u0006I\u0017!Q><\b%\\1os\u0002\u001aXmY8oI\u0002:\u0018\u000e\u001e5!MJ\f7\r^5p]N\u0004C.\u001a4uA\u00054G/\u001a:!i\u0006\\\u0017N\\4!Q>,(o\u001d\u0011b]\u0012\u0004S.\u001b8vi\u0016\u001c\bE\u001a:p[\u0002\u0002W.[2s_N,7m\u001c8eg\u0002T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.AM+\b\u000f]8si\u0016$\u0007e\u001d;sS:<\u0007E^1mk\u0016\u001c\be\u001c4!A\u001aLW\r\u001c3aA\u0019|'\u000f\t;j[\u0016\u0004\u0003f\u001e5jG\"\u00043m\u001c8tSN$8\u000fI8gA\u0001Dw.\u001e:aY\u0001\u0002W.\u001b8vi\u0016\u0004G\u0006\t1tK\u000e|g\u000e\u001a1*A\u0005\u0014X\rK2bg\u0016\u0004\u0013N\\:f]NLG/\u001b<fSiR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012I\u001fV\u0013&\u0005\f\u0011)E!\u0013C\u0006\t\u0012I\u001fV\u00136K\t\u0017!E!\u0013&\u0005\f\u0011#\u0011J\u001b&%\u000b\u0011.AQCW\r\t5pkJ\u0004c-[3mI\u0002B\u0003\u0007I\u0017!eMJ#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b&sU\u000bV##Y\u0001B#%\u0014\u0012-A\tj\u0015J\u0014\u0012-A\tj\u0015JT*#Y\u0001\u0012S*\u0013(V)\u0016\u001b&%\u000b\u0011.AQDW\rI7j]V$Xm\u001d\u0011gS\u0016dG\r\t\u00151A5\u0002S'O\u0015\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u00123+R\"P\u001d\u0012\u0013C\u0006\t\u0015#'\nb\u0003EI*F\u0007\nb\u0003EI*F\u0007>sEi\u0015\u0012-A\t\u001aViQ*#S\u0001j\u0003\u0005\u001e5fAM,7m\u001c8eg\u00022\u0017.\u001a7eY\u0001Jgn\u00197vI&tw\r\t4sC\u000e$\u0018n\u001c8bY\u0002\u0002\u0018M\u001d;tAU\u0004\b\u0005^8![&\u001c'o\u001c\u0011tK\u000e|g\u000e\u001a\u0011qe\u0016\u001c\u0017n]5p]:\u0002#+\u001a;ve:\u001c\b%\u0019\u0011E\u000b\u000eKU*\u0011')q1\u0002c'\u000b\u0011qe\u0016\u001c\u0017n]5p]\u00022\u0018\r\\;f])\u0001\u0003\u0005\t\u0011!A)\u00023o\\;sG\u0016\u0004S\u0006I1!I\u0006$X\rI8sAQLW.Z:uC6\u0004\be\u001c:!i&lW\rI8sA%tG/\u001a:wC2\u00043m\u001c7v[:\u0004cM]8nA]DWM]3!A\u001aLW\r\u001c3aAMDw.\u001e7eA\t,\u0007%\u001a=ue\u0006\u001cG/\u001a3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003_\nqq\u0002\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)3\u0016\u000b%\u000b\t$S\u001f6\u0003C+S'F'R\u000bU\n\u0015\u0011(eA\n\u0014(\f\u00199[E\u0012\u0004\u0005M\u0019;aAR\u0004\u0007\r\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q],Wm\u001b\u0011G%>k\u0005\u0005^5nKN$\u0018-\u001c9(eA\n\u0014(\f\u00199[E\u0012\u0004\u0005M\u0019;aAR\u0004\u0007\r\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a4G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015e_f\u0004cIU(NA\u0011\u000bE+R\u00143aEJT\u0006\r\u001d.cI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113eQR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fU#D\u001f:#5\u000b\t$S\u001f6\u0003C/[7fgR\fW\u000e]\u00143aEJT&\r\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0014G\f\u00191aA\u0002\u0014gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0003\u0007\r\u00191aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006Z1zg\u00022%kT'!S:$XM\u001d<bY\u0002*\u0004\u0005Z1zg\u0002\u001a\u0004\u0005[8veN\u0004s\u0007I7j]V$Xm]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f]3d_:$7\u000f\t$S\u001f6\u0003\u0013N\u001c;feZ\fG\u000eI\u001b!Q>,(o\u001d\u00114a\u0001\u001aXmY8oIN\u0004\u0013\u0007I7jY2L7/Z2p]\u0012\u001c\b%\r\u0011nS\u000e\u0014xn]3d_:$7/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!gAr\u0003\u0007M\u00191aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&T(O)\"\u0003cIU(NA%sE+\u0012*W\u00032\u0003sE\r\u00193c5\n\u0014g\n\u0011Z\u000b\u0006\u0013\u0006\u0005V(!\u001b>sE\u000bS\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK'J\u001dV#V\t\t$S\u001f6\u0003\u0013J\u0014+F%Z\u000bE\nI\u00142eM\u0002#g\r\u001e6ki*\u0014H\f\u00191eA\u0002\u0014g\n\u0011E\u0003f\u0003Ck\u0014\u0011T\u000b\u000e{e\nR\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AU*$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b%P+J\u0003cIU(NAQLW.\u001a\u0011(aeR\u0004\u0007\u000f\u001e1c9\u0002\u0004\u0007\r\u00191c\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5Ke*\u0016+FA\u0019\u0013v*\u0014\u0011uS6,\u0007e\n\u0019:uAB$\bM\u0019/aA\u0002\u0004\u0007M\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015T\u000b\u000e{e\n\u0012\u0011G%>k\u0005\u0005^5nK\u0002:\u0003'\u000f\u001e1qi\u0002\u0014G\f\u00191aA\u0002\u0014gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0003\u0007\r\u00191aER\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002v\u0005A%\u0002\t\u0011!AQCW\rI0G+:\u001bu\f\t4v]\u000e$\u0018n\u001c8!SN\u0004S-];jm\u0006dWM\u001c;!i>\u0004\u0003\rZ1uK~\u0003\u0018M\u001d;)M&,G\u000e\u001a\u0017!g>,(oY3*A:R\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003w\na\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002\u0002\u0006)1G\f\u0019/a\u00059Q\t\u001f;sC\u000e$\bC\u0001\u0018\u0019'\u0015A\u0012\u0011RAH!\rA\u00141R\u0005\u0004\u0003\u001bK$AB!osJ+g\r\u0005\u0003\u0002\u0012\u0006]UBAAJ\u0015\u0011\t)*!\u0005\u0002\u0005%|\u0017bA$\u0002\u0014R\u0011\u0011QQ\u0001\u000bGJ,\u0017\r^3FqB\u0014HcB\u0017\u0002 \u0006\r\u0016Q\u0015\u0005\u0007\u0003CS\u0002\u0019\u00011\u0002\u0011\u0019,hn\u0019(b[\u0016DQ!\u0013\u000eA\u00025BQ\u0001\u0014\u000eA\u00025\nQ!\u00199qYf$rAUAV\u0003[\u000by\u000bC\u0003J7\u0001\u0007Q\u0006C\u0003M7\u0001\u0007Q\u0006C\u0003O7\u0001\u0007Q&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u0016\u0011\u0019\t\u0006q\u0005]\u00161X\u0005\u0004\u0003sK$AB(qi&|g\u000e\u0005\u00049\u0003{kS&L\u0005\u0004\u0003\u007fK$A\u0002+va2,7\u0007\u0003\u0005\u0002Dr\t\t\u00111\u0001S\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u0013\u0004B!a\u0003\u0002L&!\u0011QZA\u0007\u0005\u0019y%M[3di\u0002")
public class Extract
extends Expression
implements RuntimeReplaceable,
InheritAnalysisRules,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression replacement;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Extract x$0) {
        return Extract$.MODULE$.unapply(x$0);
    }

    public static Expression createExpr(String funcName, Expression field, Expression source) {
        return Extract$.MODULE$.createExpr(funcName, field, source);
    }

    @Override
    public Expression child() {
        return InheritAnalysisRules.child$(this);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return InheritAnalysisRules.flatArguments$(this);
    }

    @Override
    public final String sql() {
        return InheritAnalysisRules.sql$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        Extract extract2 = this;
        synchronized (extract2) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Extract extract2 = this;
        synchronized (extract2) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression replacement() {
        return this.replacement;
    }

    @Override
    public Seq<Expression> parameters() {
        return new .colon.colon((Object)this.field(), (List)new .colon.colon((Object)this.source(), (List)Nil$.MODULE$));
    }

    @Override
    public String makeSQLString(Seq<String> childrenSQL) {
        Some some;
        String string;
        Option<String> option = this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS());
        if (option instanceof Some && "date_part".equals(string = (String)(some = (Some)option).value())) {
            return this.prettyName() + "(" + childrenSQL.mkString(", ") + ")";
        }
        return this.prettyName() + "(" + childrenSQL.mkString(" FROM ") + ")";
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public Extract copy(Expression field, Expression source, Expression replacement) {
        return new Extract(field, source, replacement);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.replacement();
    }

    @Override
    public String productPrefix() {
        return "Extract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.field();
            }
            case 1: {
                return this.source();
            }
            case 2: {
                return this.replacement();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Extract;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "field";
            }
            case 1: {
                return "source";
            }
            case 2: {
                return "replacement";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Extract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Extract extract2 = (Extract)x$1;
        Expression expression = this.field();
        Expression expression2 = extract2.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = extract2.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replacement();
        Expression expression6 = extract2.replacement();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!extract2.canEqual(this)) return false;
        return true;
    }

    public Extract(Expression field, Expression source, Expression replacement) {
        this.field = field;
        this.source = source;
        this.replacement = replacement;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        InheritAnalysisRules.$init$(this);
        Statics.releaseFence();
    }

    public Extract(Expression field, Expression source) {
        this(field, source, Extract$.MODULE$.createExpr("extract", field, source));
    }
}

