/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.DatePartExpressionBuilder$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="_FUNC_(field, source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted, and supported string values are as same as the fields of the equivalent function `EXTRACT`.\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_('week', timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_('doy', DATE'2019-08-12');\n       224\n      > SELECT _FUNC_('SECONDS', timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_('days', interval 5 days 3 hours 7 minutes);\n       5\n      > SELECT _FUNC_('seconds', interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n      > SELECT _FUNC_('MONTH', INTERVAL '2021-11' YEAR TO MONTH);\n       11\n      > SELECT _FUNC_('MINUTE', INTERVAL '123 23:55:59.002001' DAY TO SECOND);\n       55\n  ", note="\n    The _FUNC_ function is equivalent to the SQL-standard function `EXTRACT(field FROM source)`\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005];Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\n\u0011\u0004R1uKB\u000b'\u000f^#yaJ,7o]5p]\n+\u0018\u000e\u001c3fe*\u0011aaB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\t\u0013\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0014\u00035\tQAA\rECR,\u0007+\u0019:u\u000bb\u0004(/Z:tS>t')^5mI\u0016\u00148cA\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0011\u000e\u0003yQ!aH\u0004\u0002\u0011\u0005t\u0017\r\\=tSNL!!\t\u0010\u0003#\u0015C\bO]3tg&|gNQ;jY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0002%\u0005)!-^5mIR\u0019a%\u000b\u001c\u0011\u0005M9\u0013B\u0001\u0015\u0006\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006U\r\u0001\raK\u0001\tMVt7MT1nKB\u0011Af\r\b\u0003[E\u0002\"A\f\r\u000e\u0003=R!\u0001M\t\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a\u0019\u0011\u001511\u00011\u00018!\rATH\n\b\u0003smr!A\f\u001e\n\u0003eI!\u0001\u0010\r\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\u0004'\u0016\f(B\u0001\u001f\u0019Q9\t\u0011\tR#H\u0011*[UJ\u0014)R'R\u0003\"a\u0005\"\n\u0005\r+!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0002\r\u0006\tvLR+O\u0007~Cc-[3mI2\u00023o\\;sG\u0016L\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fA\u0011\fG/Z\u0018uS6,7\u000f^1na\u0002z'\u000fI5oi\u0016\u0014h/\u00197!g>,(oY3/\u0003%\t'oZ;nK:$8/I\u0001J\u0003\t\u0005\"\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011gS\u0016dG\rI\u0017!g\u0016dWm\u0019;tA]D\u0017n\u00195!a\u0006\u0014H\u000fI8gAQDW\rI:pkJ\u001cW\rI:i_VdG\r\t2fA\u0015DHO]1di\u0016$G\u0006I1oI\u0002\u001aX\u000f\u001d9peR,G\rI:ue&tw\r\t<bYV,7\u000fI1sK\u0002\n7\u000fI:b[\u0016\u0004\u0013m\u001d\u0011uQ\u0016\u0004c-[3mIN\u0004sN\u001a\u0011uQ\u0016\u0004S-];jm\u0006dWM\u001c;!MVt7\r^5p]\u0002\u0002W\t\u0017+S\u0003\u000e#\u0006M\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!g>,(oY3![\u0001\n\u0007\u0005Z1uK>\"\u0018.\\3ti\u0006l\u0007\u000fI8sA%tG/\u001a:wC2\u00043m\u001c7v[:\u0004cM]8nA]DWM]3!A\u001aLW\r\u001c3aAMDw.\u001e7eA\t,\u0007%\u001a=ue\u0006\u001cG/\u001a3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0002\u0019\u0006)iE\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(3\u0016\u000b%k\n\u0017!)&kUi\u0015+B\u001bB\u0003sE\r\u00192s5\u0002\u0004(L\u00193AA\n$\b\r\u0019;aAr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aEJ$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014xK\u0016\\w\u0005\f\u0011uS6,7\u000f^1na\u001e\u0012\u0004'M\u001d.aaj\u0013G\r\u00111ci\u0002\u0004G\u000f\u00191]E\u00124\u0007N\u001b7O%Z$\u0002\t\u0011!A\u0001\u0002\u0003eM\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"w._\u0014-A\u0011\u000bE+R\u00143aEJT\u0006\r\u001d.cI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113eQR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*F\u0007>sEiU\u0014-AQLW.Z:uC6\u0004xE\r\u00192s5\n\u0004'\f\u00192AA\u0002$\b\r\u0019;aEr\u0003\u0007\r\u00191aE:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112]A\u0002\u0004\u0007\r\u00192\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C-Y=tO1\u0002\u0013N\u001c;feZ\fG\u000eI\u001b!I\u0006L8\u000fI\u001a!Q>,(o\u001d\u00118A5Lg.\u001e;fg&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM,7m\u001c8eg\u001eb\u0003%\u001b8uKJ4\u0018\r\u001c\u00116A!|WO]:!gA\u00023/Z2p]\u0012\u001c\b%\r\u0011nS2d\u0017n]3d_:$7\u000fI\u0019![&\u001c'o\\:fG>tGm]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0002d\u0006\r\u00192aA\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014N\u001f:#\u0006j\n\u0017!\u0013:#VI\u0015,B\u0019\u0002:#\u0007\r\u001a2[E\nt\u0005I-F\u0003J\u0003Ck\u0014\u0011N\u001f:#\u0006*K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ'J\u001dV#Vi\n\u0017!\u0013:#VI\u0015,B\u0019\u0002:\u0013GM\u001a!eMRT'\u000e\u001e6s9\u0002\u0004G\r\u00191c\u001d\u0002C)Q-!)>\u00033+R\"P\u001d\u0012K3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001b6\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f\u0013aT\u0001d\u0015\u0001\u0002\u0003\u0005\t+iK\u0002zf)\u0016(D?\u00022WO\\2uS>t\u0007%[:!KF,\u0018N^1mK:$\b\u0005^8!i\",\u0007eU)M[M$\u0018M\u001c3be\u0012\u0004c-\u001e8di&|g\u000e\t1F1R\u0013\u0016i\u0011+)M&,G\u000e\u001a\u0011G%>k\u0005e]8ve\u000e,\u0017\u0006\u0019\u0006!A\u0005)qM]8va\u0006\n!+\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0003U\u000bQa\r\u00181]ABc\u0002A!E\u000b\u001eC%jS'O!F\u001bF\u000b")
public final class DatePartExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return DatePartExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return DatePartExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return DatePartExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName);
    }

    public static Option<FunctionSignature> functionSignature() {
        return DatePartExpressionBuilder$.MODULE$.functionSignature();
    }
}

