/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ", since="1.0.1", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%f\u0001B\u0016-\u0001fB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t=\u0002\u0011\t\u0012)A\u00051\"Aq\f\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005e\u0001\tE\t\u0015!\u0003b\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u001di\u0007A1A\u0005F9Dq!a\u0003\u0001A\u00035q\u000eC\u0004\u0002\u000e\u0001!\t&a\u0004\t\u0015\u0005m\u0001\u0001#b\u0001\n\u0003\ni\u0002C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!1\u0011q\n\u0001\u0005B-Dq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u00111\u000f\u0001\u0005B\u0005U\u0004BB\u0019\u0001\t\u0003\n9\tC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003o\u0003\u0011\u0013!C\u0001\u0003sC\u0011\"a4\u0001#\u0003%\t!!5\t\u0013\u0005U\u0007!!A\u0005B\u0005]\u0007\"CAt\u0001\u0005\u0005I\u0011AAu\u0011%\t\t\u0010AA\u0001\n\u0003\t\u0019\u0010C\u0005\u0002z\u0002\t\t\u0011\"\u0011\u0002|\"I!\u0011\u0002\u0001\u0002\u0002\u0013\u0005!1\u0002\u0005\n\u0005\u001f\u0001\u0011\u0011!C!\u0005#A\u0011B!\u0006\u0001\u0003\u0003%\tEa\u0006\b\u000f\t\u0005C\u0006#\u0001\u0003D\u001911\u0006\fE\u0001\u0005\u000bBa!\u001a\u0011\u0005\u0002\t]\u0003b\u0002B-A\u0011\u0005!1\f\u0005\b\u0005C\u0002C\u0011\u0001B2\u0011%\u00119\u0007\tb\u0001\n\u0003\u0011I\u0007\u0003\u0005\u0003\b\u0002\u0002\u000b\u0011\u0002B6\u0011%\u0011I\u0006IA\u0001\n\u0003\u0013I\tC\u0005\u0003\u0010\u0002\n\n\u0011\"\u0001\u0002R\"I!\u0011\u0013\u0011\u0002\u0002\u0013\u0005%1\u0013\u0005\n\u0005;\u0003\u0013\u0013!C\u0001\u0003#D\u0011Ba(!\u0003\u0003%IA!)\u0003\u0011\r\u000b7/Z,iK:T!!\f\u0018\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003_A\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<7\u0001A\n\u0007\u0001ir\u0014\t\u0012&\u0011\u0005mbT\"\u0001\u0017\n\u0005ub#AC#yaJ,7o]5p]B\u00111hP\u0005\u0003\u00012\u0012AdQ8na2,\u0007\u0010V=qK6+'oZ5oO\u0016C\bO]3tg&|g\u000e\u0005\u0002<\u0005&\u00111\t\f\u0002\u0016\u0007>tG-\u001b;j_:\fG.\u0012=qe\u0016\u001c8/[8o!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u001d\u0001&o\u001c3vGR\u0004\"aS*\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(9\u0003\u0019a$o\\8u}%\tq)\u0003\u0002S\r\u00069\u0001/Y2lC\u001e,\u0017B\u0001+V\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0011f)\u0001\u0005ce\u0006t7\r[3t+\u0005A\u0006cA&Z7&\u0011!,\u0016\u0002\u0004'\u0016\f\b\u0003B#]uiJ!!\u0018$\u0003\rQ+\b\u000f\\33\u0003%\u0011'/\u00198dQ\u0016\u001c\b%A\u0005fYN,g+\u00197vKV\t\u0011\rE\u0002FEjJ!a\u0019$\u0003\r=\u0003H/[8o\u0003))Gn]3WC2,X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dD\u0017\u000e\u0005\u0002<\u0001!)a+\u0002a\u00011\"9q,\u0002I\u0001\u0002\u0004\t\u0017\u0001C2iS2$'/\u001a8\u0016\u00031\u00042aS-;\u00031qw\u000eZ3QCR$XM\u001d8t+\u0005y\u0007cA&ZaB\u0019\u0011/!\u0002\u000f\u0005I|hBA:~\u001d\t!HP\u0004\u0002vw:\u0011aO\u001f\b\u0003oft!!\u0014=\n\u0003]J!!\u000e\u001c\n\u0005M\"\u0014BA\u00193\u0013\ty\u0003'\u0003\u0002\u007f]\u0005)AO]3fg&!\u0011\u0011AA\u0002\u0003-!&/Z3QCR$XM\u001d8\u000b\u0005yt\u0013\u0002BA\u0004\u0003\u0013\u00111\u0002\u0016:fKB\u000bG\u000f^3s]*!\u0011\u0011AA\u0002\u00035qw\u000eZ3QCR$XM\u001d8tA\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004O\u0006E\u0001bBA\n\u0013\u0001\u0007\u0011QC\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003L\u0003/Q\u0014bAA\r+\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002)%t\u0007/\u001e;UsB,7OR8s\u001b\u0016\u0014x-\u001b8h+\t\ty\u0002\u0005\u0003L3\u0006\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001d\u0002'A\u0003usB,7/\u0003\u0003\u0002,\u0005\u0015\"\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0007)\ty\u0003E\u0002F\u0003cI1!a\rG\u0005%!(/\u00198tS\u0016tG/\u0001\u0005ok2d\u0017M\u00197f+\t\tI\u0004E\u0002F\u0003wI1!!\u0010G\u0005\u001d\u0011un\u001c7fC:\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013/\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA'\u0003\u000f\u0012q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0016C2<\u0018-_:Fm\u0006dW/\u0019;fI&s\u0007/\u001e;t\u0003q9\u0018\u000e\u001e5OK^\fEn^1zg\u00163\u0018\r\\;bi\u0016$\u0017J\u001c9viN$2aZA+\u0011\u0019\tyE\u0004a\u0001Y\u0006a!M]1oG\"<%o\\;qgV\u0011\u00111\f\t\u0004\u0017fc\u0017\u0001B3wC2$B!!\u0019\u0002hA\u0019Q)a\u0019\n\u0007\u0005\u0015dIA\u0002B]fD\u0011\"!\u001b\u0011!\u0003\u0005\r!a\u001b\u0002\u000b%t\u0007/\u001e;\u0011\t\u00055\u0014qN\u0007\u0002]%\u0019\u0011\u0011\u000f\u0018\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u000f\t\u0005\u0003s\n\tI\u0004\u0003\u0002|\u0005u\u0004CA'G\u0013\r\tyHR\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0015Q\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}d)\u0006\u0002\u0002x\u0005!R.\u001e7uS\n\u0013\u0018M\\2iKN\u001cu\u000eZ3hK:$b!!$\u0002\u001a\u0006\r\u0006\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME&A\u0004d_\u0012,w-\u001a8\n\t\u0005]\u0015\u0011\u0013\u0002\t\u000bb\u0004(oQ8eK\"9\u00111T\nA\u0002\u0005u\u0015aA2uqB!\u0011qRAP\u0013\u0011\t\t+!%\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011QU\nA\u0002\u00055\u0015AA3w\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u000e\u0006-\u0016Q\u0016\u0005\b\u00037#\u0002\u0019AAO\u0011\u001d\t)\u000b\u0006a\u0001\u0003\u001b\u000bAaY8qsR)q-a-\u00026\"9a+\u0006I\u0001\u0002\u0004A\u0006bB0\u0016!\u0003\u0005\r!Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYLK\u0002Y\u0003{[#!a0\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u00134\u0015AC1o]>$\u0018\r^5p]&!\u0011QZAb\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019NK\u0002b\u0003{\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAm!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\fA\u0001\\1oO*\u0011\u00111]\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0004\u0006u\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAv!\r)\u0015Q^\u0005\u0004\u0003_4%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA1\u0003kD\u0011\"a>\u001b\u0003\u0003\u0005\r!a;\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0010\u0005\u0004\u0002\u0000\n\u0015\u0011\u0011M\u0007\u0003\u0005\u0003Q1Aa\u0001G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001d\u0005\u001bA\u0011\"a>\u001d\u0003\u0003\u0005\r!!\u0019\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00033\u0014\u0019\u0002C\u0005\u0002xv\t\t\u00111\u0001\u0002l\u00061Q-];bYN$B!!\u000f\u0003\u001a!I\u0011q\u001f\u0010\u0002\u0002\u0003\u0007\u0011\u0011\r\u0015\u0018\u0001\tu!1\u0005B\u0013\u0005S\u0011YCa\f\u00032\tU\"q\u0007B\u001e\u0005{\u00012a\u000fB\u0010\u0013\r\u0011\t\u0003\f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u00119#AA.\u0007\u0006\u001bV\tI,I\u000b:\u0003S\r\u001f9sc\u0001\"\u0006*\u0012(!Kb\u0004(O\r\u0011\\/\"+e\nI3yaJ\u001c\u0004\u0005\u0016%F\u001d\u0002*\u0007\u0010\u001d:5;*\u00023,\u0012'T\u000b\u0002*\u0007\u0010\u001d:6;\u0002*e\n\u0012\u0011.A]CWM\u001c\u0011aKb\u0004(/\r1!{\u0001\"(/^3-AI,G/\u001e:og\u0002\u0002W\r\u001f9se\u0001\\\u0004%\u001a7tK\u0002:\b.\u001a8!A\u0016D\bO]\u001aaAu\u0002CO];fY\u0001\u0012X\r^;s]N\u0004\u0003-\u001a=qeR\u00027\bI3mg\u0016\u0004#/\u001a;ve:\u001c\b\u0005Y3yaJ,\u0004ML\u0001\nCJ<W/\\3oiN\f#A!\f\u0002\u0003sT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJ\fD\u0006I3yaJ\u001c\u0004%\f\u0011uQ\u0016\u0004#M]1oG\"\u00043m\u001c8eSRLwN\u001c\u0011fqB\u0014Xm]:j_:\u001c\be\u001d5pk2$\u0007%\u00197mA\t,\u0007EY8pY\u0016\fg\u000e\t;za\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJ\u0014D\u0006I3yaJ$D\u0006I3yaJ,\u0004%\f\u0011uQ\u0016\u0004#M]1oG\"\u0004c/\u00197vK\u0002*\u0007\u0010\u001d:fgNLwN\\:!C:$\u0007%\u001a7tK\u00022\u0018\r\\;fA\u0015D\bO]3tg&|g\u000eI:i_VdG\rI1mY\u0002\u0012WM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AM\fW.\u001a\u0011usB,\u0007e\u001c:!G>,'oY5cY\u0016\u0004Co\u001c\u0011bA\r|W.\\8oAQL\b/\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005g\t!Q\u0001\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!\u0007\u0006\u001bV\tI,I\u000b:\u0003\u0013\u0007\t !a\u0001\"\u0006*\u0012(!c\u0001:\u0006*\u0012(!e\u0001r\u0004\u0005\r\u0011U\u0011\u0016s\u0005E\r\u00181A\u0015c5+\u0012\u00112]I\u0002SI\u0014#<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0003G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011D\u0003N+\u0005e\u0016%F\u001d\u0002\n\u0004\u0005\u0010\u00111AQCUI\u0014\u00112A]CUI\u0014\u00113Ay\u0002\u0003\u0007\t+I\u000b:\u0003#G\f\u0019!\u000b2\u001bV\tI\u0019/e\u0001*e\nR\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!e9\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\"B'\u0016\u0003s\u000bS#OAE\u0002C\b\t\u0019!)\"+e\nI\u0019!/\"+e\n\t\u001a!y\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\u0012d\u0006\r\u0011F\u001d\u0012[$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003:\u0005)\u0011G\f\u0019/c\u0005)qM]8va\u0006\u0012!qH\u0001\u0012G>tG-\u001b;j_:\fGn\u00184v]\u000e\u001c\u0018\u0001C\"bg\u0016<\u0006.\u001a8\u0011\u0005m\u00023#\u0002\u0011\u0003H\t5\u0003cA#\u0003J%\u0019!1\n$\u0003\r\u0005s\u0017PU3g!\u0011\u0011yE!\u0016\u000e\u0005\tE#\u0002\u0002B*\u0003C\f!![8\n\u0007Q\u0013\t\u0006\u0006\u0002\u0003D\u0005)\u0011\r\u001d9msR)qM!\u0018\u0003`!)aK\ta\u00011\")qL\ta\u0001u\u0005\u00012M]3bi\u00164%o\\7QCJ\u001cXM\u001d\u000b\u0004O\n\u0015\u0004\"\u0002,$\u0001\u0004a\u0017!\u0004:fO&\u001cHO]=F]R\u0014\u00180\u0006\u0002\u0003lA1Q\tXA<\u0005[\u0002b!\u0012/\u0003p\tU\u0004cA\u001e\u0003r%\u0019!1\u000f\u0017\u0003\u001d\u0015C\bO]3tg&|g.\u00138g_B!!q\u000fBA\u001d\u0011\u0011IH! \u000f\u0007M\u0014Y(C\u0002\u0002J9JAAa \u0002H\u0005\u0001b)\u001e8di&|gNU3hSN$(/_\u0005\u0005\u0005\u0007\u0013)IA\bGk:\u001cG/[8o\u0005VLG\u000eZ3s\u0015\u0011\u0011y(a\u0012\u0002\u001dI,w-[:uef,e\u000e\u001e:zAQ)qMa#\u0003\u000e\")aK\na\u00011\"9qL\nI\u0001\u0002\u0004\t\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0013BM!\u0011)%Ma&\u0011\t\u0015c\u0006,\u0019\u0005\t\u00057C\u0013\u0011!a\u0001O\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\u000b\u0005\u0003\u0002\\\n\u0015\u0016\u0002\u0002BT\u0003;\u0014aa\u00142kK\u000e$\b")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
ConditionalExpression,
Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private final Seq<Enumeration.Value> nodePatterns;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen x$0) {
        return CaseWhen$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static Tuple2<String, Tuple2<ExpressionInfo, Function1<Seq<Expression>, Expression>>> registryEntry() {
        return CaseWhen$.MODULE$.registryEntry();
    }

    public static CaseWhen createFromParser(Seq<Expression> branches) {
        return CaseWhen$.MODULE$.createFromParser(branches);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((IterableOps)this.branches().flatMap((Function1 & Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        })).$plus$plus(this.elseValue());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public CaseWhen withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (newChildren.length() % 2 == 0) {
            return this.copy((Seq<Tuple2<Expression, Expression>>)newChildren.grouped(2).map((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                IndexedSeq indexedSeq = x0$1;
                if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    Expression a = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    Expression b = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    return new Tuple2((Object)a, (Object)b);
                }
                throw new MatchError((Object)indexedSeq);
            }).toSeq(), this.copy$default$2());
        }
        return this.copy((Seq<Tuple2<Expression, Expression>>)((IterableOps)newChildren.dropRight(1)).grouped(2).map((Function1 & Serializable)x0$2 -> {
            SeqOps seqOps;
            IndexedSeq indexedSeq = x0$2;
            if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Expression a = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Expression b = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                return new Tuple2((Object)a, (Object)b);
            }
            throw new MatchError((Object)indexedSeq);
        }).toSeq(), (Option<Expression>)newChildren.lastOption());
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((IterableOps)this.branches().map((Function1 & Serializable)x$1 -> ((Expression)x$1._2()).dataType())).$plus$plus((IterableOnce)this.elseValue().map((Function1 & Serializable)x$2 -> x$2.dataType()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if (!this.bitmap$trans$0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        if (this.branches().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$3)))) {
            Tuple2 tuple2 = this.branches().span((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$2(x$4)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq h = (Seq)tuple2._1();
            Seq t = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)h, (Object)t);
            Seq h2 = (Seq)tuple22._1();
            Seq t2 = (Seq)tuple22._2();
            return h2.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$3(x$6))) || ((Expression)((Tuple2)t2.head())._2()).nullable();
        }
        return this.branches().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$4(x$7))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$9)))) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            int index = this.branches().indexWhere((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$3(x$10)));
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)TypeUtils$.MODULE$.ordinalNumber(index)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)TypeUtils$.MODULE$.toSQLExpr((Expression)((Tuple2)this.branches().apply(index))._1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)((Expression)((Tuple2)this.branches().apply(index))._1()).dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)TypeUtils$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((IterableOnceOps)this.inputTypesForMerging().map((Function1 & Serializable)t -> TypeUtils$.MODULE$.toSQLType((AbstractDataType)t))).mkString("[", ", ", "]"))}))));
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = (Expression)this.children().head();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public CaseWhen withNewAlwaysEvaluatedInputs(Seq<Expression> alwaysEvaluatedInputs) {
        return this.withNewChildrenInternal((IndexedSeq)alwaysEvaluatedInputs.toIndexedSeq().$plus$plus((IterableOnce)this.children().drop(1)));
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        Nil$ conditions = this.branches().length() > 1 ? (Seq)this.branches().map((Function1 & Serializable)x$11 -> (Expression)x$11._1()) : Nil$.MODULE$;
        Nil$ values = this.elseValue().nonEmpty() ? (Seq)((IterableOps)this.branches().map((Function1 & Serializable)x$12 -> (Expression)x$12._2())).$plus$plus(this.elseValue()) : Nil$.MODULE$;
        return new .colon.colon((Object)conditions, (List)new .colon.colon((Object)values, (List)Nil$.MODULE$));
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression c = (Expression)tuple2._1();
                Expression v = (Expression)tuple2._2();
                return " WHEN " + c + " THEN " + v;
            }
            throw new MatchError((Object)tuple2);
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$13 -> " ELSE " + x$13).getOrElse((Function0 & Serializable)() -> "");
        return "CASE" + cases + elseCase + " END";
    }

    @Override
    public String sql() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression c = (Expression)tuple2._1();
                Expression v = (Expression)tuple2._2();
                return " WHEN " + c.sql() + " THEN " + v.sql();
            }
            throw new MatchError((Object)tuple2);
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$14 -> " ELSE " + x$14.sql()).getOrElse((Function0 & Serializable)() -> "");
        return "CASE" + cases + elseCase + " END";
    }

    private ExprCode multiBranchesCodegen(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression condExpr = (Expression)tuple2._1();
                Expression valueExpr = (Expression)tuple2._2();
                ExprCode cond = condExpr.genCode(ctx);
                ExprCode res = valueExpr.genCode(ctx);
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + cond.code() + "\n         |if (!" + cond.isNull() + " && " + cond.value() + ") {\n         |  " + res.code() + "\n         |  " + resultState + " = (byte)(" + res.isNull() + " ? " + HAS_NULL + " : " + HAS_NONNULL + ");\n         |  " + ev.value() + " = " + res.value() + ";\n         |  continue;\n         |}\n       "));
            }
            throw new MatchError((Object)tuple2);
        });
        Option elseCode = this.elseValue().map((Function1 & Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + res.code() + "\n         |" + resultState + " = (byte)(" + res.isNull() + " ? " + HAS_NULL + " : " + HAS_NONNULL + ");\n         |" + ev.value() + " = " + res.value() + ";\n       "));
        });
        Seq x$1 = allConditions = (Seq)cases.$plus$plus((IterableOnce)elseCode);
        String x$2 = "caseWhen";
        String x$3 = "byte";
        Function1 & Serializable x$4 = (Function1 & Serializable)func -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |byte " + resultState + " = " + NOT_MATCHED + ";\n           |do {\n           |  " + func + "\n           |} while (false);\n           |return " + resultState + ";\n         "));
        Function1 & Serializable x$5 = (Function1 & Serializable)x$15 -> ((IterableOnceOps)x$15.map((Function1 & Serializable)funcCall -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + resultState + " = " + funcCall + ";\n           |if (" + resultState + " != " + NOT_MATCHED + ") {\n           |  continue;\n           |}\n         ")))).mkString();
        Seq<Tuple2<String, String>> x$6 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, "caseWhen", x$6, "byte", (Function1<String, String>)x$4, (Function1<Seq<String>, String>)x$5);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        if (this.branches().length() == 1) {
            return new If((Expression)((Tuple2)this.branches().apply(0))._1(), (Expression)((Tuple2)this.branches().apply(0))._2(), (Expression)this.elseValue().getOrElse((Function0 & Serializable)() -> Literal$.MODULE$.create(null, ((Expression)((Tuple2)this.branches().apply(0))._2()).dataType()))).doGenCode(ctx, ev);
        }
        return this.multiBranchesCodegen(ctx, ev);
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.branches();
            }
            case 1: {
                return this.elseValue();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "branches";
            }
            case 1: {
                return "elseValue";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$3) {
        Object object = x$3._1();
        Literal literal = Literal$.MODULE$.TrueLiteral();
        return !(object != null ? !object.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$nullable$2(Tuple2 x$4) {
        Object object = x$4._1();
        Literal literal = Literal$.MODULE$.TrueLiteral();
        return object == null ? literal != null : !object.equals(literal);
    }

    public static final /* synthetic */ boolean $anonfun$nullable$3(Tuple2 x$6) {
        return ((Expression)x$6._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$nullable$4(Tuple2 x$7) {
        return ((Expression)x$7._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$9) {
        DataType dataType = ((Expression)x$9._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$3(Tuple2 x$10) {
        DataType dataType = ((Expression)x$10._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
        ConditionalExpression.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.CASE_WHEN(), (List)Nil$.MODULE$);
    }
}

