/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001B\u0013'\u0001NB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003S\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011!Q\u0007\u0001#b\u0001\n\u0013Y\u0007\u0002\u0003<\u0001\u0011\u000b\u0007I\u0011B<\t\r\u0005\u0015\u0001\u0001\"\u0011_\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002 \u0001!I!!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!!#\u0001\t#\nY\tC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0001\u0002\u0018\"I\u0011Q\u0014\u0001\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003k\u0003\u0011\u0013!C\u0001\u0003?C\u0011\"a.\u0001\u0003\u0003%\t%!/\t\u0013\u0005%\u0007!!A\u0005\u0002\u0005-\u0007\"CAj\u0001\u0005\u0005I\u0011AAk\u0011%\tY\u000eAA\u0001\n\u0003\ni\u000eC\u0005\u0002l\u0002\t\t\u0011\"\u0001\u0002n\"I\u0011\u0011\u001f\u0001\u0002\u0002\u0013\u0005\u00131\u001f\u0005\n\u0003o\u0004\u0011\u0011!C!\u0003s<\u0011B!\b'\u0003\u0003E\tAa\b\u0007\u0011\u00152\u0013\u0011!E\u0001\u0005CAa\u0001W\u0010\u0005\u0002\te\u0002\"\u0003B\u001e?\u0005\u0005IQ\tB\u001f\u0011%\u0011ydHA\u0001\n\u0003\u0013\t\u0005C\u0005\u0003H}\t\t\u0011\"!\u0003J!I!1L\u0010\u0002\u0002\u0013%!Q\f\u0002\u000e\u0003J\u0014\u0018-_:Pm\u0016\u0014H.\u00199\u000b\u0005\u001dB\u0013aC3yaJ,7o]5p]NT!!\u000b\u0016\u0002\u0011\r\fG/\u00197zgRT!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u001b9wy\"\u0005CA\u001b7\u001b\u00051\u0013BA\u001c'\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00026s%\u0011!H\n\u0002&\u0005&t\u0017M]=BeJ\f\u00170\u0012=qe\u0016\u001c8/[8o/&$\b.S7qY&\u001c\u0017\u000e^\"bgR\u0004\"!\u000e\u001f\n\u0005u2#!\u0003)sK\u0012L7-\u0019;f!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u001d\u0001&o\u001c3vGR\u0004\"!R'\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%3\u0003\u0019a$o\\8u}%\t\u0011)\u0003\u0002M\u0001\u00069\u0001/Y2lC\u001e,\u0017B\u0001(P\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ta\u0005)\u0001\u0003mK\u001a$X#\u0001*\u0011\u0005U\u001a\u0016B\u0001+'\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rQ6\f\u0018\t\u0003k\u0001AQ\u0001U\u0003A\u0002ICQAV\u0003A\u0002I\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001`!\ty\u0004-\u0003\u0002b\u0001\n9!i\\8mK\u0006t\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dD\u0013\u0001C1oC2L8/[:\n\u0005%4'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012\u0001\u001c\t\u0004\u000b6|\u0017B\u00018P\u0005!y%\u000fZ3sS:<\u0007CA q\u0013\t\t\bIA\u0002B]fD#\u0001C:\u0011\u0005}\"\u0018BA;A\u0005%!(/\u00198tS\u0016tG/\u0001\u0007e_\u00163\u0018\r\\;bi&|g.F\u0001y!\u0015y\u0014p_>p\u0013\tQ\bIA\u0005Gk:\u001cG/[8oeA\u0011Ap`\u0007\u0002{*\u0011a\u0010K\u0001\u0005kRLG.C\u0002\u0002\u0002u\u0014\u0011\"\u0011:sCf$\u0015\r^1)\u0005%\u0019\u0018\u0001\u00038vY2\f'\r\\3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u000b=\fY!a\u0004\t\r\u000551\u00021\u0001p\u0003\t\t\u0017\u0007\u0003\u0004\u0002\u0012-\u0001\ra\\\u0001\u0003CJ\n\u0001BZ1ti\u00163\u0018\r\u001c\u000b\u0006_\u0006]\u00111\u0004\u0005\u0007\u00033a\u0001\u0019A>\u0002\t\u0005\u0014(/\r\u0005\u0007\u0003;a\u0001\u0019A>\u0002\t\u0005\u0014(OM\u0001\u000fEJ,H/\u001a$pe\u000e,WI^1m)\u0015y\u00171EA\u0013\u0011\u0019\tI\"\u0004a\u0001w\"1\u0011QD\u0007A\u0002m\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005-\u0012qGA!!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019M\u000591m\u001c3fO\u0016t\u0017\u0002BA\u001b\u0003_\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003sq\u0001\u0019AA\u001e\u0003\r\u0019G\u000f\u001f\t\u0005\u0003[\ti$\u0003\u0003\u0002@\u0005=\"AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0007r\u0001\u0019AA\u0016\u0003\t)g/A\u0006gCN$8i\u001c3fO\u0016tGCCA%\u00033\nY&!\u0018\u0002bA!\u00111JA*\u001d\u0011\ti%a\u0014\u0011\u0005\u001d\u0003\u0015bAA)\u0001\u00061\u0001K]3eK\u001aLA!!\u0016\u0002X\t11\u000b\u001e:j]\u001eT1!!\u0015A\u0011\u001d\tId\u0004a\u0001\u0003wAq!a\u0011\u0010\u0001\u0004\tY\u0003C\u0004\u0002`=\u0001\r!!\u0013\u0002\u000fMl\u0017\r\u001c7fe\"9\u00111M\bA\u0002\u0005%\u0013A\u00022jO\u001e,'/A\tceV$XMR8sG\u0016\u001cu\u000eZ3hK:$\"\"!\u0013\u0002j\u0005-\u0014QNA8\u0011\u001d\tI\u0004\u0005a\u0001\u0003wAq!a\u0011\u0011\u0001\u0004\tY\u0003C\u0004\u0002`A\u0001\r!!\u0013\t\u000f\u0005\r\u0004\u00031\u0001\u0002J\u00051b.\u001e7m'\u00064W-\u00127f[\u0016tGoQ8eK\u001e,g\u000e\u0006\u0006\u0002J\u0005U\u0014\u0011PA?\u0003\u0003Cq!a\u001e\u0012\u0001\u0004\tI%\u0001\u0005beJ\f\u0017PV1s\u0011\u001d\tY(\u0005a\u0001\u0003\u0013\nQ!\u001b8eKbDq!a \u0012\u0001\u0004\tI%\u0001\u0003d_\u0012,\u0007bBAB#\u0001\u0007\u0011\u0011J\u0001\u000bSNtU\u000f\u001c7D_\u0012,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011J\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$RAWAG\u0003#Ca!a$\u0014\u0001\u0004\u0011\u0016a\u00028fo2+g\r\u001e\u0005\u0007\u0003'\u001b\u0002\u0019\u0001*\u0002\u00119,wOU5hQR\fAaY8qsR)!,!'\u0002\u001c\"9\u0001\u000b\u0006I\u0001\u0002\u0004\u0011\u0006b\u0002,\u0015!\u0003\u0005\rAU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tKK\u0002S\u0003G[#!!*\u0011\t\u0005\u001d\u0016\u0011W\u0007\u0003\u0003SSA!a+\u0002.\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_\u0003\u0015AC1o]>$\u0018\r^5p]&!\u00111WAU\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0017\u0001\u00026bm\u0006LA!!\u0016\u0002@\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u001a\t\u0004\u007f\u0005=\u0017bAAi\u0001\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q.a6\t\u0013\u0005e\u0017$!AA\u0002\u00055\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002`B)\u0011\u0011]At_6\u0011\u00111\u001d\u0006\u0004\u0003K\u0004\u0015AC2pY2,7\r^5p]&!\u0011\u0011^Ar\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007}\u000by\u000f\u0003\u0005\u0002Zn\t\t\u00111\u0001p\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u0016Q\u001f\u0005\n\u00033d\u0012\u0011!a\u0001\u0003\u001b\fa!Z9vC2\u001cHcA0\u0002|\"A\u0011\u0011\\\u000f\u0002\u0002\u0003\u0007q\u000eK\n\u0001\u0003\u007f\u0014)Aa\u0002\u0003\f\t5!\u0011\u0003B\n\u0005/\u0011I\u0002E\u00026\u0005\u0003I1Aa\u0001'\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0003\u0002\u0003/|f)\u0016(D?\"\n\u0017\u0007\f\u0011be%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011ueV,\u0007%\u001b4!CF\u00023m\u001c8uC&t7\u000fI1uA1,\u0017m\u001d;!C\u0002rwN\\\u0017ok2d\u0007%\u001a7f[\u0016tG\u000f\t9sKN,g\u000e\u001e\u0011bYN|\u0007%\u001b8!CJr\u0003%\u00134!i\",\u0007%\u0019:sCf\u001c\b\u0005[1wK\u0002rw\u000eI2p[6|g\u000eI3mK6,g\u000e\u001e\u0011b]\u0012\u0004C\u000f[3zA\u0005\u0014X\r\t2pi\"\u0004cn\u001c8.K6\u0004H/\u001f\u0011b]\u0012\u0004S-\u001b;iKJ\u0004sN\u001a\u0011uQ\u0016l\u0007eY8oi\u0006Lgn\u001d\u0011bA9,H\u000e\u001c\u0011fY\u0016lWM\u001c;!]VdG\u000eI5tAI,G/\u001e:oK\u0012d\u0003EZ1mg\u0016\u0004s\u000e\u001e5fe^L7/\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0004\u0002)*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMJC\u0006I1se\u0006L\bf\r\u0017!i1\u0002S'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0005)qM]8va\u0006\u0012!QC\u0001\fCJ\u0014\u0018-_0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003\u001c\u0005)!G\f\u001b/a\u0005i\u0011I\u001d:bsN|e/\u001a:mCB\u0004\"!N\u0010\u0014\u000b}\u0011\u0019Ca\f\u0011\u000f\t\u0015\"1\u0006*S56\u0011!q\u0005\u0006\u0004\u0005S\u0001\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005[\u00119CA\tBEN$(/Y2u\rVt7\r^5p]J\u0002BA!\r\u000385\u0011!1\u0007\u0006\u0005\u0005k\t\u0019-\u0001\u0002j_&\u0019aJa\r\u0015\u0005\t}\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0016!B1qa2LH#\u0002.\u0003D\t\u0015\u0003\"\u0002)#\u0001\u0004\u0011\u0006\"\u0002,#\u0001\u0004\u0011\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0017\u00129\u0006E\u0003@\u0005\u001b\u0012\t&C\u0002\u0003P\u0001\u0013aa\u00149uS>t\u0007#B \u0003TI\u0013\u0016b\u0001B+\u0001\n1A+\u001e9mKJB\u0001B!\u0017$\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B0!\u0011\tiL!\u0019\n\t\t\r\u0014q\u0018\u0002\u0007\u001f\nTWm\u0019;")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
Predicate,
Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap x$0) {
        return ArraysOverlap$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    @Override
    public boolean leftArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.leftArrayElementNullable$(this);
    }

    @Override
    public boolean rightArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.rightArrayElementNullable$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            return TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), this.prettyName());
        }
        return typeCheckResult;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.doEvaluation$lzycompute();
        }
        return this.doEvaluation;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || this.leftArrayElementNullable() || this.rightArrayElementNullable();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            ArrayData bigger2 = (ArrayData)tuple23._1();
            ArrayData smaller2 = (ArrayData)tuple23._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$26, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$26), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$27, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$27), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$28, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, hasNull, arr2, object2, BoxesRunTime.unboxToInt((Object)x$28), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |ArrayData " + smaller + ";\n         |ArrayData " + bigger + ";\n         |if (" + a1 + ".numElements() > " + a2 + ".numElements()) {\n         |  " + bigger + " = " + a1 + ";\n         |  " + smaller + " = " + a2 + ";\n         |} else {\n         |  " + smaller + " = " + a1 + ";\n         |  " + bigger + " = " + a2 + ";\n         |}\n         |if (" + smaller + ".numElements() > 0) {\n         |  " + comparisonCode + "\n         |}\n       "));
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, set + ".add(" + getFromSmaller + ");", ev.isNull() + " = true;");
        String setIsNullCode = this.nullable() ? ev.isNull() + " = false;" : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + set + ".contains(" + getFromBigger + ")) {\n         |  " + setIsNullCode + "\n         |  " + ev.value() + " = true;\n         |  break;\n         |}\n       ")), ev.isNull() + " = true;");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + javaSet + "<" + javaElementClass + "> " + set + " = new " + javaSet + "<" + javaElementClass + ">();\n       |for (int " + i + " = 0; " + i + " < " + smaller + ".numElements(); " + i + " ++) {\n       |  " + addToSetFromSmallerCode + "\n       |}\n       |for (int " + i + " = 0; " + i + " < " + bigger + ".numElements(); " + i + " ++) {\n       |  " + elementIsInSetCode + "\n       |}\n     "));
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? ev.isNull() + " = false;" : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger) + ") {\n         |  " + setIsNullCode + "\n         |  " + ev.value() + " = true;\n         |}\n       ")), ev.isNull() + " = true;");
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |for (int " + j + " = 0; " + j + " < " + smaller + ".numElements() && !" + ev.value() + "; " + j + " ++) {\n         |  " + compareValues + "\n         |}\n       ")), ev.isNull() + " = true;");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |for (int " + i + " = 0; " + i + " < " + bigger + ".numElements() && !" + ev.value() + "; " + i + " ++) {\n       |  " + isInSmaller + "\n       |}\n     "));
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        if (this.inputTypes().exists((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$30)))) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + arrayVar + ".isNullAt(" + index + ")) {\n         |  " + isNullCode + "\n         |} else {\n         |  " + code + "\n         |}\n       "));
        }
        return code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    @Override
    public ArraysOverlap withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$26, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
            return;
        }
        smallestSet$1.add(v);
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$27, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
            return;
        }
        if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$29, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
            return;
        }
        if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, BooleanRef hasNull$3, ArrayData arr2$1, Object nonLocalReturnKey3$1, int x$28, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
            return;
        }
        arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$29, v2) -> {
            ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$29), v2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$30) {
        return ((ArrayType)x$30).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        Predicate.$init$(this);
    }
}

