/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.analysis.resolver.AggregateWithLcaResolutionResult;
import org.apache.spark.sql.catalyst.analysis.resolver.AutoGeneratedAliasProvider;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScope;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.SemanticComparator;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.AggregateHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\b\u0010\u0001yA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019I\u0004\u0001)A\u0005m!9!\b\u0001b\u0001\n\u0013Y\u0004BB \u0001A\u0003%A\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0005\u0002\u0010\u0001\t\n\u0011\"\u0001\u0002\u0012!9\u0011q\u0005\u0001\u0005\n\u0005%\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003/\u0002A\u0011BA-\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\u0012!\u0004T1uKJ\fGnQ8mk6t\u0017\t\\5bgJ+7o\u001c7wKJT!\u0001E\t\u0002\u0011I,7o\u001c7wKJT!AE\n\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001F\u000b\u0002\u0011\r\fG/\u00197zgRT!AF\f\u0002\u0007M\fHN\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011a%K\u0007\u0002O)\u0011\u0001&F\u0001\u0007KJ\u0014xN]:\n\u0005):#aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0002%\u0015D\bO]3tg&|gNU3t_24XM\u001d\t\u0003[9j\u0011aD\u0005\u0003_=\u0011!#\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"\"AM\u001a\u0011\u00055\u0002\u0001\"B\u0016\u0003\u0001\u0004a\u0013AB:d_B,7/F\u00017!\tis'\u0003\u00029\u001f\tqa*Y7f'\u000e|\u0007/Z*uC\u000e\\\u0017aB:d_B,7\u000fI\u0001\u000eC2L\u0017m\u001d)s_ZLG-\u001a:\u0016\u0003q\u0002\"!L\u001f\n\u0005yz!AG!vi><UM\\3sCR,G-\u00117jCN\u0004&o\u001c<jI\u0016\u0014\u0018AD1mS\u0006\u001c\bK]8wS\u0012,'\u000fI\u0001\u0015Q\u0006tG\r\\3MG\u0006Le.Q4he\u0016<\u0017\r^3\u0015\u0005\t+\u0005CA\u0017D\u0013\t!uB\u0001\u0011BO\u001e\u0014XmZ1uK^KG\u000f\u001b'dCJ+7o\u001c7vi&|gNU3tk2$\b\"\u0002$\b\u0001\u00049\u0015!\u0005:fg>dg/\u001a3BO\u001e\u0014XmZ1uKB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\bY><\u0017nY1m\u0015\ta5#A\u0003qY\u0006t7/\u0003\u0002O\u0013\nI\u0011iZ4sK\u001e\fG/Z\u0001\u001cEVLG\u000e\u001a)s_*,7\r^,ji\"\u0014Vm]8mm\u0016$GjY1\u0015\rE#\u0016L\u0018:u!\tA%+\u0003\u0002T\u0013\n9\u0001K]8kK\u000e$\b\"B+\t\u0001\u00041\u0016!\u0004:fg>dg/\u001a3DQ&dG\r\u0005\u0002I/&\u0011\u0001,\u0013\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u0003[\u0011\u0001\u00071,A\u0003tG>\u0004X\r\u0005\u0002.9&\u0011Ql\u0004\u0002\n\u001d\u0006lWmU2pa\u0016DQa\u0018\u0005A\u0002\u0001\f1c\u001c:jO&t\u0017\r\u001c)s_*,7\r\u001e'jgR\u00042!Y5m\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002f;\u00051AH]8pizJ\u0011AI\u0005\u0003Q\u0006\nq\u0001]1dW\u0006<W-\u0003\u0002kW\n\u00191+Z9\u000b\u0005!\f\u0003CA7q\u001b\u0005q'BA8\u0014\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005Et'a\u0004(b[\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\t\u000bMD\u0001\u0019\u00011\u00023\u0019L'o\u001d;Ji\u0016\u0014\u0018\r^5p]B\u0013xN[3di2K7\u000f\u001e\u0005\bk\"\u0001\n\u00111\u0001w\u0003=\u0011X-\\1qa\u0016$\u0017\t\\5bg\u0016\u001c\bc\u0001\u0011xs&\u0011\u00010\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ri|\u00181AA\u0005\u001b\u0005Y(B\u0001?~\u0003\u0011)H/\u001b7\u000b\u0003y\fAA[1wC&\u0019\u0011\u0011A>\u0003\u000f!\u000b7\u000f['baB\u0019Q.!\u0002\n\u0007\u0005\u001daN\u0001\u0004FqB\u0014\u0018\n\u001a\t\u0004[\u0006-\u0011bAA\u0007]\n)\u0011\t\\5bg\u0006)#-^5mIB\u0013xN[3di^KG\u000f\u001b*fg>dg/\u001a3MG\u0006$C-\u001a4bk2$H%N\u000b\u0003\u0003'Q3A^A\u000bW\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0011C\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00121\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AI3yiJ\f7\r\u001e'dC\u0006sGMU3qY\u0006\u001cW-Q4h/&$\b\u000e\u0015:pU\u0016\u001cG\u000fF\u0002R\u0003WAa!!\f\u000b\u0001\u00049\u0015!C1hOJ,w-\u0019;f\u0003\u0019*\u0007\u0010\u001e:bGR\fum\u001a:fO\u0006$X-\u00118e\u000fJ|W\u000f]5oO\u0016C\bO]3tg&|gn\u001d\u000b\u000b\u0003g\tI$!\u0010\u0002H\u00055\u0003cA7\u00026%\u0019\u0011q\u00078\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0002<-\u0001\r!a\r\u0002\u0015\u0015D\bO]3tg&|g\u000eC\u0004\u0002@-\u0001\r!!\u0011\u0002K\u001d\u0014x.\u001e9j]\u001e,\u0005\u0010\u001d:fgNLwN\\:TK6\fg\u000e^5d\u0007>l\u0007/\u0019:bi>\u0014\bcA\u0017\u0002D%\u0019\u0011QI\b\u0003%M+W.\u00198uS\u000e\u001cu.\u001c9be\u0006$xN\u001d\u0005\b\u0003\u0013Z\u0001\u0019AA&\u0003i)\u0007\u0010\u001e:bGR,G-\u0012=qe\u0016\u001c8/[8o\u00032L\u0017m]3t!\u0015Qx0a\rm\u0011\u001d\tye\u0003a\u0001\u0003#\nqC\\3x\u0003\u001e<'/Z4bi\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0011\ti\f\u0019\u0006\\\u0005\u0004\u0003+Z(!\u0004'j].,G\rS1tQN+G/\u0001\nhKR|%/\u00169eCR,W*\u00199qS:<G#\u00027\u0002\\\u0005u\u0003bBA%\u0019\u0001\u0007\u00111\n\u0005\b\u0003wa\u0001\u0019AA\u001a\u0003A)\b\u000fZ1uK\u0006c\u0017.Y:Ue\u0016,7\u000f\u0006\u0004\u0002d\u0005%\u0014Q\u000e\t\u0006u\u0006\u0015\u0014\u0011B\u0005\u0004\u0003OZ(!C!se\u0006LH*[:u\u0011\u001d\tY'\u0004a\u0001\u0003G\nq!\u00197jCN,7\u000fC\u0003v\u001b\u0001\u0007a\u000f")
public class LateralColumnAliasResolver
implements QueryErrorsBase {
    private final NameScopeStack scopes;
    private final AutoGeneratedAliasProvider aliasProvider;

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    private AutoGeneratedAliasProvider aliasProvider() {
        return this.aliasProvider;
    }

    public AggregateWithLcaResolutionResult handleLcaInAggregate(Aggregate resolvedAggregate) {
        Project project = this.extractLcaAndReplaceAggWithProject(resolvedAggregate);
        if (project != null) {
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan aggregate = project.child();
            if (projectList instanceof Seq) {
                Seq<NamedExpression> seq = projectList;
                if (aggregate instanceof Aggregate) {
                    Aggregate aggregate2 = (Aggregate)aggregate;
                    ExprUtils$.MODULE$.assertValidAggregation(aggregate2);
                    HashMap remappedAliases = new HashMap(seq.size());
                    seq.foreach((Function1 & Serializable)x0$1 -> {
                        Object object = x0$1;
                        if (object instanceof Alias) {
                            Alias alias = (Alias)object;
                            return remappedAliases.put(alias.exprId(), alias);
                        }
                        return BoxedUnit.UNIT;
                    });
                    Project finalProject = this.buildProjectWithResolvedLca(aggregate2, this.scopes().current(), seq, (Seq<NamedExpression>)((Seq)aggregate2.aggregateExpressions().map((Function1 & Serializable)x$1 -> x$1.toAttribute())), (Option<HashMap<ExprId, Alias>>)new Some(remappedAliases));
                    Seq aggregateListAliases = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.scopes().current().lcaRegistry().getAliasDependencyLevels()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala((List)x$2).asScala())).toSeq();
                    Some x$12 = new Some(finalProject.projectList().map((Function1 & Serializable)x$3 -> x$3.toAttribute()));
                    boolean x$22 = true;
                    Option<Seq<Attribute>> x$32 = this.scopes().overwriteCurrent$default$2();
                    Option<HashSet<ExprId>> x$4 = this.scopes().overwriteCurrent$default$3();
                    Seq<Alias> x$5 = this.scopes().overwriteCurrent$default$4();
                    this.scopes().overwriteCurrent((Option<Seq<Attribute>>)x$12, x$32, x$4, x$5, true);
                    return new AggregateWithLcaResolutionResult(finalProject, finalProject.projectList(), (Seq<Alias>)aggregateListAliases);
                }
            }
        }
        throw SparkException$.MODULE$.internalError("Single-pass analyzer failed to resolve lateral column aliases in aggregate: " + resolvedAggregate.treeString());
    }

    public Project buildProjectWithResolvedLca(LogicalPlan resolvedChild, NameScope scope, Seq<NamedExpression> originalProjectList, Seq<NamedExpression> firstIterationProjectList, Option<HashMap<ExprId, Alias>> remappedAliases) {
        ArrayList<ArrayList<Alias>> aliasDependencyMap = scope.lcaRegistry().getAliasDependencyLevels();
        Tuple2 tuple2 = (Tuple2)CollectionConverters$.MODULE$.ListHasAsScala(aliasDependencyMap).asScala().foldLeft((Object)new Tuple2((Object)resolvedChild, firstIterationProjectList), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ArrayList availableAliases = (ArrayList)tuple2._2();
                if (tuple22 != null) {
                    LogicalPlan currentPlan = (LogicalPlan)tuple22._1();
                    Seq currentProjectList = (Seq)tuple22._2();
                    ArrayBuffer referencedAliases = new ArrayBuffer();
                    ArrayList<Alias> updatedAliases = this.updateAliasTrees(availableAliases, remappedAliases);
                    updatedAliases.forEach(alias -> {
                        if (scope.lcaRegistry().isAttributeLaterallyReferenced(alias.toAttribute())) {
                            referencedAliases.append(alias);
                            return;
                        }
                    });
                    if (referencedAliases.nonEmpty()) {
                        Seq newProjectList = (Seq)((IterableOps)currentProjectList.map((Function1 & Serializable)x$4 -> x$4.toAttribute())).$plus$plus((IterableOnce)referencedAliases);
                        return new Tuple2((Object)new Project((Seq<NamedExpression>)newProjectList, currentPlan), (Object)newProjectList);
                    }
                    return new Tuple2((Object)currentPlan, (Object)currentProjectList);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan finalChildPlan = (LogicalPlan)tuple2._1();
        LogicalPlan finalChildPlan2 = finalChildPlan;
        Seq finalProjectList = (Seq)originalProjectList.map((Function1 & Serializable)alias -> {
            if (scope.lcaRegistry().isAttributeLaterallyReferenced(alias.toAttribute())) {
                return alias.toAttribute();
            }
            return alias;
        });
        return new Project((Seq<NamedExpression>)finalProjectList, finalChildPlan2);
    }

    public Option<HashMap<ExprId, Alias>> buildProjectWithResolvedLca$default$5() {
        return None$.MODULE$;
    }

    private Project extractLcaAndReplaceAggWithProject(Aggregate aggregate) {
        LinkedHashSet newAggregateExpressions = new LinkedHashSet();
        HashMap extractedExpressionAliases = new HashMap();
        SemanticComparator groupingExpressionSemanticComparator = new SemanticComparator(aggregate.groupingExpressions());
        Seq extractedExpressions = (Seq)aggregate.aggregateExpressions().map((Function1 & Serializable)aggregateExpression -> (NamedExpression)((Object)this.extractAggregateAndGroupingExpressions((Expression)((Object)aggregateExpression), groupingExpressionSemanticComparator, extractedExpressionAliases, newAggregateExpressions)));
        Seq x$1 = CollectionConverters$.MODULE$.SetHasAsScala(newAggregateExpressions).asScala().toSeq();
        Seq<Expression> x$2 = aggregate.copy$default$1();
        LogicalPlan x$3 = aggregate.copy$default$3();
        Option<AggregateHint> x$4 = aggregate.copy$default$4();
        Project result = new Project((Seq<NamedExpression>)extractedExpressions, aggregate.copy(x$2, (Seq<NamedExpression>)x$1, x$3, x$4));
        return result;
    }

    private Expression extractAggregateAndGroupingExpressions(Expression expression, SemanticComparator groupingExpressionsSemanticComparator, HashMap<Expression, NamedExpression> extractedExpressionAliases, LinkedHashSet<NamedExpression> newAggregateExpressions) {
        ScalarSubquery scalarSubquery;
        Expression expression2 = expression;
        if (expression2 instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression2;
            NamedExpression ne = this.getOrUpdateMapping(extractedExpressionAliases, aggregateExpression);
            newAggregateExpressions.add(ne);
            return ne.toAttribute();
        }
        if (groupingExpressionsSemanticComparator.exists(expression2)) {
            NamedExpression ne = this.getOrUpdateMapping(extractedExpressionAliases, expression2);
            newAggregateExpressions.add(ne);
            return ne.toAttribute();
        }
        if (expression2 instanceof ScalarSubquery && (scalarSubquery = (ScalarSubquery)expression2).children().nonEmpty() && !groupingExpressionsSemanticComparator.exists(scalarSubquery)) {
            throw package$.MODULE$.AnalysisErrorAt(scalarSubquery).failAnalysis("SCALAR_SUBQUERY_IS_IN_GROUP_BY_OR_AGGREGATE_FUNCTION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)this.toSQLExpr(scalarSubquery))}))));
        }
        return (Expression)expression2.mapChildren((Function1 & Serializable)child -> this.extractAggregateAndGroupingExpressions((Expression)child, groupingExpressionsSemanticComparator, extractedExpressionAliases, newAggregateExpressions));
    }

    private NamedExpression getOrUpdateMapping(HashMap<Expression, NamedExpression> extractedExpressionAliases, Expression expression) {
        Expression key = expression.canonicalized();
        return extractedExpressionAliases.computeIfAbsent(key, x$5 -> {
            Expression expression = expression;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression = (NamedExpression)((Object)expression);
                return namedExpression;
            }
            return this.aliasProvider().newAlias(expression, this.aliasProvider().newAlias$default$2(), this.aliasProvider().newAlias$default$3());
        });
    }

    private ArrayList<Alias> updateAliasTrees(ArrayList<Alias> aliases, Option<HashMap<ExprId, Alias>> remappedAliases) {
        Option<HashMap<ExprId, Alias>> option = remappedAliases;
        if (option instanceof Some) {
            Some some = (Some)option;
            HashMap map = (HashMap)some.value();
            ArrayList<Alias> updatedAliases = new ArrayList<Alias>(aliases.size());
            aliases.forEach(alias -> {
                Alias updatedAlias = map.getOrDefault(alias.exprId(), alias);
                updatedAliases.add(updatedAlias);
            });
            return updatedAliases;
        }
        if (None$.MODULE$.equals(option)) {
            return aliases;
        }
        throw new MatchError(option);
    }

    public LateralColumnAliasResolver(ExpressionResolver expressionResolver) {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.scopes = expressionResolver.getNameScopes();
        this.aliasProvider = new AutoGeneratedAliasProvider(expressionResolver.getExpressionIdAssigner());
    }
}

