/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.NondeterministicExpressionCollection$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.analysis.resolver.AggregateResolutionResult;
import org.apache.spark.sql.catalyst.analysis.resolver.AggregateWithLcaResolutionResult;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.LateralColumnAliasResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScope;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.OrdinalReplacementGroupingExpressions;
import org.apache.spark.sql.catalyst.analysis.resolver.PullOutNondeterministicExpressionInExpressionTree$;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvedAggregateExpressions;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0007\u000f\u0001uA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\to\u0001\u0011\t\u0011)A\u0005q!)1\b\u0001C\u0001y!9\u0001\t\u0001b\u0001\n\u0013\t\u0005BB#\u0001A\u0003%!\tC\u0004G\u0001\t\u0007I\u0011B$\t\r-\u0003\u0001\u0015!\u0003I\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0011\u0015Y\u0007\u0001\"\u0003m\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015!\b\u0001\"\u0003v\u0005E\tum\u001a:fO\u0006$XMU3t_24XM\u001d\u0006\u0003\u001fA\t\u0001B]3t_24XM\u001d\u0006\u0003#I\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003'Q\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0004\u0001y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0003&M!\u0002T\"\u0001\b\n\u0005\u001dr!\u0001\u0005+sK\u0016tu\u000eZ3SKN|GN^3s!\tIc&D\u0001+\u0015\tYC&A\u0004m_\u001eL7-\u00197\u000b\u00055\u0012\u0012!\u00029mC:\u001c\u0018BA\u0018+\u0005%\tum\u001a:fO\u0006$X\r\u0005\u0002*c%\u0011!G\u000b\u0002\f\u0019><\u0017nY1m!2\fg.\u0001\tpa\u0016\u0014\u0018\r^8s%\u0016\u001cx\u000e\u001c<feB\u0011Q%N\u0005\u0003m9\u0011\u0001BU3t_24XM]\u0001\u0013Kb\u0004(/Z:tS>t'+Z:pYZ,'\u000f\u0005\u0002&s%\u0011!H\u0004\u0002\u0013\u000bb\u0004(/Z:tS>t'+Z:pYZ,'/\u0001\u0004=S:LGO\u0010\u000b\u0004{yz\u0004CA\u0013\u0001\u0011\u0015\u00194\u00011\u00015\u0011\u001594\u00011\u00019\u0003\u0019\u00198m\u001c9fgV\t!\t\u0005\u0002&\u0007&\u0011AI\u0004\u0002\u000f\u001d\u0006lWmU2pa\u0016\u001cF/Y2l\u0003\u001d\u00198m\u001c9fg\u0002\n1\u0002\\2b%\u0016\u001cx\u000e\u001c<feV\t\u0001\n\u0005\u0002&\u0013&\u0011!J\u0004\u0002\u001b\u0019\u0006$XM]1m\u0007>dW/\u001c8BY&\f7OU3t_24XM]\u0001\rY\u000e\f'+Z:pYZ,'\u000fI\u0001\be\u0016\u001cx\u000e\u001c<f)\t\u0001d\nC\u0003P\u0011\u0001\u0007\u0001&A\nv]J,7o\u001c7wK\u0012\fum\u001a:fO\u0006$X-\u0001\u000buef\u0014Vm]8mm\u0016<%o\\;q\u0005f\fE\u000e\u001c\u000b\u0004%\u0012L\u0007cA*\\=:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/r\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005i\u0003\u0013a\u00029bG.\fw-Z\u0005\u00039v\u00131aU3r\u0015\tQ\u0006\u0005\u0005\u0002`E6\t\u0001M\u0003\u0002b%\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t\u0019\u0007M\u0001\u0006FqB\u0014Xm]:j_:DQ!Z\u0005A\u0002\u0019\fA#Y4he\u0016<\u0017\r^3FqB\u0014Xm]:j_:\u001c\bCA\u0013h\u0013\tAgB\u0001\u000fSKN|GN^3e\u0003\u001e<'/Z4bi\u0016,\u0005\u0010\u001d:fgNLwN\\:\t\u000b)L\u0001\u0019\u0001\u0015\u0002\u0013\u0005<wM]3hCR,\u0017A\u0007;ssB+H\u000e\\(vi:{g\u000eZ3uKJl\u0017N\\5ti&\u001cGC\u0001\u0015n\u0011\u0015Q'\u00021\u0001)\u00035\u0019\u0017M\\$s_V\u0004()_!mYR\u0011\u0001o\u001d\t\u0003?EL!A\u001d\u0011\u0003\u000f\t{w\u000e\\3b]\")\u0011m\u0003a\u0001%\u00069r-\u001a;He>,\b/\u001b8h\u0003R$(/\u001b2vi\u0016LEm\u001d\u000b\u0004m\u0006\r\u0001cA<}}6\t\u0001P\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! =\u0003\u000f!\u000b7\u000f[*fiB\u0011ql`\u0005\u0004\u0003\u0003\u0001'AB#yaJLE\rC\u0003k\u0019\u0001\u0007\u0001\u0006")
public class AggregateResolver
implements TreeNodeResolver<Aggregate, LogicalPlan> {
    private final Resolver operatorResolver;
    private final ExpressionResolver expressionResolver;
    private final NameScopeStack scopes;
    private final LateralColumnAliasResolver lcaResolver;

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    private LateralColumnAliasResolver lcaResolver() {
        return this.lcaResolver;
    }

    @Override
    public LogicalPlan resolve(Aggregate unresolvedAggregate) {
        AggregateResolutionResult aggregateResolutionResult;
        this.scopes().pushScope(this.scopes().pushScope$default$1());
        try {
            LogicalPlan resolvedChild = this.operatorResolver.resolve(unresolvedAggregate.child());
            ResolvedAggregateExpressions resolvedAggregateExpressions = this.expressionResolver.resolveAggregateExpressions(unresolvedAggregate.aggregateExpressions(), unresolvedAggregate);
            this.scopes().current().setOrdinalReplacementExpressions(new OrdinalReplacementGroupingExpressions((IndexedSeq<NamedExpression>)resolvedAggregateExpressions.expressions().toIndexedSeq(), resolvedAggregateExpressions.hasStar(), resolvedAggregateExpressions.expressionIndexesWithAggregateFunctions()));
            Seq<Expression> resolvedGroupingExpressions = this.canGroupByAll(unresolvedAggregate.groupingExpressions()) ? this.tryResolveGroupByAll(resolvedAggregateExpressions, unresolvedAggregate) : this.expressionResolver.resolveGroupingExpressions(unresolvedAggregate.groupingExpressions(), unresolvedAggregate);
            Aggregate partiallyResolvedAggregate = unresolvedAggregate.copy(resolvedGroupingExpressions, resolvedAggregateExpressions.expressions(), resolvedChild, unresolvedAggregate.copy$default$4());
            Aggregate resolvedAggregate = this.tryPullOutNondeterministic(partiallyResolvedAggregate);
            if (resolvedAggregateExpressions.hasLateralColumnAlias()) {
                AggregateWithLcaResolutionResult aggregateWithLcaResolutionResult = this.lcaResolver().handleLcaInAggregate(resolvedAggregate);
                aggregateResolutionResult = new AggregateResolutionResult(aggregateWithLcaResolutionResult.resolvedOperator(), aggregateWithLcaResolutionResult.outputList(), (Option<HashSet<ExprId>>)None$.MODULE$, aggregateWithLcaResolutionResult.aggregateListAliases());
            } else {
                ExprUtils$.MODULE$.assertValidAggregation(resolvedAggregate);
                aggregateResolutionResult = new AggregateResolutionResult(resolvedAggregate, resolvedAggregate.aggregateExpressions(), (Option<HashSet<ExprId>>)new Some(this.getGroupingAttributeIds(resolvedAggregate)), this.scopes().current().getTopAggregateExpressionAliases());
            }
        }
        finally {
            this.scopes().popScope();
        }
        AggregateResolutionResult resolvedAggregate = aggregateResolutionResult;
        this.scopes().overwriteOutputAndExtendHiddenOutput((Seq<Attribute>)((Seq)resolvedAggregate.outputList().map((Function1 & Serializable)x$1 -> x$1.toAttribute())), resolvedAggregate.groupingAttributeIds(), resolvedAggregate.aggregateListAliases());
        return resolvedAggregate.operator();
    }

    private Seq<Expression> tryResolveGroupByAll(ResolvedAggregateExpressions aggregateExpressions, Aggregate aggregate) {
        if (aggregateExpressions.resolvedExpressionsWithoutAggregates().isEmpty() && aggregateExpressions.hasAttributeOutsideOfAggregateExpressions()) {
            throw package$.MODULE$.AnalysisErrorAt(aggregate).failAnalysis("UNRESOLVED_ALL_IN_GROUP_BY", (Map<String, String>)Predef$.MODULE$.Map().empty());
        }
        return (Seq)aggregateExpressions.resolvedExpressionsWithoutAggregates().map((Function1 & Serializable)x0$1 -> {
            NamedExpression namedExpression = x0$1;
            if (namedExpression instanceof Alias) {
                Alias alias = (Alias)namedExpression;
                return alias.child();
            }
            return (Expression)((Object)namedExpression);
        });
    }

    private Aggregate tryPullOutNondeterministic(Aggregate aggregate) {
        LinkedHashMap<Expression, NamedExpression> nondeterministicToAttributes = NondeterministicExpressionCollection$.MODULE$.getNondeterministicToAttributes(aggregate.groupingExpressions());
        if (!nondeterministicToAttributes.isEmpty()) {
            Project newChild = new Project((Seq<NamedExpression>)((Seq)this.scopes().current().output().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(nondeterministicToAttributes.values()).asScala().toSeq())), aggregate.child());
            Seq resolvedAggregateExpressions = (Seq)aggregate.aggregateExpressions().map((Function1 & Serializable)expression -> (NamedExpression)((Object)PullOutNondeterministicExpressionInExpressionTree$.MODULE$.apply((Expression)((Object)expression), nondeterministicToAttributes)));
            Seq resolvedGroupingExpressions = (Seq)aggregate.groupingExpressions().map((Function1 & Serializable)expression -> PullOutNondeterministicExpressionInExpressionTree$.MODULE$.apply(expression, nondeterministicToAttributes));
            return aggregate.copy((Seq<Expression>)resolvedGroupingExpressions, (Seq<NamedExpression>)resolvedAggregateExpressions, newChild, aggregate.copy$default$4());
        }
        return aggregate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canGroupByAll(Seq<Expression> expressions) {
        boolean x$7;
        boolean x$6;
        boolean x$5;
        boolean x$4;
        Seq<Expression> seq = expressions;
        if (seq == null) return false;
        SeqOps seqOps = scala.package$.MODULE$.Seq().unapplySeq(seq);
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return false;
        if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return false;
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) return false;
        Expression unresolvedAttribute = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        if (!(unresolvedAttribute instanceof UnresolvedAttribute)) return false;
        UnresolvedAttribute unresolvedAttribute2 = (UnresolvedAttribute)unresolvedAttribute;
        boolean bl = unresolvedAttribute2.equalsIgnoreCase("ALL");
        boolean isOrderByAll = bl;
        if (!isOrderByAll) return false;
        NameScope qual$1 = this.scopes().current();
        .colon.colon x$1 = new .colon.colon((Object)"ALL", (List)Nil$.MODULE$);
        boolean x$2 = true;
        boolean x$3 = qual$1.resolveMultipartName$default$2();
        if (!qual$1.resolveMultipartName((Seq<String>)x$1, x$3, true, x$4 = qual$1.resolveMultipartName$default$4(), x$5 = qual$1.resolveMultipartName$default$5(), x$6 = qual$1.resolveMultipartName$default$6(), x$7 = qual$1.resolveMultipartName$default$7()).candidates().isEmpty()) return false;
        return true;
    }

    private HashSet<ExprId> getGroupingAttributeIds(Aggregate aggregate) {
        HashSet<ExprId> groupingAttributeIds = new HashSet<ExprId>(aggregate.groupingExpressions().size());
        aggregate.groupingExpressions().foreach((Function1 & Serializable)rootExpression -> {
            rootExpression.foreach((Function1 & Serializable)x0$1 -> {
                AggregateResolver.$anonfun$getGroupingAttributeIds$2(groupingAttributeIds$1, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return groupingAttributeIds;
    }

    public static final /* synthetic */ void $anonfun$getGroupingAttributeIds$2(HashSet groupingAttributeIds$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            groupingAttributeIds$1.add(attributeReference.exprId());
            return;
        }
    }

    public AggregateResolver(Resolver operatorResolver, ExpressionResolver expressionResolver) {
        this.operatorResolver = operatorResolver;
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.scopes = operatorResolver.getNameScopes();
        this.lcaResolver = expressionResolver.getLcaResolver();
    }
}

